/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html.dtd;

import com.intellij.html.RelaxedHtmlNSDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SimpleFieldCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSTypeDescriptorProvider;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlNSDescriptorImpl
implements XmlNSDescriptor,
DumbAware,
XmlNSTypeDescriptorProvider {
    private final XmlNSDescriptor myDelegate;
    protected final boolean myRelaxed;
    protected final boolean myCaseSensitive;
    private static final SimpleFieldCache<Map<String, HtmlElementDescriptorImpl>, HtmlNSDescriptorImpl> myCachedDeclsCache = new SimpleFieldCache<Map<String, HtmlElementDescriptorImpl>, HtmlNSDescriptorImpl>(){

        protected Map<String, HtmlElementDescriptorImpl> compute(HtmlNSDescriptorImpl htmlNSDescriptor) {
            return htmlNSDescriptor.doBuildCachedMap();
        }

        protected Map<String, HtmlElementDescriptorImpl> getValue(HtmlNSDescriptorImpl htmlNSDescriptor) {
            return htmlNSDescriptor.myCachedDecls;
        }

        protected void putValue(Map<String, HtmlElementDescriptorImpl> map, HtmlNSDescriptorImpl htmlNSDescriptor) {
            htmlNSDescriptor.myCachedDecls = map;
        }
    };
    private volatile Map<String, HtmlElementDescriptorImpl> myCachedDecls;

    public HtmlNSDescriptorImpl(XmlNSDescriptor _delegate) {
        this(_delegate, _delegate instanceof RelaxedHtmlNSDescriptor, false);
    }

    public HtmlNSDescriptorImpl(XmlNSDescriptor _delegate, boolean relaxed, boolean caseSensitive) {
        this.myDelegate = _delegate;
        this.myRelaxed = relaxed;
        this.myCaseSensitive = caseSensitive;
    }

    @Nullable
    public static XmlAttributeDescriptor getCommonAttributeDescriptor(@NotNull String attributeName, @Nullable XmlTag context) {
        XmlElementDescriptor descriptor;
        if (attributeName == null) {
            HtmlNSDescriptorImpl.$$$reportNull$$$0(0);
        }
        if ((descriptor = HtmlNSDescriptorImpl.guessTagForCommonAttributes(context)) != null) {
            return descriptor.getAttributeDescriptor(attributeName, context);
        }
        return null;
    }

    public static XmlAttributeDescriptor @NotNull [] getCommonAttributeDescriptors(XmlTag context) {
        XmlElementDescriptor descriptor = HtmlNSDescriptorImpl.guessTagForCommonAttributes(context);
        if (descriptor != null) {
            XmlAttributeDescriptor[] xmlAttributeDescriptorArray = descriptor.getAttributesDescriptors(context);
            if (xmlAttributeDescriptorArray == null) {
                HtmlNSDescriptorImpl.$$$reportNull$$$0(1);
            }
            return xmlAttributeDescriptorArray;
        }
        if (XmlAttributeDescriptor.EMPTY == null) {
            HtmlNSDescriptorImpl.$$$reportNull$$$0(2);
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    @Nullable
    public static XmlElementDescriptor guessTagForCommonAttributes(@Nullable XmlTag context) {
        if (context == null) {
            return null;
        }
        XmlNSDescriptor nsDescriptor = context.getNSDescriptor(context.getNamespace(), false);
        if (nsDescriptor instanceof HtmlNSDescriptorImpl) {
            XmlElementDescriptor descriptor = ((HtmlNSDescriptorImpl)nsDescriptor).getElementDescriptorByName("div");
            descriptor = descriptor == null ? ((HtmlNSDescriptorImpl)nsDescriptor).getElementDescriptorByName("span") : descriptor;
            return descriptor;
        }
        return null;
    }

    private Map<String, HtmlElementDescriptorImpl> buildDeclarationMap() {
        return (Map)myCachedDeclsCache.get((Object)this);
    }

    private HashMap<String, HtmlElementDescriptorImpl> doBuildCachedMap() {
        XmlElementDescriptor[] elements;
        HashMap<String, HtmlElementDescriptorImpl> decls = new HashMap<String, HtmlElementDescriptorImpl>();
        for (XmlElementDescriptor element : elements = this.myDelegate == null ? XmlElementDescriptor.EMPTY_ARRAY : this.myDelegate.getRootElementsDescriptors(null)) {
            decls.put(this.myCaseSensitive ? element.getName() : StringUtil.toLowerCase((String)element.getName()), this.createHtmlElementDescriptor(element));
        }
        return decls;
    }

    @NotNull
    protected HtmlElementDescriptorImpl createHtmlElementDescriptor(XmlElementDescriptor element) {
        return new HtmlElementDescriptorImpl(element, this.myRelaxed, this.myCaseSensitive);
    }

    @Override
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        XmlElementDescriptor xmlElementDescriptor;
        if (tag == null) {
            HtmlNSDescriptorImpl.$$$reportNull$$$0(3);
        }
        if ((xmlElementDescriptor = this.getElementDescriptorByName(tag.getLocalName())) == null && this.myRelaxed) {
            xmlElementDescriptor = this.myDelegate.getElementDescriptor(tag);
        }
        return xmlElementDescriptor;
    }

    @ApiStatus.Internal
    public XmlElementDescriptor getElementDescriptorByName(String name) {
        if (!this.myCaseSensitive) {
            name = StringUtil.toLowerCase((String)name);
        }
        return this.buildDeclarationMap().get(name);
    }

    @Override
    public XmlElementDescriptor @NotNull [] getRootElementsDescriptors(@Nullable XmlDocument document) {
        if (this.myDelegate == null) {
            if (XmlElementDescriptor.EMPTY_ARRAY == null) {
                HtmlNSDescriptorImpl.$$$reportNull$$$0(4);
            }
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        if (document != null) {
            XmlElementDescriptor[] xmlElementDescriptorArray = this.myDelegate.getRootElementsDescriptors(document);
            if (xmlElementDescriptorArray == null) {
                HtmlNSDescriptorImpl.$$$reportNull$$$0(5);
            }
            return xmlElementDescriptorArray;
        }
        XmlElementDescriptor[] xmlElementDescriptorArray = (XmlElementDescriptor[])this.buildDeclarationMap().values().stream().map(HtmlElementDescriptorImpl::getDelegate).toArray(XmlElementDescriptor[]::new);
        if (xmlElementDescriptorArray == null) {
            HtmlNSDescriptorImpl.$$$reportNull$$$0(6);
        }
        return xmlElementDescriptorArray;
    }

    @Override
    @Nullable
    public XmlFile getDescriptorFile() {
        return this.myDelegate == null ? null : this.myDelegate.getDescriptorFile();
    }

    public PsiElement getDeclaration() {
        return this.myDelegate == null ? null : this.myDelegate.getDeclaration();
    }

    public String getName(PsiElement context) {
        return this.myDelegate == null ? "" : this.myDelegate.getName(context);
    }

    public String getName() {
        return this.myDelegate == null ? "" : this.myDelegate.getName();
    }

    public void init(PsiElement element) {
        this.myDelegate.init(element);
    }

    public Object @NotNull [] getDependencies() {
        Object[] objectArray = this.myDelegate == null ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : this.myDelegate.getDependencies();
        if (objectArray == null) {
            HtmlNSDescriptorImpl.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(@NotNull String name, XmlTag context) {
        if (name == null) {
            HtmlNSDescriptorImpl.$$$reportNull$$$0(8);
        }
        return this.myDelegate instanceof XmlNSTypeDescriptorProvider ? ((XmlNSTypeDescriptorProvider)((Object)this.myDelegate)).getTypeDescriptor(name, context) : null;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(XmlTag descriptorTag) {
        return this.myDelegate instanceof XmlNSTypeDescriptorProvider ? ((XmlNSTypeDescriptorProvider)((Object)this.myDelegate)).getTypeDescriptor(descriptorTag) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/html/dtd/HtmlNSDescriptorImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/html/dtd/HtmlNSDescriptorImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonAttributeDescriptors";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElementsDescriptors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommonAttributeDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDescriptor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 4, 5, 6, 7 -> new IllegalStateException(string2);
        };
    }
}

