/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.xml.impl.XmlEnumerationDescriptor;
import com.intellij.xml.psi.XmlPsiBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEnumeratedValueReference
extends PsiReferenceBase<XmlElement>
implements EmptyResolveMessageProvider,
ResolvingHint {
    private final XmlEnumerationDescriptor myDescriptor;

    public XmlEnumeratedValueReference(XmlElement value, XmlEnumerationDescriptor descriptor) {
        super((PsiElement)value);
        this.myDescriptor = descriptor;
    }

    public XmlEnumeratedValueReference(XmlElement value, XmlEnumerationDescriptor descriptor, TextRange range) {
        super((PsiElement)value, range);
        this.myDescriptor = descriptor;
    }

    public boolean canResolveTo(@NotNull Class<? extends PsiElement> elementClass) {
        if (elementClass == null) {
            XmlEnumeratedValueReference.$$$reportNull$$$0(0);
        }
        return ReflectionUtil.isAssignable(XmlElement.class, elementClass);
    }

    @Nullable
    public PsiElement resolve() {
        return this.myDescriptor.getValueDeclaration((XmlElement)this.getElement(), this.getValue());
    }

    public Object @NotNull [] getVariants() {
        if (this.myDescriptor.isFixed()) {
            Object[] objectArray;
            String defaultValue = this.myDescriptor.getDefaultValue();
            if (defaultValue == null) {
                objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = defaultValue;
            }
            if (objectArray == null) {
                XmlEnumeratedValueReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }
        String[] values = this.myDescriptor.getValuesForCompletion();
        Object[] objectArray = values == null ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : values;
        if (objectArray == null) {
            XmlEnumeratedValueReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String name = this.getElement() instanceof XmlTag ? "tag" : "attribute";
        String string2 = this.myDescriptor.isFixed() ? XmlPsiBundle.message("xml.inspections.should.have.fixed.value", StringUtil.capitalize((String)name), this.myDescriptor.getDefaultValue()) : XmlPsiBundle.message("xml.inspections.wrong.value", name);
        if (string2 == null) {
            XmlEnumeratedValueReference.$$$reportNull$$$0(3);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/XmlEnumeratedValueReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/XmlEnumeratedValueReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canResolveTo";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3 -> new IllegalStateException(string2);
        };
    }
}

