/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.folding;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncAnnotation;
import org.intellij.plugins.relaxNG.compact.psi.RncName;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RncFoldingBuilder
implements FoldingBuilder {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            RncFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            RncFoldingBuilder.$$$reportNull$$$0(1);
        }
        ArrayList regions = new ArrayList();
        RncFoldingBuilder.process(node, document, regions);
        FoldingDescriptor[] foldingDescriptorArray = regions.size() > 0 ? regions.toArray(FoldingDescriptor.EMPTY_ARRAY) : FoldingDescriptor.EMPTY_ARRAY;
        if (foldingDescriptorArray == null) {
            RncFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        IElementType type;
        if (node == null) {
            RncFoldingBuilder.$$$reportNull$$$0(3);
        }
        if ((type = node.getElementType()) == RncTokenTypes.LBRACE) {
            return "{ ... }";
        }
        if (RncFoldingBuilder.isCommentLike(type)) {
            return "# ...";
        }
        if (RncFoldingBuilder.isAnnotation(type)) {
            RncName element = ((RncAnnotation)node.getPsi()).getNameElement();
            if (element != null) {
                ASTNode n = element.getNode();
                assert (n != null);
                return EscapeUtil.unescapeText(n) + " [ ... ]";
            }
            return "[ ... ]";
        }
        return "...";
    }

    private static boolean isAnnotation(IElementType type) {
        return RncElementTypes.ANNOTATION == type || RncElementTypes.ANNOTATION_ELEMENT == type || RncElementTypes.FORWARD_ANNOTATION == type;
    }

    private static boolean isCommentLike(IElementType type) {
        return RncTokenTypes.COMMENTS.contains(type) || RncTokenTypes.DOC_TOKENS.contains(type);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            RncFoldingBuilder.$$$reportNull$$$0(4);
        }
        return RncFoldingBuilder.isCommentLike(node.getElementType()) && CodeFoldingSettings.getInstance().COLLAPSE_DOC_COMMENTS;
    }

    private static void process(@Nullable ASTNode node, Document document, ArrayList<? super FoldingDescriptor> regions) {
        if (node == null) {
            return;
        }
        ASTNode[] braces = node.getChildren(RncTokenTypes.BRACES);
        if (braces.length == 2) {
            ASTNode lbrace = braces[0];
            ASTNode rbrace = braces[1];
            if (RncFoldingBuilder.shouldFold(lbrace, rbrace, document)) {
                TextRange range = new TextRange(lbrace.getStartOffset(), rbrace.getTextRange().getEndOffset());
                regions.add((FoldingDescriptor)new FoldingDescriptor(lbrace, range));
            }
        } else if (RncFoldingBuilder.isAnnotation(node.getElementType()) && RncFoldingBuilder.isOnDifferentLine(node.getFirstChildNode(), node.getLastChildNode(), document)) {
            regions.add((FoldingDescriptor)new FoldingDescriptor(node, node.getTextRange()));
        }
        node = node.getFirstChildNode();
        while (node != null) {
            node = RncFoldingBuilder.checkNodeAndSiblings(node, RncTokenTypes.DOC_TOKENS, regions, document);
            node = RncFoldingBuilder.checkNodeAndSiblings(node, RncTokenTypes.COMMENTS, regions, document);
            RncFoldingBuilder.process(node, document, regions);
            if (node == null) continue;
            node = node.getTreeNext();
        }
    }

    @Nullable
    private static ASTNode checkNodeAndSiblings(@Nullable ASTNode node, TokenSet tokens, ArrayList<? super FoldingDescriptor> regions, Document document) {
        if (node != null && tokens.contains(node.getElementType())) {
            ASTNode start2;
            ASTNode end = start2 = node;
            if ((node = node.getTreeNext()) != null) {
                do {
                    end = node;
                } while ((node = node.getTreeNext()) != null && tokens.contains(node.getElementType()));
            }
            if (end != start2) {
                while (end.getPsi() instanceof PsiWhiteSpace) {
                    end = end.getTreePrev();
                }
                if (RncFoldingBuilder.isOnDifferentLine(start2, end, document)) {
                    regions.add((FoldingDescriptor)new FoldingDescriptor(start2, new TextRange(start2.getStartOffset(), end.getTextRange().getEndOffset())));
                }
            }
        }
        return node;
    }

    private static boolean shouldFold(ASTNode first, ASTNode second, Document document) {
        if (first.getElementType() != RncTokenTypes.LBRACE) {
            return false;
        }
        if (second.getElementType() != RncTokenTypes.RBRACE) {
            return false;
        }
        return RncFoldingBuilder.isOnDifferentLine(first, second, document);
    }

    private static boolean isOnDifferentLine(ASTNode first, ASTNode second, Document document) {
        return document.getLineNumber(first.getStartOffset()) != document.getLineNumber(second.getStartOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/compact/folding/RncFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/compact/folding/RncFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

