/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.konan;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.konan.FileWithMetadata;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u001c\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H$J\u0016\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "version", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "readFile", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "<init>", "(ILcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function1;)V", "getReadFile", "()Lkotlin/jvm/functions/Function1;", "getStubVersion", "buildMetadataFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "fileWithMetadata", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "buildFileStub", "content", "decompiler-native"})
@SourceDebugExtension(value={"SMAP\nKlibMetadataStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibMetadataStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public abstract class KlibMetadataStubBuilder
extends ClsStubBuilder {
    private final int version;
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Function1<VirtualFile, FileWithMetadata> readFile;

    public KlibMetadataStubBuilder(int version2, @NotNull FileType fileType, @NotNull Function1<? super VirtualFile, ? extends FileWithMetadata> readFile) {
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        Intrinsics.checkNotNullParameter(readFile, "readFile");
        this.version = version2;
        this.fileType = fileType;
        this.readFile = readFile;
    }

    @NotNull
    protected final Function1<VirtualFile, FileWithMetadata> getReadFile() {
        return this.readFile;
    }

    @Override
    public int getStubVersion() {
        return 27 + this.version;
    }

    @NotNull
    protected abstract PsiFileStub<?> buildMetadataFileStub(@NotNull FileWithMetadata.Compatible var1, @NotNull FileContent var2);

    @Override
    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content) {
        PsiFileStub<?> psiFileStub;
        Intrinsics.checkNotNullParameter(content, "content");
        VirtualFile virtualFile = content.getFile();
        Intrinsics.checkNotNullExpressionValue(virtualFile, "getFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        boolean bl = FileTypeRegistry.getInstance().isFileOfType(virtualFile2, this.fileType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Unexpected file type " + virtualFile2.getFileType();
            throw new AssertionError((Object)string2);
        }
        FileWithMetadata fileWithMetadata = this.readFile.invoke(virtualFile2);
        if (fileWithMetadata == null) {
            return null;
        }
        FileWithMetadata fileWithMetadata2 = fileWithMetadata;
        FileWithMetadata fileWithMetadata3 = fileWithMetadata2;
        if (fileWithMetadata3 instanceof FileWithMetadata.Incompatible) {
            psiFileStub = ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        } else if (fileWithMetadata3 instanceof FileWithMetadata.Compatible) {
            psiFileStub = this.buildMetadataFileStub((FileWithMetadata.Compatible)fileWithMetadata2, content);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return psiFileStub;
    }
}

