/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0002\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0015\u0010\t\u001a\u0004\u0018\u00010\n*\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u001a\u0015\u0010\r\u001a\u0004\u0018\u00010\u000e*\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u001b\u001aD\u0010\u001f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020\u00010 *\u00020\"2\u0006\u0010#\u001a\u00020\u00012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010(\u001a\u00020\u0004H\u0000\u001aD\u0010)\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020\u00010 *\u00020\"2\u0006\u0010#\u001a\u00020\u00012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010(\u001a\u00020\u0004H\u0000\u001a\u0014\u0010*\u001a\u00020\u0001*\u00020\u00012\u0006\u0010+\u001a\u00020,H\u0000\u001a\f\u0010-\u001a\u00020'*\u00020\u0001H\u0000\"\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0004*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\"\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u0014*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006."}, d2={"negate", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "decrement", "canChangeValueDuringExecution", "", "getCanChangeValueDuringExecution", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Z", "canHaveSideEffects", "getCanHaveSideEffects", "toByte", "", "", "(Ljava/lang/Object;)Ljava/lang/Byte;", "toShort", "", "(Ljava/lang/Object;)Ljava/lang/Short;", "toInt", "", "(Ljava/lang/Object;)Ljava/lang/Integer;", "toLong", "", "(Ljava/lang/Object;)Ljava/lang/Long;", "toFloat", "", "(Ljava/lang/Object;)Ljava/lang/Float;", "toDouble", "", "(Ljava/lang/Object;)Ljava/lang/Double;", "constLongValue", "getConstLongValue", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Ljava/lang/Long;", "createTemporaryVariableIfNecessary", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "expression", "nameHint", "", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isMutable", "createLoopTemporaryVariableIfNecessary", "castIfNecessary", "targetClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getMostPreciseTypeFromValInitializer", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/backend/common/lower/loops/UtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n350#2,12:230\n350#2,12:242\n350#2,12:255\n1#3:254\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/backend/common/lower/loops/UtilsKt\n*L\n32#1:230,12\n55#1:242,12\n189#1:255,12\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final IrExpression negate(@NotNull IrExpression $this$negate) {
        IrExpression irExpression;
        Number value2;
        Intrinsics.checkNotNullParameter($this$negate, "<this>");
        IrConst irConst = $this$negate instanceof IrConst ? (IrConst)$this$negate : null;
        Object t = irConst != null ? irConst.getValue() : null;
        Number number = value2 = t instanceof Number ? (Number)((Number)t) : (Number)null;
        if (value2 instanceof Integer) {
            irExpression = BuildersKt.IrConstImpl($this$negate.getStartOffset(), $this$negate.getEndOffset(), $this$negate.getType(), IrConstKind.Int.INSTANCE, -value2.intValue());
        } else if (value2 instanceof Long) {
            irExpression = BuildersKt.IrConstImpl($this$negate.getStartOffset(), $this$negate.getEndOffset(), $this$negate.getType(), IrConstKind.Long.INSTANCE, -value2.longValue());
        } else {
            IrCallImpl irCallImpl;
            if (IrTypePredicatesKt.isNothing($this$negate.getType())) {
                return $this$negate;
            }
            IrClass irClass = IrTypesKt.getClass($this$negate.getType());
            Intrinsics.checkNotNull(irClass);
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass);
            int $i$f$single = 0;
            IrAnnotationContainer single$iv = null;
            boolean found$iv = false;
            Iterator<IrSimpleFunction> iterator2 = $this$single$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunction element$iv;
                IrSimpleFunction it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), OperatorNameConventions.UNARY_MINUS) && it.getValueParameters().isEmpty())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction unaryMinusFun = (IrSimpleFunction)single$iv;
            int n = $this$negate.getStartOffset();
            $i$f$single = $this$negate.getEndOffset();
            single$iv = unaryMinusFun.getReturnType();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = unaryMinusFun.getSymbol();
            IrCallImpl $this$negate_u24lambda_u241 = irCallImpl = new IrCallImpl(n, $i$f$single, (IrType)single$iv, irSimpleFunctionSymbol, 0, 0, null, null, 192, null);
            boolean bl = false;
            $this$negate_u24lambda_u241.setDispatchReceiver($this$negate);
            irExpression = IrUtilsKt.implicitCastIfNeededTo(irCallImpl, $this$negate.getType());
        }
        return irExpression;
    }

    @NotNull
    public static final IrExpression decrement(@NotNull IrExpression $this$decrement) {
        IrExpression irExpression;
        Object thisValue;
        Intrinsics.checkNotNullParameter($this$decrement, "<this>");
        IrConst irConst = $this$decrement instanceof IrConst ? (IrConst)$this$decrement : null;
        Object object = thisValue = irConst != null ? irConst.getValue() : null;
        if (thisValue instanceof Integer) {
            irExpression = BuildersKt.IrConstImpl($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Int.INSTANCE, ((Number)thisValue).intValue() - 1);
        } else if (thisValue instanceof Long) {
            irExpression = BuildersKt.IrConstImpl($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Long.INSTANCE, ((Number)thisValue).longValue() - 1L);
        } else if (thisValue instanceof Character) {
            irExpression = BuildersKt.IrConstImpl($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Char.INSTANCE, Character.valueOf((char)(((Character)thisValue).charValue() - '\u0001')));
        } else {
            IrCallImpl irCallImpl;
            IrClass irClass = IrTypesKt.getClass($this$decrement.getType());
            Intrinsics.checkNotNull(irClass);
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass);
            int $i$f$single = 0;
            IrAnnotationContainer single$iv = null;
            boolean found$iv = false;
            Iterator<IrSimpleFunction> iterator2 = $this$single$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunction element$iv;
                IrSimpleFunction it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), OperatorNameConventions.DEC) && it.getValueParameters().isEmpty())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction decFun = (IrSimpleFunction)single$iv;
            int n = $this$decrement.getStartOffset();
            $i$f$single = $this$decrement.getEndOffset();
            single$iv = $this$decrement.getType();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = decFun.getSymbol();
            IrCallImpl $this$decrement_u24lambda_u243 = irCallImpl = new IrCallImpl(n, $i$f$single, (IrType)single$iv, irSimpleFunctionSymbol, 0, 0, null, null, 192, null);
            boolean bl = false;
            $this$decrement_u24lambda_u243.setDispatchReceiver($this$decrement);
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    public static final boolean getCanChangeValueDuringExecution(@NotNull IrExpression $this$canChangeValueDuringExecution) {
        Intrinsics.checkNotNullParameter($this$canChangeValueDuringExecution, "<this>");
        IrExpression irExpression = $this$canChangeValueDuringExecution;
        return irExpression instanceof IrGetValue ? !IrUtilsKt.isImmutable(((IrGetValue)$this$canChangeValueDuringExecution).getSymbol().getOwner()) : !(irExpression instanceof IrConst) && !(irExpression instanceof IrGetObjectValue) && !(irExpression instanceof IrGetEnumValue);
    }

    public static final boolean getCanHaveSideEffects(@NotNull IrExpression $this$canHaveSideEffects) {
        Intrinsics.checkNotNullParameter($this$canHaveSideEffects, "<this>");
        return !IrUtilsKt.isTrivial($this$canHaveSideEffects);
    }

    private static final Byte toByte(Object $this$toByte) {
        Object object = $this$toByte;
        return object instanceof Number ? Byte.valueOf(((Number)$this$toByte).byteValue()) : (object instanceof Character ? Byte.valueOf((byte)((Character)$this$toByte).charValue()) : null);
    }

    private static final Short toShort(Object $this$toShort) {
        Object object = $this$toShort;
        return object instanceof Number ? Short.valueOf(((Number)$this$toShort).shortValue()) : (object instanceof Character ? Short.valueOf((short)((Character)$this$toShort).charValue()) : null);
    }

    private static final Integer toInt(Object $this$toInt) {
        Object object = $this$toInt;
        return object instanceof Number ? Integer.valueOf(((Number)$this$toInt).intValue()) : (object instanceof Character ? Integer.valueOf(((Character)$this$toInt).charValue()) : null);
    }

    private static final Long toLong(Object $this$toLong) {
        Object object = $this$toLong;
        return object instanceof Number ? Long.valueOf(((Number)$this$toLong).longValue()) : (object instanceof Character ? Long.valueOf(((Character)$this$toLong).charValue()) : null);
    }

    private static final Float toFloat(Object $this$toFloat) {
        Object object = $this$toFloat;
        return object instanceof Number ? Float.valueOf(((Number)$this$toFloat).floatValue()) : (object instanceof Character ? Float.valueOf(((Character)$this$toFloat).charValue()) : null);
    }

    private static final Double toDouble(Object $this$toDouble) {
        Object object = $this$toDouble;
        return object instanceof Number ? Double.valueOf(((Number)$this$toDouble).doubleValue()) : (object instanceof Character ? Double.valueOf(((Character)$this$toDouble).charValue()) : null);
    }

    @Nullable
    public static final Long getConstLongValue(@NotNull IrExpression $this$constLongValue) {
        Intrinsics.checkNotNullParameter($this$constLongValue, "<this>");
        return $this$constLongValue instanceof IrConst ? UtilsKt.toLong(((IrConst)$this$constLongValue).getValue()) : null;
    }

    @NotNull
    public static final Pair<IrVariable, IrExpression> createTemporaryVariableIfNecessary(@NotNull DeclarationIrBuilder $this$createTemporaryVariableIfNecessary, @NotNull IrExpression expression2, @Nullable String nameHint, @Nullable IrType irType, boolean isMutable) {
        Pair<IrVariable, IrGetValueImpl> pair;
        Intrinsics.checkNotNullParameter($this$createTemporaryVariableIfNecessary, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (UtilsKt.getCanHaveSideEffects(expression2)) {
            IrVariable it = IrBuilderKt.createTmpVariable$default($this$createTemporaryVariableIfNecessary.getScope(), expression2, nameHint, isMutable, null, irType, 8, null);
            boolean bl = false;
            pair = new Pair<IrVariable, IrGetValueImpl>(it, ExpressionHelpersKt.irGet($this$createTemporaryVariableIfNecessary, it));
        } else {
            pair = new Pair<IrVariable, IrGetValueImpl>((IrVariable)null, (IrGetValueImpl)expression2);
        }
        return pair;
    }

    public static /* synthetic */ Pair createTemporaryVariableIfNecessary$default(DeclarationIrBuilder declarationIrBuilder, IrExpression irExpression, String string2, IrType irType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            irType = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return UtilsKt.createTemporaryVariableIfNecessary(declarationIrBuilder, irExpression, string2, irType, bl);
    }

    @NotNull
    public static final Pair<IrVariable, IrExpression> createLoopTemporaryVariableIfNecessary(@NotNull DeclarationIrBuilder $this$createLoopTemporaryVariableIfNecessary, @NotNull IrExpression expression2, @Nullable String nameHint, @Nullable IrType irType, boolean isMutable) {
        Pair<IrVariable, IrGetValueImpl> pair;
        Intrinsics.checkNotNullParameter($this$createLoopTemporaryVariableIfNecessary, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (UtilsKt.getCanChangeValueDuringExecution(expression2)) {
            IrVariable it = IrBuilderKt.createTmpVariable$default($this$createLoopTemporaryVariableIfNecessary.getScope(), expression2, nameHint, isMutable, null, irType, 8, null);
            boolean bl = false;
            pair = new Pair<IrVariable, IrGetValueImpl>(it, ExpressionHelpersKt.irGet($this$createLoopTemporaryVariableIfNecessary, it));
        } else {
            pair = new Pair<IrVariable, IrGetValueImpl>((IrVariable)null, (IrGetValueImpl)expression2);
        }
        return pair;
    }

    public static /* synthetic */ Pair createLoopTemporaryVariableIfNecessary$default(DeclarationIrBuilder declarationIrBuilder, IrExpression irExpression, String string2, IrType irType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            irType = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return UtilsKt.createLoopTemporaryVariableIfNecessary(declarationIrBuilder, irExpression, string2, irType, bl);
    }

    @NotNull
    public static final IrExpression castIfNecessary(@NotNull IrExpression $this$castIfNecessary, @NotNull IrClass targetClass) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter($this$castIfNecessary, "<this>");
        Intrinsics.checkNotNullParameter(targetClass, "targetClass");
        if (Intrinsics.areEqual($this$castIfNecessary.getType(), IrUtilsKt.getDefaultType(targetClass)) || IrTypePredicatesKt.isNothing($this$castIfNecessary.getType())) {
            irExpression = $this$castIfNecessary;
        } else if ($this$castIfNecessary instanceof IrConst && IrTypePredicatesKt.isPrimitiveType$default(IrUtilsKt.getDefaultType(targetClass), false, 1, null)) {
            IrConstImpl<Number> irConstImpl;
            IrSimpleType targetType = IrUtilsKt.getDefaultType(targetClass);
            PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(targetType);
            switch (primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
                case 1: {
                    int n = $this$castIfNecessary.getStartOffset();
                    int n2 = $this$castIfNecessary.getEndOffset();
                    IrType irType = targetType;
                    Byte by = UtilsKt.toByte(((IrConst)$this$castIfNecessary).getValue());
                    Intrinsics.checkNotNull(by);
                    irConstImpl = IrConstImpl.Companion.byte(n, n2, irType, by);
                    break;
                }
                case 2: {
                    int n = $this$castIfNecessary.getStartOffset();
                    int n3 = $this$castIfNecessary.getEndOffset();
                    IrType irType = targetType;
                    Short s = UtilsKt.toShort(((IrConst)$this$castIfNecessary).getValue());
                    Intrinsics.checkNotNull(s);
                    irConstImpl = IrConstImpl.Companion.short(n, n3, irType, s);
                    break;
                }
                case 3: {
                    int n = $this$castIfNecessary.getStartOffset();
                    int n4 = $this$castIfNecessary.getEndOffset();
                    IrType irType = targetType;
                    Integer n5 = UtilsKt.toInt(((IrConst)$this$castIfNecessary).getValue());
                    Intrinsics.checkNotNull(n5);
                    irConstImpl = IrConstImpl.Companion.int(n, n4, irType, n5);
                    break;
                }
                case 4: {
                    int n = $this$castIfNecessary.getStartOffset();
                    int n6 = $this$castIfNecessary.getEndOffset();
                    IrType irType = targetType;
                    Long l = UtilsKt.toLong(((IrConst)$this$castIfNecessary).getValue());
                    Intrinsics.checkNotNull(l);
                    irConstImpl = IrConstImpl.Companion.long(n, n6, irType, l);
                    break;
                }
                case 5: {
                    int n = $this$castIfNecessary.getStartOffset();
                    int n7 = $this$castIfNecessary.getEndOffset();
                    IrType irType = targetType;
                    Float f = UtilsKt.toFloat(((IrConst)$this$castIfNecessary).getValue());
                    Intrinsics.checkNotNull(f);
                    irConstImpl = IrConstImpl.Companion.float(n, n7, irType, f.floatValue());
                    break;
                }
                case 6: {
                    int n = $this$castIfNecessary.getStartOffset();
                    int n8 = $this$castIfNecessary.getEndOffset();
                    IrType irType = targetType;
                    Double d = UtilsKt.toDouble(((IrConst)$this$castIfNecessary).getValue());
                    Intrinsics.checkNotNull(d);
                    irConstImpl = IrConstImpl.Companion.double(n, n8, irType, d);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Cannot cast expression of type " + RenderIrElementKt.render$default($this$castIfNecessary.getType(), null, 1, null) + " to " + RenderIrElementKt.render$default(targetType, null, 1, null)).toString());
                }
            }
            irExpression = irConstImpl;
        } else {
            IrCallImpl irCallImpl;
            Name name2 = Name.identifier("to" + targetClass.getName().asString());
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
            Name numberCastFunctionName = name2;
            IrClass irClass = IrTypesKt.getClass($this$castIfNecessary.getType());
            if (irClass == null) {
                throw new IllegalStateException(("Has to be a class " + RenderIrElementKt.render$default($this$castIfNecessary.getType(), null, 1, null)).toString());
            }
            IrClass classifier = irClass;
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(classifier);
            boolean $i$f$single = false;
            IrSimpleFunction single$iv = null;
            boolean found$iv = false;
            Iterator<IrSimpleFunction> iterator2 = $this$single$iv.iterator();
            while (iterator2.hasNext()) {
                IrSimpleFunction element$iv;
                IrSimpleFunction it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), numberCastFunctionName) && it.getDispatchReceiverParameter() != null && it.getExtensionReceiverParameter() == null && it.getValueParameters().isEmpty())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction castFun = single$iv;
            IrCallImpl $this$castIfNecessary_u24lambda_u247 = irCallImpl = new IrCallImpl($this$castIfNecessary.getStartOffset(), $this$castIfNecessary.getEndOffset(), castFun.getReturnType(), castFun.getSymbol(), 0, 0, null, null, 192, null);
            boolean bl = false;
            $this$castIfNecessary_u24lambda_u247.setDispatchReceiver($this$castIfNecessary);
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    @NotNull
    public static final IrType getMostPreciseTypeFromValInitializer(@NotNull IrExpression $this$getMostPreciseTypeFromValInitializer) {
        Intrinsics.checkNotNullParameter($this$getMostPreciseTypeFromValInitializer, "<this>");
        IrExpression temp = null;
        temp = $this$getMostPreciseTypeFromValInitializer;
        while (true) {
            IrExpression it;
            if (UtilsKt.getMostPreciseTypeFromValInitializer$unwrapValInitializer(temp) != null) {
                IrExpression it2;
                boolean bl = false;
                temp = it2;
                continue;
            }
            if (UtilsKt.getMostPreciseTypeFromValInitializer$unwrapStatementContainer(temp) == null) break;
            boolean bl = false;
            temp = it;
        }
        return temp.getType();
    }

    private static final IrExpression getMostPreciseTypeFromValInitializer$unwrapValInitializer(IrExpression expression2) {
        Object object = expression2 instanceof IrGetValue ? (IrGetValue)expression2 : null;
        IrValueDeclaration irValueDeclaration = object != null && (object = ((IrValueAccessExpression)object).getSymbol()) != null ? object.getOwner() : null;
        IrVariable irVariable = irValueDeclaration instanceof IrVariable ? (IrVariable)irValueDeclaration : null;
        if (irVariable == null) {
            return null;
        }
        IrVariable irVariable2 = irVariable;
        if (irVariable2.isVar()) {
            return null;
        }
        return irVariable2.getInitializer();
    }

    private static final IrExpression getMostPreciseTypeFromValInitializer$unwrapStatementContainer(IrExpression expression2) {
        IrExpression irExpression;
        IrStatementContainer irStatementContainer = expression2 instanceof IrStatementContainer ? (IrStatementContainer)((Object)expression2) : null;
        if (irStatementContainer != null) {
            IrStatement irStatement;
            IrStatementContainer it = irStatementContainer;
            boolean bl = false;
            irExpression = it instanceof IrReturnTarget ? null : ((irStatement = CollectionsKt.lastOrNull(it.getStatements())) instanceof IrExpression ? (IrExpression)irStatement : null);
        } else {
            irExpression = null;
        }
        return irExpression;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            try {
                nArray[PrimitiveType.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.SHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.INT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.LONG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.FLOAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.DOUBLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

