/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.TestGeneratorKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/GenerateWasmTests;", "Lorg/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nGenerateWasmTests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateWasmTests.kt\norg/jetbrains/kotlin/backend/wasm/lower/GenerateWasmTests\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1#2:39\n1863#3,2:40\n*S KotlinDebug\n*F\n+ 1 GenerateWasmTests.kt\norg/jetbrains/kotlin/backend/wasm/lower/GenerateWasmTests\n*L\n31#1:40,2\n*E\n"})
public final class GenerateWasmTests
implements ModuleLoweringPass {
    @NotNull
    private final WasmBackendContext context;

    public GenerateWasmTests(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter(irModule, "irModule");
        TestGeneratorKt.generateJsTests(this.context, irModule, true);
        if (this.context.getTestEntryPoints().isEmpty()) {
            return;
        }
        if (!(this.context.getWasmSymbols().getStartUnitTests() != null)) {
            boolean $i$a$-require-GenerateWasmTests$lower$22 = false;
            String $i$a$-require-GenerateWasmTests$lower$22 = "kotlin.test package must be present";
            throw new IllegalArgumentException($i$a$-require-GenerateWasmTests$lower$22.toString());
        }
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)this.context.getWasmSymbols().getStartUnitTests(), 0, 0, 6, null);
        IrBody irBody = ((IrSimpleFunction)this.context.getWasmSymbols().getStartUnitTests().getOwner()).getBody();
        Intrinsics.checkNotNull(irBody, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        IrBlockBody startFunctionBody = (IrBlockBody)irBody;
        Iterable $this$forEach$iv = this.context.getTestEntryPoints();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrSimpleFunction testEntry = (IrSimpleFunction)element$iv;
            boolean bl = false;
            startFunctionBody.getStatements().add(ExpressionHelpersKt.irCall((IrBuilderWithScope)builder, testEntry));
        }
    }
}

