/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0017J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/CompilerLoggerAdapter;", "Lorg/jetbrains/kotlin/util/Logger;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "treatWarningsAsErrors", "", "<init>", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Z)V", "log", "", "message", "", "warning", "strongWarning", "error", "fatal", "", "orError", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "cli"})
final class CompilerLoggerAdapter
implements Logger {
    @NotNull
    private final MessageCollector messageCollector;
    private final boolean treatWarningsAsErrors;

    public CompilerLoggerAdapter(@NotNull MessageCollector messageCollector, boolean treatWarningsAsErrors) {
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        this.messageCollector = messageCollector;
        this.treatWarningsAsErrors = treatWarningsAsErrors;
    }

    @Override
    public void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.messageCollector.report(CompilerMessageSeverity.LOGGING, message, null);
    }

    @Override
    public void warning(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.messageCollector.report(this.orError(CompilerMessageSeverity.WARNING), message, null);
    }

    @Override
    public void strongWarning(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.messageCollector.report(this.orError(CompilerMessageSeverity.STRONG_WARNING), message, null);
    }

    @Override
    public void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.messageCollector.report(CompilerMessageSeverity.ERROR, message, null);
    }

    @Override
    @Deprecated(message="Invocation of fatal() may cause severe side effects such as throwing an exception or even terminating the current JVM process (check various implementations of this function for details). The code that uses Logger.fatal() sometimes expects a particular kind of side effect. This is an undesirable design. And it's definitely not a responsibility of Logger to influence the execution flow of the program.", replaceWith=@ReplaceWith(expression="error(message)", imports={}))
    @NotNull
    public Void fatal(@NotNull String message) {
        block0: {
            Intrinsics.checkNotNullParameter(message, "message");
            this.error(message);
            MessageCollector messageCollector = this.messageCollector;
            GroupingMessageCollector groupingMessageCollector = messageCollector instanceof GroupingMessageCollector ? (GroupingMessageCollector)messageCollector : null;
            if (groupingMessageCollector == null) break block0;
            groupingMessageCollector.flush();
        }
        throw new CompilationErrorException();
    }

    private final CompilerMessageSeverity orError(CompilerMessageSeverity $this$orError) {
        return this.treatWarningsAsErrors ? CompilerMessageSeverity.ERROR : $this$orError;
    }
}

