/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.NativeStandardInteropNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOutletChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCOutletChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCOutletChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOutletChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,68:1\n37#2:69\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCOutletChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOutletChecker\n*L\n63#1:69\n*E\n"})
public final class FirNativeObjCOutletChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCOutletChecker INSTANCE = new FirNativeObjCOutletChecker();

    private FirNativeObjCOutletChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSession session2 = context.getSession();
        FirMemberDeclaration $this$isExpect$iv = declaration;
        boolean $i$f$isExpect = false;
        if (!$this$isExpect$iv.getStatus().isExpect() && FirObjCInteropKt.isKotlinObjCClass(declaration.getSymbol(), context.getSession())) {
            FirNativeObjCOutletChecker.check$checkKotlinObjCClass(session2, reporter, context, declaration);
        }
    }

    private static final void check$checkCanGenerateFunctionImp(DiagnosticReporter $reporter, CheckerContext $context, FirPropertyAccessor setter2) {
        if (setter2.getValueParameters().size() > 2) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)setter2.getSource(), FirNativeErrors.INSTANCE.getTWO_OR_LESS_PARAMETERS_ARE_SUPPORTED_HERE(), (DiagnosticContext)$context, null, 8, null);
        }
    }

    private static final void check$checkCanGenerateOutletSetterImp(DiagnosticReporter $reporter, CheckerContext $context, FirSession session2, FirProperty property) {
        if (!property.isVar()) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)property.getSource(), FirNativeErrors.INSTANCE.getPROPERTY_MUST_BE_VAR(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOutletClassId().asSingleFqName(), (DiagnosticContext)$context, null, 16, null);
            return;
        }
        FirReceiverParameter firReceiverParameter = property.getReceiverParameter();
        if (firReceiverParameter != null) {
            FirReceiverParameter it = firReceiverParameter;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getMUST_NOT_HAVE_EXTENSION_RECEIVER(), (Object)('@' + NativeStandardInteropNames.INSTANCE.getObjCOutletClassId().asFqNameString()), (DiagnosticContext)$context, null, 16, null);
        }
        FirTypeRef type2 = property.getReturnTypeRef();
        if (!FirObjCInteropKt.isObjCObjectType(type2, session2)) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)property.getReturnTypeRef().getSource(), FirNativeErrors.INSTANCE.getMUST_BE_OBJC_OBJECT_TYPE(), (Object)("" + '@' + NativeStandardInteropNames.INSTANCE.getObjCOutletClassId().asSingleFqName() + " type"), (Object)FirTypeUtilsKt.getConeType(type2), (DiagnosticContext)$context, null, 32, null);
        }
        FirPropertyAccessor firPropertyAccessor = property.getSetter();
        Intrinsics.checkNotNull(firPropertyAccessor);
        FirNativeObjCOutletChecker.check$checkCanGenerateFunctionImp($reporter, $context, firPropertyAccessor);
    }

    private static final void check$checkKotlinObjCClass(FirSession session2, DiagnosticReporter $reporter, CheckerContext $context, FirClass firClass) {
        for (FirDeclaration decl : firClass.getDeclarations()) {
            if (!(decl instanceof FirProperty) || !FirAnnotationUtilsKt.hasAnnotation(((FirProperty)decl).getAnnotations(), NativeStandardInteropNames.INSTANCE.getObjCOutletClassId(), session2)) continue;
            FirNativeObjCOutletChecker.check$checkCanGenerateOutletSetterImp($reporter, $context, session2, (FirProperty)decl);
        }
    }
}

