/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsCommonInlineClassesUtils;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IdSignatureValues;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsInlineClassesUtils;", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonInlineClassesUtils;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getInlinedClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isClassInlineLike", "", "klass", "boxIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getBoxIntrinsic", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "unboxIntrinsic", "getUnboxIntrinsic", "backend.js"})
public final class JsInlineClassesUtils
implements JsCommonInlineClassesUtils {
    @NotNull
    private final JsIrBackendContext context;

    public JsInlineClassesUtils(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public IrClass getInlinedClass(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        if (type2 instanceof IrSimpleType) {
            IrClass irClass = IrTypeUtilsKt.erase(type2);
            if (irClass == null) {
                return null;
            }
            IrClass erased = irClass;
            if (this.isClassInlineLike(erased)) {
                if (IrTypePredicatesKt.isMarkedNullable((IrSimpleType)type2)) {
                    IrType fieldType = null;
                    IrClass fieldInlinedClass = erased;
                    while (true) {
                        if (IrTypePredicatesKt.isMarkedNullable(fieldType = this.getInlineClassUnderlyingType(fieldInlinedClass))) {
                            return null;
                        }
                        if (this.getInlinedClass(fieldType) == null) break;
                    }
                }
                return erased;
            }
        }
        return null;
    }

    @Override
    public boolean isClassInlineLike(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return JsCommonInlineClassesUtils.super.isClassInlineLike(klass) || Intrinsics.areEqual(klass.getSymbol().getSignature(), IdSignatureValues._char);
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getBoxIntrinsic() {
        return this.context.getIntrinsics().getJsBoxIntrinsic();
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getUnboxIntrinsic() {
        return this.context.getIntrinsics().getJsUnboxIntrinsic();
    }
}

