/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.phaser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.LoggingContext;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfigurationService;
import org.jetbrains.kotlin.backend.common.phaser.PhaserState;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\u0004\b\u0001\u0010\u0003*\u0004\b\u0002\u0010\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005B\u0081\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00000\t\u0012$\b\u0002\u0010\n\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00028\u0001`\r0\t\u0012$\b\u0002\u0010\u000e\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00028\u0002`\r0\t\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J3\u0010\u001b\u001a\u00028\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001f2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\"J3\u0010#\u001a\u00028\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001f2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\"J3\u0010$\u001a\u00028\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001f2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\"J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00020\u001f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001fH&J3\u0010&\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001f2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010'J;\u0010(\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00020\u001f2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u00012\u0006\u0010)\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010*J3\u0010+\u001a\u00028\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001f2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010,\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\"J\b\u0010-\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R-\u0010\n\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00028\u0001`\r0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R-\u0010\u000e\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00028\u0002`\r0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/backend/common/phaser/AbstractNamedCompilerPhase;", "Context", "Lorg/jetbrains/kotlin/backend/common/LoggingContext;", "Input", "Output", "Lorg/jetbrains/kotlin/backend/common/phaser/CompilerPhase;", "name", "", "prerequisite", "", "preconditions", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/phaser/Checker;", "postconditions", "nlevels", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;I)V", "getName", "()Ljava/lang/String;", "getPrerequisite", "()Ljava/util/Set;", "getPreconditions", "getPostconditions", "getNlevels", "()I", "invoke", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;", "phaserState", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;", "context", "input", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/LoggingContext;Ljava/lang/Object;)Ljava/lang/Object;", "phaseBody", "outputIfNotEnabled", "changePhaserStateType", "runBefore", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/LoggingContext;Ljava/lang/Object;)V", "runAfter", "output", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/LoggingContext;Ljava/lang/Object;Ljava/lang/Object;)V", "runAndProfile", "source", "toString", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nCompilerPhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerPhase.kt\norg/jetbrains/kotlin/backend/common/phaser/AbstractNamedCompilerPhase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CompilerPhase.kt\norg/jetbrains/kotlin/backend/common/phaser/CompilerPhaseKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,254:1\n1557#2:255\n1628#2,3:256\n33#3,4:259\n33#3,4:265\n29#4,2:263\n31#4:269\n*S KotlinDebug\n*F\n+ 1 CompilerPhase.kt\norg/jetbrains/kotlin/backend/common/phaser/AbstractNamedCompilerPhase\n*L\n102#1:255\n102#1:256,3\n111#1:259,4\n136#1:265,4\n135#1:263,2\n135#1:269\n*E\n"})
public abstract class AbstractNamedCompilerPhase<Context extends LoggingContext, Input, Output>
implements CompilerPhase<Context, Input, Output> {
    @NotNull
    private final String name;
    @NotNull
    private final Set<AbstractNamedCompilerPhase<?, ?, ?>> prerequisite;
    @NotNull
    private final Set<Function1<Input, Unit>> preconditions;
    @NotNull
    private final Set<Function1<Output, Unit>> postconditions;
    private final int nlevels;

    public AbstractNamedCompilerPhase(@NotNull String name, @NotNull Set<? extends AbstractNamedCompilerPhase<?, ?, ?>> prerequisite, @NotNull Set<? extends Function1<? super Input, Unit>> preconditions, @NotNull Set<? extends Function1<? super Output, Unit>> postconditions, int nlevels) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(prerequisite, (String)"prerequisite");
        Intrinsics.checkNotNullParameter(preconditions, (String)"preconditions");
        Intrinsics.checkNotNullParameter(postconditions, (String)"postconditions");
        this.name = name;
        this.prerequisite = prerequisite;
        this.preconditions = preconditions;
        this.postconditions = postconditions;
        this.nlevels = nlevels;
    }

    public /* synthetic */ AbstractNamedCompilerPhase(String string, Set set, Set set2, Set set3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n2 & 4) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n2 & 8) != 0) {
            set3 = SetsKt.emptySet();
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        this(string, set, set2, set3, n);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Set<AbstractNamedCompilerPhase<?, ?, ?>> getPrerequisite() {
        return this.prerequisite;
    }

    @NotNull
    public final Set<Function1<Input, Unit>> getPreconditions() {
        return this.preconditions;
    }

    @NotNull
    public final Set<Function1<Output, Unit>> getPostconditions() {
        return this.postconditions;
    }

    protected final int getNlevels() {
        return this.nlevels;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Output invoke(@NotNull PhaseConfigurationService phaseConfig, @NotNull PhaserState<Input> phaserState, @NotNull Context context, Input input) {
        Output Output2;
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter(phaserState, (String)"phaserState");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        if (!phaseConfig.isEnabled(this)) {
            return this.outputIfNotEnabled(phaseConfig, phaserState, context, input);
        }
        boolean bl = phaserState.getAlreadyDone().containsAll((Collection)this.prerequisite);
        if (_Assertions.ENABLED && !bl) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean $i$a$-assert-AbstractNamedCompilerPhase$invoke$22 = false;
            Iterable iterable = SetsKt.minus(this.prerequisite, (Iterable)phaserState.getAlreadyDone());
            StringBuilder stringBuilder = new StringBuilder().append("Lowering ").append(this.name).append(": phases ");
            boolean $i$f$map = false;
            void var10_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AbstractNamedCompilerPhase abstractNamedCompilerPhase = (AbstractNamedCompilerPhase)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.name);
            }
            String $i$a$-assert-AbstractNamedCompilerPhase$invoke$22 = stringBuilder.append((List)destination$iv$iv).append(" are required, but not satisfied").toString();
            throw new AssertionError((Object)$i$a$-assert-AbstractNamedCompilerPhase$invoke$22);
        }
        context.setInVerbosePhase(phaseConfig.isVerbose(this));
        this.runBefore(phaseConfig, phaserState, context, input);
        if (phaseConfig.getNeedProfiling()) {
            Output2 = this.runAndProfile(phaseConfig, phaserState, context, input);
        } else {
            void $this$downlevel$iv;
            PhaserState<Input> $i$a$-assert-AbstractNamedCompilerPhase$invoke$22 = phaserState;
            int nlevels$iv = this.nlevels;
            boolean $i$f$downlevel = false;
            $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() + nlevels$iv);
            boolean bl3 = false;
            Output result$iv = this.phaseBody(phaseConfig, phaserState, context, input);
            $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() - nlevels$iv);
            Output2 = result$iv;
        }
        Output output = Output2;
        this.runAfter(phaseConfig, this.changePhaserStateType(phaserState), context, input, output);
        phaserState.getAlreadyDone().add(this);
        int n = phaserState.getPhaseCount();
        phaserState.setPhaseCount(n + 1);
        return output;
    }

    public abstract Output phaseBody(@NotNull PhaseConfigurationService var1, @NotNull PhaserState<Input> var2, @NotNull Context var3, Input var4);

    public abstract Output outputIfNotEnabled(@NotNull PhaseConfigurationService var1, @NotNull PhaserState<Input> var2, @NotNull Context var3, Input var4);

    @NotNull
    public abstract PhaserState<Output> changePhaserStateType(@NotNull PhaserState<Input> var1);

    public abstract void runBefore(@NotNull PhaseConfigurationService var1, @NotNull PhaserState<Input> var2, @NotNull Context var3, Input var4);

    public abstract void runAfter(@NotNull PhaseConfigurationService var1, @NotNull PhaserState<Output> var2, @NotNull Context var3, Input var4, Output var5);

    /*
     * WARNING - void declaration
     */
    private final Output runAndProfile(PhaseConfigurationService phaseConfig, PhaserState<Input> phaserState, Context context, Input source) {
        void $this$downlevel$iv;
        Ref.ObjectRef result = new Ref.ObjectRef();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        PhaserState<Input> phaserState2 = phaserState;
        int nlevels$iv = this.nlevels;
        boolean $i$f$downlevel = false;
        $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() + nlevels$iv);
        Ref.ObjectRef objectRef = result;
        boolean bl2 = false;
        Output result$iv = this.phaseBody(phaseConfig, phaserState, context, source);
        $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() - nlevels$iv);
        objectRef.element = result$iv;
        long msec = System.currentTimeMillis() - start$iv;
        System.out.println((Object)(StringsKt.repeat((CharSequence)"\t", (int)phaserState.getDepth()) + this.name + ": " + msec + " msec"));
        Object object = result.element;
        Intrinsics.checkNotNull((Object)object);
        return (Output)object;
    }

    @NotNull
    public String toString() {
        return "Compiler Phase @" + this.name;
    }
}

