/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\rj\u0002`\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "value", "", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "<init>", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getValue", "()Ljava/lang/Object;", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "getFields", "()Ljava/util/Map;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getField", "symbol", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "toString", "", "Companion", "ir.interpreter"})
public final class Primitive
implements State {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Object value;
    @NotNull
    private final IrType type;
    @NotNull
    private final Map<IrSymbol, State> fields;
    @NotNull
    private final IrClass irClass;

    public Primitive(@Nullable Object value, @NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.value = value;
        this.type = type;
        this.fields = new LinkedHashMap();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.type);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this.irClass = (IrClass)irClassSymbol.getOwner();
    }

    @Nullable
    public final Object getValue() {
        return this.value;
    }

    @NotNull
    public final IrType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @Nullable
    public State getField(@NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        return null;
    }

    @Override
    @NotNull
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrSimpleFunction owner = (IrSimpleFunction)expression.getSymbol().getOwner();
        return owner.isFakeOverride() ? UtilsKt.getFirstNonInterfaceOverridden(owner) : (IrFunction)owner;
    }

    @NotNull
    public String toString() {
        return "Primitive(value=" + this.value + ", type=" + IrUtilsKt.getDefaultType(this.getIrClass()) + ')';
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive$Companion;", "", "<init>", "()V", "nullStateOfType", "Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Primitive nullStateOfType(@NotNull IrType irType) {
            Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
            return new Primitive(null, irType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

