/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.inspectionKts.js;

import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.qodana.inspectionKts.templates.InspectionKtsTemplateKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a8\u0006\u0003"}, d2={"templateJsInspectionKts", "", "filename", "intellij.qodana.inspectionKts.js"})
public final class TemplatesKt {
    private static final String templateJsInspectionKts(String filename) {
        String inspectionName = InspectionKtsTemplateKt.templateInspectionKtsFilenameToInspectionName(filename);
        String imports = "import com.intellij.lang.javascript.psi.JSFunction\nimport com.intellij.lang.javascript.psi.JSVariable";
        String topComment = "/**\n * This is an auto-generated template JavaScript custom inspection\n * Reports all local variables inside all functions\n *\n * The inspection is applied automatically and executed on-fly: to see the inspection results, open the JavaScript file in the editor\n */";
        String inspectionVisitorContent = StringsKt.trimIndent((String)("\n    val everyVariableInFunctionInspection = localInspection { psiFile, inspection ->\n        // take js functions in file\n        val functions = psiFile.descendantsOfType<JSFunction>()\n    \n        functions.forEach { function: JSFunction ->\n            // take all local variables inside the function\n            val variables = function.descendantsOfType<JSVariable>()\n            variables.forEach { variable: JSVariable ->\n                // declaration type \u2013 const/val/var, if none \u2013 ignore\n                val variableDeclarationKeyword = variable.statement?.varKeyword ?: return@forEach\n                // variable type\n                val variableType = variable.resolveJsType()\n                val message = \"This is a variable ${variable.name} in function ${function.name} of type $variableType declared as $variableDeclarationKeyword. " + inspectionName + "\"\n                inspection.registerProblem(variable.nameIdentifier ?: variable, message)\n            }\n        }\n    }\n  "));
        return InspectionKtsTemplateKt.standardLocalInspectionKtsTemplateContent$default(filename, imports, topComment, null, inspectionVisitorContent, "everyVariableInFunctionInspection", null, 72, null);
    }

    public static final /* synthetic */ String access$templateJsInspectionKts(String filename) {
        return TemplatesKt.templateJsInspectionKts(filename);
    }
}

