/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 5693540857015L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1585815930 - 31066, 1585815930 - 29980, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1585815930 - 31065, 1585815930 - 16976, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 66338758564653L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.Q();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1306243620 + (char)-27244, 1306243620 + (char)-24824, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1306243620 + (char)-27243, 1306243620 + 21996, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1306243620 + (char)-27238, 1306243620 + (char)-16593, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 11116886554075L;
                Object object = this.lock;
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.Q();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1511237100 - -((char)-12491), 1511237100 - (char)-12115, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1511237100 - -((char)-12490), 1511106030 + (char)-7197, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1511237100 - -((char)-12489), 1511106030 + (char)-6108, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1511237100 - -((char)-12496), -1511106030 + -((char)-7603), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1511237100 - -((char)-12495), 1511237100 - (char)-4377, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1511237100 - -((char)-12489), 1511106030 + (char)-6108, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1511237100 - -((char)-12494), -1511237100 - -((char)-11894), (int)l2));
            if (ActionTimestamp.Q() != null) {
                SshAgentIpcService.Q(new ActionTimestamp[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 135426801276025L;
                    actionTimestampArray = SshAgentIpcService.Q();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block27: {
            block28: {
                l2 = 115706579369455L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            actionTimestampArray = SshAgentIpcService.Q();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-160429680 - -22499, -160429680 - -5170, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-160429680 - -22511, 160429680 - 12362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-160429680 - -22500, 160429680 - 515, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-160429680 - -22511, 160429680 - 12362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-160429680 - -22501, -160429680 - -10753, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-160429680 - -22499, -160429680 - -5170, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-160429680 - -22511, 160429680 - 12362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-160429680 - -22502, -160429680 - -14631, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-160429680 - -22499, -160429680 - -5170, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-160429680 - -22511, 160429680 - 12362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-160429680 - -22503, 160429680 - 9531, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-160429680 - -22511, 160429680 - 12362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-160429680 - -22488, 160429680 - 17854, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-160429680 - -22511, 160429680 - 12362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-160429680 - -22501, -160429680 - -10753, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-160429680 - -22499, -160429680 - -5170, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-160429680 - -22511, 160429680 - 12362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-160429680 - -22489, -160429680 - -13404, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 19179268251403L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(2055701880 - 8571, -2055701880 - -16683, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 54635942152700L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(336849900 - 30433, 336849900 - (char)-25582, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00e5\u0003\u009cA<\u000f8\u00f4j\u00e4\u00a7[\u009e\u00a6\u00a9\u00df\u00c2\u009f\u00c2\u0014\u001e\u00cc\u00e3\u00be\u00c82\u00db\u00d6\u0094\u00a6\u00bd\u00c7\u001f\u00ccX\u0019\u0011\u0081\u00bf\u00c5";
                        var4_3 = "\u00e5\u0003\u009cA<\u000f8\u00f4j\u00e4\u00a7[\u009e\u00a6\u00a9\u00df\u00c2\u009f\u00c2\u0014\u001e\u00cc\u00e3\u00be\u00c82\u00db\u00d6\u0094\u00a6\u00bd\u00c7\u001f\u00ccX\u0019\u0011\u0081\u00bf\u00c5".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 42;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 87;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 46;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 113;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 11;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 25;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 57;
                                        break;
                                    }
                                    default: {
                                        v11 = 37;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFFCF6) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 50;
                            case 1 -> 100;
                            case 2 -> 217;
                            case 3 -> 134;
                            case 4 -> 121;
                            case 5 -> 63;
                            case 6 -> 185;
                            case 7 -> 145;
                            case 8 -> 60;
                            case 9 -> 207;
                            case 10 -> 153;
                            case 11 -> 192;
                            case 12 -> 67;
                            case 13 -> 218;
                            case 14 -> 68;
                            case 15 -> 118;
                            case 16 -> 12;
                            case 17 -> 104;
                            case 18 -> 29;
                            case 19 -> 200;
                            case 20 -> 108;
                            case 21 -> 70;
                            case 22 -> 4;
                            case 23 -> 98;
                            case 24 -> 136;
                            case 25 -> 132;
                            case 26 -> 56;
                            case 27 -> 33;
                            case 28 -> 196;
                            case 29 -> 169;
                            case 30 -> 17;
                            case 31 -> 30;
                            case 32 -> 21;
                            case 33 -> 96;
                            case 34 -> 241;
                            case 35 -> 249;
                            case 36 -> 18;
                            case 37 -> 146;
                            case 38 -> 198;
                            case 39 -> 158;
                            case 40 -> 48;
                            case 41 -> 103;
                            case 42 -> 129;
                            case 43 -> 181;
                            case 44 -> 8;
                            case 45 -> 210;
                            case 46 -> 166;
                            case 47 -> 88;
                            case 48 -> 216;
                            case 49 -> 97;
                            case 50 -> 162;
                            case 51 -> 170;
                            case 52 -> 94;
                            case 53 -> 31;
                            case 54 -> 42;
                            case 55 -> 1;
                            case 56 -> 175;
                            case 57 -> 81;
                            case 58 -> 144;
                            case 59 -> 202;
                            case 60 -> 66;
                            case 61 -> 255;
                            case 62 -> 180;
                            case 63 -> 72;
                            case 64 -> 227;
                            case 65 -> 177;
                            case 66 -> 45;
                            case 67 -> 113;
                            case 68 -> 71;
                            case 69 -> 116;
                            case 70 -> 85;
                            case 71 -> 240;
                            case 72 -> 226;
                            case 73 -> 99;
                            case 74 -> 228;
                            case 75 -> 157;
                            case 76 -> 92;
                            case 77 -> 195;
                            case 78 -> 182;
                            case 79 -> 250;
                            case 80 -> 133;
                            case 81 -> 199;
                            case 82 -> 212;
                            case 83 -> 148;
                            case 84 -> 49;
                            case 85 -> 163;
                            case 86 -> 117;
                            case 87 -> 122;
                            case 88 -> 130;
                            case 89 -> 219;
                            case 90 -> 58;
                            case 91 -> 77;
                            case 92 -> 243;
                            case 93 -> 149;
                            case 94 -> 206;
                            case 95 -> 110;
                            case 96 -> 253;
                            case 97 -> 7;
                            case 98 -> 51;
                            case 99 -> 25;
                            case 100 -> 179;
                            case 101 -> 224;
                            case 102 -> 156;
                            case 103 -> 214;
                            case 104 -> 159;
                            case 105 -> 62;
                            case 106 -> 190;
                            case 107 -> 178;
                            case 108 -> 235;
                            case 109 -> 105;
                            case 110 -> 14;
                            case 111 -> 184;
                            case 112 -> 84;
                            case 113 -> 222;
                            case 114 -> 127;
                            case 115 -> 101;
                            case 116 -> 123;
                            case 117 -> 53;
                            case 118 -> 124;
                            case 119 -> 245;
                            case 120 -> 137;
                            case 121 -> 40;
                            case 122 -> 174;
                            case 123 -> 143;
                            case 124 -> 128;
                            case 125 -> 83;
                            case 126 -> 39;
                            case 127 -> 73;
                            case 128 -> 203;
                            case 129 -> 80;
                            case 130 -> 44;
                            case 131 -> 173;
                            case 132 -> 114;
                            case 133 -> 20;
                            case 134 -> 233;
                            case 135 -> 2;
                            case 136 -> 237;
                            case 137 -> 251;
                            case 138 -> 223;
                            case 139 -> 76;
                            case 140 -> 15;
                            case 141 -> 186;
                            case 142 -> 69;
                            case 143 -> 229;
                            case 144 -> 41;
                            case 145 -> 135;
                            case 146 -> 79;
                            case 147 -> 234;
                            case 148 -> 3;
                            case 149 -> 75;
                            case 150 -> 86;
                            case 151 -> 220;
                            case 152 -> 194;
                            case 153 -> 74;
                            case 154 -> 215;
                            case 155 -> 172;
                            case 156 -> 208;
                            case 157 -> 168;
                            case 158 -> 93;
                            case 159 -> 24;
                            case 160 -> 26;
                            case 161 -> 36;
                            case 162 -> 78;
                            case 163 -> 64;
                            case 164 -> 211;
                            case 165 -> 43;
                            case 166 -> 46;
                            case 167 -> 183;
                            case 168 -> 55;
                            case 169 -> 65;
                            case 170 -> 37;
                            case 171 -> 27;
                            case 172 -> 239;
                            case 173 -> 120;
                            case 174 -> 82;
                            case 175 -> 89;
                            case 176 -> 131;
                            case 177 -> 16;
                            case 178 -> 138;
                            case 179 -> 13;
                            case 180 -> 95;
                            case 181 -> 23;
                            case 182 -> 154;
                            case 183 -> 9;
                            case 184 -> 151;
                            case 185 -> 28;
                            case 186 -> 141;
                            case 187 -> 111;
                            case 188 -> 106;
                            case 189 -> 155;
                            case 190 -> 35;
                            case 191 -> 225;
                            case 192 -> 87;
                            case 193 -> 59;
                            case 194 -> 54;
                            case 195 -> 205;
                            case 196 -> 119;
                            case 197 -> 187;
                            case 198 -> 247;
                            case 199 -> 112;
                            case 200 -> 147;
                            case 201 -> 11;
                            case 202 -> 236;
                            case 203 -> 90;
                            case 204 -> 52;
                            case 205 -> 201;
                            case 206 -> 165;
                            case 207 -> 0;
                            case 208 -> 188;
                            case 209 -> 102;
                            case 210 -> 91;
                            case 211 -> 107;
                            case 212 -> 61;
                            case 213 -> 191;
                            case 214 -> 244;
                            case 215 -> 176;
                            case 216 -> 38;
                            case 217 -> 230;
                            case 218 -> 254;
                            case 219 -> 109;
                            case 220 -> 34;
                            case 221 -> 204;
                            case 222 -> 232;
                            case 223 -> 140;
                            case 224 -> 32;
                            case 225 -> 197;
                            case 226 -> 47;
                            case 227 -> 167;
                            case 228 -> 164;
                            case 229 -> 189;
                            case 230 -> 142;
                            case 231 -> 252;
                            case 232 -> 5;
                            case 233 -> 242;
                            case 234 -> 213;
                            case 235 -> 139;
                            case 236 -> 126;
                            case 237 -> 6;
                            case 238 -> 221;
                            case 239 -> 19;
                            case 240 -> 10;
                            case 241 -> 238;
                            case 242 -> 115;
                            case 243 -> 209;
                            case 244 -> 160;
                            case 245 -> 231;
                            case 246 -> 150;
                            case 247 -> 171;
                            case 248 -> 193;
                            case 249 -> 161;
                            case 250 -> 57;
                            case 251 -> 22;
                            case 252 -> 246;
                            case 253 -> 152;
                            case 254 -> 125;
                            default -> 248;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (actionTimestampArray == null) {
                ActionTimestamp.Q("gr82vc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 131412987522031L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.Q();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(126875760 - (char)-32515, 126875760 - (char)-4946, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(126875760 - (char)-32527, -126875760 - -((char)-14186), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(126875760 - (char)-32506, 126875760 - (char)-7838, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(126875760 - (char)-32515, 126875760 - (char)-4946, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(126875760 - (char)-32527, -126875760 - -((char)-14186), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(126875760 - (char)-32507, 126875760 - (char)-4860, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 119084583203049L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.Q();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1974962760 + (char)-7646, -1974962760 + -((char)-2679), (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1974962760 + (char)-7645, 1974962760 + (char)-17676, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 115690116522318L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.Q();
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    actionTimestampArray = actionTimestampArray2;
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18822), -877513650 - -((char)-13035), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18834), 877513650 - (char)-3797, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18819), 877513650 - (char)-5669, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18834), 877513650 - (char)-3797, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18824), -877513650 - -((char)-1310), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18822), -877513650 - -((char)-13035), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18834), 877513650 - (char)-3797, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18818), -877382580 + -((char)-10443), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18822), -877513650 - -((char)-13035), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18834), 877513650 - (char)-3797, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18805), -877382580 + -((char)-11016), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18822), -877513650 - -((char)-13035), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18834), 877513650 - (char)-3797, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-877382580 + -((char)-18804), 877382580 + (char)-2331, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 110745977193377L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                actionTimestampArray = SshAgentIpcService.Q();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-245494110 - -20635, -245494110 - -5354, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-245494110 - -20623, 245494110 + 1802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-245494110 - -20618, 245494110 - 27264, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-245494110 - -20619, 245494110 - 19313, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-245494110 - -20635, -245494110 - -5354, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-245494110 - -20623, 245494110 + 1802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-245494110 - -20616, 245494110 - 13471, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-245494110 - -20635, -245494110 - -5354, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-245494110 - -20623, 245494110 + 1802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-245494110 - -20617, -245494110 - -19509, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-245494110 - -20635, -245494110 - -5354, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-245494110 - -20623, 245494110 + 1802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-245494110 - -20614, -245494110 - -28929, (int)l2));
                    if (actionTimestampArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-245494110 - -20635, -245494110 - -5354, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-245494110 - -20623, 245494110 + 1802, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-245494110 - -20615, -245494110 - -27939, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "u\f\u00db\u00da\u00ad\u00beHA\u0014o/\u00a0Y<F\u00d5D>\u0006\u00b2\u0015\u00d0\u00f83\u00a4\u00e8>\u00d9\n\u0006\u00df\u00cc\u008e\u00c2m\u00fc\u0018\u00f3\u0083S\u00fc\u00c07H\u00aaE\u00a6\u00d2q\u00ba\u008b,H\u00a2\u00ca\u00be\t\u00b9\u00f8\u00a9\u0090\t\u008d\u001c\u0002\u00be\u0081\u00e0x\u0018\u007f\u0005?\u0013\u00929\u00f4\b`\u00b9y\u001d\u00ab`\u008ex\u0005\u00e6\u00fc\u00a9\u00c4\u0093\u001e\u0097`\u00923i\n\u00dfw\u0012\ts\u0003\u00c2\u00e5\u0081\u00e1\u00f6n\u00e6i\u001e\u00dbQ9\bW\u00d3j\u0087\u00f2\u0010\u0081\u009e\u00b4)\u00fa{[\u00a0\u00ffAC\u00f7\u00c2..\u0007\t55\u00c3\u008a\u00eaA3\u00b3\u00f8\u0010c\u008f\u00e8\u000bq?*(\u00d1P\u0086\u00d5zj9\u008f?\u00b6\u00e6\u00be\u00e3\u00e1\u0019Ky\u00f1\u0019J\u00faZ,\u00af\u00e1\u00f6\u000b\u009b\u0000?\u00a4\u000e\u00b0\u00f3\u008e\u00a1\u00e5\u00feU#\u0086>\u00c2\\\u008b\u0019\u00e1*\u00e7\u0087\u0084\u0089\u00d5+\u00e3Q\u00e6[\u00f4,\u00cb\u0095\u00feB\\!\u0013\u000fd\u0097\u00e9\u00e6\b\u00b7,\u0083\u00af\u00f46e\u00b2\f\u00bb\u00b9\u0012\u0006\u00dban_p\u00f6\u00e0\u0005Fw\u00f2\u008bo\u00e8L\b\u00fa\u00bcNs\u00d6\u00eb\u00a1\u0086v/\u009e\u00a0\u001dJU\u00a3\u00bcp$\"\u00bb1\u00b7\u00e0\u00e6zx\u0016\u00fd\u008ab\u00f3S/\u0007\u0017^&\u0017\u00a4\u0005\u0002pa\u00f1\u00d3/\u009c}eC\u0011\u00d2gV\u00a4\u0093\u00bc\u00adt\u00cc\u00e9k\u001f\u00ab\u00b0\u0015)\u0099I\u00c1\u001f\u00d1\u0004\u000b\u00a2\u00cd\u00ccku\u00d0\u0014_\u00ec\u00e2\u00eb\u0019\u0094`2\u00c9\n\u00d9\u000f\u00ff\u000b\u00a8~p\u00fe\u0097~\u00e7\u00bcA\u0086\u00cc\u0015\u00a0\u00e0q.\u00b0\f\u00ef\u008f~\u0000\u00e3\u00e9n\t\u0002\u009b\u0006]X\u00bc4)ymO\u0092\u00d2>\u00a8\u00f1\u00fc\u00d9\u00ae\u0019}\u00b1\u00e3\u00df\u009e\u00c9M\u00f0P\u0010\u0089\u00f3\u001d\u0097\u00b1\u00c6\u00f9byb\u00b7M\u00c9\u00d6o\u001a\u00c4\u00f5j\u0007X\u00b5a\u00933C\u000f\u0007\u0097\u00c6\u00fc\u0091g\u00ec\u0093(\u00e61\u00f08\u0095\u0001\u00b61O\u0016\u00f2\u00d6\u00d5\u00c9\u00b4Ss\u00f5^4S\u00b6\u0086\u00ecl\u00c8)V\u00dd\u0010&5\u00a7\u00ccUKF\u00d4r\u00df\u000fC\u008d\n\u0086\"\u00ba\u00e5\u0085P\r\u00b0\u00e4=\u00db7\"r=.\u0098\u00fe\u007f-\u00d9L\u00dc\u00b8\u00b9\u00bc\u00a9\u00bf\u0012\u00feY\u00cb\u00a0j\u001an\u00e2r\u00e1\u0091\u00d6\u00d9R\u00dfcM\u009e\u000eQ\u0086H\u00e7j\u0096\u00ec\u0000q\u00bd\u0094\u00f2\u00b5\u0013\u001b\u00f2c;^\u00ff\u0014\u00cb\f\u00c2\u00bbo3\u009a\u001d]\u0092\n\u00e3\u00e8k5W\u00f6\u00ed*m\u00cf\n\u00ea\u00ad\u00fc\u0080\u0013+\u0085\u00c1\u00a0`\u0018?\u00bb\u0082H\u00c9j,\u009d @\u00f1\u00d3\u00f0R\u00ecZK\u00fb\u0017\u0011\u00b2S]>)\u0004\u008c\u00e0\u00ae'\u00b9\u0016\u0001+\u00c7T\u00da&\u00c0\u0017\u008a~\u0016\u008e\u00ce\u0012\u00c7\u0088\u0005H\u00db\u0086\u00a3L\u0092t\u00ed3b\u008c\u00a7\u0019\u0010\n\u00b4\u00b3";
                var4_3 = "u\f\u00db\u00da\u00ad\u00beHA\u0014o/\u00a0Y<F\u00d5D>\u0006\u00b2\u0015\u00d0\u00f83\u00a4\u00e8>\u00d9\n\u0006\u00df\u00cc\u008e\u00c2m\u00fc\u0018\u00f3\u0083S\u00fc\u00c07H\u00aaE\u00a6\u00d2q\u00ba\u008b,H\u00a2\u00ca\u00be\t\u00b9\u00f8\u00a9\u0090\t\u008d\u001c\u0002\u00be\u0081\u00e0x\u0018\u007f\u0005?\u0013\u00929\u00f4\b`\u00b9y\u001d\u00ab`\u008ex\u0005\u00e6\u00fc\u00a9\u00c4\u0093\u001e\u0097`\u00923i\n\u00dfw\u0012\ts\u0003\u00c2\u00e5\u0081\u00e1\u00f6n\u00e6i\u001e\u00dbQ9\bW\u00d3j\u0087\u00f2\u0010\u0081\u009e\u00b4)\u00fa{[\u00a0\u00ffAC\u00f7\u00c2..\u0007\t55\u00c3\u008a\u00eaA3\u00b3\u00f8\u0010c\u008f\u00e8\u000bq?*(\u00d1P\u0086\u00d5zj9\u008f?\u00b6\u00e6\u00be\u00e3\u00e1\u0019Ky\u00f1\u0019J\u00faZ,\u00af\u00e1\u00f6\u000b\u009b\u0000?\u00a4\u000e\u00b0\u00f3\u008e\u00a1\u00e5\u00feU#\u0086>\u00c2\\\u008b\u0019\u00e1*\u00e7\u0087\u0084\u0089\u00d5+\u00e3Q\u00e6[\u00f4,\u00cb\u0095\u00feB\\!\u0013\u000fd\u0097\u00e9\u00e6\b\u00b7,\u0083\u00af\u00f46e\u00b2\f\u00bb\u00b9\u0012\u0006\u00dban_p\u00f6\u00e0\u0005Fw\u00f2\u008bo\u00e8L\b\u00fa\u00bcNs\u00d6\u00eb\u00a1\u0086v/\u009e\u00a0\u001dJU\u00a3\u00bcp$\"\u00bb1\u00b7\u00e0\u00e6zx\u0016\u00fd\u008ab\u00f3S/\u0007\u0017^&\u0017\u00a4\u0005\u0002pa\u00f1\u00d3/\u009c}eC\u0011\u00d2gV\u00a4\u0093\u00bc\u00adt\u00cc\u00e9k\u001f\u00ab\u00b0\u0015)\u0099I\u00c1\u001f\u00d1\u0004\u000b\u00a2\u00cd\u00ccku\u00d0\u0014_\u00ec\u00e2\u00eb\u0019\u0094`2\u00c9\n\u00d9\u000f\u00ff\u000b\u00a8~p\u00fe\u0097~\u00e7\u00bcA\u0086\u00cc\u0015\u00a0\u00e0q.\u00b0\f\u00ef\u008f~\u0000\u00e3\u00e9n\t\u0002\u009b\u0006]X\u00bc4)ymO\u0092\u00d2>\u00a8\u00f1\u00fc\u00d9\u00ae\u0019}\u00b1\u00e3\u00df\u009e\u00c9M\u00f0P\u0010\u0089\u00f3\u001d\u0097\u00b1\u00c6\u00f9byb\u00b7M\u00c9\u00d6o\u001a\u00c4\u00f5j\u0007X\u00b5a\u00933C\u000f\u0007\u0097\u00c6\u00fc\u0091g\u00ec\u0093(\u00e61\u00f08\u0095\u0001\u00b61O\u0016\u00f2\u00d6\u00d5\u00c9\u00b4Ss\u00f5^4S\u00b6\u0086\u00ecl\u00c8)V\u00dd\u0010&5\u00a7\u00ccUKF\u00d4r\u00df\u000fC\u008d\n\u0086\"\u00ba\u00e5\u0085P\r\u00b0\u00e4=\u00db7\"r=.\u0098\u00fe\u007f-\u00d9L\u00dc\u00b8\u00b9\u00bc\u00a9\u00bf\u0012\u00feY\u00cb\u00a0j\u001an\u00e2r\u00e1\u0091\u00d6\u00d9R\u00dfcM\u009e\u000eQ\u0086H\u00e7j\u0096\u00ec\u0000q\u00bd\u0094\u00f2\u00b5\u0013\u001b\u00f2c;^\u00ff\u0014\u00cb\f\u00c2\u00bbo3\u009a\u001d]\u0092\n\u00e3\u00e8k5W\u00f6\u00ed*m\u00cf\n\u00ea\u00ad\u00fc\u0080\u0013+\u0085\u00c1\u00a0`\u0018?\u00bb\u0082H\u00c9j,\u009d @\u00f1\u00d3\u00f0R\u00ecZK\u00fb\u0017\u0011\u00b2S]>)\u0004\u008c\u00e0\u00ae'\u00b9\u0016\u0001+\u00c7T\u00da&\u00c0\u0017\u008a~\u0016\u008e\u00ce\u0012\u00c7\u0088\u0005H\u00db\u0086\u00a3L\u0092t\u00ed3b\u008c\u00a7\u0019\u0010\n\u00b4\u00b3".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 101;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00a6\u00c7\u009a\u00e1\u00e0\u00c8\u000f\u00f2\u00e9\u001d\n\u00f5\n\u00aaQ\u0012\u00f3_\u00bc'\u008d\u00ed6\r>\u0018pc4\u00cf;\u00f3uvw\u0082\u00db\u00e6\\";
                    var4_3 = "\u00a6\u00c7\u009a\u00e1\u00e0\u00c8\u000f\u00f2\u00e9\u001d\n\u00f5\n\u00aaQ\u0012\u00f3_\u00bc'\u008d\u00ed6\r>\u0018pc4\u00cf;\u00f3uvw\u0082\u00db\u00e6\\".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 38;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 23;
                            break;
                        }
                        case 1: {
                            v15 = 102;
                            break;
                        }
                        case 2: {
                            v15 = 80;
                            break;
                        }
                        case 3: {
                            v15 = 127;
                            break;
                        }
                        case 4: {
                            v15 = 59;
                            break;
                        }
                        case 5: {
                            v15 = 107;
                            break;
                        }
                        default: {
                            v15 = 125;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFDC97) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 224;
                case 1 -> 219;
                case 2 -> 121;
                case 3 -> 242;
                case 4 -> 204;
                case 5 -> 155;
                case 6 -> 61;
                case 7 -> 114;
                case 8 -> 196;
                case 9 -> 148;
                case 10 -> 208;
                case 11 -> 82;
                case 12 -> 206;
                case 13 -> 97;
                case 14 -> 145;
                case 15 -> 37;
                case 16 -> 27;
                case 17 -> 183;
                case 18 -> 226;
                case 19 -> 215;
                case 20 -> 222;
                case 21 -> 9;
                case 22 -> 240;
                case 23 -> 115;
                case 24 -> 184;
                case 25 -> 217;
                case 26 -> 29;
                case 27 -> 18;
                case 28 -> 172;
                case 29 -> 73;
                case 30 -> 210;
                case 31 -> 80;
                case 32 -> 48;
                case 33 -> 40;
                case 34 -> 135;
                case 35 -> 190;
                case 36 -> 225;
                case 37 -> 59;
                case 38 -> 87;
                case 39 -> 17;
                case 40 -> 28;
                case 41 -> 53;
                case 42 -> 108;
                case 43 -> 46;
                case 44 -> 141;
                case 45 -> 169;
                case 46 -> 86;
                case 47 -> 244;
                case 48 -> 126;
                case 49 -> 78;
                case 50 -> 31;
                case 51 -> 93;
                case 52 -> 151;
                case 53 -> 207;
                case 54 -> 211;
                case 55 -> 185;
                case 56 -> 140;
                case 57 -> 75;
                case 58 -> 52;
                case 59 -> 99;
                case 60 -> 174;
                case 61 -> 117;
                case 62 -> 202;
                case 63 -> 118;
                case 64 -> 164;
                case 65 -> 65;
                case 66 -> 157;
                case 67 -> 57;
                case 68 -> 125;
                case 69 -> 223;
                case 70 -> 138;
                case 71 -> 200;
                case 72 -> 165;
                case 73 -> 62;
                case 74 -> 68;
                case 75 -> 103;
                case 76 -> 22;
                case 77 -> 167;
                case 78 -> 100;
                case 79 -> 238;
                case 80 -> 47;
                case 81 -> 252;
                case 82 -> 89;
                case 83 -> 216;
                case 84 -> 191;
                case 85 -> 228;
                case 86 -> 110;
                case 87 -> 8;
                case 88 -> 14;
                case 89 -> 251;
                case 90 -> 203;
                case 91 -> 92;
                case 92 -> 79;
                case 93 -> 154;
                case 94 -> 250;
                case 95 -> 142;
                case 96 -> 84;
                case 97 -> 5;
                case 98 -> 11;
                case 99 -> 133;
                case 100 -> 247;
                case 101 -> 143;
                case 102 -> 146;
                case 103 -> 112;
                case 104 -> 234;
                case 105 -> 218;
                case 106 -> 38;
                case 107 -> 43;
                case 108 -> 54;
                case 109 -> 241;
                case 110 -> 231;
                case 111 -> 13;
                case 112 -> 109;
                case 113 -> 90;
                case 114 -> 201;
                case 115 -> 1;
                case 116 -> 106;
                case 117 -> 16;
                case 118 -> 42;
                case 119 -> 69;
                case 120 -> 221;
                case 121 -> 72;
                case 122 -> 70;
                case 123 -> 76;
                case 124 -> 236;
                case 125 -> 149;
                case 126 -> 177;
                case 127 -> 98;
                case 128 -> 197;
                case 129 -> 156;
                case 130 -> 159;
                case 131 -> 186;
                case 132 -> 2;
                case 133 -> 4;
                case 134 -> 71;
                case 135 -> 173;
                case 136 -> 181;
                case 137 -> 0;
                case 138 -> 139;
                case 139 -> 50;
                case 140 -> 212;
                case 141 -> 120;
                case 142 -> 39;
                case 143 -> 32;
                case 144 -> 188;
                case 145 -> 104;
                case 146 -> 178;
                case 147 -> 113;
                case 148 -> 229;
                case 149 -> 25;
                case 150 -> 77;
                case 151 -> 85;
                case 152 -> 152;
                case 153 -> 153;
                case 154 -> 64;
                case 155 -> 45;
                case 156 -> 67;
                case 157 -> 105;
                case 158 -> 81;
                case 159 -> 166;
                case 160 -> 254;
                case 161 -> 128;
                case 162 -> 19;
                case 163 -> 168;
                case 164 -> 51;
                case 165 -> 83;
                case 166 -> 111;
                case 167 -> 195;
                case 168 -> 179;
                case 169 -> 21;
                case 170 -> 12;
                case 171 -> 49;
                case 172 -> 124;
                case 173 -> 36;
                case 174 -> 94;
                case 175 -> 15;
                case 176 -> 248;
                case 177 -> 24;
                case 178 -> 162;
                case 179 -> 192;
                case 180 -> 26;
                case 181 -> 134;
                case 182 -> 41;
                case 183 -> 182;
                case 184 -> 58;
                case 185 -> 180;
                case 186 -> 23;
                case 187 -> 199;
                case 188 -> 187;
                case 189 -> 150;
                case 190 -> 243;
                case 191 -> 129;
                case 192 -> 107;
                case 193 -> 209;
                case 194 -> 255;
                case 195 -> 147;
                case 196 -> 132;
                case 197 -> 127;
                case 198 -> 253;
                case 199 -> 160;
                case 200 -> 220;
                case 201 -> 101;
                case 202 -> 170;
                case 203 -> 235;
                case 204 -> 194;
                case 205 -> 33;
                case 206 -> 176;
                case 207 -> 233;
                case 208 -> 137;
                case 209 -> 189;
                case 210 -> 249;
                case 211 -> 123;
                case 212 -> 88;
                case 213 -> 55;
                case 214 -> 56;
                case 215 -> 10;
                case 216 -> 161;
                case 217 -> 122;
                case 218 -> 35;
                case 219 -> 3;
                case 220 -> 213;
                case 221 -> 198;
                case 222 -> 130;
                case 223 -> 66;
                case 224 -> 232;
                case 225 -> 44;
                case 226 -> 227;
                case 227 -> 131;
                case 228 -> 96;
                case 229 -> 63;
                case 230 -> 7;
                case 231 -> 246;
                case 232 -> 30;
                case 233 -> 230;
                case 234 -> 239;
                case 235 -> 119;
                case 236 -> 158;
                case 237 -> 205;
                case 238 -> 144;
                case 239 -> 20;
                case 240 -> 175;
                case 241 -> 95;
                case 242 -> 34;
                case 243 -> 74;
                case 244 -> 245;
                case 245 -> 214;
                case 246 -> 6;
                case 247 -> 237;
                case 248 -> 60;
                case 249 -> 136;
                case 250 -> 102;
                case 251 -> 116;
                case 252 -> 91;
                case 253 -> 193;
                case 254 -> 163;
                default -> 171;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 133133250302920L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2145878040 + -((char)-31811), -2145878040 + -((char)-18781), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 85120123768177L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.Q();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1833013950 + -((char)-30033), -1833013950 + -((char)-26577), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1833013950 + -((char)-30030), 1833013950 + 29841, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1833013950 + -((char)-30031), 1833013950 + (char)-9872, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00b6,\u00f1U\u00ef\u00ebhV\u0010\u0097\u00cb$\b\u00ef\u00fb\u0091\r3\u00a6Q\f$9Op";
                    var4_3 = "\u00b6,\u00f1U\u00ef\u00ebhV\u0010\u0097\u00cb$\b\u00ef\u00fb\u0091\r3\u00a6Q\f$9Op".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 75;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00d7N\u00f04\u00925\u00a5i\u00a9\u00bcky4\u00db\u00dd\u00ea3h\u00b2r\u00b5\u00be\u00d4\u008fb\u0088Y\u00a0\u00d6\u001b/~\u00ac\u0094_\u00f3\u00b9\u00b3\u00bbQ\u00ad(Z\u00c0\u00a0\u0082\u00efB\u0083]@\u00bf\u00e4v\u001c\u0080o\u001f\u001e";
                        var4_3 = "\u00d7N\u00f04\u00925\u00a5i\u00a9\u00bcky4\u00db\u00dd\u00ea3h\u00b2r\u00b5\u00be\u00d4\u008fb\u0088Y\u00a0\u00d6\u001b/~\u00ac\u0094_\u00f3\u00b9\u00b3\u00bbQ\u00ad(Z\u00c0\u00a0\u0082\u00efB\u0083]@\u00bf\u00e4v\u001c\u0080o\u001f\u001e".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 99;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 32;
                                break;
                            }
                            case 1: {
                                v15 = 116;
                                break;
                            }
                            case 2: {
                                v15 = 15;
                                break;
                            }
                            case 3: {
                                v15 = 93;
                                break;
                            }
                            case 4: {
                                v15 = 60;
                                break;
                            }
                            case 5: {
                                v15 = 96;
                                break;
                            }
                            default: {
                                v15 = 30;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x6FE3) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 253;
                    case 1 -> 107;
                    case 2 -> 54;
                    case 3 -> 96;
                    case 4 -> 87;
                    case 5 -> 239;
                    case 6 -> 159;
                    case 7 -> 16;
                    case 8 -> 112;
                    case 9 -> 115;
                    case 10 -> 42;
                    case 11 -> 82;
                    case 12 -> 152;
                    case 13 -> 104;
                    case 14 -> 17;
                    case 15 -> 209;
                    case 16 -> 10;
                    case 17 -> 137;
                    case 18 -> 105;
                    case 19 -> 150;
                    case 20 -> 139;
                    case 21 -> 113;
                    case 22 -> 149;
                    case 23 -> 169;
                    case 24 -> 185;
                    case 25 -> 1;
                    case 26 -> 163;
                    case 27 -> 21;
                    case 28 -> 25;
                    case 29 -> 180;
                    case 30 -> 79;
                    case 31 -> 5;
                    case 32 -> 248;
                    case 33 -> 222;
                    case 34 -> 146;
                    case 35 -> 167;
                    case 36 -> 212;
                    case 37 -> 123;
                    case 38 -> 179;
                    case 39 -> 66;
                    case 40 -> 203;
                    case 41 -> 170;
                    case 42 -> 24;
                    case 43 -> 91;
                    case 44 -> 114;
                    case 45 -> 240;
                    case 46 -> 161;
                    case 47 -> 145;
                    case 48 -> 134;
                    case 49 -> 7;
                    case 50 -> 136;
                    case 51 -> 173;
                    case 52 -> 237;
                    case 53 -> 195;
                    case 54 -> 13;
                    case 55 -> 130;
                    case 56 -> 97;
                    case 57 -> 238;
                    case 58 -> 184;
                    case 59 -> 219;
                    case 60 -> 109;
                    case 61 -> 111;
                    case 62 -> 110;
                    case 63 -> 178;
                    case 64 -> 89;
                    case 65 -> 94;
                    case 66 -> 207;
                    case 67 -> 183;
                    case 68 -> 15;
                    case 69 -> 211;
                    case 70 -> 62;
                    case 71 -> 160;
                    case 72 -> 158;
                    case 73 -> 201;
                    case 74 -> 177;
                    case 75 -> 140;
                    case 76 -> 196;
                    case 77 -> 193;
                    case 78 -> 141;
                    case 79 -> 27;
                    case 80 -> 189;
                    case 81 -> 69;
                    case 82 -> 34;
                    case 83 -> 81;
                    case 84 -> 213;
                    case 85 -> 80;
                    case 86 -> 76;
                    case 87 -> 61;
                    case 88 -> 117;
                    case 89 -> 37;
                    case 90 -> 254;
                    case 91 -> 43;
                    case 92 -> 121;
                    case 93 -> 194;
                    case 94 -> 95;
                    case 95 -> 235;
                    case 96 -> 135;
                    case 97 -> 78;
                    case 98 -> 200;
                    case 99 -> 153;
                    case 100 -> 101;
                    case 101 -> 60;
                    case 102 -> 45;
                    case 103 -> 40;
                    case 104 -> 236;
                    case 105 -> 93;
                    case 106 -> 4;
                    case 107 -> 56;
                    case 108 -> 231;
                    case 109 -> 249;
                    case 110 -> 255;
                    case 111 -> 241;
                    case 112 -> 71;
                    case 113 -> 138;
                    case 114 -> 244;
                    case 115 -> 18;
                    case 116 -> 172;
                    case 117 -> 220;
                    case 118 -> 118;
                    case 119 -> 3;
                    case 120 -> 226;
                    case 121 -> 77;
                    case 122 -> 72;
                    case 123 -> 64;
                    case 124 -> 122;
                    case 125 -> 168;
                    case 126 -> 86;
                    case 127 -> 58;
                    case 128 -> 192;
                    case 129 -> 133;
                    case 130 -> 234;
                    case 131 -> 102;
                    case 132 -> 205;
                    case 133 -> 166;
                    case 134 -> 30;
                    case 135 -> 182;
                    case 136 -> 216;
                    case 137 -> 55;
                    case 138 -> 119;
                    case 139 -> 165;
                    case 140 -> 11;
                    case 141 -> 242;
                    case 142 -> 245;
                    case 143 -> 53;
                    case 144 -> 202;
                    case 145 -> 157;
                    case 146 -> 127;
                    case 147 -> 29;
                    case 148 -> 90;
                    case 149 -> 215;
                    case 150 -> 0;
                    case 151 -> 23;
                    case 152 -> 22;
                    case 153 -> 100;
                    case 154 -> 46;
                    case 155 -> 156;
                    case 156 -> 214;
                    case 157 -> 175;
                    case 158 -> 70;
                    case 159 -> 106;
                    case 160 -> 83;
                    case 161 -> 155;
                    case 162 -> 132;
                    case 163 -> 28;
                    case 164 -> 52;
                    case 165 -> 35;
                    case 166 -> 33;
                    case 167 -> 75;
                    case 168 -> 6;
                    case 169 -> 63;
                    case 170 -> 225;
                    case 171 -> 191;
                    case 172 -> 85;
                    case 173 -> 103;
                    case 174 -> 126;
                    case 175 -> 143;
                    case 176 -> 162;
                    case 177 -> 14;
                    case 178 -> 154;
                    case 179 -> 252;
                    case 180 -> 176;
                    case 181 -> 147;
                    case 182 -> 230;
                    case 183 -> 246;
                    case 184 -> 36;
                    case 185 -> 84;
                    case 186 -> 116;
                    case 187 -> 41;
                    case 188 -> 8;
                    case 189 -> 223;
                    case 190 -> 9;
                    case 191 -> 120;
                    case 192 -> 20;
                    case 193 -> 142;
                    case 194 -> 67;
                    case 195 -> 108;
                    case 196 -> 92;
                    case 197 -> 19;
                    case 198 -> 74;
                    case 199 -> 188;
                    case 200 -> 48;
                    case 201 -> 65;
                    case 202 -> 229;
                    case 203 -> 31;
                    case 204 -> 129;
                    case 205 -> 98;
                    case 206 -> 49;
                    case 207 -> 227;
                    case 208 -> 210;
                    case 209 -> 204;
                    case 210 -> 26;
                    case 211 -> 181;
                    case 212 -> 2;
                    case 213 -> 47;
                    case 214 -> 12;
                    case 215 -> 187;
                    case 216 -> 39;
                    case 217 -> 51;
                    case 218 -> 164;
                    case 219 -> 125;
                    case 220 -> 32;
                    case 221 -> 224;
                    case 222 -> 221;
                    case 223 -> 144;
                    case 224 -> 208;
                    case 225 -> 198;
                    case 226 -> 233;
                    case 227 -> 124;
                    case 228 -> 148;
                    case 229 -> 38;
                    case 230 -> 131;
                    case 231 -> 128;
                    case 232 -> 151;
                    case 233 -> 217;
                    case 234 -> 190;
                    case 235 -> 228;
                    case 236 -> 232;
                    case 237 -> 247;
                    case 238 -> 197;
                    case 239 -> 250;
                    case 240 -> 243;
                    case 241 -> 171;
                    case 242 -> 99;
                    case 243 -> 50;
                    case 244 -> 44;
                    case 245 -> 88;
                    case 246 -> 174;
                    case 247 -> 251;
                    case 248 -> 218;
                    case 249 -> 68;
                    case 250 -> 73;
                    case 251 -> 186;
                    case 252 -> 199;
                    case 253 -> 206;
                    case 254 -> 57;
                    default -> 59;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 64794672355650L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0012'(?Bo>K\t\u0015-;5\u000f-#Wk";
                    var5_4 = "\u0012'(?Bo>K\t\u0015-;5\u000f-#Wk".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 24;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 97;
                                    break;
                                }
                                case 1: {
                                    v11 = 90;
                                    break;
                                }
                                case 2: {
                                    v11 = 66;
                                    break;
                                }
                                case 3: {
                                    v11 = 73;
                                    break;
                                }
                                case 4: {
                                    v11 = 63;
                                    break;
                                }
                                case 5: {
                                    v11 = 27;
                                    break;
                                }
                                default: {
                                    v11 = 21;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 130487720081542L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = ")\u0019S%q\t\n\u0004/\u0007_?\n#\u0018T?}\u000b\u0012\t\u0019]\t#\u0018T?}\u000b\u0012\u0005\u0013\r$\u001eI2w\u0006\b\u0005\u0014N8v\u000f";
                    var5_4 = ")\u0019S%q\t\n\u0004/\u0007_?\n#\u0018T?}\u000b\u0012\t\u0019]\t#\u0018T?}\u000b\u0012\u0005\u0013\r$\u001eI2w\u0006\b\u0005\u0014N8v\u000f".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 36;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "%\u001dS$w\u0000\u0007\u0006%\u001dS${\n";
                        var5_4 = "%\u001dS$w\u0000\u0007\u0006%\u001dS${\n".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 34;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 68;
                                break;
                            }
                            case 1: {
                                v15 = 83;
                                break;
                            }
                            case 2: {
                                v15 = 30;
                                break;
                            }
                            case 3: {
                                v15 = 117;
                                break;
                            }
                            case 4: {
                                v15 = 60;
                                break;
                            }
                            case 5: {
                                v15 = 76;
                                break;
                            }
                            default: {
                                v15 = 66;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 140629130369639L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-983811420 - -7328, -983811420 - -5818, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 114998944957466L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00ec\u00e9\u00acY\u00a9\u0003\u00109\u0087\u0005\u00d0i\r\u008d~\r8\u00b8&\u00fd\u00ee\u001f\u00ae8\u0002\u00b4\u00e4}\u00bb\u0010\u000b@\u0087\t\u00e5\u0014\u00e4d\u0082\u00bb\u0017\u00d1#\u00b6;\u009e\u0005\u00de\u0099\u00cc\u0093F3\u000f\u0088\u00e7\u00c6<\u00a9\u00ef\u00c7\u009e2\u001f\u00c9\u00e4\u00e4\u00ef\u00cb\u00b2g\u008aw\u00fa\u00e0\u00f6\u0086\u00bd\u0001\u00f54sa\u001e\u00e1\u00dd_\u0098;4\u00fd\u0080|\u0094\u00deD\u00ce\u00d4\u00e2K\u0015ye\u0001";
                    var4_3 = "\u00ec\u00e9\u00acY\u00a9\u0003\u00109\u0087\u0005\u00d0i\r\u008d~\r8\u00b8&\u00fd\u00ee\u001f\u00ae8\u0002\u00b4\u00e4}\u00bb\u0010\u000b@\u0087\t\u00e5\u0014\u00e4d\u0082\u00bb\u0017\u00d1#\u00b6;\u009e\u0005\u00de\u0099\u00cc\u0093F3\u000f\u0088\u00e7\u00c6<\u00a9\u00ef\u00c7\u009e2\u001f\u00c9\u00e4\u00e4\u00ef\u00cb\u00b2g\u008aw\u00fa\u00e0\u00f6\u0086\u00bd\u0001\u00f54sa\u001e\u00e1\u00dd_\u0098;4\u00fd\u0080|\u0094\u00deD\u00ce\u00d4\u00e2K\u0015ye\u0001".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 22;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0011\u00f2\u009d\u0006\u00ff\u00ac\u00fe*\u0098+\r\u009a9\u0086!\u00c1L\u001e]\u008b9\u0017\u0083\u008d\u00a1\u007f\u00c9]\u007f=\u00b42\u00feUI\u00d0\u001d\u0080\u0090\u00cas@\r6*\u00a8\u00b2\u00d3\u00ad-a\u00ae\u00b9\u0099*V\u00b9!\u00c2di\u009c\u0091\u00d0\u001a\u00a1\u00e9\u00ab\u00e2\u00e8\" 0\u0019\u0099\u00fc\u00ae\u00fd\u00fa\u0006\u0003N\u0084r\u00a8\u00b2\u00b5\u0095\u000eNh\u00be\u00ae";
                        var4_3 = "\u0011\u00f2\u009d\u0006\u00ff\u00ac\u00fe*\u0098+\r\u009a9\u0086!\u00c1L\u001e]\u008b9\u0017\u0083\u008d\u00a1\u007f\u00c9]\u007f=\u00b42\u00feUI\u00d0\u001d\u0080\u0090\u00cas@\r6*\u00a8\u00b2\u00d3\u00ad-a\u00ae\u00b9\u0099*V\u00b9!\u00c2di\u009c\u0091\u00d0\u001a\u00a1\u00e9\u00ab\u00e2\u00e8\" 0\u0019\u0099\u00fc\u00ae\u00fd\u00fa\u0006\u0003N\u0084r\u00a8\u00b2\u00b5\u0095\u000eNh\u00be\u00ae".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 12;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 109;
                                break;
                            }
                            case 1: {
                                v15 = 80;
                                break;
                            }
                            case 2: {
                                v15 = 96;
                                break;
                            }
                            case 3: {
                                v15 = 95;
                                break;
                            }
                            case 4: {
                                v15 = 89;
                                break;
                            }
                            case 5: {
                                v15 = 25;
                                break;
                            }
                            default: {
                                v15 = 112;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xD23) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 109;
                    case 1 -> 58;
                    case 2 -> 133;
                    case 3 -> 73;
                    case 4 -> 194;
                    case 5 -> 43;
                    case 6 -> 175;
                    case 7 -> 243;
                    case 8 -> 63;
                    case 9 -> 102;
                    case 10 -> 254;
                    case 11 -> 185;
                    case 12 -> 8;
                    case 13 -> 78;
                    case 14 -> 97;
                    case 15 -> 170;
                    case 16 -> 250;
                    case 17 -> 153;
                    case 18 -> 79;
                    case 19 -> 94;
                    case 20 -> 187;
                    case 21 -> 98;
                    case 22 -> 24;
                    case 23 -> 205;
                    case 24 -> 29;
                    case 25 -> 45;
                    case 26 -> 81;
                    case 27 -> 96;
                    case 28 -> 40;
                    case 29 -> 95;
                    case 30 -> 212;
                    case 31 -> 174;
                    case 32 -> 171;
                    case 33 -> 100;
                    case 34 -> 70;
                    case 35 -> 210;
                    case 36 -> 39;
                    case 37 -> 209;
                    case 38 -> 41;
                    case 39 -> 253;
                    case 40 -> 211;
                    case 41 -> 48;
                    case 42 -> 156;
                    case 43 -> 196;
                    case 44 -> 44;
                    case 45 -> 114;
                    case 46 -> 124;
                    case 47 -> 193;
                    case 48 -> 142;
                    case 49 -> 151;
                    case 50 -> 25;
                    case 51 -> 84;
                    case 52 -> 54;
                    case 53 -> 161;
                    case 54 -> 177;
                    case 55 -> 132;
                    case 56 -> 239;
                    case 57 -> 247;
                    case 58 -> 17;
                    case 59 -> 104;
                    case 60 -> 18;
                    case 61 -> 188;
                    case 62 -> 191;
                    case 63 -> 241;
                    case 64 -> 245;
                    case 65 -> 5;
                    case 66 -> 19;
                    case 67 -> 213;
                    case 68 -> 51;
                    case 69 -> 146;
                    case 70 -> 11;
                    case 71 -> 32;
                    case 72 -> 4;
                    case 73 -> 231;
                    case 74 -> 101;
                    case 75 -> 255;
                    case 76 -> 179;
                    case 77 -> 47;
                    case 78 -> 93;
                    case 79 -> 183;
                    case 80 -> 91;
                    case 81 -> 52;
                    case 82 -> 138;
                    case 83 -> 115;
                    case 84 -> 125;
                    case 85 -> 26;
                    case 86 -> 136;
                    case 87 -> 75;
                    case 88 -> 55;
                    case 89 -> 244;
                    case 90 -> 103;
                    case 91 -> 149;
                    case 92 -> 192;
                    case 93 -> 3;
                    case 94 -> 53;
                    case 95 -> 126;
                    case 96 -> 117;
                    case 97 -> 128;
                    case 98 -> 7;
                    case 99 -> 13;
                    case 100 -> 119;
                    case 101 -> 23;
                    case 102 -> 158;
                    case 103 -> 157;
                    case 104 -> 130;
                    case 105 -> 116;
                    case 106 -> 68;
                    case 107 -> 225;
                    case 108 -> 150;
                    case 109 -> 219;
                    case 110 -> 129;
                    case 111 -> 201;
                    case 112 -> 36;
                    case 113 -> 107;
                    case 114 -> 206;
                    case 115 -> 178;
                    case 116 -> 37;
                    case 117 -> 90;
                    case 118 -> 176;
                    case 119 -> 87;
                    case 120 -> 200;
                    case 121 -> 242;
                    case 122 -> 173;
                    case 123 -> 184;
                    case 124 -> 127;
                    case 125 -> 110;
                    case 126 -> 189;
                    case 127 -> 72;
                    case 128 -> 74;
                    case 129 -> 106;
                    case 130 -> 82;
                    case 131 -> 118;
                    case 132 -> 216;
                    case 133 -> 236;
                    case 134 -> 143;
                    case 135 -> 76;
                    case 136 -> 145;
                    case 137 -> 233;
                    case 138 -> 77;
                    case 139 -> 15;
                    case 140 -> 217;
                    case 141 -> 85;
                    case 142 -> 135;
                    case 143 -> 162;
                    case 144 -> 108;
                    case 145 -> 220;
                    case 146 -> 65;
                    case 147 -> 89;
                    case 148 -> 64;
                    case 149 -> 202;
                    case 150 -> 88;
                    case 151 -> 67;
                    case 152 -> 147;
                    case 153 -> 232;
                    case 154 -> 155;
                    case 155 -> 20;
                    case 156 -> 35;
                    case 157 -> 248;
                    case 158 -> 214;
                    case 159 -> 14;
                    case 160 -> 229;
                    case 161 -> 86;
                    case 162 -> 228;
                    case 163 -> 42;
                    case 164 -> 16;
                    case 165 -> 71;
                    case 166 -> 166;
                    case 167 -> 180;
                    case 168 -> 224;
                    case 169 -> 246;
                    case 170 -> 80;
                    case 171 -> 234;
                    case 172 -> 6;
                    case 173 -> 56;
                    case 174 -> 165;
                    case 175 -> 105;
                    case 176 -> 121;
                    case 177 -> 199;
                    case 178 -> 221;
                    case 179 -> 59;
                    case 180 -> 144;
                    case 181 -> 31;
                    case 182 -> 154;
                    case 183 -> 83;
                    case 184 -> 10;
                    case 185 -> 28;
                    case 186 -> 169;
                    case 187 -> 66;
                    case 188 -> 172;
                    case 189 -> 49;
                    case 190 -> 46;
                    case 191 -> 112;
                    case 192 -> 152;
                    case 193 -> 237;
                    case 194 -> 235;
                    case 195 -> 139;
                    case 196 -> 12;
                    case 197 -> 21;
                    case 198 -> 249;
                    case 199 -> 38;
                    case 200 -> 140;
                    case 201 -> 195;
                    case 202 -> 222;
                    case 203 -> 131;
                    case 204 -> 240;
                    case 205 -> 208;
                    case 206 -> 167;
                    case 207 -> 164;
                    case 208 -> 238;
                    case 209 -> 168;
                    case 210 -> 9;
                    case 211 -> 223;
                    case 212 -> 50;
                    case 213 -> 204;
                    case 214 -> 182;
                    case 215 -> 163;
                    case 216 -> 226;
                    case 217 -> 137;
                    case 218 -> 111;
                    case 219 -> 186;
                    case 220 -> 123;
                    case 221 -> 22;
                    case 222 -> 203;
                    case 223 -> 252;
                    case 224 -> 160;
                    case 225 -> 120;
                    case 226 -> 230;
                    case 227 -> 92;
                    case 228 -> 60;
                    case 229 -> 33;
                    case 230 -> 227;
                    case 231 -> 218;
                    case 232 -> 134;
                    case 233 -> 197;
                    case 234 -> 251;
                    case 235 -> 30;
                    case 236 -> 141;
                    case 237 -> 61;
                    case 238 -> 122;
                    case 239 -> 215;
                    case 240 -> 1;
                    case 241 -> 27;
                    case 242 -> 2;
                    case 243 -> 159;
                    case 244 -> 34;
                    case 245 -> 69;
                    case 246 -> 207;
                    case 247 -> 62;
                    case 248 -> 113;
                    case 249 -> 57;
                    case 250 -> 148;
                    case 251 -> 99;
                    case 252 -> 198;
                    case 253 -> 0;
                    case 254 -> 190;
                    default -> 181;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 42608024992625L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1949404110 + -26056, -1949404110 + -2143, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 47197256827622L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.Q();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(138803130 + 66, -138803130 + -752, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 76826787916427L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "J\u0011?\u0011U\u0003\u009fX\u00d3";
                var4_3 = "J\u0011?\u0011U\u0003\u009fX\u00d3".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 39;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 6;
                                break;
                            }
                            case 1: {
                                v11 = 105;
                                break;
                            }
                            case 2: {
                                v11 = 93;
                                break;
                            }
                            case 3: {
                                v11 = 56;
                                break;
                            }
                            case 4: {
                                v11 = 103;
                                break;
                            }
                            case 5: {
                                v11 = 34;
                                break;
                            }
                            default: {
                                v11 = 42;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFB51B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 56;
                    case 1 -> 173;
                    case 2 -> 252;
                    case 3 -> 204;
                    case 4 -> 207;
                    case 5 -> 60;
                    case 6 -> 150;
                    case 7 -> 111;
                    case 8 -> 147;
                    case 9 -> 161;
                    case 10 -> 57;
                    case 11 -> 67;
                    case 12 -> 4;
                    case 13 -> 82;
                    case 14 -> 9;
                    case 15 -> 70;
                    case 16 -> 99;
                    case 17 -> 244;
                    case 18 -> 52;
                    case 19 -> 225;
                    case 20 -> 129;
                    case 21 -> 255;
                    case 22 -> 5;
                    case 23 -> 30;
                    case 24 -> 114;
                    case 25 -> 103;
                    case 26 -> 105;
                    case 27 -> 216;
                    case 28 -> 211;
                    case 29 -> 2;
                    case 30 -> 217;
                    case 31 -> 191;
                    case 32 -> 76;
                    case 33 -> 68;
                    case 34 -> 192;
                    case 35 -> 35;
                    case 36 -> 146;
                    case 37 -> 116;
                    case 38 -> 54;
                    case 39 -> 183;
                    case 40 -> 180;
                    case 41 -> 34;
                    case 42 -> 242;
                    case 43 -> 220;
                    case 44 -> 78;
                    case 45 -> 182;
                    case 46 -> 7;
                    case 47 -> 53;
                    case 48 -> 215;
                    case 49 -> 49;
                    case 50 -> 38;
                    case 51 -> 245;
                    case 52 -> 212;
                    case 53 -> 247;
                    case 54 -> 87;
                    case 55 -> 137;
                    case 56 -> 32;
                    case 57 -> 208;
                    case 58 -> 92;
                    case 59 -> 63;
                    case 60 -> 8;
                    case 61 -> 181;
                    case 62 -> 141;
                    case 63 -> 42;
                    case 64 -> 39;
                    case 65 -> 162;
                    case 66 -> 104;
                    case 67 -> 218;
                    case 68 -> 117;
                    case 69 -> 233;
                    case 70 -> 79;
                    case 71 -> 235;
                    case 72 -> 198;
                    case 73 -> 44;
                    case 74 -> 47;
                    case 75 -> 203;
                    case 76 -> 189;
                    case 77 -> 98;
                    case 78 -> 11;
                    case 79 -> 83;
                    case 80 -> 224;
                    case 81 -> 10;
                    case 82 -> 228;
                    case 83 -> 165;
                    case 84 -> 190;
                    case 85 -> 187;
                    case 86 -> 86;
                    case 87 -> 80;
                    case 88 -> 127;
                    case 89 -> 248;
                    case 90 -> 250;
                    case 91 -> 148;
                    case 92 -> 201;
                    case 93 -> 194;
                    case 94 -> 223;
                    case 95 -> 128;
                    case 96 -> 213;
                    case 97 -> 159;
                    case 98 -> 185;
                    case 99 -> 205;
                    case 100 -> 240;
                    case 101 -> 113;
                    case 102 -> 91;
                    case 103 -> 126;
                    case 104 -> 164;
                    case 105 -> 239;
                    case 106 -> 142;
                    case 107 -> 152;
                    case 108 -> 97;
                    case 109 -> 90;
                    case 110 -> 193;
                    case 111 -> 16;
                    case 112 -> 210;
                    case 113 -> 0;
                    case 114 -> 154;
                    case 115 -> 3;
                    case 116 -> 88;
                    case 117 -> 23;
                    case 118 -> 29;
                    case 119 -> 123;
                    case 120 -> 25;
                    case 121 -> 131;
                    case 122 -> 12;
                    case 123 -> 74;
                    case 124 -> 238;
                    case 125 -> 66;
                    case 126 -> 157;
                    case 127 -> 177;
                    case 128 -> 85;
                    case 129 -> 121;
                    case 130 -> 195;
                    case 131 -> 153;
                    case 132 -> 55;
                    case 133 -> 229;
                    case 134 -> 17;
                    case 135 -> 20;
                    case 136 -> 65;
                    case 137 -> 130;
                    case 138 -> 93;
                    case 139 -> 188;
                    case 140 -> 58;
                    case 141 -> 166;
                    case 142 -> 246;
                    case 143 -> 84;
                    case 144 -> 119;
                    case 145 -> 140;
                    case 146 -> 14;
                    case 147 -> 110;
                    case 148 -> 160;
                    case 149 -> 136;
                    case 150 -> 237;
                    case 151 -> 69;
                    case 152 -> 178;
                    case 153 -> 26;
                    case 154 -> 175;
                    case 155 -> 62;
                    case 156 -> 135;
                    case 157 -> 112;
                    case 158 -> 133;
                    case 159 -> 15;
                    case 160 -> 230;
                    case 161 -> 176;
                    case 162 -> 234;
                    case 163 -> 226;
                    case 164 -> 149;
                    case 165 -> 59;
                    case 166 -> 109;
                    case 167 -> 174;
                    case 168 -> 222;
                    case 169 -> 75;
                    case 170 -> 196;
                    case 171 -> 169;
                    case 172 -> 24;
                    case 173 -> 72;
                    case 174 -> 124;
                    case 175 -> 18;
                    case 176 -> 184;
                    case 177 -> 139;
                    case 178 -> 6;
                    case 179 -> 37;
                    case 180 -> 241;
                    case 181 -> 143;
                    case 182 -> 71;
                    case 183 -> 61;
                    case 184 -> 186;
                    case 185 -> 132;
                    case 186 -> 156;
                    case 187 -> 41;
                    case 188 -> 206;
                    case 189 -> 101;
                    case 190 -> 227;
                    case 191 -> 118;
                    case 192 -> 102;
                    case 193 -> 253;
                    case 194 -> 77;
                    case 195 -> 51;
                    case 196 -> 95;
                    case 197 -> 1;
                    case 198 -> 200;
                    case 199 -> 40;
                    case 200 -> 94;
                    case 201 -> 179;
                    case 202 -> 96;
                    case 203 -> 122;
                    case 204 -> 81;
                    case 205 -> 144;
                    case 206 -> 168;
                    case 207 -> 251;
                    case 208 -> 254;
                    case 209 -> 21;
                    case 210 -> 158;
                    case 211 -> 171;
                    case 212 -> 202;
                    case 213 -> 197;
                    case 214 -> 249;
                    case 215 -> 134;
                    case 216 -> 36;
                    case 217 -> 145;
                    case 218 -> 163;
                    case 219 -> 138;
                    case 220 -> 107;
                    case 221 -> 199;
                    case 222 -> 46;
                    case 223 -> 231;
                    case 224 -> 33;
                    case 225 -> 214;
                    case 226 -> 100;
                    case 227 -> 108;
                    case 228 -> 115;
                    case 229 -> 27;
                    case 230 -> 232;
                    case 231 -> 170;
                    case 232 -> 236;
                    case 233 -> 48;
                    case 234 -> 73;
                    case 235 -> 167;
                    case 236 -> 243;
                    case 237 -> 120;
                    case 238 -> 155;
                    case 239 -> 28;
                    case 240 -> 172;
                    case 241 -> 219;
                    case 242 -> 125;
                    case 243 -> 89;
                    case 244 -> 31;
                    case 245 -> 43;
                    case 246 -> 64;
                    case 247 -> 221;
                    case 248 -> 50;
                    case 249 -> 19;
                    case 250 -> 106;
                    case 251 -> 22;
                    case 252 -> 209;
                    case 253 -> 151;
                    case 254 -> 45;
                    default -> 13;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

