/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.assertion.moduleAssertion;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.testFramework.assertion.collectionAssertion.CollectionAssertions;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlImplKt;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0007J1\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0011J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0007J9\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0016J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0007J1\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0019J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0007J)\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\t\"\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u001a0\fH\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/testFramework/assertion/moduleAssertion/ContentRootAssertions;", "", "<init>", "()V", "assertContentRoots", "", "module", "Lcom/intellij/openapi/module/Module;", "expectedRoots", "", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/module/Module;[Ljava/nio/file/Path;)V", "", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Ljava/nio/file/Path;)V", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;Lcom/intellij/platform/workspace/storage/EntityStorage;Ljava/lang/String;[Ljava/nio/file/Path;)V", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;[Ljava/nio/file/Path;)V", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "(Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;[Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;)V", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nContentRootAssertions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentRootAssertions.kt\ncom/intellij/platform/testFramework/assertion/moduleAssertion/ContentRootAssertions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1557#2:79\n1628#2,3:80\n1557#2:83\n1628#2,3:84\n*S KotlinDebug\n*F\n+ 1 ContentRootAssertions.kt\ncom/intellij/platform/testFramework/assertion/moduleAssertion/ContentRootAssertions\n*L\n64#1:79\n64#1:80,3\n75#1:83\n75#1:84,3\n*E\n"})
public final class ContentRootAssertions {
    @NotNull
    public static final ContentRootAssertions INSTANCE = new ContentRootAssertions();

    private ContentRootAssertions() {
    }

    @JvmStatic
    public static final void assertContentRoots(@NotNull Module module2, Path ... expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)expectedRoots, (String)"expectedRoots");
        ContentRootAssertions.assertContentRoots(module2, ArraysKt.asList((Object[])expectedRoots));
    }

    @JvmStatic
    public static final void assertContentRoots(@NotNull Module module2, @NotNull List<? extends Path> expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter(expectedRoots, (String)"expectedRoots");
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        ContentRootAssertions.assertContentRoots(project, string, expectedRoots);
    }

    @JvmStatic
    public static final void assertContentRoots(@NotNull Project project, @NotNull String moduleName, Path ... expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)expectedRoots, (String)"expectedRoots");
        ContentRootAssertions.assertContentRoots(project, moduleName, (List<? extends Path>)ArraysKt.asList((Object[])expectedRoots));
    }

    @JvmStatic
    public static final void assertContentRoots(@NotNull Project project, @NotNull String moduleName, @NotNull List<? extends Path> expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter(expectedRoots, (String)"expectedRoots");
        WorkspaceModel workspaceModel = WorkspaceModelKt.getWorkspaceModel((Project)project);
        ImmutableEntityStorage storage = workspaceModel.getCurrentSnapshot();
        VirtualFileUrlManager virtualFileUrlManager = workspaceModel.getVirtualFileUrlManager();
        ContentRootAssertions.assertContentRoots(virtualFileUrlManager, (EntityStorage)storage, moduleName, expectedRoots);
    }

    @JvmStatic
    public static final void assertContentRoots(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull EntityStorage storage, @NotNull String moduleName, Path ... expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)expectedRoots, (String)"expectedRoots");
        ContentRootAssertions.assertContentRoots(virtualFileUrlManager, storage, moduleName, ArraysKt.asList((Object[])expectedRoots));
    }

    @JvmStatic
    public static final void assertContentRoots(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull EntityStorage storage, @NotNull String moduleName, @NotNull List<? extends Path> expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter(expectedRoots, (String)"expectedRoots");
        ModuleId moduleId = new ModuleId(moduleName);
        ModuleEntity moduleEntity = (ModuleEntity)storage.resolve((SymbolicEntityId)moduleId);
        Assertions.assertNotNull((Object)moduleEntity, () -> ContentRootAssertions.assertContentRoots$lambda$0(moduleName));
        ModuleEntity moduleEntity2 = moduleEntity;
        Intrinsics.checkNotNull((Object)moduleEntity2);
        ContentRootAssertions.assertContentRoots(virtualFileUrlManager, moduleEntity2, expectedRoots);
    }

    @JvmStatic
    public static final void assertContentRoots(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull ModuleEntity moduleEntity, Path ... expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)expectedRoots, (String)"expectedRoots");
        ContentRootAssertions.assertContentRoots(virtualFileUrlManager, moduleEntity, (List<? extends Path>)ArraysKt.asList((Object[])expectedRoots));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void assertContentRoots(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull ModuleEntity moduleEntity, @NotNull List<? extends Path> expectedRoots) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter(expectedRoots, (String)"expectedRoots");
        Iterable $this$map$iv = expectedRoots;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path2 = it.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize(...)");
            collection.add(VirtualFileUrlImplKt.toVirtualFileUrl((Path)path2, (VirtualFileUrlManager)virtualFileUrlManager));
        }
        List expectedRootUrls = (List)destination$iv$iv;
        ContentRootAssertions.assertContentRoots(moduleEntity, expectedRootUrls);
    }

    @JvmStatic
    public static final void assertContentRoots(@NotNull ModuleEntity moduleEntity, VirtualFileUrl ... expectedRoots) {
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)expectedRoots, (String)"expectedRoots");
        ContentRootAssertions.assertContentRoots(moduleEntity, ArraysKt.asList((Object[])expectedRoots));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void assertContentRoots(@NotNull ModuleEntity moduleEntity, @NotNull List<? extends VirtualFileUrl> expectedRoots) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter(expectedRoots, (String)"expectedRoots");
        Iterable $this$map$iv = moduleEntity.getContentRoots();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ContentRootEntity contentRootEntity = (ContentRootEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrl());
        }
        List actualRoots = (List)destination$iv$iv;
        CollectionAssertions.assertEqualsUnordered$default(expectedRoots, actualRoots, null, 4, null);
    }

    private static final String assertContentRoots$lambda$0(String $moduleName) {
        return "The module '" + $moduleName + "' doesn't exist";
    }
}

