/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.testFramework.core.FileComparisonFailedError;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ExpectedHighlightingData {
    @ApiStatus.Internal
    public static final String EXPECTED_DUPLICATION_MESSAGE = "Expected duplication problem. Please remove `ExpectedHighlightingData.expectedDuplicatedHighlighting()` surrounding call, if there is no such problem any more";
    private static final String ERROR_MARKER = "error";
    private static final String WARNING_MARKER = "warning";
    private static final String WEAK_WARNING_MARKER = "weak_warning";
    private static final String INFO_MARKER = "info";
    private static final String TEXT_ATTRIBUTES_MARKER = "text_attr";
    private static final String END_LINE_HIGHLIGHT_MARKER = "EOLError";
    private static final String END_LINE_WARNING_MARKER = "EOLWarning";
    private static final String INJECT_MARKER = "inject";
    private static final String HIGHLIGHT_MARKER = "highlight";
    private static final String INJECTED_SYNTAX_MARKER = "injectedSyntax";
    private static final String SYMBOL_NAME_MARKER = "symbolName";
    private static final String LINE_MARKER = "lineMarker";
    private static final String ANY_TEXT = "*";
    private static final HighlightInfoType WHATEVER = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, HighlighterColors.TEXT);
    private static boolean isDuplicatedCheckDisabled = false;
    private static int failedDuplicationChecks = 0;
    private final Map<String, ExpectedHighlightingSet> myHighlightingTypes;
    private final Map<RangeMarker, LineMarkerInfo<?>> myLineMarkerInfos;
    private final Document myDocument;
    private final String myText;
    private final boolean myIgnoreExtraHighlighting;
    private static final SmartPsiElementPointer<PsiElement> NULL_POINTER = new SmartPsiElementPointer<PsiElement>(){

        @Nullable
        public PsiElement getElement() {
            return null;
        }

        @Nullable
        public PsiFile getContainingFile() {
            return null;
        }

        @NotNull
        public Project getProject() {
            throw new UnsupportedOperationException();
        }

        public VirtualFile getVirtualFile() {
            return null;
        }

        @Nullable
        public Segment getRange() {
            return null;
        }

        @Nullable
        public Segment getPsiRange() {
            return null;
        }
    };

    public ExpectedHighlightingData(@NotNull Document document, boolean checkWarnings, boolean checkInfos) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(0);
        }
        this(document, checkWarnings, false, checkInfos);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(1);
        }
        this(document, checkWarnings, checkWeakWarnings, checkInfos, false);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos, boolean ignoreExtraHighlighting) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(2);
        }
        this.myHighlightingTypes = new LinkedHashMap<String, ExpectedHighlightingSet>();
        this.myLineMarkerInfos = new HashMap();
        this.myDocument = document;
        this.myText = document.getText();
        this.registerHighlightingType(ERROR_MARKER, new ExpectedHighlightingSet(HighlightSeverity.ERROR, false, true));
        this.registerHighlightingType(WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, false));
        this.registerHighlightingType(WEAK_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, false));
        this.registerHighlightingType(INJECT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, false));
        this.registerHighlightingType(HIGHLIGHT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY, false, false));
        this.registerHighlightingType(INJECTED_SYNTAX_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SYNTAX_SEVERITY, false, false));
        this.registerHighlightingType(INFO_MARKER, new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, false));
        this.registerHighlightingType(TEXT_ATTRIBUTES_MARKER, new ExpectedHighlightingSet(HighlightSeverity.TEXT_ATTRIBUTES, false, false));
        this.registerHighlightingType(SYMBOL_NAME_MARKER, new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, false));
        for (SeveritiesProvider provider : SeveritiesProvider.EP_NAME.getExtensionList()) {
            for (HighlightInfoType type : provider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity severity = type.getSeverity(null);
                this.registerHighlightingType(severity.getName(), new ExpectedHighlightingSet(severity, false, true));
            }
        }
        this.registerHighlightingType(END_LINE_HIGHLIGHT_MARKER, new ExpectedHighlightingSet(HighlightSeverity.ERROR, true, true));
        this.registerHighlightingType(END_LINE_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, false));
        this.myIgnoreExtraHighlighting = ignoreExtraHighlighting;
        if (checkWarnings) {
            this.checkWarnings();
        }
        if (checkWeakWarnings) {
            this.checkWeakWarnings();
        }
        if (checkInfos) {
            this.checkInfos();
        }
    }

    public ExpectedHighlightingData(@NotNull Document document) {
        if (document == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(3);
        }
        this(document, false, false, false, false);
    }

    public boolean hasLineMarkers() {
        return !this.myLineMarkerInfos.isEmpty();
    }

    public void init() {
        WriteCommandAction.runWriteCommandAction(null, () -> {
            DocumentUtil.executeInBulk((Document)this.myDocument, () -> {
                this.extractExpectedLineMarkerSet(this.myDocument);
                this.extractExpectedHighlightsSet(this.myDocument);
            });
            this.refreshLineMarkers();
        });
    }

    public void checkWarnings() {
        this.registerHighlightingType(WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, true));
        this.registerHighlightingType(END_LINE_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, true));
    }

    public void checkWeakWarnings() {
        this.registerHighlightingType(WEAK_WARNING_MARKER, new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, true));
    }

    public void checkInfos() {
        this.registerHighlightingType(INFO_MARKER, new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, true));
        this.registerHighlightingType(TEXT_ATTRIBUTES_MARKER, new ExpectedHighlightingSet(HighlightSeverity.TEXT_ATTRIBUTES, false, true));
        this.registerHighlightingType(INJECT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, true));
        this.registerHighlightingType(HIGHLIGHT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY, false, true));
    }

    public void checkSymbolNames() {
        this.registerHighlightingType(SYMBOL_NAME_MARKER, new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, true));
    }

    public void registerHighlightingType(@NotNull String key, @NotNull ExpectedHighlightingSet highlightingSet) {
        if (key == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(4);
        }
        if (highlightingSet == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(5);
        }
        this.myHighlightingTypes.put(key, highlightingSet);
    }

    private void refreshLineMarkers() {
        for (Map.Entry<RangeMarker, LineMarkerInfo<?>> entry : this.myLineMarkerInfos.entrySet()) {
            RangeMarker rangeMarker = entry.getKey();
            int startOffset = rangeMarker.getStartOffset();
            int endOffset = rangeMarker.getEndOffset();
            LineMarkerInfo<?> value2 = entry.getValue();
            TextRange range = new TextRange(startOffset, endOffset);
            String tooltip = value2.getLineMarkerTooltip();
            Icon icon = value2.getIcon();
            MyLineMarkerInfo markerInfo = new MyLineMarkerInfo(range, GutterIconRenderer.Alignment.RIGHT, tooltip, icon != null ? icon.toString() : null);
            entry.setValue(markerInfo);
        }
    }

    private void extractExpectedLineMarkerSet(Document document) {
        Matcher opening;
        String text = document.getText();
        String pat = ".*?((<lineMarker)(?: descr=\"((?:[^\"\\\\]|\\\\\")*)\")?(?: icon=\"((?:[^\"\\\\]|\\\\\")*)\")?>)(.*)";
        Pattern openingTagRx = Pattern.compile(pat, 32);
        Pattern closingTagRx = Pattern.compile("(.*?)(</lineMarker>)(.*)", 32);
        while ((opening = openingTagRx.matcher(text)).matches()) {
            int startOffset = opening.start(1);
            String descr = opening.group(3) != null ? opening.group(3) : ANY_TEXT;
            String icon = opening.group(4) != null ? opening.group(4) : ANY_TEXT;
            String rest = opening.group(5);
            Matcher closing = closingTagRx.matcher(rest);
            if (!closing.matches()) {
                Assert.fail((String)"Cannot find closing </lineMarker>");
            }
            document.replaceString(startOffset, opening.end(1), (CharSequence)"");
            String content = closing.group(1);
            int endOffset = startOffset + closing.start(3);
            String endTag = closing.group(2);
            document.replaceString(startOffset, endOffset, (CharSequence)content);
            TextRange range = new TextRange(startOffset, endOffset -= endTag.length());
            String tooltip = StringUtil.unescapeStringCharacters((String)descr);
            MyLineMarkerInfo markerInfo = new MyLineMarkerInfo(range, GutterIconRenderer.Alignment.RIGHT, tooltip, icon);
            this.myLineMarkerInfos.put(document.createRangeMarker(startOffset, endOffset), markerInfo);
            text = document.getText();
        }
    }

    private void extractExpectedHighlightsSet(Document document) {
        String text = document.getText();
        Set<String> markers = this.myHighlightingTypes.keySet();
        String typesRx = String.join((CharSequence)"|", markers);
        String openingTagRx = "<(?<marker>" + typesRx + ")(?:\\s+(?:descr=\"(?<descr>(?:\\\\\"|[^\"])*)\"|type=\"(?<type>[0-9A-Z_]+)\"|foreground=\"(?<foreground>[0-9xa-f]+)\"|background=\"(?<background>[0-9xa-f]+)\"|effectcolor=\"(?<effectcolor>[0-9xa-f]+)\"|effecttype=\"(?<effecttype>[A-Z]+)\"|fonttype=\"(?<fonttype>[0-9]+)\"|textAttributesKey=\"(?<textAttributesKey>(?:\\\\\"|[^\"])*)\"|tooltip=\"(?<tooltip>(?:\\\\\"|[^\"])*)\"))*\\s*(?<closed>/)?>";
        Matcher matcher = Pattern.compile(openingTagRx).matcher(text);
        Ref textOffset = Ref.create((Object)0);
        int pos = 0;
        while (matcher.find(pos)) {
            textOffset.set((Object)((Integer)textOffset.get() + matcher.start() - pos));
            pos = this.extractExpectedHighlight(matcher, text, document, (Ref<Integer>)textOffset);
        }
    }

    private int extractExpectedHighlight(Matcher matcher, String text, Document document, Ref<Integer> textOffset) {
        int toContinueFrom;
        boolean closed;
        document.deleteString(((Integer)textOffset.get()).intValue(), (Integer)textOffset.get() + matcher.end() - matcher.start());
        String marker = matcher.group("marker");
        @NlsSafe String descr = matcher.group("descr");
        String typeString = matcher.group("type");
        String foregroundColor = matcher.group("foreground");
        String backgroundColor = matcher.group("background");
        String effectColor = matcher.group("effectcolor");
        String effectType = matcher.group("effecttype");
        String fontType = matcher.group("fonttype");
        String attrKey = matcher.group("textAttributesKey");
        @NlsSafe String tooltip = matcher.group("tooltip");
        boolean bl = closed = matcher.group("closed") != null;
        if (descr == null) {
            descr = ANY_TEXT;
        } else if (descr.equals("null")) {
            descr = null;
        }
        if (descr != null) {
            descr = descr.replaceAll("\\\\\\\\\"", "\"");
            descr = descr.replaceAll("\\\\\"", "\"");
        }
        if (tooltip == null) {
            tooltip = ANY_TEXT;
        } else if (tooltip.equals("null")) {
            tooltip = null;
        }
        if (tooltip != null) {
            tooltip = tooltip.replaceAll("\\\\\\\\\"", "\"");
            tooltip = tooltip.replaceAll("\\\\\"", "\"");
        }
        HighlightInfoType type = WHATEVER;
        if (typeString != null) {
            try {
                type = this.getTypeByName(typeString);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (type == null) {
                Assert.fail((String)("Wrong highlight type: " + typeString));
            }
        }
        TextAttributes forcedAttributes = null;
        if (foregroundColor != null) {
            int ft = fontType != null ? Integer.parseInt(fontType) : 0;
            forcedAttributes = new TextAttributes(Color.decode(foregroundColor), backgroundColor != null ? Color.decode(backgroundColor) : null, effectColor != null ? Color.decode(effectColor) : null, effectType != null ? EffectType.valueOf((String)effectType) : null, ft);
        }
        int rangeStart = (Integer)textOffset.get();
        if (closed) {
            toContinueFrom = matcher.end();
        } else {
            int pos = matcher.end();
            Matcher closingTagMatcher = Pattern.compile("</" + marker + ">").matcher(text);
            while (true) {
                int nextTagStart;
                if (!closingTagMatcher.find(pos)) {
                    toContinueFrom = pos;
                    break;
                }
                int n = nextTagStart = matcher.find(pos) ? matcher.start() : text.length();
                if (closingTagMatcher.start() < nextTagStart) {
                    textOffset.set((Object)((Integer)textOffset.get() + closingTagMatcher.start() - pos));
                    document.deleteString(((Integer)textOffset.get()).intValue(), (Integer)textOffset.get() + closingTagMatcher.end() - closingTagMatcher.start());
                    toContinueFrom = closingTagMatcher.end();
                    break;
                }
                textOffset.set((Object)((Integer)textOffset.get() + nextTagStart - pos));
                pos = this.extractExpectedHighlight(matcher, text, document, textOffset);
            }
        }
        ExpectedHighlightingSet expectedHighlightingSet = this.myHighlightingTypes.get(marker);
        if (expectedHighlightingSet.enabled) {
            TextAttributesKey forcedTextAttributesKey = attrKey == null ? null : TextAttributesKey.createTextAttributesKey((String)attrKey);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)type).range(rangeStart, ((Integer)textOffset.get()).intValue()).severity(expectedHighlightingSet.severity);
            if (forcedAttributes != null) {
                builder.textAttributes(forcedAttributes);
            }
            if (forcedTextAttributesKey != null) {
                builder.textAttributes(forcedTextAttributesKey);
            }
            if (descr != null) {
                builder.description(descr);
            }
            if (tooltip != null) {
                if (tooltip.startsWith("<html>")) {
                    builder.escapedToolTip(tooltip);
                } else {
                    builder.unescapedToolTip(tooltip);
                }
            }
            if (expectedHighlightingSet.endOfLine) {
                builder.endOfLine();
            }
            HighlightInfo highlightInfo = builder.createUnconditionally();
            expectedHighlightingSet.infos.add(highlightInfo);
        }
        return toContinueFrom;
    }

    protected HighlightInfoType getTypeByName(String typeString) throws Exception {
        Field field = HighlightInfoType.class.getField(typeString);
        return (HighlightInfoType)field.get(null);
    }

    public void checkLineMarkers(@Nullable PsiFile psiFile, @NotNull Collection<? extends LineMarkerInfo> markerInfos, @NotNull String text) {
        Icon icon;
        if (markerInfos == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(6);
        }
        if (text == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(7);
        }
        String fileName = psiFile == null ? "" : psiFile.getName() + ": ";
        StringBuilder failMessage = new StringBuilder();
        for (LineMarkerInfo lineMarkerInfo : markerInfos) {
            if (this.containsLineMarker(lineMarkerInfo, this.myLineMarkerInfos.values())) continue;
            if (!failMessage.isEmpty()) {
                failMessage.append('\n');
            }
            failMessage.append(fileName).append("extra ").append(ExpectedHighlightingData.rangeString(text, lineMarkerInfo.startOffset, lineMarkerInfo.endOffset)).append(": '").append(this.sanitizedLineMarkerTooltip(lineMarkerInfo)).append('\'');
            icon = lineMarkerInfo.getIcon();
            if (icon == null || icon.toString().equals(ANY_TEXT)) continue;
            failMessage.append(" icon='").append(icon).append('\'');
        }
        for (LineMarkerInfo lineMarkerInfo : this.myLineMarkerInfos.values()) {
            if (!markerInfos.isEmpty() && this.containsLineMarker(lineMarkerInfo, markerInfos)) continue;
            if (!failMessage.isEmpty()) {
                failMessage.append('\n');
            }
            failMessage.append(fileName).append("missing ").append(ExpectedHighlightingData.rangeString(text, lineMarkerInfo.startOffset, lineMarkerInfo.endOffset)).append(": '").append(this.sanitizedLineMarkerTooltip(lineMarkerInfo)).append('\'');
            icon = lineMarkerInfo.getIcon();
            if (icon == null || icon.toString().equals(ANY_TEXT)) continue;
            failMessage.append(" icon='").append(icon).append('\'');
        }
        if (!failMessage.isEmpty()) {
            VirtualFile virtualFile;
            String filePath = null;
            if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null) {
                filePath = (String)virtualFile.getUserData(VfsTestUtil.TEST_DATA_FILE_PATH);
            }
            throw new FileComparisonFailedError(failMessage.toString(), this.myText, this.getActualLineMarkerFileText(markerInfos), filePath);
        }
    }

    protected String sanitizedLineMarkerTooltip(@NotNull LineMarkerInfo info) {
        if (info == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(8);
        }
        return info.getLineMarkerTooltip();
    }

    @NotNull
    private String getActualLineMarkerFileText(@NotNull Collection<? extends LineMarkerInfo> markerInfos) {
        if (markerInfos == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(9);
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        ArrayList<Pair> lineMarkerInfos = new ArrayList<Pair>(markerInfos.size() * 2);
        for (LineMarkerInfo lineMarkerInfo : markerInfos) {
            lineMarkerInfos.add(Pair.create((Object)lineMarkerInfo, (Object)lineMarkerInfo.startOffset));
        }
        for (LineMarkerInfo lineMarkerInfo : markerInfos) {
            lineMarkerInfos.add(Pair.create((Object)lineMarkerInfo, (Object)lineMarkerInfo.endOffset));
        }
        Collections.reverse(lineMarkerInfos.subList(markerInfos.size(), lineMarkerInfos.size()));
        lineMarkerInfos.sort(Comparator.comparingInt(o -> (Integer)o.second));
        String documentText = this.myDocument.getText();
        for (Pair info : lineMarkerInfos) {
            LineMarkerInfo expectedLineMarker = (LineMarkerInfo)info.first;
            result.append(documentText, index, (int)((Integer)info.second));
            if ((Integer)info.second == expectedLineMarker.startOffset) {
                result.append("<lineMarker descr=\"").append(this.sanitizedLineMarkerTooltip(expectedLineMarker)).append("\">");
            } else {
                result.append("</lineMarker>");
            }
            index = (Integer)info.second;
        }
        result.append(documentText, index, this.myDocument.getTextLength());
        String string = result.toString();
        if (string == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected boolean containsLineMarker(@NotNull LineMarkerInfo info, Collection<? extends LineMarkerInfo> where) {
        if (info == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(11);
        }
        Icon icon = info.getIcon();
        for (LineMarkerInfo lineMarkerInfo : where) {
            if (lineMarkerInfo.startOffset != info.startOffset || lineMarkerInfo.endOffset != info.endOffset || !this.matchLineMarkersTooltip(info, lineMarkerInfo) || !ExpectedHighlightingData.matchIcons(icon, lineMarkerInfo.getIcon())) continue;
            return true;
        }
        return false;
    }

    protected boolean matchLineMarkersTooltip(@NotNull LineMarkerInfo info, @NotNull LineMarkerInfo markerInfo) {
        if (info == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(12);
        }
        if (markerInfo == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(13);
        }
        return ExpectedHighlightingData.matchDescriptions(false, info.getLineMarkerTooltip(), markerInfo.getLineMarkerTooltip());
    }

    protected static boolean matchIcons(Icon icon1, Icon icon2) {
        String s2;
        String s1 = String.valueOf(icon1);
        if (Comparing.strEqual((String)s1, (String)(s2 = String.valueOf(icon2)))) {
            return true;
        }
        return Comparing.strEqual((String)ANY_TEXT, (String)s1) || Comparing.strEqual((String)ANY_TEXT, (String)s2);
    }

    public void checkResult(@Nullable PsiFile psiFile, Collection<? extends HighlightInfo> infos, String text) {
        this.checkResult(psiFile, infos, text, null);
    }

    public void checkResult(@Nullable PsiFile psiFile, Collection<? extends HighlightInfo> infos, String text, @Nullable String filePath) {
        StringBuilder failMessage = new StringBuilder();
        Set expectedFound = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)new HashingStrategy<HighlightInfo>(){

            public int hashCode(HighlightInfo object) {
                return object.hashCode();
            }

            public boolean equals(HighlightInfo o1, HighlightInfo o2) {
                return o1 == null || o2 == null ? o1 == o2 : o1.getSeverity() == o2.getSeverity() && ExpectedHighlightingData.haveSamePresentation(o1, o2, true);
            }
        });
        if (!this.myIgnoreExtraHighlighting) {
            HashMap<ExpectedHighlightingSet, Set<HighlightInfo>> indexed = new HashMap<ExpectedHighlightingSet, Set<HighlightInfo>>();
            for (ExpectedHighlightingSet expectedHighlightingSet : this.myHighlightingTypes.values()) {
                indexed.put(expectedHighlightingSet, ExpectedHighlightingData.indexInfos(expectedHighlightingSet.infos));
            }
            for (HighlightInfo highlightInfo : infos) {
                ThreeState state = this.expectedInfosContainsInfo(highlightInfo, indexed);
                if (state == ThreeState.NO) {
                    ExpectedHighlightingData.reportProblem(psiFile, failMessage, text, highlightInfo, "extra ");
                    failMessage.append(" [").append(highlightInfo.type).append(']');
                    continue;
                }
                if (state != ThreeState.YES) continue;
                if (expectedFound.contains(highlightInfo)) {
                    if (isDuplicatedCheckDisabled) {
                        ++failedDuplicationChecks;
                    } else {
                        ExpectedHighlightingData.reportProblem(psiFile, failMessage, text, highlightInfo, "duplicated ");
                    }
                }
                expectedFound.add(highlightInfo);
            }
        }
        Set<HighlightInfo> indexedInfos = ExpectedHighlightingData.indexInfos(infos);
        Collection<ExpectedHighlightingSet> expectedHighlights = this.myHighlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : expectedHighlights) {
            Set<HighlightInfo> expInfos = highlightingSet.infos;
            for (HighlightInfo expectedInfo : expInfos) {
                if (indexedInfos.contains(expectedInfo) || !highlightingSet.enabled) continue;
                ExpectedHighlightingData.reportProblem(psiFile, failMessage, text, expectedInfo, "missing ");
            }
        }
        if (!failMessage.isEmpty()) {
            VirtualFile virtualFile;
            if (filePath == null && psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null) {
                filePath = (String)virtualFile.getUserData(VfsTestUtil.TEST_DATA_FILE_PATH);
            }
            failMessage.append('\n');
            this.compareTexts(infos, text, failMessage.toString(), filePath);
        }
    }

    @NotNull
    private static Set<HighlightInfo> indexInfos(Collection<? extends HighlightInfo> infos) {
        Set index = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)new HashingStrategy<HighlightInfo>(){

            public int hashCode(HighlightInfo object) {
                return object == null ? 0 : Objects.hash(object.startOffset, object.endOffset);
            }

            public boolean equals(HighlightInfo o1, HighlightInfo o2) {
                return o1 == null || o2 == null ? o1 == o2 : ExpectedHighlightingData.matchesPattern(o1, o2, false);
            }
        });
        index.addAll(infos);
        Set set = index;
        if (set == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(14);
        }
        return set;
    }

    private static void reportProblem(@Nullable PsiFile psiFile, @NotNull StringBuilder failMessage, @NotNull String text, @NotNull HighlightInfo info, @NotNull String messageType) {
        if (failMessage == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(15);
        }
        if (text == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(16);
        }
        if (info == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(17);
        }
        if (messageType == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(18);
        }
        String fileName = psiFile == null ? "" : psiFile.getName() + ": ";
        int startOffset = info.getActualStartOffset();
        int endOffset = info.getActualEndOffset();
        String s = text.substring(startOffset, endOffset);
        String desc = info.getDescription();
        if (!failMessage.isEmpty()) {
            failMessage.append('\n');
        }
        failMessage.append(fileName).append(messageType).append(ExpectedHighlightingData.rangeString(text, startOffset, endOffset)).append(": '").append(s).append('\'');
        if (desc != null) {
            failMessage.append(" (").append(desc).append(')');
        }
    }

    private void compareTexts(Collection<? extends HighlightInfo> infos, String text, String failMessage, @Nullable String filePath) {
        String actual = ExpectedHighlightingData.composeText(this.myHighlightingTypes, infos, text);
        if (filePath != null && !this.myText.equals(actual)) {
            throw new FileComparisonFailedError(failMessage, this.myText, actual, filePath);
        }
        Assert.assertEquals((String)(failMessage + "\n"), (Object)this.myText, (Object)actual);
        Assert.fail((String)failMessage);
    }

    private static String findTag(Map<String, ExpectedHighlightingSet> types, HighlightInfo info) {
        Map.Entry entry = (Map.Entry)ContainerUtil.find(types.entrySet(), e -> ((ExpectedHighlightingSet)e.getValue()).enabled && ((ExpectedHighlightingSet)e.getValue()).severity == info.getSeverity() && ((ExpectedHighlightingSet)e.getValue()).endOfLine == info.isAfterEndOfLine());
        return entry != null ? (String)entry.getKey() : null;
    }

    @NotNull
    public static String composeText(@NotNull Map<String, ExpectedHighlightingSet> types, @NotNull Collection<? extends HighlightInfo> infos, @NotNull String text) {
        if (types == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(19);
        }
        if (infos == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(20);
        }
        if (text == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(21);
        }
        List list = infos.stream().map(info -> Pair.pair((Object)ExpectedHighlightingData.findTag(types, info), (Object)info)).filter(p -> p.first != null).collect(Collectors.toList());
        boolean showAttributesKeys = types.values().stream().flatMap(set -> set.infos.stream()).anyMatch(info -> info.forcedTextAttributesKey != null);
        String anyWrappedInHtml = XmlStringUtil.wrapInHtml((CharSequence)ANY_TEXT);
        boolean showTooltips = types.values().stream().flatMap(set -> set.infos.stream()).anyMatch(info -> !anyWrappedInHtml.equals(info.getToolTip()));
        list.sort((o1, o2) -> {
            int bySeverity;
            HighlightInfo i1 = (HighlightInfo)o1.second;
            HighlightInfo i2 = (HighlightInfo)o2.second;
            int byEnds = i2.endOffset - i1.endOffset;
            if (byEnds != 0) {
                return byEnds;
            }
            if (!i1.isAfterEndOfLine() && !i2.isAfterEndOfLine()) {
                int byStarts = i1.startOffset - i2.startOffset;
                if (byStarts != 0) {
                    return byStarts;
                }
            } else {
                int byEOL = Boolean.compare(i2.isAfterEndOfLine(), i1.isAfterEndOfLine());
                if (byEOL != 0) {
                    return byEOL;
                }
            }
            if ((bySeverity = i2.getSeverity().compareTo(i1.getSeverity())) != 0) {
                return bySeverity;
            }
            return Comparing.compare((Comparable)((Object)i1.getDescription()), (Comparable)((Object)i2.getDescription()));
        });
        StringBuilder sb = new StringBuilder();
        int[] offsets = ExpectedHighlightingData.composeText(sb, list, 0, text, text.length(), -1, showAttributesKeys, showTooltips);
        sb.insert(0, text.substring(0, offsets[1]));
        String string = sb.toString();
        if (string == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Deprecated
    public static void expectedDuplicatedHighlighting(@NotNull Runnable check) {
        if (check == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(23);
        }
        try {
            isDuplicatedCheckDisabled = true;
            failedDuplicationChecks = 0;
            check.run();
        }
        finally {
            isDuplicatedCheckDisabled = false;
        }
        if (failedDuplicationChecks == 0) {
            throw new IllegalStateException(EXPECTED_DUPLICATION_MESSAGE);
        }
    }

    private static int[] composeText(StringBuilder sb, List<? extends Pair<String, ? extends HighlightInfo>> list, int index, String text, int endPos, int startPos, boolean showAttributesKeys, boolean showTooltip) {
        int i2;
        for (i2 = index; i2 < list.size(); ++i2) {
            Pair<String, ? extends HighlightInfo> pair = list.get(i2);
            HighlightInfo info = (HighlightInfo)pair.second;
            if (info.endOffset <= startPos) break;
            String severity = (String)pair.first;
            HighlightInfo prev = i2 < list.size() - 1 ? (HighlightInfo)list.get((int)(i2 + 1)).second : null;
            int start = MathUtil.clamp((int)info.endOffset, (int)0, (int)text.length());
            int end = MathUtil.clamp((int)endPos, (int)start, (int)text.length());
            sb.insert(0, text.substring(start, end));
            sb.insert(0, "</" + severity + ">");
            endPos = info.endOffset;
            if (prev != null && prev.endOffset > info.startOffset) {
                int[] offsets = ExpectedHighlightingData.composeText(sb, list, i2 + 1, text, endPos, info.startOffset, showAttributesKeys, showTooltip);
                i2 = offsets[0] - 1;
                endPos = offsets[1];
            }
            sb.insert(0, text.substring(info.startOffset, Math.max(endPos, info.startOffset)));
            StringBuilder str = new StringBuilder().append('<').append(severity);
            if (info.getSeverity() != HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY) {
                String description = info.getDescription();
                String toolTip = info.getToolTip();
                str.append(" descr=\"").append(StringUtil.escapeQuotes((String)String.valueOf(description))).append('\"');
                if (showTooltip) {
                    str.append(" tooltip=\"").append(StringUtil.escapeQuotes((String)String.valueOf(toolTip != null ? XmlStringUtil.stripHtml((String)toolTip) : null))).append('\"');
                }
            }
            if (showAttributesKeys) {
                str.append(" textAttributesKey=\"").append(((TextAttributesKey)ObjectUtils.notNull((Object)info.forcedTextAttributesKey, (Object)info.type.getAttributesKey())).getExternalName()).append('\"');
            }
            str.append('>');
            sb.insert(0, str);
            endPos = info.startOffset;
        }
        return new int[]{i2, endPos};
    }

    private ThreeState expectedInfosContainsInfo(HighlightInfo info, Map<ExpectedHighlightingSet, Set<HighlightInfo>> indexed) {
        if (info.getTextAttributes(null, null) == TextAttributes.ERASE_MARKER) {
            return ThreeState.UNSURE;
        }
        Collection<ExpectedHighlightingSet> expectedHighlights = this.myHighlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : expectedHighlights) {
            if (highlightingSet.severity != info.getSeverity()) continue;
            if (!highlightingSet.enabled) {
                return ThreeState.UNSURE;
            }
            Set<HighlightInfo> index = indexed.get(highlightingSet);
            if (index == null || !index.contains(info)) continue;
            return ThreeState.YES;
        }
        return ThreeState.NO;
    }

    private static boolean matchesPattern(@NotNull HighlightInfo expectedInfo, @NotNull HighlightInfo info, boolean strictMatch) {
        if (expectedInfo == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(24);
        }
        if (info == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(25);
        }
        if (expectedInfo == info) {
            return true;
        }
        boolean typeMatches = expectedInfo.type.equals(info.type) || !strictMatch && (expectedInfo.type == WHATEVER || info.type == WHATEVER);
        boolean textAttributesMatches = Comparing.equal((Object)expectedInfo.getTextAttributes(null, null), (Object)info.getTextAttributes(null, null)) || !strictMatch && (expectedInfo.forcedTextAttributes == null || info.forcedTextAttributes == null);
        boolean attributesKeyMatches = !strictMatch && (expectedInfo.forcedTextAttributesKey == null || info.forcedTextAttributesKey == null) || Objects.equals(expectedInfo.forcedTextAttributesKey, info.forcedTextAttributesKey);
        return ExpectedHighlightingData.haveSamePresentation(info, expectedInfo, strictMatch) && info.getSeverity() == expectedInfo.getSeverity() && typeMatches && textAttributesMatches && attributesKeyMatches;
    }

    private static boolean haveSamePresentation(@NotNull HighlightInfo info1, @NotNull HighlightInfo info2, boolean strictMatch) {
        if (info1 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(26);
        }
        if (info2 == null) {
            ExpectedHighlightingData.$$$reportNull$$$0(27);
        }
        return info1.startOffset == info2.startOffset && info1.endOffset == info2.endOffset && info1.isAfterEndOfLine() == info2.isAfterEndOfLine() && ExpectedHighlightingData.matchDescriptions(strictMatch, info1.getDescription(), info2.getDescription()) && ExpectedHighlightingData.matchTooltips(strictMatch, info1.getToolTip(), info2.getToolTip());
    }

    protected static boolean matchDescriptions(boolean strictMatch, String d1, String d2) {
        if (Comparing.strEqual((String)d1, (String)d2)) {
            return true;
        }
        if (strictMatch) {
            return false;
        }
        if (Comparing.strEqual((String)ANY_TEXT, (String)d1) || Comparing.strEqual((String)ANY_TEXT, (String)d2)) {
            return true;
        }
        if (d1 != null && d2 != null) {
            if (d1.endsWith("\u2026") && d1.regionMatches(0, d2, 0, d1.length() - 1)) {
                return true;
            }
            if (d2.endsWith("\u2026") && d2.regionMatches(0, d1, 0, d2.length() - 1)) {
                return true;
            }
        }
        return false;
    }

    private static boolean matchTooltips(boolean strictMatch, String t1, String t2) {
        if (Comparing.strEqual((String)t1, (String)t2)) {
            return true;
        }
        if (strictMatch) {
            return false;
        }
        t1 = t1 != null ? Strings.unescapeXmlEntities((String)XmlStringUtil.stripHtml((String)t1)) : null;
        t2 = t2 != null ? Strings.unescapeXmlEntities((String)XmlStringUtil.stripHtml((String)t2)) : null;
        return ExpectedHighlightingData.matchDescriptions(false, t1, t2);
    }

    private static String rangeString(String text, int startOffset, int endOffset) {
        LineColumn start = StringUtil.offsetToLineColumn((CharSequence)text, (int)startOffset);
        assert (start != null) : "textLength = " + text.length() + ", startOffset = " + startOffset;
        LineColumn end = StringUtil.offsetToLineColumn((CharSequence)text, (int)endOffset);
        assert (end != null) : "textLength = " + text.length() + ", endOffset = " + endOffset;
        if (start.line == end.line) {
            return String.format("(%d:%d/%d)", start.line + 1, start.column + 1, end.column - start.column);
        }
        return String.format("(%d:%d..%d:%d)", start.line + 1, end.line + 1, start.column + 1, end.column + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingSet";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerInfos";
                break;
            }
            case 7: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = INFO_MARKER;
                break;
            }
            case 10: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ExpectedHighlightingData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerInfo";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failMessage";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedInfo";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info1";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ExpectedHighlightingData";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualLineMarkerFileText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "indexInfos";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "composeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlightingType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkLineMarkers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sanitizedLineMarkerTooltip";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActualLineMarkerFileText";
                break;
            }
            case 10: 
            case 14: 
            case 22: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsLineMarker";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchLineMarkersTooltip";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reportProblem";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "composeText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "expectedDuplicatedHighlighting";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "matchesPattern";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "haveSamePresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14, 22 -> new IllegalStateException(string);
        };
    }

    public static class ExpectedHighlightingSet {
        private final HighlightSeverity severity;
        private final boolean endOfLine;
        private final boolean enabled;
        private final Set<HighlightInfo> infos;

        public ExpectedHighlightingSet(@NotNull HighlightSeverity severity, boolean endOfLine, boolean enabled) {
            if (severity == null) {
                ExpectedHighlightingSet.$$$reportNull$$$0(0);
            }
            this.severity = severity;
            this.endOfLine = endOfLine;
            this.enabled = enabled;
            this.infos = new HashSet<HighlightInfo>();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/testFramework/ExpectedHighlightingData$ExpectedHighlightingSet", "<init>"));
        }
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final String myTooltip;

        MyLineMarkerInfo(TextRange range, GutterIconRenderer.Alignment alignment, String tooltip, String iconPath) {
            super(NULL_POINTER, range, (Icon)new PathIcon(iconPath), null, null, null, alignment);
            this.myTooltip = tooltip;
        }

        public String getLineMarkerTooltip() {
            return this.myTooltip;
        }
    }

    private static class PathIcon
    implements Icon {
        private final String path;

        private PathIcon(@NotNull String path) {
            if (path == null) {
                PathIcon.$$$reportNull$$$0(0);
            }
            this.path = path;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof PathIcon && ((PathIcon)obj).path.equals(this.path);
        }

        public String toString() {
            return this.path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/ExpectedHighlightingData$PathIcon", "<init>"));
        }
    }
}

