/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.logging;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.logging.FixType;
import com.intellij.codeInspection.logging.LoggingConditionDisagreesWithLogLevelStatementInspectionKt;
import com.intellij.codeInspection.logging.LoggingUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInspection/logging/LoggingConditionDisagreesWithLogLevelStatementInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "LoggingStringTemplateAsArgumentVisitor", "intellij.jvm.analysis.impl"})
public final class LoggingConditionDisagreesWithLogLevelStatementInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UCallExpression.class};
        return UastHintedVisitorAdapter.Companion.create(language, (AbstractUastNonRecursiveVisitor)new LoggingStringTemplateAsArgumentVisitor(holder), classArray, true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J8\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0002J'\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\tH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/codeInspection/logging/LoggingConditionDisagreesWithLogLevelStatementInspection$LoggingStringTemplateAsArgumentVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/logging/LoggingConditionDisagreesWithLogLevelStatementInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "processActualLoggers", "", "callExpression", "guardIsUsed", "guarded", "Lorg/jetbrains/uast/UExpression;", "processLegacyLoggers", "guardIsUsedLegacy", "registerProblem", "call", "levelFromCondition", "", "loggerLevel", "guardedCondition", "createFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lorg/jetbrains/uast/UCallExpression;Lorg/jetbrains/uast/UExpression;)[Lcom/intellij/codeInspection/LocalQuickFix;", "createChangeGuard", "guard", "createChangeLog", "getGuardName", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nLoggingConditionDisagreesWithLogLevelStatementInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingConditionDisagreesWithLogLevelStatementInspection.kt\ncom/intellij/codeInspection/logging/LoggingConditionDisagreesWithLogLevelStatementInspection$LoggingStringTemplateAsArgumentVisitor\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,223:1\n171#2:224\n171#2:234\n1755#3,3:225\n295#3,2:232\n1755#3,3:235\n37#4:228\n36#4,3:229\n*S KotlinDebug\n*F\n+ 1 LoggingConditionDisagreesWithLogLevelStatementInspection.kt\ncom/intellij/codeInspection/logging/LoggingConditionDisagreesWithLogLevelStatementInspection$LoggingStringTemplateAsArgumentVisitor\n*L\n60#1:224\n87#1:234\n66#1:225,3\n141#1:232,2\n96#1:235,3\n134#1:228\n134#1:229,3\n*E\n"})
    public final class LoggingStringTemplateAsArgumentVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public LoggingStringTemplateAsArgumentVisitor(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (LoggingUtil.Companion.getLOG_MATCHERS$intellij_jvm_analysis_impl().uCallMatches(node)) {
                this.processActualLoggers(node);
            } else if (LoggingUtil.Companion.getLEGACY_LOG_MATCHERS$intellij_jvm_analysis_impl().uCallMatches(node)) {
                this.processLegacyLoggers(node);
            }
            return true;
        }

        private final void processActualLoggers(UCallExpression callExpression) {
            UExpression uExpression = LoggingUtil.Companion.getGuardedCondition$intellij_jvm_analysis_impl(callExpression);
            if (uExpression == null) {
                return;
            }
            UExpression guardedCondition = uExpression;
            if (this.guardIsUsed(guardedCondition)) {
                return;
            }
            LoggingUtil.Companion.LevelType levelType = LoggingUtil.Companion.getLoggerLevel$intellij_jvm_analysis_impl$default(LoggingUtil.Companion, callExpression, false, 2, null);
            if (levelType == null) {
                return;
            }
            LoggingUtil.Companion.LevelType loggerLevel = levelType;
            LoggingUtil.Companion.LevelType levelType2 = LoggingUtil.Companion.getLevelFromCondition$intellij_jvm_analysis_impl(guardedCondition);
            if (levelType2 == null) {
                return;
            }
            LoggingUtil.Companion.LevelType levelFromCondition = levelType2;
            if (!LoggingUtil.Companion.isGuardedIn$intellij_jvm_analysis_impl(levelFromCondition, loggerLevel)) {
                this.registerProblem(guardedCondition, levelFromCondition.name(), loggerLevel.name(), callExpression, guardedCondition);
            }
        }

        private final boolean guardIsUsed(UExpression guarded) {
            boolean bl;
            block8: {
                PsiElement sourcePsi;
                PsiElement psiElement = guarded.getSourcePsi();
                if (psiElement == null) {
                    return false;
                }
                PsiElement $this$toUElementOfType$iv = sourcePsi = psiElement;
                boolean $i$f$toUElementOfType = false;
                UExpression guardedCondition = (UExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UExpression.class);
                if (guardedCondition == null) {
                    return false;
                }
                List<UCallExpression> calls = LoggingUtil.Companion.getLoggerCalls$intellij_jvm_analysis_impl(guardedCondition);
                LoggingUtil.Companion.LevelType levelType = LoggingUtil.Companion.getLevelFromCondition$intellij_jvm_analysis_impl(guardedCondition);
                if (levelType == null) {
                    return false;
                }
                LoggingUtil.Companion.LevelType levelFromCondition = levelType;
                Iterable $this$any$iv = calls;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        LoggingUtil.Companion.LevelType loggerLevel;
                        boolean bl2;
                        UCallExpression call = (UCallExpression)element$iv;
                        boolean bl3 = false;
                        UExpression condition = LoggingUtil.Companion.getGuardedCondition$intellij_jvm_analysis_impl(call);
                        PsiElement psiElement2 = guardedCondition.getSourcePsi();
                        if (psiElement2 != null) {
                            UExpression uExpression = condition;
                            bl2 = psiElement2.isEquivalentTo((PsiElement)(uExpression != null ? uExpression.getSourcePsi() : null));
                        } else {
                            bl2 = false;
                        }
                        if (!(!bl2 ? false : (LoggingUtil.Companion.getLoggerLevel$intellij_jvm_analysis_impl$default(LoggingUtil.Companion, call, false, 2, null) == null ? false : LoggingUtil.Companion.isGuardedIn$intellij_jvm_analysis_impl(levelFromCondition, loggerLevel)))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final void processLegacyLoggers(UCallExpression callExpression) {
            UExpression uExpression = LoggingUtil.Companion.getGuardedCondition$intellij_jvm_analysis_impl(callExpression);
            if (uExpression == null) {
                return;
            }
            UExpression guardedCondition = uExpression;
            if (this.guardIsUsedLegacy(guardedCondition)) {
                return;
            }
            LoggingUtil.Companion.LegacyLevelType legacyLevelType = LoggingUtil.Companion.getLegacyLoggerLevel$intellij_jvm_analysis_impl(callExpression);
            if (legacyLevelType == null) {
                return;
            }
            LoggingUtil.Companion.LegacyLevelType loggerLevel = legacyLevelType;
            LoggingUtil.Companion.LegacyLevelType legacyLevelType2 = LoggingUtil.Companion.getLegacyLevelFromCondition$intellij_jvm_analysis_impl(guardedCondition);
            if (legacyLevelType2 == null) {
                return;
            }
            LoggingUtil.Companion.LegacyLevelType levelFromCondition = legacyLevelType2;
            if (!LoggingUtil.Companion.isLegacyGuardedIn$intellij_jvm_analysis_impl(levelFromCondition, loggerLevel)) {
                this.registerProblem(guardedCondition, levelFromCondition.name(), loggerLevel.name(), callExpression, guardedCondition);
            }
        }

        private final boolean guardIsUsedLegacy(UExpression guarded) {
            PsiElement psiElement = guarded.getSourcePsi();
            if (psiElement == null) {
                return false;
            }
            PsiElement sourcePsi = psiElement;
            Object object = CachedValuesManager.getManager((Project)sourcePsi.getProject()).getCachedValue((UserDataHolder)sourcePsi, () -> LoggingStringTemplateAsArgumentVisitor.guardIsUsedLegacy$lambda$2(sourcePsi));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (Boolean)object;
        }

        private final void registerProblem(UExpression call, String levelFromCondition, String loggerLevel, UCallExpression callExpression, UExpression guardedCondition) {
            LocalQuickFix[] fixes = this.createFixes(callExpression, guardedCondition);
            Object[] objectArray = new Object[]{levelFromCondition, loggerLevel};
            String message = JvmAnalysisBundle.message("jvm.inspection.logging.condition.disagrees.with.log.statement.problem.descriptor", objectArray);
            if (call instanceof UCallExpression) {
                UCallExpression uCallExpression = (UCallExpression)call;
                Intrinsics.checkNotNull((Object)message);
                ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UCallExpression)uCallExpression, (String)message, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length), null, (int)8, null);
            }
            if (call instanceof UReferenceExpression) {
                UReferenceExpression uReferenceExpression = (UReferenceExpression)call;
                Intrinsics.checkNotNull((Object)message);
                ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UReferenceExpression)uReferenceExpression, (String)message, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length), null, (int)8, null);
            }
        }

        static /* synthetic */ void registerProblem$default(LoggingStringTemplateAsArgumentVisitor loggingStringTemplateAsArgumentVisitor, UExpression uExpression, String string, String string2, UCallExpression uCallExpression, UExpression uExpression2, int n, Object object) {
            if ((n & 8) != 0) {
                uCallExpression = null;
            }
            if ((n & 0x10) != 0) {
                uExpression2 = null;
            }
            loggingStringTemplateAsArgumentVisitor.registerProblem(uExpression, string, string2, uCallExpression, uExpression2);
        }

        private final LocalQuickFix[] createFixes(UCallExpression callExpression, UExpression guardedCondition) {
            LocalQuickFix guardFix;
            if (callExpression == null || guardedCondition == null) {
                return new LocalQuickFix[0];
            }
            List result = new ArrayList();
            LocalQuickFix logFix = this.createChangeLog(callExpression, guardedCondition);
            if (logFix != null) {
                result.add(logFix);
            }
            if ((guardFix = this.createChangeGuard(guardedCondition, callExpression)) != null) {
                result.add(guardFix);
            }
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new LocalQuickFix[0]);
        }

        private final LocalQuickFix createChangeGuard(UExpression guard, UCallExpression callExpression) {
            Object object;
            Object v1;
            block5: {
                String string = this.getGuardName(guard);
                if (string == null) {
                    return null;
                }
                String guardName = string;
                if (LoggingUtil.Companion.getGUARD_MAP().get(guardName) == null) {
                    return null;
                }
                if (LoggingUtil.Companion.getLoggerCalls$intellij_jvm_analysis_impl(guard).size() != 1) {
                    return null;
                }
                Iterable $this$firstOrNull$iv = LoggingUtil.Companion.getGUARD_MAP().entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getValue(), (Object)callExpression.getMethodName())) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            if ((object = (Map.Entry)v1) == null || (object = (String)object.getKey()) == null) {
                return null;
            }
            Object callToGuard = object;
            return (LocalQuickFix)LoggingConditionDisagreesWithLogLevelStatementInspectionKt.access$ChangeCallNameFix(FixType.GUARD, guard, (String)callToGuard);
        }

        private final LocalQuickFix createChangeLog(UCallExpression callExpression, UExpression guard) {
            String string = this.getGuardName(guard);
            if (string == null) {
                return null;
            }
            String guardName = string;
            String string2 = LoggingUtil.Companion.getGUARD_MAP().get(guardName);
            if (string2 == null) {
                return null;
            }
            String guardToCall = string2;
            if (!CollectionsKt.contains((Iterable)LoggingUtil.Companion.getGUARD_MAP().values(), (Object)callExpression.getMethodName())) {
                return null;
            }
            return (LocalQuickFix)LoggingConditionDisagreesWithLogLevelStatementInspectionKt.access$ChangeCallNameFix(FixType.CALL, (UExpression)callExpression, guardToCall);
        }

        private final String getGuardName(UExpression guard) {
            UExpression uExpression = guard;
            return uExpression instanceof UCallExpression ? ((UCallExpression)guard).getMethodName() : (uExpression instanceof UQualifiedReferenceExpression ? ((UQualifiedReferenceExpression)guard).getResolvedName() : null);
        }

        private static final CachedValueProvider.Result guardIsUsedLegacy$lambda$2(PsiElement $sourcePsi) {
            boolean bl;
            block7: {
                Object[] $this$toUElementOfType$iv = $sourcePsi;
                boolean $i$f$toUElementOfType = false;
                UExpression guardedCondition = (UExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UExpression.class);
                if (guardedCondition == null) {
                    $this$toUElementOfType$iv = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
                    return CachedValueProvider.Result.create((Object)false, (Object[])$this$toUElementOfType$iv);
                }
                List<UCallExpression> calls = LoggingUtil.Companion.getLoggerCalls$intellij_jvm_analysis_impl(guardedCondition);
                LoggingUtil.Companion.LegacyLevelType legacyLevelType = LoggingUtil.Companion.getLegacyLevelFromCondition$intellij_jvm_analysis_impl(guardedCondition);
                if (legacyLevelType == null) {
                    Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
                    return CachedValueProvider.Result.create((Object)false, (Object[])objectArray);
                }
                LoggingUtil.Companion.LegacyLevelType levelFromCondition = legacyLevelType;
                Iterable $this$any$iv = calls;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        LoggingUtil.Companion.LegacyLevelType loggerLevel;
                        boolean bl2;
                        UCallExpression call = (UCallExpression)element$iv;
                        boolean bl3 = false;
                        UExpression condition = LoggingUtil.Companion.getGuardedCondition$intellij_jvm_analysis_impl(call);
                        PsiElement psiElement = guardedCondition.getSourcePsi();
                        if (psiElement != null) {
                            UExpression uExpression = condition;
                            bl2 = psiElement.isEquivalentTo((PsiElement)(uExpression != null ? uExpression.getSourcePsi() : null));
                        } else {
                            bl2 = false;
                        }
                        if (!(!bl2 ? false : (LoggingUtil.Companion.getLegacyLoggerLevel$intellij_jvm_analysis_impl(call) == null ? false : LoggingUtil.Companion.isLegacyGuardedIn$intellij_jvm_analysis_impl(levelFromCondition, loggerLevel)))) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)bl, (Object[])objectArray);
        }
    }
}

