/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.intellij.lang.regexp.RegExpFileType;
import org.jetbrains.annotations.NotNull;

public final class TypeFilter
extends FilterAction {
    boolean myShowRegex;

    public TypeFilter() {
        super(SSRBundle.messagePointer("type.filter.name", new Object[0]));
    }

    @Override
    @NotNull
    public String getShortText(NamedScriptableDefinition variable) {
        if (!(variable instanceof MatchVariableConstraint)) {
            return "";
        }
        MatchVariableConstraint constraint = (MatchVariableConstraint)variable;
        if (constraint.getNameOfExprType().isEmpty()) {
            return "";
        }
        String string2 = SSRBundle.message("exprtype.tooltip.message", constraint.isInvertExprType() ? 1 : 0, constraint.isRegexExprType() ? constraint.getNameOfExprType() : constraint.getExpressionTypes(), constraint.isExprTypeWithinHierarchy() ? 1 : 0);
        if (string2 == null) {
            TypeFilter.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    public boolean hasFilter() {
        MatchVariableConstraint variable = this.myTable.getMatchVariable();
        return variable != null && !StringUtil.isEmpty((String)variable.getNameOfExprType());
    }

    @Override
    public void clearFilter() {
        MatchVariableConstraint variable = this.myTable.getMatchVariable();
        if (variable == null) {
            return;
        }
        variable.setNameOfExprType("");
        variable.setInvertExprType(false);
        variable.setExprTypeWithinHierarchy(false);
    }

    @Override
    public boolean isApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        if (this.myTable.getMatchVariable() == null) {
            return false;
        }
        this.myShowRegex = this.isApplicableConstraint("TYPE REGEX", nodes, completePattern, target);
        return this.isApplicableConstraint("TYPE", nodes, completePattern, target);
    }

    @Override
    protected void setLabel(SimpleColoredComponent component) {
        MatchVariableConstraint variable = this.myTable.getMatchVariable();
        if (variable == null) {
            return;
        }
        String s = variable.isRegexExprType() ? variable.getNameOfExprType() : variable.getExpressionTypes();
        Object value = variable.isInvertExprType() ? "!" + s : s;
        this.myLabel.append(SSRBundle.message("type.0.label", value));
        if (variable.isExprTypeWithinHierarchy()) {
            this.myLabel.append(SSRBundle.message("within.hierarchy.label", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public FilterEditor<MatchVariableConstraint> getEditor() {
        return new FilterEditor<MatchVariableConstraint>(this.myTable.getMatchVariable(), this.myTable.getConstraintChangedCallback()){
            private final EditorTextField myTextField;
            private final JLabel myTypeLabel;
            private final JCheckBox myHierarchyCheckBox;
            private final JCheckBox myRegexCheckBox;
            private final ContextHelpLabel myHelpLabel;
            {
                this.myTextField = UIUtil.createTextComponent("", TypeFilter.this.myTable.getProject());
                this.myTypeLabel = new JLabel(SSRBundle.message("type.label", new Object[0]));
                this.myHierarchyCheckBox = new JCheckBox(SSRBundle.message("within.type.hierarchy.check.box", new Object[0]), false);
                this.myRegexCheckBox = new JCheckBox(SSRBundle.message("regex.check.box", new Object[0]), false);
                this.myRegexCheckBox.addActionListener(e -> {
                    RegExpFileType fileType = this.myRegexCheckBox.isSelected() ? RegExpFileType.INSTANCE : PlainTextFileType.INSTANCE;
                    Document document = UIUtil.createDocument((FileType)fileType, this.myTextField.getText(), TypeFilter.this.myTable.getProject());
                    this.myTextField.setDocument(document);
                });
                this.myHelpLabel = ContextHelpLabel.create((String)SSRBundle.message("type.filter.help.text", new Object[0]));
            }

            @Override
            protected void layoutComponents() {
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.myTypeLabel).addComponent((Component)this.myTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent((Component)this.myHelpLabel)).addGroup(layout.createSequentialGroup().addComponent(this.myHierarchyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myRegexCheckBox)));
                layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myTypeLabel).addComponent((Component)this.myTextField).addComponent((Component)this.myHelpLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myHierarchyCheckBox).addComponent(this.myRegexCheckBox)));
            }

            @Override
            protected void loadValues() {
                boolean regex = ((MatchVariableConstraint)this.myConstraint).isRegexExprType();
                this.myTextField.setFileType((FileType)(TypeFilter.this.myShowRegex && regex ? RegExpFileType.INSTANCE : PlainTextFileType.INSTANCE));
                this.myTextField.setText((((MatchVariableConstraint)this.myConstraint).isInvertExprType() ? "!" : "") + (regex ? ((MatchVariableConstraint)this.myConstraint).getNameOfExprType() : ((MatchVariableConstraint)this.myConstraint).getExpressionTypes()));
                this.myHierarchyCheckBox.setSelected(((MatchVariableConstraint)this.myConstraint).isExprTypeWithinHierarchy());
                this.myRegexCheckBox.setSelected(TypeFilter.this.myShowRegex && regex);
                this.myRegexCheckBox.setVisible(TypeFilter.this.myShowRegex);
            }

            @Override
            public void saveValues() {
                String text2 = this.myTextField.getText();
                boolean inverted = text2.startsWith("!");
                if (inverted) {
                    text2 = text2.substring(1);
                }
                if (TypeFilter.this.myShowRegex && this.myRegexCheckBox.isSelected()) {
                    ((MatchVariableConstraint)this.myConstraint).setNameOfExprType(text2);
                } else {
                    ((MatchVariableConstraint)this.myConstraint).setExpressionTypes(text2);
                }
                ((MatchVariableConstraint)this.myConstraint).setInvertExprType(inverted);
                ((MatchVariableConstraint)this.myConstraint).setExprTypeWithinHierarchy(this.myHierarchyCheckBox.isSelected());
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myTextField;
            }

            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.myTextField};
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/filters/TypeFilter", "getShortText"));
    }
}

