/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Consumer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomDeclarationSearcher
extends PomDeclarationSearcher {
    public void findDeclarationsAt(@NotNull PsiElement token, int offsetInElement, @NotNull Consumer<? super PomTarget> consumer) {
        DomElement nameElement;
        if (token == null) {
            AbstractDomDeclarationSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            AbstractDomDeclarationSearcher.$$$reportNull$$$0(1);
        }
        if (!(token instanceof XmlToken)) {
            return;
        }
        PsiElement element = token.getParent();
        if (element == null) {
            return;
        }
        IElementType tokenType = ((XmlToken)token).getTokenType();
        PsiElement parentElement = element.getParent();
        DomManager domManager = DomManager.getDomManager(token.getProject());
        if (tokenType == XmlTokenType.XML_DATA_CHARACTERS && element instanceof XmlText && parentElement instanceof XmlTag) {
            XmlTag tag = (XmlTag)parentElement;
            for (XmlText text2 : tag.getValue().getTextElements()) {
                if (!InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)text2))) continue;
                return;
            }
            nameElement = domManager.getDomElement(tag);
        } else if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && element instanceof XmlAttributeValue && parentElement instanceof XmlAttribute) {
            if (InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)element))) {
                return;
            }
            nameElement = domManager.getDomElement((XmlAttribute)parentElement);
        } else {
            return;
        }
        if (!(nameElement instanceof GenericDomValue)) {
            return;
        }
        DomElement parent = nameElement.getParent();
        if (parent == null) {
            return;
        }
        DomTarget target = this.createDomTarget(parent, nameElement);
        if (target != null) {
            consumer.consume((Object)target);
        }
    }

    @Nullable
    protected abstract DomTarget createDomTarget(DomElement var1, DomElement var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "token";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/xml/AbstractDomDeclarationSearcher";
        objectArray[2] = "findDeclarationsAt";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

