/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.GenericDomValueReference;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DomHighlightingHelperImpl
extends DomHighlightingHelper {
    public static final DomHighlightingHelperImpl INSTANCE = new DomHighlightingHelperImpl();
    private final GenericValueReferenceProvider myProvider = new GenericValueReferenceProvider();
    private final DomApplicationComponent myDomApplicationComponent = DomApplicationComponent.getInstance();

    @Override
    public void runAnnotators(DomElement element, DomElementAnnotationHolder holder, @NotNull Class<? extends DomElement> rootClass) {
        DomElementsAnnotator annotator;
        if (rootClass == null) {
            DomHighlightingHelperImpl.$$$reportNull$$$0(0);
        }
        if ((annotator = this.myDomApplicationComponent.getAnnotator(rootClass)) != null) {
            annotator.annotate(element, holder);
        }
    }

    @Override
    public @Unmodifiable @NotNull List<DomElementProblemDescriptor> checkRequired(DomElement element, DomElementAnnotationHolder holder) {
        Required required = element.getAnnotation(Required.class);
        if (required != null) {
            XmlElement xmlElement = element.getXmlElement();
            if (xmlElement == null) {
                if (required.value()) {
                    String xmlElementName = element.getXmlElementName();
                    String namespace = element.getXmlElementNamespace();
                    if (element instanceof GenericAttributeValue) {
                        List<DomElementProblemDescriptor> list2 = Collections.singletonList(holder.createProblem(element, XmlDomBundle.message("dom.inspections.attribute.0.should.be.defined", xmlElementName), new DefineAttributeQuickFix(xmlElementName, namespace)));
                        if (list2 == null) {
                            DomHighlightingHelperImpl.$$$reportNull$$$0(1);
                        }
                        return list2;
                    }
                    List<DomElementProblemDescriptor> list3 = Collections.singletonList(holder.createProblem(element, HighlightSeverity.ERROR, XmlDomBundle.message("dom.inspections.child.tag.0.should.be.defined", xmlElementName), new AddRequiredSubtagFix(xmlElementName, namespace)));
                    if (list3 == null) {
                        DomHighlightingHelperImpl.$$$reportNull$$$0(2);
                    }
                    return list3;
                }
            } else if (element instanceof GenericDomValue) {
                List list4 = ContainerUtil.createMaybeSingletonList((Object)DomHighlightingHelperImpl.checkRequiredGenericValue((GenericDomValue)element, required, holder));
                if (list4 == null) {
                    DomHighlightingHelperImpl.$$$reportNull$$$0(3);
                }
                return list4;
            }
        }
        if (DomUtil.hasXml(element)) {
            SmartList list5 = new SmartList();
            DomGenericInfo info = element.getGenericInfo();
            for (AbstractDomChildrenDescription abstractDomChildrenDescription : info.getChildrenDescriptions()) {
                Required annotation;
                if (!(abstractDomChildrenDescription instanceof DomCollectionChildDescription)) continue;
                DomCollectionChildDescription childDescription = (DomCollectionChildDescription)abstractDomChildrenDescription;
                if (!abstractDomChildrenDescription.getValues(element).isEmpty() || (annotation = abstractDomChildrenDescription.getAnnotation(Required.class)) == null || !annotation.value()) continue;
                list5.add((Object)holder.createProblem(element, childDescription, XmlDomBundle.message("dom.inspections.child.tag.0.should.be.defined", ((DomCollectionChildDescription)abstractDomChildrenDescription).getXmlElementName())));
            }
            SmartList smartList = list5;
            if (smartList == null) {
                DomHighlightingHelperImpl.$$$reportNull$$$0(4);
            }
            return smartList;
        }
        List<DomElementProblemDescriptor> list5 = Collections.emptyList();
        if (list5 == null) {
            DomHighlightingHelperImpl.$$$reportNull$$$0(5);
        }
        return list5;
    }

    @Override
    @NotNull
    public List<DomElementProblemDescriptor> checkResolveProblems(GenericDomValue element, DomElementAnnotationHolder holder) {
        Required required;
        if (StringUtil.isEmpty((String)element.getStringValue()) && (required = element.getAnnotation(Required.class)) != null && !required.nonEmpty()) {
            List<DomElementProblemDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                DomHighlightingHelperImpl.$$$reportNull$$$0(6);
            }
            return list2;
        }
        XmlElement valueElement = DomUtil.getValueElement(element);
        if (valueElement != null && !DomHighlightingHelperImpl.isSoftReference(element)) {
            String errorMessage;
            SmartList list3 = new SmartList();
            Object[] psiReferences = this.myProvider.getReferencesByElement(valueElement, new ProcessingContext());
            GenericDomValueReference domReference = (GenericDomValueReference)((Object)ContainerUtil.findInstance((Object[])psiReferences, GenericDomValueReference.class));
            Converter converter = WrappingConverter.getDeepestConverter(element.getConverter(), element);
            boolean hasBadResolve = false;
            if (domReference == null || !DomHighlightingHelperImpl.isDomResolveOK(element, domReference, converter)) {
                for (Object reference : psiReferences) {
                    if (reference == domReference || !DomHighlightingHelperImpl.hasBadResolve((PsiReference)reference)) continue;
                    hasBadResolve = true;
                    list3.add((Object)holder.createResolveProblem(element, (PsiReference)reference));
                }
                boolean isResolvingConverter = converter instanceof ResolvingConverter;
                if (!hasBadResolve && (domReference != null || isResolvingConverter && DomHighlightingHelperImpl.hasBadResolve(domReference = new GenericDomValueReference(element)))) {
                    hasBadResolve = true;
                    String errorMessage2 = converter.getErrorMessage(element.getStringValue(), ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler(element)));
                    if (errorMessage2 != null) {
                        list3.add((Object)holder.createResolveProblem(element, (PsiReference)domReference));
                    }
                }
            }
            if (!hasBadResolve && psiReferences.length == 0 && element.getValue() == null && !PsiTreeUtil.hasErrorElements((PsiElement)valueElement) && (errorMessage = converter.getErrorMessage(element.getStringValue(), ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler(element)))) != null) {
                list3.add((Object)holder.createProblem((DomElement)element, errorMessage, new LocalQuickFix[0]));
            }
            SmartList smartList = list3;
            if (smartList == null) {
                DomHighlightingHelperImpl.$$$reportNull$$$0(7);
            }
            return smartList;
        }
        List<DomElementProblemDescriptor> list4 = Collections.emptyList();
        if (list4 == null) {
            DomHighlightingHelperImpl.$$$reportNull$$$0(8);
        }
        return list4;
    }

    private static boolean isDomResolveOK(GenericDomValue element, GenericDomValueReference domReference, Converter converter) {
        return !DomHighlightingHelperImpl.hasBadResolve((PsiReference)domReference) || converter instanceof ResolvingConverter && ((ResolvingConverter)converter).getAdditionalVariants(domReference.getConvertContext()).contains(element.getStringValue());
    }

    @Override
    @NotNull
    public List<DomElementProblemDescriptor> checkNameIdentity(DomElement element, DomElementAnnotationHolder holder) {
        DomElement domElement;
        String elementName = ElementPresentationManager.getElementName(element);
        if (StringUtil.isNotEmpty((String)elementName) && (domElement = DomUtil.findDuplicateNamedValue(element, elementName)) != null) {
            String typeName = ElementPresentationManager.getTypeNameForObject(element);
            GenericDomValue<?> genericDomValue = domElement.getGenericInfo().getNameDomElement(element);
            if (genericDomValue != null) {
                List<DomElementProblemDescriptor> list2 = Collections.singletonList(holder.createProblem(genericDomValue, DomUtil.getFile(domElement).equals(DomUtil.getFile(element)) ? XmlDomBundle.message("dom.inspections.identity", typeName) : XmlDomBundle.message("dom.inspections.identity.in.other.file", typeName, domElement.getXmlTag().getContainingFile().getName()), new LocalQuickFix[0]));
                if (list2 == null) {
                    DomHighlightingHelperImpl.$$$reportNull$$$0(9);
                }
                return list2;
            }
        }
        List<DomElementProblemDescriptor> list3 = Collections.emptyList();
        if (list3 == null) {
            DomHighlightingHelperImpl.$$$reportNull$$$0(10);
        }
        return list3;
    }

    private static boolean hasBadResolve(PsiReference reference) {
        return XmlHighlightVisitor.hasBadResolve(reference, true);
    }

    private static boolean isSoftReference(GenericDomValue value) {
        Resolve resolve = value.getAnnotation(Resolve.class);
        if (resolve != null && resolve.soft()) {
            return true;
        }
        Convert convert = value.getAnnotation(Convert.class);
        if (convert != null && convert.soft()) {
            return true;
        }
        Referencing referencing = value.getAnnotation(Referencing.class);
        return referencing != null && referencing.soft();
    }

    @Nullable
    private static DomElementProblemDescriptor checkRequiredGenericValue(GenericDomValue child, Required required, DomElementAnnotationHolder annotator) {
        String stringValue = child.getStringValue();
        if (stringValue == null) {
            return null;
        }
        if (required.nonEmpty() && DomHighlightingHelperImpl.isEmpty(child, stringValue)) {
            return annotator.createProblem((DomElement)child, XmlDomBundle.message("dom.inspections.value.must.not.be.empty", new Object[0]), new LocalQuickFix[0]);
        }
        if (required.identifier() && !DomHighlightingHelperImpl.isIdentifier(stringValue)) {
            return annotator.createProblem((DomElement)child, XmlDomBundle.message("dom.inspections.value.must.be.identifier", new Object[0]), new LocalQuickFix[0]);
        }
        return null;
    }

    private static boolean isIdentifier(String s) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(GenericDomValue child, String stringValue) {
        XmlAttributeValue value;
        if (!stringValue.trim().isEmpty()) {
            return false;
        }
        return !(child instanceof GenericAttributeValue) || (value = ((GenericAttributeValue)child).getXmlAttributeValue()) == null || !value.getTextRange().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkRequired";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "checkResolveProblems";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "checkNameIdentity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotators";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string2);
        };
    }

    private static final class AddRequiredSubtagFix
    implements LocalQuickFix {
        private final String tagName;
        private final String tagNamespace;

        private AddRequiredSubtagFix(@NotNull String _tagName, @NotNull String _tagNamespace) {
            if (_tagName == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(0);
            }
            if (_tagNamespace == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(1);
            }
            this.tagName = _tagName;
            this.tagNamespace = _tagNamespace;
        }

        @NotNull
        public String getName() {
            String string2 = XmlDomBundle.message("dom.quickfix.insert.required.tag.text", this.tagName);
            if (string2 == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @NotNull
        public String getFamilyName() {
            String string2 = XmlDomBundle.message("dom.quickfix.insert.required.tag.family", new Object[0]);
            if (string2 == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(3);
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            XmlTag tag;
            if (project2 == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                AddRequiredSubtagFix.$$$reportNull$$$0(5);
            }
            if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class, (boolean)false)) != null) {
                this.doFix(tag);
            }
        }

        private void doFix(XmlTag parentTag) {
            parentTag.add(parentTag.createChildTag(this.tagName, this.tagNamespace, null, false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_tagName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_tagNamespace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

