/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.JpsNamedElement;
import org.jetbrains.jps.model.module.JpsModule;

public final class ModuleChunk {
    private final Set<JpsModule> modules;
    private final boolean containsTests;
    private final Set<ModuleBuildTarget> targets;

    public ModuleChunk(@NotNull Set<ModuleBuildTarget> targets) {
        if (targets == null) {
            ModuleChunk.$$$reportNull$$$0(0);
        }
        this.targets = targets;
        this.modules = new LinkedHashSet<JpsModule>(targets.size());
        boolean containsTests = false;
        for (ModuleBuildTarget target : targets) {
            this.modules.add(target.getModule());
            containsTests |= target.isTests();
        }
        this.containsTests = containsTests;
    }

    @Nls
    @NotNull
    public String getPresentableShortName() {
        String name;
        String first = this.modules.iterator().next().getName();
        if (this.modules.size() > 1) {
            name = JpsBuildBundle.message("target.description.0.and.1.more", first, this.modules.size() - 1);
            String fullName = this.getName();
            if (fullName.length() < name.length()) {
                name = fullName;
            }
        } else {
            name = first;
        }
        if (this.containsTests()) {
            String string = JpsBuildBundle.message("target.description.tests.of.0", name);
            if (string == null) {
                ModuleChunk.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            ModuleChunk.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        if (this.modules.size() == 1) {
            String string = this.modules.iterator().next().getName();
            if (string == null) {
                ModuleChunk.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.modules.stream().map(JpsNamedElement::getName).collect(Collectors.joining(","));
        if (string == null) {
            ModuleChunk.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Set<JpsModule> getModules() {
        Set<JpsModule> set = this.modules;
        if (set == null) {
            ModuleChunk.$$$reportNull$$$0(5);
        }
        return set;
    }

    public boolean containsTests() {
        return this.containsTests;
    }

    @NotNull
    public Set<ModuleBuildTarget> getTargets() {
        Set<ModuleBuildTarget> set = this.targets;
        if (set == null) {
            ModuleChunk.$$$reportNull$$$0(6);
        }
        return set;
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    public ModuleBuildTarget representativeTarget() {
        ModuleBuildTarget moduleBuildTarget = this.targets.iterator().next();
        if (moduleBuildTarget == null) {
            ModuleChunk.$$$reportNull$$$0(7);
        }
        return moduleBuildTarget;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/ModuleChunk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/ModuleChunk";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableShortName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "representativeTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

