/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiActionRunner;

public final class Scrolling {
    public static void scrollToVisible(@Nonnull Robot robot, @Nonnull JComponent c) {
        JComponent root = Scrolling.findClosestValidatingRootAncestor(c);
        while (root != null) {
            Scrolling.scrollToVisible(robot, root, c);
            root = Scrolling.findClosestValidatingRootAncestor(root);
        }
    }

    @Nullable
    private static JComponent findClosestValidatingRootAncestor(@Nonnull JComponent c) {
        Container root = c;
        while (root != null) {
            Container parent = root.getParent();
            if (!((root = parent) instanceof JComponent) || !(root instanceof JViewport) && !(root instanceof JInternalFrame)) continue;
            return root;
        }
        return null;
    }

    private static void scrollToVisible(@Nonnull Robot robot, @Nonnull JComponent container, @Nonnull Component target) {
        Rectangle r = SwingUtilities.convertRectangle(target.getParent(), target.getBounds(), container);
        Scrolling.scrollToVisible(robot, container, Preconditions.checkNotNull(r));
    }

    private static void scrollToVisible(@Nonnull Robot robot, @Nonnull JComponent c, @Nonnull Rectangle rectangle) {
        GuiActionRunner.execute(() -> c.scrollRectToVisible(rectangle));
        robot.waitForIdle();
    }

    private Scrolling() {
    }
}

