/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.ConvertLambdaToClosureIntention;
import org.jetbrains.plugins.groovy.annotator.intentions.ReplaceDotFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.GrDoWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrExpressionList;
import org.jetbrains.plugins.groovy.lang.psi.api.GrInExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrTryResourceList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnAmbiguousClosureContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020'H\u0016J \u0010(\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00072\u0006\u00102\u001a\u000203H\u0002J\u0010\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010B\u001a\u00020A2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010C\u001a\u00020A2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010D\u001a\u00020\u00072\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020KH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre30;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "<init>", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "error", "", "typeArgumentList", "Lcom/intellij/psi/PsiElement;", "msg", "", "visitModifierList", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "visitDoWhileStatement", "statement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrDoWhileStatement;", "visitVariableDeclaration", "variableDeclaration", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "visitExpressionList", "expressionList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrExpressionList;", "visitTryResourceList", "resourceList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrTryResourceList;", "visitBinaryExpression", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;", "visitInExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrInExpression;", "visitInstanceofExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrInstanceOfExpression;", "visitAssignmentExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrAssignmentExpression;", "visitIndexProperty", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;", "visitReferenceExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "highlightIncorrectDot", "wrongDot", "Lcom/intellij/psi/tree/IElementType;", "correctDot", "visitArrayInitializer", "arrayInitializer", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrArrayInitializer;", "visitLambdaExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;", "visitTypeDefinitionBody", "typeDefinitionBody", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinitionBody;", "checkAmbiguousCodeBlockInDefinition", "visitBlockStatement", "blockStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrBlockStatement;", "visitClosure", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "visitParenthesizedExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrParenthesizedExpression;", "visitApplicationStatement", "applicationStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrApplicationStatement;", "followsError", "", "isClosureAmbiguous", "mayBeAnonymousBody", "visitTypeElement", "typeElement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrTypeElement;", "visitCodeReferenceElement", "refElement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrCodeReferenceElement;", "visitTupleAssignmentExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrTupleAssignmentExpression;", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGroovyAnnotatorPre30.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyAnnotatorPre30.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre30\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,278:1\n1#2:279\n13402#3,2:280\n13402#3,2:282\n*S KotlinDebug\n*F\n+ 1 GroovyAnnotatorPre30.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre30\n*L\n260#1:280,2\n266#1:282,2\n*E\n"})
public final class GroovyAnnotatorPre30
extends GroovyElementVisitor {
    @NotNull
    private final AnnotationHolder holder;

    public GroovyAnnotatorPre30(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    private final void error(PsiElement typeArgumentList, @InspectionMessage String msg) {
        this.holder.newAnnotation(HighlightSeverity.ERROR, msg).range(typeArgumentList).create();
    }

    @Override
    public void visitModifierList(@NotNull GrModifierList modifierList) {
        Intrinsics.checkNotNullParameter((Object)modifierList, (String)"modifierList");
        PsiElement psiElement = modifierList.getModifier("default");
        if (psiElement == null) {
            return;
        }
        PsiElement modifier = psiElement;
        String string = GroovyBundle.message("default.modifier.in.old.versions", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.error(modifier, string);
    }

    @Override
    public void visitDoWhileStatement(@NotNull GrDoWhileStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        super.visitDoWhileStatement(statement);
        PsiElement psiElement = statement.getDoKeyword();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getDoKeyword(...)");
        String string = GroovyBundle.message("unsupported.do.while.statement", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.error(psiElement, string);
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        GrExpression initializer;
        Intrinsics.checkNotNullParameter((Object)variableDeclaration, (String)"variableDeclaration");
        super.visitVariableDeclaration(variableDeclaration);
        if (variableDeclaration.getParent() instanceof GrTraditionalForClause) {
            if (variableDeclaration.isTuple()) {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.tuple.declaration.in.for", new Object[0])).create();
            } else if (variableDeclaration.getVariables().length > 1) {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.multiple.variables.in.for", new Object[0])).create();
            }
        } else if (variableDeclaration.isTuple() && (initializer = variableDeclaration.getTupleInitializer()) != null && PsiUtilKt.isApplicationExpression(initializer)) {
            PsiElement psiElement = initializer;
            String string = GroovyBundle.message("unsupported.tuple.application.initializer", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.error(psiElement, string);
        }
    }

    @Override
    public void visitExpressionList(@NotNull GrExpressionList expressionList) {
        Intrinsics.checkNotNullParameter((Object)expressionList, (String)"expressionList");
        super.visitExpressionList(expressionList);
        if (expressionList.getExpressions().size() > 1) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.expression.list.in.for.update", new Object[0])).create();
        }
    }

    @Override
    public void visitTryResourceList(@NotNull GrTryResourceList resourceList) {
        Intrinsics.checkNotNullParameter((Object)resourceList, (String)"resourceList");
        super.visitTryResourceList(resourceList);
        PsiElement psiElement = resourceList.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        String string = GroovyBundle.message("unsupported.resource.list", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.error(psiElement, string);
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryExpression(expression);
        PsiElement psiElement = expression.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOperationToken(...)");
        PsiElement operator = psiElement;
        IElementType iElementType = operator.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType tokenType = iElementType;
        if (tokenType == GroovyElementTypes.T_ID || tokenType == GroovyElementTypes.T_NID) {
            Object[] objectArray = new Object[]{tokenType};
            String string = GroovyBundle.message("operator.is.not.supported.in", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.error(operator, string);
        }
    }

    @Override
    public void visitInExpression(@NotNull GrInExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitInExpression(expression);
        if (GrInExpression.isNegated(expression)) {
            PsiElement psiElement = expression.getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOperationToken(...)");
            String string = GroovyBundle.message("unsupported.negated.in", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.error(psiElement, string);
        }
    }

    @Override
    public void visitInstanceofExpression(@NotNull GrInstanceOfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitInstanceofExpression(expression);
        if (GrInstanceOfExpression.isNegated(expression)) {
            PsiElement psiElement = expression.getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOperationToken(...)");
            String string = GroovyBundle.message("unsupported.negated.instanceof", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.error(psiElement, string);
        }
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitAssignmentExpression(expression);
        PsiElement psiElement = expression.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOperationToken(...)");
        PsiElement operator = psiElement;
        if (operator.getNode().getElementType() == GroovyElementTypes.T_ELVIS_ASSIGN) {
            String string = GroovyBundle.message("unsupported.elvis.assignment", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.error(operator, string);
        }
    }

    @Override
    public void visitIndexProperty(@NotNull GrIndexProperty expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitIndexProperty(expression);
        PsiElement safeAccessToken = expression.getSafeAccessToken();
        if (safeAccessToken != null) {
            String string = GroovyBundle.message("unsupported.safe.index.access", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.error(safeAccessToken, string);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitReferenceExpression(expression);
        IElementType iElementType = GroovyElementTypes.T_METHOD_REFERENCE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"T_METHOD_REFERENCE");
        IElementType iElementType2 = GroovyElementTypes.T_METHOD_CLOSURE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"T_METHOD_CLOSURE");
        this.highlightIncorrectDot(expression, iElementType, iElementType2);
        IElementType iElementType3 = GroovyElementTypes.T_SAFE_CHAIN_DOT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"T_SAFE_CHAIN_DOT");
        IElementType iElementType4 = GroovyElementTypes.T_SAFE_DOT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"T_SAFE_DOT");
        this.highlightIncorrectDot(expression, iElementType3, iElementType4);
    }

    private final void highlightIncorrectDot(GrReferenceExpression expression, IElementType wrongDot, IElementType correctDot) {
        PsiElement psiElement = expression.getDotToken();
        if (psiElement == null) {
            return;
        }
        PsiElement dot = psiElement;
        IElementType iElementType = dot.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType tokenType = iElementType;
        if (Intrinsics.areEqual((Object)tokenType, (Object)wrongDot)) {
            ReplaceDotFix fix = new ReplaceDotFix(tokenType, correctDot);
            Object[] objectArray = new Object[]{tokenType};
            String string = GroovyBundle.message("operator.is.not.supported.in", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)expression.getProject()).createProblemDescriptor(dot, dot, message, ProblemHighlightType.ERROR, true, new LocalQuickFix[0]);
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
            ProblemDescriptor descriptor = problemDescriptor;
            this.holder.newAnnotation(HighlightSeverity.ERROR, message).range(dot).newLocalQuickFix((LocalQuickFix)fix, descriptor).registerFix().create();
        }
    }

    @Override
    public void visitArrayInitializer(@NotNull GrArrayInitializer arrayInitializer) {
        Intrinsics.checkNotNullParameter((Object)arrayInitializer, (String)"arrayInitializer");
        super.visitArrayInitializer(arrayInitializer);
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.array.initializers", new Object[0])).create();
    }

    @Override
    public void visitLambdaExpression(@NotNull GrLambdaExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitLambdaExpression(expression);
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.lambda", new Object[0])).range(expression.getArrow()).withFix((CommonIntentionAction)new ConvertLambdaToClosureIntention(expression)).create();
    }

    @Override
    public void visitTypeDefinitionBody(@NotNull GrTypeDefinitionBody typeDefinitionBody) {
        Intrinsics.checkNotNullParameter((Object)typeDefinitionBody, (String)"typeDefinitionBody");
        super.visitTypeDefinitionBody(typeDefinitionBody);
        this.checkAmbiguousCodeBlockInDefinition(typeDefinitionBody);
    }

    private final void checkAmbiguousCodeBlockInDefinition(GrTypeDefinitionBody typeDefinitionBody) {
        PsiElement psiElement = typeDefinitionBody.getParent();
        GrAnonymousClassDefinition grAnonymousClassDefinition = psiElement instanceof GrAnonymousClassDefinition ? (GrAnonymousClassDefinition)psiElement : null;
        if (grAnonymousClassDefinition == null) {
            return;
        }
        GrAnonymousClassDefinition parent = grAnonymousClassDefinition;
        PsiElement prev = typeDefinitionBody.getPrevSibling();
        if (!PsiUtil.isLineFeed(prev)) {
            return;
        }
        PsiElement psiElement2 = parent.getParent();
        GrNewExpression grNewExpression = psiElement2 instanceof GrNewExpression ? (GrNewExpression)psiElement2 : null;
        if (grNewExpression == null) {
            return;
        }
        GrNewExpression newExpression = grNewExpression;
        GrStatementOwner statementOwner = (GrStatementOwner)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrStatementOwner.class);
        GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrParenthesizedExpression.class);
        if (parenthesizedExpression != null && PsiTreeUtil.isAncestor((PsiElement)statementOwner, (PsiElement)parenthesizedExpression, (boolean)true)) {
            return;
        }
        GrArgumentList argumentList = (GrArgumentList)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrArgumentList.class);
        if (argumentList != null && !(argumentList instanceof GrCommandArgumentList) && PsiTreeUtil.isAncestor((PsiElement)statementOwner, (PsiElement)argumentList, (boolean)true)) {
            return;
        }
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("ambiguous.code.block", new Object[0])).create();
    }

    @Override
    public void visitBlockStatement(@NotNull GrBlockStatement blockStatement) {
        Intrinsics.checkNotNullParameter((Object)blockStatement, (String)"blockStatement");
        super.visitBlockStatement(blockStatement);
        if (blockStatement.getParent() instanceof GrStatementOwner) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("ambiguous.code.block", new Object[0])).create();
        }
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        super.visitClosure(closure);
        if (!closure.hasParametersSection() && !this.followsError(closure) && this.isClosureAmbiguous(closure)) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("ambiguous.code.block", new Object[0])).create();
        }
    }

    @Override
    public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitParenthesizedExpression(expression);
        GrExpression operand = expression.getOperand();
        if (operand instanceof GrCall && PsiUtilKt.isApplicationExpression(operand)) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("call.without.parentheses.are.supported.since.groovy.3", new Object[0])).range((PsiElement)operand).create();
        }
    }

    @Override
    public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
        PsiElement badNewline;
        Intrinsics.checkNotNullParameter((Object)applicationStatement, (String)"applicationStatement");
        super.visitApplicationStatement(applicationStatement);
        GrExpression grExpression = applicationStatement.getInvokedExpression();
        Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"getInvokedExpression(...)");
        GrExpression invoked = grExpression;
        PsiElement psiElement = invoked.getFirstChild();
        if (psiElement != null && (psiElement = psiElement.getNextSibling()) != null) {
            PsiElement psiElement2;
            PsiElement it = psiElement2 = psiElement;
            boolean bl = false;
            v2 = PsiUtilKt.isNewLine(it) ? psiElement2 : null;
        } else {
            v2 = badNewline = null;
        }
        if (badNewline != null) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("newlines.here.are.available.since.groovy.3", new Object[0])).range(badNewline).create();
        }
    }

    private final boolean followsError(GrClosableBlock closure) {
        PsiElement prev = closure.getPrevSibling();
        return prev instanceof PsiErrorElement || prev instanceof PsiWhiteSpace && ((PsiWhiteSpace)prev).getPrevSibling() instanceof PsiErrorElement;
    }

    private final boolean isClosureAmbiguous(GrClosableBlock closure) {
        if (this.mayBeAnonymousBody(closure)) {
            return true;
        }
        PsiElement place = closure;
        PsiElement parent;
        while ((parent = place.getParent()) != null && !(parent instanceof GrUnAmbiguousClosureContainer)) {
            if (PsiUtil.isExpressionStatement(place)) {
                return true;
            }
            if (parent.getFirstChild() != place) {
                return false;
            }
            place = parent;
        }
        return false;
    }

    private final boolean mayBeAnonymousBody(GrClosableBlock closure) {
        PsiElement psiElement = closure.getParent();
        GrMethodCallExpression grMethodCallExpression = psiElement instanceof GrMethodCallExpression ? (GrMethodCallExpression)psiElement : null;
        if (grMethodCallExpression == null) {
            return false;
        }
        GrMethodCallExpression parent = grMethodCallExpression;
        if (!(parent.getInvokedExpression() instanceof GrNewExpression)) {
            return false;
        }
        GrClosableBlock[] grClosableBlockArray = parent.getClosureArguments();
        if (!ArrayUtil.contains((Object)closure, (Object[])Arrays.copyOf(grClosableBlockArray, grClosableBlockArray.length))) {
            return false;
        }
        for (PsiElement run = parent.getParent(); run != null; run = run.getParent()) {
            if (run instanceof GrParenthesizedExpression) {
                return false;
            }
            if (!(run instanceof GrReturnStatement) && !(run instanceof GrAssertStatement) && !(run instanceof GrThrowStatement) && !(run instanceof GrCommandArgumentList)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitTypeElement(@NotNull GrTypeElement typeElement) {
        Intrinsics.checkNotNullParameter((Object)typeElement, (String)"typeElement");
        GrAnnotation[] grAnnotationArray = typeElement.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)grAnnotationArray, (String)"getAnnotations(...)");
        Object[] $this$forEach$iv = grAnnotationArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GrAnnotation it = (GrAnnotation)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            PsiElement psiElement = it;
            String string = GroovyBundle.message("unsupported.type.annotations", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.error(psiElement, string);
        }
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        Intrinsics.checkNotNullParameter((Object)refElement, (String)"refElement");
        GrAnnotation[] grAnnotationArray = refElement.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)grAnnotationArray, (String)"getAnnotations(...)");
        Object[] $this$forEach$iv = grAnnotationArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GrAnnotation it = (GrAnnotation)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            PsiElement psiElement = it;
            String string = GroovyBundle.message("unsupported.type.annotations", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.error(psiElement, string);
        }
    }

    @Override
    public void visitTupleAssignmentExpression(@NotNull GrTupleAssignmentExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        GrExpression rValue = expression.getRValue();
        if (rValue != null && PsiUtilKt.isApplicationExpression(rValue)) {
            PsiElement psiElement = rValue;
            String string = GroovyBundle.message("unsupported.tuple.application.initializer", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.error(psiElement, string);
        }
    }
}

