/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public final class TypeArguments {
    private static final Type OBJECT_TYPE = Object.class;
    private static final Type[] NO_TYPES = new Type[0];

    private TypeArguments() {
    }

    public static Type[] get(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] argumentTypes = ((ParameterizedType)type).getActualTypeArguments();
            for (int i = 0; i < argumentTypes.length; ++i) {
                argumentTypes[i] = TypeArguments.expand(argumentTypes[i]);
            }
            return argumentTypes;
        }
        if (type instanceof GenericArrayType) {
            return new Type[]{TypeArguments.expand(((GenericArrayType)type).getGenericComponentType())};
        }
        return NO_TYPES;
    }

    public static Type get(Type type, int index) {
        if (type instanceof ParameterizedType) {
            return TypeArguments.expand(((ParameterizedType)type).getActualTypeArguments()[index]);
        }
        if (type instanceof GenericArrayType) {
            if (0 == index) {
                return TypeArguments.expand(((GenericArrayType)type).getGenericComponentType());
            }
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return OBJECT_TYPE;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Class<?> rawComponentType = TypeArguments.getRawType(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(rawComponentType, 0).getClass();
        }
        return Object.class;
    }

    private static Type expand(Type type) {
        if (type instanceof WildcardType) {
            return ((WildcardType)type).getUpperBounds()[0];
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)type).getBounds()[0];
        }
        return type;
    }
}

