/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.TargetVM;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsyncUtils {
    public static Throwable unwrap(Throwable throwable) {
        return throwable instanceof CompletionException ? throwable.getCause() : throwable;
    }

    public static <T> CompletableFuture<T> toCompletableFuture(ThrowingSupplier<T> supplier) {
        try {
            return CompletableFuture.completedFuture(supplier.get());
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Exception;
    }

    public static class JDWPCompletableFuture<T>
    extends CompletableFuture<T> {
        @Override
        public <U> CompletableFuture<U> newIncompleteFuture() {
            return new JDWPCompletableFuture<T>();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            JDWPCompletableFuture.assertNotReaderThread();
            return super.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            JDWPCompletableFuture.assertNotReaderThread();
            return super.get(timeout, unit);
        }

        private static void assertNotReaderThread() {
            if (Thread.currentThread() instanceof TargetVM.ReaderThread) {
                throw new IllegalStateException("Should not happen in JDWP reader thread");
            }
        }
    }
}

