/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.gradle.toolingExtension.GradleToolingExtensionClass;
import com.intellij.gradle.toolingExtension.impl.GradleToolingExtensionImplClass;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.platform.externalSystem.rt.ExternalSystemRtClass;
import groovy.lang.MissingMethodException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.invocation.Gradle;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleGroovyUtil;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;
import org.jetbrains.plugins.gradle.tooling.proxy.Main;
import org.slf4j.LoggerFactory;
import org.slf4j.jul.JDK14LoggerFactory;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0018\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\u001a \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u0004\u001a\u0006\u0010\u0014\u001a\u00020\u0010\u001a&\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005\u001a&\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005\u001a:\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0005\u001a\u0006\u0010\u001f\u001a\u00020\u0010\u001a(\u0010 \u001a\u00020\u00102\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$\u001a\u0006\u0010'\u001a\u00020\u0010\u001a\u0006\u0010(\u001a\u00020\u0005\u001a\"\u0010)\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050+\u001a\u0006\u00101\u001a\u00020\u0005\u001a\u0006\u00102\u001a\u00020\u0005\u001an\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\b\u00109\u001a\u0004\u0018\u00010\u00052\b\u0010:\u001a\u0004\u0018\u00010\u00052\b\u0010;\u001a\u0004\u0018\u00010\u00052\b\u0010<\u001a\u0004\u0018\u00010\u00052\u0006\u0010=\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u0012\u001a\u001c\u0010@\u001a\u00020\u00052\u0012\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050+0+H\u0002\u001a!\u0010B\u001a\u00020\u00052\u0012\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050D\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010E\u001a\u0016\u0010B\u001a\u00020\u00052\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00050+H\u0007\u001a&\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0014\b\u0002\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050IH\u0002\u001a2\u0010F\u001a\u00020\u00052\n\u0010J\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010G\u001a\u00020\u00052\u0014\b\u0002\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050IH\u0007\u001a\u0016\u0010K\u001a\u00020\u00102\u0006\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u00020\u0005\u001a\u0018\u0010N\u001a\u00020\u00052\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u0004\u001a\u0018\u0010O\u001a\u00020\u00122\u0006\u0010P\u001a\u00020\u00102\u0006\u0010M\u001a\u00020QH\u0002\u001a \u0010R\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0SH\u0007\u001a\u0016\u0010T\u001a\u0004\u0018\u00010\u00052\n\u0010U\u001a\u0006\u0012\u0002\b\u00030\fH\u0002\u001a\u0010\u0010V\u001a\u00020\u00122\u0006\u0010W\u001a\u00020\u0005H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "EXCLUDED_JAR_SUFFIXES", "", "", "MAIN_INIT_SCRIPT_NAME", "MAPPER_INIT_SCRIPT_NAME", "WRAPPER_INIT_SCRIPT_NAME", "TEST_INIT_SCRIPT_NAME", "IDEA_PLUGIN_CONFIGURATOR_SCRIPT_NAME", "GRADLE_TOOLING_EXTENSION_CLASSES", "Ljava/lang/Class;", "", "GRADLE_TOOLING_EXTENSION_PROXY_CLASSES", "createMainInitScript", "Ljava/nio/file/Path;", "isBuildSrcProject", "", "toolingExtensionClasses", "createIdeaPluginConfiguratorInitScript", "loadDownloadArtifactInitScript", "dependencyNotation", "taskName", "downloadTarget", "externalProjectPath", "loadLegacyDownloadArtifactInitScript", "loadTaskInitScript", "projectPath", "taskType", "taskConfiguration", "createTargetPathMapperInitScript", "createWrapperInitScript", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "jarFile", "Ljava/io/File;", "scriptFile", "fileWithPathToProperties", "createTestInitScript", "loadJvmDebugInitScript", "loadJvmOptionsInitScript", "tasks", "", "jvmArgs", "JUNIT_3_COMPARISON_FAILURE", "JUNIT_4_COMPARISON_FAILURE", "ASSERTION_FAILED_ERROR", "FILE_COMPARISON_FAILURE", "loadIjTestLoggerInitScript", "loadFileComparisonTestLoggerInitScript", "loadApplicationInitScript", "gradlePath", "runAppTaskName", "mainClassToRun", "javaExePath", "sourceSetName", "params", "definitions", "intelliJRtPath", "workingDirectory", "useManifestJar", "useArgsFile", "useClasspathFile", "loadEnhanceGradleDaemonClasspathInit", "classesNames", "joinInitScripts", "initScripts", "", "([Ljava/lang/String;)Ljava/lang/String;", "loadInitScript", "resourcePath", "parameters", "", "aClass", "createInitScript", "prefix", "content", "loadToolingExtensionProvidingInitScript", "isContentEquals", "path", "", "getToolingExtensionsJarPaths", "", "getToolingExtensionsJarPath", "toolingExtensionClass", "isExcluded", "jarPath", "intellij.gradle"})
@JvmName(name="GradleInitScriptUtil")
@SourceDebugExtension(value={"SMAP\nGradleInitScriptUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleInitScriptUtil.kt\norg/jetbrains/plugins/gradle/service/execution/GradleInitScriptUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,342:1\n1619#2:343\n1863#2:344\n1864#2:346\n1620#2:347\n1755#2,3:348\n1#3:345\n*S KotlinDebug\n*F\n+ 1 GradleInitScriptUtil.kt\norg/jetbrains/plugins/gradle/service/execution/GradleInitScriptUtil\n*L\n317#1:343\n317#1:344\n317#1:346\n317#1:347\n340#1:348,3\n317#1:345\n*E\n"})
public final class GradleInitScriptUtil {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Set<String> EXCLUDED_JAR_SUFFIXES;
    @NotNull
    public static final String MAIN_INIT_SCRIPT_NAME = "ijInit";
    @NotNull
    public static final String MAPPER_INIT_SCRIPT_NAME = "ijMapper";
    @NotNull
    public static final String WRAPPER_INIT_SCRIPT_NAME = "ijWrapper";
    @NotNull
    public static final String TEST_INIT_SCRIPT_NAME = "ijTestInit";
    @NotNull
    public static final String IDEA_PLUGIN_CONFIGURATOR_SCRIPT_NAME = "ijIdeaPluginConfigurator";
    @JvmField
    @NotNull
    public static final Set<Class<? extends Object>> GRADLE_TOOLING_EXTENSION_CLASSES;
    @JvmField
    @NotNull
    public static final Set<Class<? extends Object>> GRADLE_TOOLING_EXTENSION_PROXY_CLASSES;
    @NotNull
    private static final List<String> JUNIT_3_COMPARISON_FAILURE;
    @NotNull
    private static final List<String> JUNIT_4_COMPARISON_FAILURE;
    @NotNull
    private static final List<String> ASSERTION_FAILED_ERROR;
    @NotNull
    private static final List<String> FILE_COMPARISON_FAILURE;

    @NotNull
    public static final Path createMainInitScript(boolean isBuildSrcProject, @NotNull Set<? extends Class<?>> toolingExtensionClasses) {
        Intrinsics.checkNotNullParameter(toolingExtensionClasses, (String)"toolingExtensionClasses");
        String[] stringArray = new String[]{GradleInitScriptUtil.loadToolingExtensionProvidingInitScript(SetsKt.plus(GRADLE_TOOLING_EXTENSION_CLASSES, (Iterable)toolingExtensionClasses)), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/RegistryProcessor.gradle", null, 2, null), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/JetGradlePlugin.gradle", null, 2, null), GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/Init.gradle", MapsKt.mapOf((Pair)TuplesKt.to((Object)"IS_BUILD_SCR_PROJECT", (Object)String.valueOf(isBuildSrcProject))))};
        String initScript = GradleInitScriptUtil.joinInitScripts(stringArray);
        return GradleInitScriptUtil.createInitScript(MAIN_INIT_SCRIPT_NAME, initScript);
    }

    @NotNull
    public static final Path createIdeaPluginConfiguratorInitScript() {
        String[] stringArray = new String[]{GradleInitScriptUtil.loadToolingExtensionProvidingInitScript(GRADLE_TOOLING_EXTENSION_CLASSES), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/IdeaPluginConfigurator.gradle", null, 2, null)};
        String initScript = GradleInitScriptUtil.joinInitScripts(stringArray);
        return GradleInitScriptUtil.createInitScript(IDEA_PLUGIN_CONFIGURATOR_SCRIPT_NAME, initScript);
    }

    @NotNull
    public static final String loadDownloadArtifactInitScript(@NotNull String dependencyNotation, @NotNull String taskName, @NotNull Path downloadTarget, @NotNull String externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)dependencyNotation, (String)"dependencyNotation");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)downloadTarget, (String)"downloadTarget");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DEPENDENCY_NOTATION", (Object)GradleGroovyUtil.toGroovyStringLiteral(dependencyNotation)), TuplesKt.to((Object)"TARGET_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(NioPathUtil.toCanonicalPath((Path)downloadTarget))), TuplesKt.to((Object)"GRADLE_TASK_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral(taskName)), TuplesKt.to((Object)"GRADLE_PROJECT_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(externalProjectPath2))};
        return GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/downloadArtifact.gradle", MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public static final String loadLegacyDownloadArtifactInitScript(@NotNull String dependencyNotation, @NotNull String taskName, @NotNull Path downloadTarget, @NotNull String externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)dependencyNotation, (String)"dependencyNotation");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)downloadTarget, (String)"downloadTarget");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DEPENDENCY_NOTATION", (Object)GradleGroovyUtil.toGroovyStringLiteral(dependencyNotation)), TuplesKt.to((Object)"TARGET_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(NioPathUtil.toCanonicalPath((Path)downloadTarget))), TuplesKt.to((Object)"GRADLE_TASK_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral(taskName)), TuplesKt.to((Object)"GRADLE_PROJECT_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(externalProjectPath2))};
        return GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/legacyDownloadArtifact.gradle", MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public static final String loadTaskInitScript(@NotNull String projectPath, @NotNull String taskName, @NotNull String taskType, @NotNull Set<? extends Class<?>> toolingExtensionClasses, @Nullable String taskConfiguration) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)taskType, (String)"taskType");
        Intrinsics.checkNotNullParameter(toolingExtensionClasses, (String)"toolingExtensionClasses");
        String[] stringArray = new String[2];
        stringArray[0] = GradleInitScriptUtil.loadToolingExtensionProvidingInitScript(SetsKt.plus(GRADLE_TOOLING_EXTENSION_CLASSES, (Iterable)toolingExtensionClasses));
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"PROJECT_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(projectPath));
        pairArray[1] = TuplesKt.to((Object)"TASK_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral(taskName));
        pairArray[2] = TuplesKt.to((Object)"TASK_TYPE", (Object)taskType);
        String string = taskConfiguration;
        if (string == null) {
            string = "";
        }
        pairArray[3] = TuplesKt.to((Object)"TASK_CONFIGURATION", (Object)string);
        stringArray[1] = GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/TaskInit.gradle", MapsKt.mapOf((Pair[])pairArray));
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    @NotNull
    public static final Path createTargetPathMapperInitScript() {
        String initScript = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/MapperInit.gradle", null, 2, null);
        return GradleInitScriptUtil.createInitScript(MAPPER_INIT_SCRIPT_NAME, initScript);
    }

    @NotNull
    public static final Path createWrapperInitScript(@Nullable GradleVersion gradleVersion, @NotNull File jarFile, @NotNull File scriptFile, @NotNull File fileWithPathToProperties) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)fileWithPathToProperties, (String)"fileWithPathToProperties");
        Pair[] pairArray = new Pair[4];
        Object object = gradleVersion;
        if (object == null || (object = object.getVersion()) == null || (object = GradleGroovyUtil.toGroovyStringLiteral((String)object)) == null) {
            object = "null";
        }
        pairArray[0] = TuplesKt.to((Object)"GRADLE_VERSION", (Object)object);
        String string = jarFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        pairArray[1] = TuplesKt.to((Object)"JAR_FILE", (Object)GradleGroovyUtil.toGroovyStringLiteral(string));
        String string2 = scriptFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        pairArray[2] = TuplesKt.to((Object)"SCRIPT_FILE", (Object)GradleGroovyUtil.toGroovyStringLiteral(string2));
        String string3 = fileWithPathToProperties.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        pairArray[3] = TuplesKt.to((Object)"FILE_WITH_PATH_TO_PROPERTIES", (Object)GradleGroovyUtil.toGroovyStringLiteral(string3));
        String initScript = GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/WrapperInit.gradle", MapsKt.mapOf((Pair[])pairArray));
        return GradleInitScriptUtil.createInitScript(WRAPPER_INIT_SCRIPT_NAME, initScript);
    }

    @NotNull
    public static final Path createTestInitScript() {
        String[] stringArray = new String[]{GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/TestInit.gradle", null, 2, null)};
        String initScript = GradleInitScriptUtil.joinInitScripts(stringArray);
        return GradleInitScriptUtil.createInitScript(TEST_INIT_SCRIPT_NAME, initScript);
    }

    @NotNull
    public static final String loadJvmDebugInitScript() {
        String[] stringArray = new String[]{GradleInitScriptUtil.loadToolingExtensionProvidingInitScript(GRADLE_TOOLING_EXTENSION_CLASSES), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/JvmDebugInit.gradle", null, 2, null)};
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    @NotNull
    public static final String loadJvmOptionsInitScript(@NotNull List<String> tasks2, @NotNull List<String> jvmArgs) {
        Intrinsics.checkNotNullParameter(tasks2, (String)"tasks");
        Intrinsics.checkNotNullParameter(jvmArgs, (String)"jvmArgs");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"TASKS", (Object)GradleGroovyUtil.toGroovyListLiteral((Collection)tasks2, GradleInitScriptUtil::loadJvmOptionsInitScript$lambda$0)), TuplesKt.to((Object)"JVM_ARGS", (Object)GradleGroovyUtil.toGroovyListLiteral((Collection)jvmArgs, GradleInitScriptUtil::loadJvmOptionsInitScript$lambda$1))};
        return GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/JvmOptionsInit.gradle", MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public static final String loadIjTestLoggerInitScript() {
        String[] stringArray = new String[4];
        stringArray[0] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/TestEventLogger.gradle", null, 2, null);
        stringArray[1] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/IjTestEventLogger.gradle", null, 2, null);
        stringArray[2] = GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/IjTestEventLoggerInit.gradle", null, 2, null);
        Object[] objectArray = new List[]{JUNIT_3_COMPARISON_FAILURE, JUNIT_4_COMPARISON_FAILURE, ASSERTION_FAILED_ERROR, FILE_COMPARISON_FAILURE};
        stringArray[3] = GradleInitScriptUtil.loadEnhanceGradleDaemonClasspathInit(CollectionsKt.listOf((Object[])objectArray));
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    @NotNull
    public static final String loadFileComparisonTestLoggerInitScript() {
        String[] stringArray = new String[]{GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/TestEventLogger.gradle", null, 2, null), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/FileComparisonTestEventLogger.gradle", null, 2, null), GradleInitScriptUtil.loadInitScript$default("/org/jetbrains/plugins/gradle/tooling/internal/init/FileComparisonTestEventLoggerInit.gradle", null, 2, null), GradleInitScriptUtil.loadEnhanceGradleDaemonClasspathInit(CollectionsKt.listOf(FILE_COMPARISON_FAILURE))};
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    @NotNull
    public static final String loadApplicationInitScript(@NotNull String gradlePath2, @NotNull String runAppTaskName, @NotNull String mainClassToRun, @NotNull String javaExePath, @NotNull String sourceSetName, @Nullable String params, @Nullable String definitions, @Nullable String intelliJRtPath, @Nullable String workingDirectory, boolean useManifestJar, boolean useArgsFile, boolean useClasspathFile) {
        Intrinsics.checkNotNullParameter((Object)gradlePath2, (String)"gradlePath");
        Intrinsics.checkNotNullParameter((Object)runAppTaskName, (String)"runAppTaskName");
        Intrinsics.checkNotNullParameter((Object)mainClassToRun, (String)"mainClassToRun");
        Intrinsics.checkNotNullParameter((Object)javaExePath, (String)"javaExePath");
        Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
        String[] stringArray = new String[2];
        stringArray[0] = GradleInitScriptUtil.loadToolingExtensionProvidingInitScript(GRADLE_TOOLING_EXTENSION_CLASSES);
        Pair[] pairArray = new Pair[12];
        pairArray[0] = TuplesKt.to((Object)"GRADLE_PATH", (Object)GradleGroovyUtil.toGroovyStringLiteral(gradlePath2));
        pairArray[1] = TuplesKt.to((Object)"RUN_APP_TASK_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral(runAppTaskName));
        pairArray[2] = TuplesKt.to((Object)"MAIN_CLASS_TO_RUN", (Object)GradleGroovyUtil.toGroovyStringLiteral(mainClassToRun));
        pairArray[3] = TuplesKt.to((Object)"JAVA_EXE_PATH", (Object)("mapPath(" + GradleGroovyUtil.toGroovyStringLiteral(javaExePath) + ")"));
        pairArray[4] = TuplesKt.to((Object)"SOURCE_SET_NAME", (Object)GradleGroovyUtil.toGroovyStringLiteral(sourceSetName));
        CharSequence charSequence = intelliJRtPath;
        pairArray[5] = TuplesKt.to((Object)"INTELLIJ_RT_PATH", (Object)(charSequence == null || charSequence.length() == 0 ? "null" : "mapPath(" + GradleGroovyUtil.toGroovyStringLiteral(intelliJRtPath) + ")"));
        charSequence = workingDirectory;
        pairArray[6] = TuplesKt.to((Object)"WORKING_DIRECTORY", (Object)(charSequence == null || charSequence.length() == 0 ? "null" : "mapPath(" + GradleGroovyUtil.toGroovyStringLiteral(workingDirectory) + ")"));
        charSequence = params;
        pairArray[7] = TuplesKt.to((Object)"PARAMS", (Object)(charSequence == null || charSequence.length() == 0 ? "// NO PARAMS" : params));
        charSequence = definitions;
        pairArray[8] = TuplesKt.to((Object)"DEFS", (Object)(charSequence == null || charSequence.length() == 0 ? "// NO DEFS" : definitions));
        pairArray[9] = TuplesKt.to((Object)"USE_MANIFEST_JAR", (Object)String.valueOf(useManifestJar));
        pairArray[10] = TuplesKt.to((Object)"USE_ARGS_FILE", (Object)String.valueOf(useArgsFile));
        pairArray[11] = TuplesKt.to((Object)"USE_CLASSPATH_FILE", (Object)String.valueOf(useClasspathFile));
        stringArray[1] = GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/ApplicationTaskInitScript.gradle", MapsKt.mapOf((Pair[])pairArray));
        return GradleInitScriptUtil.joinInitScripts(stringArray);
    }

    private static final String loadEnhanceGradleDaemonClasspathInit(List<? extends List<String>> classesNames) {
        return GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/EnhanceGradleDaemonClasspathInit.gradle", MapsKt.mapOf((Pair)TuplesKt.to((Object)"CLASS_NAMES", (Object)GradleGroovyUtil.toGroovyListLiteral((Collection)classesNames, GradleInitScriptUtil::loadEnhanceGradleDaemonClasspathInit$lambda$3))));
    }

    @ApiStatus.Experimental
    @NotNull
    public static final String joinInitScripts(String ... initScripts) {
        Intrinsics.checkNotNullParameter((Object)initScripts, (String)"initScripts");
        return GradleInitScriptUtil.joinInitScripts(ArraysKt.asList((Object[])initScripts));
    }

    @ApiStatus.Experimental
    @NotNull
    public static final String joinInitScripts(@NotNull List<String> initScripts) {
        Intrinsics.checkNotNullParameter(initScripts, (String)"initScripts");
        Iterable iterable = initScripts;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    private static final String loadInitScript(String resourcePath, Map<String, String> parameters) {
        return GradleInitScriptUtil.loadInitScript(Init.class, resourcePath, parameters);
    }

    static /* synthetic */ String loadInitScript$default(String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return GradleInitScriptUtil.loadInitScript(string, map);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final String loadInitScript(@NotNull Class<?> aClass, @NotNull String resourcePath, @NotNull Map<String, String> parameters) {
        Iterator<Map.Entry<String, String>> iterator;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        URL resource = aClass.getResource(resourcePath);
        if (resource == null) {
            throw new IllegalArgumentException("Cannot find init file " + resourcePath);
        }
        try {
            iterator = resource;
            Charset object = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)((Object)iterator));
            iterator = new String(byArray, object);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Cannot read init file " + resourcePath, iOException);
        }
        Object script = iterator;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String replacement = Matcher.quoteReplacement(value);
            CharSequence charSequence = (CharSequence)script;
            Regex regex = new Regex(key);
            Intrinsics.checkNotNull((Object)replacement);
            String string = replacement;
            script = regex.replaceFirst(charSequence, string);
        }
        return script;
    }

    public static /* synthetic */ String loadInitScript$default(Class clazz, String string, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return GradleInitScriptUtil.loadInitScript(clazz, string, map);
    }

    @NotNull
    public static final Path createInitScript(@NotNull String prefix, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String string = FileUtil.sanitizeFileName((String)prefix);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeFileName(...)");
        String sanitizedPrefix = string;
        byte[] contentBytes = StringsKt.encodeToByteArray((String)content);
        Path tempDirectory = Path.of(FileUtil.getTempDirectory(), new String[0]);
        Intrinsics.checkNotNull((Object)tempDirectory);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(tempDirectory, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        int suffix = 0;
        while (true) {
            String candidateName = sanitizedPrefix + ++suffix + ".gradle";
            Path candidate = tempDirectory.resolve(candidateName);
            try {
                Intrinsics.checkNotNull((Object)candidate);
                FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(candidate, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createFile(...)");
                OpenOption[] openOptionArray = new OpenOption[]{};
                Files.write(candidate, contentBytes, Arrays.copyOf(openOptionArray, openOptionArray.length));
                candidate.toFile().deleteOnExit();
                return candidate;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                Intrinsics.checkNotNull((Object)candidate);
                if (!GradleInitScriptUtil.isContentEquals(candidate, contentBytes)) continue;
                return candidate;
            }
            break;
        }
    }

    @NotNull
    public static final String loadToolingExtensionProvidingInitScript(@NotNull Set<? extends Class<?>> toolingExtensionClasses) {
        Intrinsics.checkNotNullParameter(toolingExtensionClasses, (String)"toolingExtensionClasses");
        Set<String> tapiClasspath = GradleInitScriptUtil.getToolingExtensionsJarPaths((Iterable)toolingExtensionClasses);
        return GradleInitScriptUtil.loadInitScript("/org/jetbrains/plugins/gradle/tooling/internal/init/ClassPathExtensionInitScript.gradle", MapsKt.mapOf((Pair)TuplesKt.to((Object)"EXTENSIONS_JARS_PATH", (Object)GradleGroovyUtil.toGroovyListLiteral((Collection)tapiClasspath, GradleInitScriptUtil::loadToolingExtensionProvidingInitScript$lambda$4))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isContentEquals(Path path, byte[] content) {
        if ((long)content.length != Files.size(path)) return false;
        byte[] byArray = Files.readAllBytes(path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        if (!Arrays.equals(content, byArray)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final Set<String> getToolingExtensionsJarPaths(@NotNull Iterable<? extends Class<?>> toolingExtensionClasses) {
        void var2_2;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(toolingExtensionClasses, (String)"toolingExtensionClasses");
        Iterable<? extends Class<?>> iterable = toolingExtensionClasses;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Class p0 = (Class)element$iv;
            boolean bl2 = false;
            if (GradleInitScriptUtil.getToolingExtensionsJarPath(p0) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var2_2;
    }

    private static final String getToolingExtensionsJarPath(Class<?> toolingExtensionClass) {
        String string = PathManager.getJarPathForClass(toolingExtensionClass);
        if (string == null) {
            return null;
        }
        String path = string;
        if (Intrinsics.areEqual((Object)FileUtilRt.getNameWithoutExtension((String)path), (Object)("gradle-api-" + GradleVersion.current().getBaseVersion()))) {
            LOG.warn("The gradle api jar shouldn't be added to the gradle daemon classpath: {" + toolingExtensionClass + "," + path + "}");
            return null;
        }
        if (GradleInitScriptUtil.isExcluded(path)) {
            String message = "Attempting to pass an excluded IDEA component path [" + path + "] into Gradle Daemon for class [" + toolingExtensionClass + "]";
            if (ApplicationManagerEx.isInIntegrationTest()) {
                throw new IllegalArgumentException(message);
            }
            LOG.warn(message);
        }
        return FileUtil.toCanonicalPath((String)path);
    }

    private static final boolean isExcluded(String jarPath) {
        boolean bl;
        block3: {
            String string = FileUtil.normalize((String)jarPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalize(...)");
            String normalizedJarPath = string;
            Iterable $this$any$iv = EXCLUDED_JAR_SUFFIXES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String suffix = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)normalizedJarPath, (String)suffix, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String loadJvmOptionsInitScript$lambda$0(String $this$toGroovyListLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toGroovyListLiteral, (String)"$this$toGroovyListLiteral");
        return GradleGroovyUtil.toGroovyStringLiteral($this$toGroovyListLiteral);
    }

    private static final String loadJvmOptionsInitScript$lambda$1(String $this$toGroovyListLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toGroovyListLiteral, (String)"$this$toGroovyListLiteral");
        return GradleGroovyUtil.toGroovyStringLiteral($this$toGroovyListLiteral);
    }

    private static final String loadEnhanceGradleDaemonClasspathInit$lambda$3$lambda$2(String $this$toGroovyListLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toGroovyListLiteral, (String)"$this$toGroovyListLiteral");
        return GradleGroovyUtil.toGroovyStringLiteral($this$toGroovyListLiteral);
    }

    private static final String loadEnhanceGradleDaemonClasspathInit$lambda$3(List $this$toGroovyListLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toGroovyListLiteral, (String)"$this$toGroovyListLiteral");
        return GradleGroovyUtil.toGroovyListLiteral($this$toGroovyListLiteral, GradleInitScriptUtil::loadEnhanceGradleDaemonClasspathInit$lambda$3$lambda$2);
    }

    private static final String loadToolingExtensionProvidingInitScript$lambda$4(String $this$toGroovyListLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toGroovyListLiteral, (String)"$this$toGroovyListLiteral");
        return "mapPath(" + GradleGroovyUtil.toGroovyStringLiteral($this$toGroovyListLiteral) + ")";
    }

    static {
        Logger logger = Logger.getInstance((String)"org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"lib/app.jar", "lib/app-client.jar", "lib/lib-client.jar"};
        EXCLUDED_JAR_SUFFIXES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Class[]{SystemInfoRt.class, ExternalSystemRtClass.class, GradleToolingExtensionClass.class, GradleToolingExtensionImplClass.class};
        GRADLE_TOOLING_EXTENSION_CLASSES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Class[]{KotlinVersion.class, Gradle.class, LoggerFactory.class, JDK14LoggerFactory.class, Main.class, MissingMethodException.class};
        GRADLE_TOOLING_EXTENSION_PROXY_CLASSES = SetsKt.plus(GRADLE_TOOLING_EXTENSION_CLASSES, (Iterable)SetsKt.setOf((Object[])objectArray));
        JUNIT_3_COMPARISON_FAILURE = CollectionsKt.listOf((Object)"junit.framework.ComparisonFailure");
        JUNIT_4_COMPARISON_FAILURE = CollectionsKt.listOf((Object)"org.junit.ComparisonFailure");
        ASSERTION_FAILED_ERROR = CollectionsKt.listOf((Object)"org.opentest4j.AssertionFailedError");
        objectArray = new String[]{"com.intellij.rt.execution.junit.FileComparisonFailure", "junit.framework.ComparisonFailure"};
        FILE_COMPARISON_FAILURE = CollectionsKt.listOf((Object[])objectArray);
    }
}

