/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.wsl;

import com.intellij.build.issue.BuildIssue;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.util.PathMapper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.IncorrectGradleJdkIssue;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionAware;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.execution.GradleServerConfigurationProvider;
import org.jetbrains.plugins.gradle.service.execution.LocalGradleExecutionAware;
import org.jetbrains.plugins.gradle.service.execution.wsl.GradleOnWslExecutionAware;
import org.jetbrains.plugins.gradle.service.execution.wsl.WslBuildLayoutParameters;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J$\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\t2\b\u0010#\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020\tH\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/wsl/GradleOnWslExecutionAware;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionAware;", "<init>", "()V", "prepareExecution", "", "task", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTask;", "externalProjectPath", "", "isPreviewMode", "", "taskNotificationListener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "project", "Lcom/intellij/openapi/project/Project;", "getEnvironmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "runConfiguration", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration;", "projectPath", "isRemoteRun", "getDefaultBuildLayoutParameters", "Lorg/jetbrains/plugins/gradle/service/execution/BuildLayoutParameters;", "getBuildLayoutParameters", "Ljava/nio/file/Path;", "isGradleInstallationHomeDir", "homePath", "getTargetPathMapper", "Lcom/intellij/util/PathMapper;", "wslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "getWslEnvironmentProvider", "Lorg/jetbrains/plugins/gradle/service/execution/GradleServerConfigurationProvider;", "path", "targetName", "resolveWslDistribution", "intellij.gradle"})
@ApiStatus.Internal
public final class GradleOnWslExecutionAware
implements GradleExecutionAware {
    public void prepareExecution(@NotNull ExternalSystemTask task2, @NotNull String externalProjectPath2, boolean isPreviewMode, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (isPreviewMode) {
            return;
        }
        WSLDistribution wSLDistribution = this.resolveWslDistribution(externalProjectPath2);
        if (wSLDistribution == null) {
            return;
        }
        WSLDistribution wslDistribution = wSLDistribution;
        SdkLookupProvider.SdkInfo sdkInfo2 = new LocalGradleExecutionAware().prepareJvmForExecution(task2, externalProjectPath2, taskNotificationListener, project2);
        if (!(sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Resolved)) {
            return;
        }
        String string = ((SdkLookupProvider.SdkInfo.Resolved)sdkInfo2).getHomePath();
        if (string == null) {
            return;
        }
        String homePath = string;
        WSLDistribution jdkWslDistribution = WslPath.Companion.getDistributionByWindowsUncPath(homePath);
        WSLDistribution wSLDistribution2 = jdkWslDistribution;
        if (!Intrinsics.areEqual((Object)wslDistribution.getId(), (Object)(wSLDistribution2 != null ? wSLDistribution2.getId() : null))) {
            boolean isResolveProjectTask = task2 instanceof ExternalSystemResolveProjectTask;
            String distributionPath = ((Object)wslDistribution.getUNCRootPath()).toString();
            String string2 = wslDistribution.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(...)");
            String distributionName = string2;
            Object[] objectArray = new Object[]{distributionName, distributionPath};
            String message = GradleBundle.message("gradle.incorrect.jvm.wsl.issue.description", objectArray);
            Intrinsics.checkNotNull((Object)message);
            throw new BuildIssueException((BuildIssue)new IncorrectGradleJdkIssue(externalProjectPath2, homePath, message, isResolveProjectTask));
        }
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull ExternalSystemRunConfiguration runConfiguration, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String projectPath = runConfiguration.getSettings().getExternalProjectPath();
        GradleRunConfiguration gradleRunConfiguration = runConfiguration instanceof GradleRunConfiguration ? (GradleRunConfiguration)runConfiguration : null;
        if (gradleRunConfiguration == null) {
            return null;
        }
        GradleRunConfiguration gradleRunConfiguration2 = gradleRunConfiguration;
        String targetName = gradleRunConfiguration2.getOptions().getRemoteTarget();
        Intrinsics.checkNotNull((Object)projectPath);
        return this.getWslEnvironmentProvider(project2, projectPath, targetName);
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull String projectPath, boolean isPreviewMode, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.getWslEnvironmentProvider(project2, projectPath, null);
    }

    public boolean isRemoteRun(@NotNull ExternalSystemRunConfiguration runConfiguration, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String projectPath = runConfiguration.getSettings().getExternalProjectPath();
        Intrinsics.checkNotNull((Object)projectPath);
        return this.resolveWslDistribution(projectPath) != null;
    }

    @Override
    @Nullable
    public BuildLayoutParameters getDefaultBuildLayoutParameters(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object object = ProjectUtil.guessProjectDir((Project)project2);
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Object projectLocation = object;
        WSLDistribution wSLDistribution = this.resolveWslDistribution((String)projectLocation);
        if (wSLDistribution == null) {
            return null;
        }
        WSLDistribution wslDistribution = wSLDistribution;
        return new WslBuildLayoutParameters(wslDistribution, project2, null);
    }

    @Override
    @Nullable
    public BuildLayoutParameters getBuildLayoutParameters(@NotNull Project project2, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        String projectPathString = ((Object)projectPath).toString();
        WSLDistribution wSLDistribution = this.resolveWslDistribution(projectPathString);
        if (wSLDistribution == null) {
            return null;
        }
        WSLDistribution wslDistribution = wSLDistribution;
        return new WslBuildLayoutParameters(wslDistribution, project2, projectPathString);
    }

    @Override
    public boolean isGradleInstallationHomeDir(@NotNull Project project2, @NotNull Path homePath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        String string = project2.getBasePath();
        if (string == null) {
            return false;
        }
        WSLDistribution wSLDistribution = this.resolveWslDistribution(string);
        if (wSLDistribution == null) {
            return false;
        }
        WSLDistribution wslDistribution = wSLDistribution;
        String string2 = wslDistribution.getWindowsPath(((Object)homePath).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getWindowsPath(...)");
        String windowsPath = string2;
        LocalGradleExecutionAware localGradleExecutionAware = new LocalGradleExecutionAware();
        Path path = Path.of(windowsPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return localGradleExecutionAware.isGradleInstallationHomeDir(project2, path);
    }

    private final PathMapper getTargetPathMapper(WSLDistribution wslDistribution) {
        return new PathMapper(wslDistribution){
            final /* synthetic */ WSLDistribution $wslDistribution;
            {
                this.$wslDistribution = $wslDistribution;
            }

            public boolean isEmpty() {
                return false;
            }

            public boolean canReplaceLocal(String localPath) {
                Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
                return true;
            }

            public String convertToLocal(String remotePath) {
                Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
                String string = this.$wslDistribution.getWindowsPath(remotePath);
                if (string == null) {
                    string = remotePath;
                }
                return string;
            }

            public boolean canReplaceRemote(String remotePath) {
                Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
                return true;
            }

            public String convertToRemote(String localPath) {
                Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
                String string = this.$wslDistribution.getWslPath(localPath);
                if (string == null) {
                    string = localPath;
                }
                return string;
            }

            /*
             * WARNING - void declaration
             */
            public List<String> convertToRemote(Collection<String> paths) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                Iterable $this$map$iv = paths;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertToRemote((String)it));
                }
                return (List)destination$iv$iv;
            }
        };
    }

    private final GradleServerConfigurationProvider getWslEnvironmentProvider(Project project2, String path, String targetName) {
        WslTargetEnvironmentConfiguration wslEnvironmentConfiguration;
        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration;
        String string = targetName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.Companion.getInstance(project2).getTargets().findByName(it);
        } else {
            v1 = targetEnvironmentConfiguration = null;
        }
        if (((wslTargetEnvironmentConfiguration = (wslEnvironmentConfiguration = targetEnvironmentConfiguration instanceof WslTargetEnvironmentConfiguration ? (WslTargetEnvironmentConfiguration)targetEnvironmentConfiguration : null)) == null || (wslTargetEnvironmentConfiguration = wslTargetEnvironmentConfiguration.getDistribution()) == null) && (wslTargetEnvironmentConfiguration = this.resolveWslDistribution(path)) == null) {
            return null;
        }
        WslTargetEnvironmentConfiguration wslDistribution = wslTargetEnvironmentConfiguration;
        return new GradleServerConfigurationProvider(this, (WSLDistribution)wslDistribution, wslEnvironmentConfiguration){
            private final Lazy environmentConfiguration$delegate;
            private final PathMapper pathMapper;
            final /* synthetic */ WSLDistribution $wslDistribution;
            {
                this.$wslDistribution = $wslDistribution;
                this.environmentConfiguration$delegate = LazyKt.lazy(() -> getWslEnvironmentProvider.1.environmentConfiguration_delegate$lambda$0($wslEnvironmentConfiguration, $wslDistribution));
                this.pathMapper = GradleOnWslExecutionAware.access$getTargetPathMapper($receiver, $wslDistribution);
            }

            public WslTargetEnvironmentConfiguration getEnvironmentConfiguration() {
                Lazy lazy = this.environmentConfiguration$delegate;
                return (WslTargetEnvironmentConfiguration)lazy.getValue();
            }

            public PathMapper getPathMapper() {
                return this.pathMapper;
            }

            public HostPort getServerBindingAddress(TargetEnvironmentConfiguration targetEnvironmentConfiguration) {
                Intrinsics.checkNotNullParameter((Object)targetEnvironmentConfiguration, (String)"targetEnvironmentConfiguration");
                String string = this.$wslDistribution.getWslIpAddress().getHostAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostAddress(...)");
                return new HostPort(string, 0);
            }

            private static final WslTargetEnvironmentConfiguration environmentConfiguration_delegate$lambda$0(WslTargetEnvironmentConfiguration $wslEnvironmentConfiguration, WSLDistribution $wslDistribution) {
                WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration = $wslEnvironmentConfiguration;
                if (wslTargetEnvironmentConfiguration == null) {
                    wslTargetEnvironmentConfiguration = new WslTargetEnvironmentConfiguration($wslDistribution);
                }
                return wslTargetEnvironmentConfiguration;
            }
        };
    }

    private final WSLDistribution resolveWslDistribution(String path) {
        if (!WSLUtil.isSystemCompatible()) {
            return null;
        }
        return WslPath.Companion.getDistributionByWindowsUncPath(path);
    }

    public static final /* synthetic */ PathMapper access$getTargetPathMapper(GradleOnWslExecutionAware $this, WSLDistribution wslDistribution) {
        return $this.getTargetPathMapper(wslDistribution);
    }
}

