/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetDependencyModel.DefaultGradleSourceSetDependencyModel;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.DefaultGradleSourceSetModel;
import com.intellij.gradle.toolingExtension.impl.model.taskModel.DefaultGradleTaskModel;
import com.intellij.gradle.toolingExtension.impl.modelAction.GradleModelFetchAction;
import com.intellij.gradle.toolingExtension.impl.util.GradleTreeTraverserUtil;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemOperationDescriptor;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemSyncActionsCollector;
import com.intellij.openapi.externalSystem.statistics.Phase;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemTelemetryUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.CanonicalPathPrefixTree;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMapper;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.prefixTree.map.MutablePrefixTreeMap;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.tooling.BuildActionFailureException;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.issue.DeprecatedGradleVersionIssue;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceSet;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.DefaultGradleLightBuild;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.GradleBuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.GradleLightBuild;
import org.jetbrains.plugins.gradle.model.GradleLightProject;
import org.jetbrains.plugins.gradle.model.GradleSourceSetDependencyModel;
import org.jetbrains.plugins.gradle.model.GradleSourceSetModel;
import org.jetbrains.plugins.gradle.model.GradleTaskModel;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.remote.impl.GradleLibraryNamesMixer;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleWrapperHelper;
import org.jetbrains.plugins.gradle.service.modelAction.GradleIdeaModelHolder;
import org.jetbrains.plugins.gradle.service.modelAction.GradleModelFetchActionRunner;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.BaseProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.BaseResolverExtension;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleBuildSrcProjectsResolver;
import org.jetbrains.plugins.gradle.service.project.GradleContentRootIndex;
import org.jetbrains.plugins.gradle.service.project.GradleImportCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradlePreviewCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverIndicator;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.LibraryDataNodeSubstitutor;
import org.jetbrains.plugins.gradle.service.project.ModuleMappingInfo;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.syncAction.GradleModelFetchActionResultHandler;
import org.jetbrains.plugins.gradle.service.syncAction.GradleProjectResolverResultHandler;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;

public class GradleProjectResolver
implements ExternalSystemProjectResolver<GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance(GradleProjectResolver.class);
    @NotNull
    private final GradleLibraryNamesMixer myLibraryNamesMixer = new GradleLibraryNamesMixer();
    @NotNull
    private final MultiMap<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = MultiMap.createConcurrent();
    public static final Key<Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>>> RESOLVED_SOURCE_SETS = Key.create((String)"resolvedSourceSets");
    public static final Key<Map<String, Pair<String, ExternalSystemSourceType>>> MODULES_OUTPUTS = Key.create((String)"moduleOutputsMap");
    public static final Key<MultiMap<ExternalSystemSourceType, String>> GRADLE_OUTPUTS = Key.create((String)"gradleOutputs");
    private static final Key<File> GRADLE_HOME_DIR = Key.create((String)"gradleHomeDir");
    public static final boolean DEBUG_ORPHAN_MODULES_PROCESSING = Boolean.getBoolean("external.system.debug.orphan.modules.processing");

    @Nullable
    public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId syncTaskId, @NotNull String projectPath, boolean isPreviewMode, @Nullable GradleExecutionSettings settings, @Nullable ProjectResolverPolicy resolverPolicy, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
        if (syncTaskId == null) {
            GradleProjectResolver.$$$reportNull$$$0(0);
        }
        if (projectPath == null) {
            GradleProjectResolver.$$$reportNull$$$0(1);
        }
        if (listener2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(2);
        }
        GradlePartialResolverPolicy gradleResolverPolicy = null;
        if (resolverPolicy != null) {
            if (resolverPolicy instanceof GradlePartialResolverPolicy) {
                gradleResolverPolicy = (GradlePartialResolverPolicy)resolverPolicy;
            } else {
                throw new ExternalSystemException("Unsupported project resolver policy: " + resolverPolicy.getClass().getName());
            }
        }
        GradleExecutionSettings effectiveSettings = settings != null ? settings : new GradleExecutionSettings();
        GradleProjectResolverIndicator projectResolverIndicator = new GradleProjectResolverIndicator(ProgressManager.getInstance().getProgressIndicator(), GradleConnector.newCancellationTokenSource());
        DefaultProjectResolverContext resolverContext = new DefaultProjectResolverContext(syncTaskId, projectPath, effectiveSettings, listener2, gradleResolverPolicy, projectResolverIndicator, false);
        GradleProjectResolverResultHandler resolverResultHandler = new GradleProjectResolverResultHandler(resolverContext);
        return this.computeCancellable(resolverContext, () -> {
            if (isPreviewMode) {
                return GradlePreviewCustomizer.Companion.getCustomizer(resolverContext).resolvePreviewProjectInfo(resolverContext);
            }
            resolverResultHandler.onResolveProjectInfoStarted();
            return this.resolveProjectInfo(resolverContext);
        });
    }

    @Nullable
    private DataNode<ProjectData> resolveProjectInfo(@NotNull DefaultProjectResolverContext resolverContext) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(3);
        }
        String projectPath = resolverContext.getProjectPath();
        ExternalSystemTaskId id = resolverContext.getExternalSystemTaskId();
        GradleExecutionSettings settings = resolverContext.getSettings();
        ExternalSystemTaskNotificationListener listener2 = resolverContext.getListener();
        CancellationToken cancellationToken = resolverContext.getCancellationToken();
        ExternalSystemSyncActionsCollector.logSyncStarted((Project)id.findProject(), (long)id.getId(), (boolean)settings.isParallelModelFetch());
        Span gradleExecutionSpan = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GradleExecution").startSpan();
        try {
            DataNode dataNode;
            block11: {
                Scope ignore = gradleExecutionSpan.makeCurrent();
                try {
                    GradleWrapperHelper.ensureInstalledWrapper(id, projectPath, settings, listener2, cancellationToken);
                    GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain(resolverContext);
                    DataNode projectDataNode = GradleProjectResolver.executeProjectResolverTask(resolverContext, projectResolverChain, connection -> this.doResolveProjectInfo((ProjectConnection)connection, resolverContext, projectResolverChain));
                    String gradleVersion = resolverContext.getProjectGradleVersion();
                    if (gradleVersion != null && GradleVersionUtil.isGradleOlderThan((String)gradleVersion, (String)"8.0")) {
                        String gradleHome = (String)ObjectUtils.doIfNotNull((Object)((File)resolverContext.getUserData(GRADLE_HOME_DIR)), it -> it.getPath());
                        new GradleBuildSrcProjectsResolver(this, resolverContext, gradleHome, projectResolverChain).discoverAndAppendTo((DataNode<ProjectData>)projectDataNode);
                    }
                    dataNode = projectDataNode;
                    if (ignore == null) break block11;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore.close();
            }
            return dataNode;
        }
        finally {
            gradleExecutionSpan.end();
        }
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (id == null) {
            GradleProjectResolver.$$$reportNull$$$0(4);
        }
        if (listener2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(5);
        }
        for (CancellationTokenSource cancellationTokenSource : this.myCancellationMap.get((Object)id)) {
            cancellationTokenSource.cancel();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R computeCancellable(@NotNull DefaultProjectResolverContext resolverContext, @NotNull Supplier<R> action) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(6);
        }
        if (action == null) {
            GradleProjectResolver.$$$reportNull$$$0(7);
        }
        ExternalSystemTaskId taskId = resolverContext.getExternalSystemTaskId();
        CancellationTokenSource cancellationTokenSource = resolverContext.getCancellationTokenSource();
        this.myCancellationMap.putValue((Object)taskId, (Object)cancellationTokenSource);
        try {
            R r = resolverContext.computeCancellable(action);
            return r;
        }
        finally {
            this.myCancellationMap.remove((Object)taskId, (Object)cancellationTokenSource);
        }
    }

    protected static <R> R executeProjectResolverTask(@NotNull DefaultProjectResolverContext resolverContext, @NotNull GradleProjectResolverExtension projectResolverChain, @NotNull Function<ProjectConnection, R> task2) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(8);
        }
        if (projectResolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(9);
        }
        if (task2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(10);
        }
        String projectPath = resolverContext.getProjectPath();
        ExternalSystemTaskId id = resolverContext.getExternalSystemTaskId();
        GradleExecutionSettings settings = resolverContext.getSettings();
        ExternalSystemTaskNotificationListener listener2 = resolverContext.getListener();
        CancellationToken cancellationToken = resolverContext.getCancellationToken();
        return (R)GradleExecutionHelper.execute(projectPath, settings, id, listener2, cancellationToken, connection -> {
            BuildEnvironment buildEnvironment = null;
            try {
                buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener2, cancellationToken, settings);
                if (buildEnvironment != null) {
                    resolverContext.setBuildEnvironment(buildEnvironment);
                }
                return task2.apply((ProjectConnection)connection);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                LOG.info("Gradle project resolve error", (Throwable)e);
                ExternalSystemException esException = (ExternalSystemException)((Object)((Object)ExceptionUtil.findCause((Throwable)e, ExternalSystemException.class)));
                if (esException != null && esException != e) {
                    LOG.info("\nCaused by: " + esException.getOriginalReason());
                }
                ExternalSystemSyncActionsCollector.logError((Project)id.findProject(), (long)id.getId(), (Throwable)GradleProjectResolver.extractCause(e));
                ExternalSystemSyncActionsCollector.logSyncFinished((Project)id.findProject(), (long)id.getId(), (boolean)false);
                throw projectResolverChain.getUserFriendlyError(buildEnvironment, e, projectPath, null);
            }
        });
    }

    /*
     * Loose catch block
     */
    @NotNull
    protected DataNode<ProjectData> doResolveProjectInfo(@NotNull ProjectConnection connection, @NotNull DefaultProjectResolverContext resolverContext, @NotNull GradleProjectResolverExtension projectResolverChain) throws IllegalArgumentException, IllegalStateException {
        DataNode<ProjectData> dataNode;
        Scope ignore;
        Span projectResolversSpan;
        int projectResolversErrorsCount;
        long projectResolversStartTime;
        long activityId;
        block33: {
            if (connection == null) {
                GradleProjectResolver.$$$reportNull$$$0(11);
            }
            if (resolverContext == null) {
                GradleProjectResolver.$$$reportNull$$$0(12);
            }
            if (projectResolverChain == null) {
                GradleProjectResolver.$$$reportNull$$$0(13);
            }
            GradleModelFetchAction buildAction = new GradleModelFetchAction();
            GradleExecutionSettings executionSettings = resolverContext.getSettings();
            GradleProjectResolver.configureExecutionArgumentsAndVmOptions(executionSettings, resolverContext);
            HashSet toolingExtensionClasses = new HashSet();
            for (GradleProjectResolverExtension resolverExtension = projectResolverChain; resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
                resolverExtension.setProjectResolverContext(resolverContext);
                resolverExtension.preImportCheck();
                buildAction.addTargetTypes(resolverExtension.getTargetTypes());
                try {
                    buildAction.addProjectImportModelProviders(resolverExtension.getModelProviders());
                }
                catch (Throwable t) {
                    LOG.warn(t);
                }
                try {
                    toolingExtensionClasses.addAll(resolverExtension.getToolingExtensionsClasses());
                    continue;
                }
                catch (Throwable t) {
                    LOG.warn(t);
                }
            }
            Path mainInitScriptPath = GradleInitScriptUtil.createMainInitScript(resolverContext.isBuildSrcProject(), toolingExtensionClasses);
            executionSettings.withArguments(new String[]{"--init-script", mainInitScriptPath.toString()});
            if (!executionSettings.isDownloadSources()) {
                Path ideaPluginConfiguratorInitScriptPath = GradleInitScriptUtil.createIdeaPluginConfiguratorInitScript();
                executionSettings.prependArguments(new String[]{"--init-script", ideaPluginConfiguratorInitScriptPath.toString()});
            }
            Path targetPathMapperInitScript = GradleInitScriptUtil.createTargetPathMapperInitScript();
            executionSettings.prependArguments(new String[]{"--init-script", targetPathMapperInitScript.toString()});
            TargetEnvironmentConfigurationProvider environmentConfigurationProvider = ExternalSystemExecutionAware.getEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)executionSettings);
            PathMapper pathMapper = (PathMapper)ObjectUtils.doIfNotNull((Object)environmentConfigurationProvider, it -> it.getPathMapper());
            GradleIdeaModelHolder models = new GradleIdeaModelHolder(pathMapper, resolverContext.getBuildEnvironment());
            resolverContext.setModels(models);
            ProgressManager.checkCanceled();
            activityId = resolverContext.getExternalSystemTaskId().getId();
            long gradleCallStartTime = System.currentTimeMillis();
            ExternalSystemSyncActionsCollector.logPhaseStarted(null, (long)activityId, (Phase)Phase.GRADLE_CALL);
            int gradleCallErrorsCount = 0;
            Span gradleCallSpan = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GradleCall").startSpan();
            try (Scope ignore2 = gradleCallSpan.makeCurrent();){
                GradleModelFetchActionResultHandler modelFetchActionResultHandler = new GradleModelFetchActionResultHandler(resolverContext);
                GradleModelFetchActionRunner.runAndTraceBuildAction(connection, resolverContext, buildAction, modelFetchActionResultHandler);
                GradleVersion gradleVersion = (GradleVersion)ObjectUtils.doIfNotNull((Object)resolverContext.getProjectGradleVersion(), it -> GradleVersion.version((String)it));
                if (gradleVersion != null && GradleJvmSupportMatrix.isGradleDeprecatedByIdea(gradleVersion)) {
                    String projectPath = resolverContext.getProjectPath();
                    DeprecatedGradleVersionIssue issue = new DeprecatedGradleVersionIssue(gradleVersion, projectPath);
                    resolverContext.report(MessageEvent.Kind.WARNING, (BuildIssue)issue);
                }
            }
            catch (Throwable t) {
                gradleCallSpan.setAttribute("error.count", (long)(++gradleCallErrorsCount));
                gradleCallSpan.recordException(t);
                gradleCallSpan.setStatus(StatusCode.ERROR);
                throw t;
            }
            finally {
                long gradleCallTimeInMs = System.currentTimeMillis() - gradleCallStartTime;
                ExternalSystemSyncActionsCollector.logPhaseFinished(null, (long)activityId, (Phase)Phase.GRADLE_CALL, (long)gradleCallTimeInMs, (int)gradleCallErrorsCount);
                gradleCallSpan.end();
            }
            ProgressManager.checkCanceled();
            projectResolversStartTime = System.currentTimeMillis();
            ExternalSystemSyncActionsCollector.logPhaseStarted(null, (long)activityId, (Phase)Phase.PROJECT_RESOLVERS);
            projectResolversErrorsCount = 0;
            projectResolversSpan = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GradleProjectResolverDataProcessing").startSpan();
            ignore = projectResolversSpan.makeCurrent();
            GradleProjectResolver.extractExternalProjectModels(models);
            dataNode = this.convertData(resolverContext, projectResolverChain);
            if (ignore == null) break block33;
            ignore.close();
        }
        long projectResolversTimeInMs = System.currentTimeMillis() - projectResolversStartTime;
        LOG.debug(String.format("Project data resolved in %d ms", projectResolversTimeInMs));
        ExternalSystemSyncActionsCollector.logPhaseFinished(null, (long)activityId, (Phase)Phase.PROJECT_RESOLVERS, (long)projectResolversTimeInMs, (int)projectResolversErrorsCount);
        projectResolversSpan.end();
        DataNode<ProjectData> dataNode2 = dataNode;
        if (dataNode2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(14);
        }
        return dataNode2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        ++projectResolversErrorsCount;
                        projectResolversSpan.recordException(t);
                        projectResolversSpan.setStatus(StatusCode.ERROR);
                        throw t;
                    }
                }
                catch (Throwable throwable3) {
                    long projectResolversTimeInMs2 = System.currentTimeMillis() - projectResolversStartTime;
                    LOG.debug(String.format("Project data resolved in %d ms", projectResolversTimeInMs2));
                    ExternalSystemSyncActionsCollector.logPhaseFinished(null, (long)activityId, (Phase)Phase.PROJECT_RESOLVERS, (long)projectResolversTimeInMs2, (int)projectResolversErrorsCount);
                    projectResolversSpan.end();
                    throw throwable3;
                }
            }
        }
    }

    @NotNull
    private DataNode<ProjectData> convertData(@NotNull DefaultProjectResolverContext resolverContext, @NotNull GradleProjectResolverExtension tracedResolverChain) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(15);
        }
        if (tracedResolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(16);
        }
        long activityId = resolverContext.getExternalSystemTaskId().getId();
        String projectPath = resolverContext.getProjectPath();
        String projectName = resolverContext.getRootBuild().getName();
        ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, projectName, projectPath, projectPath);
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        DataNode descriptorDataNode = new DataNode(ExternalSystemOperationDescriptor.OPERATION_DESCRIPTOR_KEY, (Object)new ExternalSystemOperationDescriptor(activityId), projectDataNode);
        projectDataNode.addChild(descriptorDataNode);
        Set<? extends IdeaModule> gradleModules = GradleProjectResolver.extractCollectedModules(resolverContext, (DataNode<ProjectData>)projectDataNode, tracedResolverChain);
        Collection<IdeaModule> includedModules = GradleProjectResolver.exposeCompositeBuild(resolverContext, (DataNode<ProjectData>)projectDataNode);
        HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap = new HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>>();
        HashMap sourceSetsMap = new HashMap();
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, sourceSetsMap);
        Map moduleOutputsMap = CollectionFactory.createFilePathMap();
        projectDataNode.putUserData(MODULES_OUTPUTS, (Object)moduleOutputsMap);
        ArtifactMappingService artifactsMap = resolverContext.getArtifactsMap();
        for (IdeaModule gradleModule : ContainerUtil.concat(gradleModules, includedModules)) {
            ProgressManager.checkCanceled();
            DataNode<ModuleData> moduleDataNode = GradleProjectResolver.createModuleData(gradleModule, tracedResolverChain, (DataNode<ProjectData>)projectDataNode);
            if (moduleDataNode == null) continue;
            String mainModuleId = GradleProjectResolverUtil.getModuleId((ProjectResolverContext)resolverContext, gradleModule);
            if (moduleMap.containsKey(mainModuleId)) {
                throw new IllegalStateException("Attempt to add module with already existing id [" + mainModuleId + "]\n new module: " + String.valueOf(gradleModule) + "\n existing module: " + String.valueOf(((Pair)moduleMap.get((Object)mainModuleId)).second));
            }
            moduleMap.put(mainModuleId, (Pair<DataNode<ModuleData>, IdeaModule>)Pair.create((Object)moduleDataNode, (Object)gradleModule));
        }
        GradleExecutionSettings executionSettings = resolverContext.getSettings();
        executionSettings.getExecutionWorkspace().setModuleIdIndex(moduleMap);
        File gradleHomeDir = null;
        for (Pair pair : moduleMap.values()) {
            GradleBuildScriptClasspathModel buildScriptClasspathModel;
            DataNode moduleDataNode = (DataNode)pair.first;
            IdeaModule ideaModule = (IdeaModule)pair.second;
            if (gradleHomeDir == null && (buildScriptClasspathModel = (GradleBuildScriptClasspathModel)resolverContext.getExtraProject(ideaModule, GradleBuildScriptClasspathModel.class)) != null) {
                gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
            }
            tracedResolverChain.populateModuleContentRoots(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            tracedResolverChain.populateModuleCompileOutputSettings(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            if (!resolverContext.isBuildSrcProject()) {
                tracedResolverChain.populateModuleTasks(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
            }
            SmartList modules = new SmartList();
            modules.add(moduleDataNode);
            modules.addAll(ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, GradleSourceSetData.KEY));
            ExternalSystemSourceType[] sourceTypes = new ExternalSystemSourceType[]{ExternalSystemSourceType.SOURCE, ExternalSystemSourceType.RESOURCE, ExternalSystemSourceType.TEST, ExternalSystemSourceType.TEST_RESOURCE};
            for (DataNode module : modules) {
                ModuleData moduleData = (ModuleData)module.getData();
                for (ExternalSystemSourceType sourceType : sourceTypes) {
                    String path = moduleData.getCompileOutputPath(sourceType);
                    if (path == null) continue;
                    moduleOutputsMap.put(path, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                }
                if (!(moduleData instanceof GradleSourceSetData)) continue;
                for (File artifactFile2 : moduleData.getArtifacts()) {
                    artifactsMap.storeModuleId(ExternalSystemApiUtil.toCanonicalPath((String)artifactFile2.getPath()), moduleData.getId());
                }
            }
            GradleSourceSetModel sourceSetModel = resolverContext.getProjectModel((ProjectModel)ideaModule, GradleSourceSetModel.class);
            if (sourceSetModel == null) continue;
            sourceSetModel.getAdditionalArtifacts().forEach(artifactFile -> {
                String path = ExternalSystemApiUtil.toCanonicalPath((String)artifactFile.getPath());
                ModuleMappingInfo mapping = artifactsMap.getModuleMapping(path);
                if (mapping != null && "base-gradle".equals(mapping.getOwnerId())) {
                    artifactsMap.markArtifactPath(path, true);
                }
            });
        }
        if (gradleHomeDir == null && executionSettings.getGradleHome() != null) {
            gradleHomeDir = new File(executionSettings.getGradleHome());
        }
        resolverContext.putUserData(GRADLE_HOME_DIR, gradleHomeDir);
        ExternalSystemTelemetryUtil.runWithSpan((ProjectSystemId)GradleConstants.SYSTEM_ID, (String)"PopulateModules", __ -> {
            for (Pair pair : moduleMap.values()) {
                DataNode moduleDataNode = (DataNode)pair.first;
                IdeaModule ideaModule = (IdeaModule)pair.second;
                tracedResolverChain.populateModuleDependencies(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
                tracedResolverChain.populateModuleExtraModels(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            }
        });
        GradleProjectResolver.mergeSourceSetContentRoots(resolverContext, moduleMap);
        if (resolverContext.isResolveModulePerSourceSet()) {
            GradleProjectResolver.mergeLibraryAndModuleDependencyData(resolverContext, (DataNode<ProjectData>)projectDataNode, resolverContext.getGradleUserHome(), gradleHomeDir);
        }
        GradleProjectResolver.processBuildSrcModules(resolverContext, (DataNode<ProjectData>)projectDataNode);
        for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
            resolver.resolveFinished((DataNode<ProjectData>)projectDataNode);
        }
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, null);
        projectDataNode.putUserData(MODULES_OUTPUTS, null);
        Collection libraries = ExternalSystemApiUtil.getChildren((DataNode)projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY);
        this.myLibraryNamesMixer.mixNames(libraries);
        DataNode dataNode = projectDataNode;
        if (dataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(17);
        }
        return dataNode;
    }

    @Nullable
    private static DataNode<ModuleData> createModuleData(@Nullable IdeaModule gradleModule, @NotNull GradleProjectResolverExtension resolverChain, @NotNull DataNode<ProjectData> projectDataNode) {
        String moduleName;
        if (resolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(18);
        }
        if (projectDataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(19);
        }
        if (gradleModule == null) {
            return null;
        }
        if (DEBUG_ORPHAN_MODULES_PROCESSING) {
            LOG.info(String.format("Importing module data: %s", gradleModule));
        }
        if ((moduleName = gradleModule.getName()) == null) {
            throw new IllegalStateException("Module with undefined name detected: " + String.valueOf(gradleModule));
        }
        return resolverChain.createModule(gradleModule, projectDataNode);
    }

    @NotNull
    private static Set<? extends IdeaModule> extractCollectedModules(@NotNull DefaultProjectResolverContext resolverContext, @NotNull DataNode<ProjectData> projectDataNode, @NotNull GradleProjectResolverExtension resolverChain) {
        IdeaProject ideaProject;
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(20);
        }
        if (projectDataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(21);
        }
        if (resolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(22);
        }
        if ((ideaProject = resolverContext.getRootModel(IdeaProject.class)) == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                GradleProjectResolver.$$$reportNull$$$0(23);
            }
            return set;
        }
        resolverChain.populateProjectExtraModels(ideaProject, projectDataNode);
        DomainObjectSet modules = ideaProject.getModules();
        if (modules == null || modules.isEmpty()) {
            throw new IllegalStateException("No modules found for the target project: " + String.valueOf(ideaProject));
        }
        DomainObjectSet domainObjectSet = modules;
        if (domainObjectSet == null) {
            GradleProjectResolver.$$$reportNull$$$0(24);
        }
        return domainObjectSet;
    }

    private static void processBuildSrcModules(DefaultProjectResolverContext ctx, DataNode<ProjectData> projectDataNode) {
        DataNode compositeNode = ExternalSystemApiUtil.find(projectDataNode, CompositeBuildData.KEY);
        if (compositeNode == null) {
            return;
        }
        GradleBuildSrcProjectsResolver.Index index = GradleBuildSrcProjectsResolver.prepareIndexes(projectDataNode);
        CompositeBuildData compositeBuildData = (CompositeBuildData)compositeNode.getData();
        for (BuildParticipant participant : compositeBuildData.getCompositeParticipants()) {
            if (!participant.getRootProjectName().endsWith("buildSrc")) continue;
            Set<String> buildSrcProjectPaths = participant.getProjects();
            @NotNull Collection buildClasspathNodes = index.buildClasspathNodesMap().get((Object)Path.of(participant.getRootPath(), new String[0]).getParent());
            @NotNull HashMap<String, DataNode<? extends ModuleData>> buildSrcModules = new HashMap<String, DataNode<? extends ModuleData>>();
            AtomicReference buildSrcModuleNode = new AtomicReference();
            ExternalSystemApiUtil.findAll(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE).stream().filter(node -> buildSrcProjectPaths.contains(((ModuleData)node.getData()).getLinkedExternalProjectPath())).forEach(node -> {
                buildSrcModules.put(((ModuleData)node.getData()).getId(), (DataNode<? extends ModuleData>)node);
                GradleModuleDataKt.setBuildSrcModule((ModuleData)node.getData());
                ExternalSystemApiUtil.findAll((DataNode)node, GradleSourceSetData.KEY).forEach(sourceSetNode -> buildSrcModules.put(((GradleSourceSetData)((Object)((Object)((Object)sourceSetNode.getData())))).getId(), (DataNode<? extends ModuleData>)sourceSetNode));
                if (participant.getRootPath().equals(((ModuleData)node.getData()).getLinkedExternalProjectPath())) {
                    if (ctx.isResolveModulePerSourceSet()) {
                        buildSrcModuleNode.set(ExternalSystemApiUtil.findChild((DataNode)node, GradleSourceSetData.KEY, sourceSetNode -> ((GradleSourceSetData)((Object)((Object)((Object)sourceSetNode.getData())))).getExternalName().endsWith(":main")));
                    } else {
                        buildSrcModuleNode.set(node);
                    }
                }
            });
            GradleBuildSrcProjectsResolver.addBuildSrcToBuildScriptClasspathData(buildClasspathNodes, buildSrcModules, (DataNode<? extends ModuleData>)((DataNode)buildSrcModuleNode.get()));
        }
    }

    private static void configureExecutionArgumentsAndVmOptions(@NotNull GradleExecutionSettings executionSettings, @NotNull DefaultProjectResolverContext resolverContext) {
        if (executionSettings == null) {
            GradleProjectResolver.$$$reportNull$$$0(25);
        }
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(26);
        }
        executionSettings.withArgument("-Didea.gradle.download.sources=" + executionSettings.isDownloadSources());
        executionSettings.withArgument("-Didea.sync.active=true");
        if (resolverContext.isResolveModulePerSourceSet()) {
            executionSettings.withArgument("-Didea.resolveSourceSetDependencies=true");
        }
        if (executionSettings.isParallelModelFetch()) {
            executionSettings.withArgument("-Didea.parallelModelFetch.enabled=true");
        }
        if (!resolverContext.isBuildSrcProject()) {
            for (GradleBuildParticipant buildParticipant : executionSettings.getExecutionWorkspace().getBuildParticipants()) {
                executionSettings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
            }
        }
        if (Registry.is((String)"gradle.daemon.experimental.dependency.resolver", (boolean)false)) {
            executionSettings.withArgument("-Didea.experimental.gradle.dependency.resolver=true");
        }
        GradleImportCustomizer importCustomizer = GradleImportCustomizer.get();
        GradleProjectResolverUtil.createProjectResolvers(resolverContext).forEachOrdered(extension -> {
            if (importCustomizer == null || importCustomizer.useExtraJvmArgs()) {
                ParametersList parametersList = new ParametersList();
                for (Pair<String, String> jvmArg : extension.getExtraJvmArgs()) {
                    parametersList.addProperty((String)jvmArg.first, (String)jvmArg.second);
                }
                executionSettings.withVmOptions(parametersList.getParameters());
            }
            executionSettings.withArguments(extension.getExtraCommandLineArgs());
        });
    }

    @NotNull
    private static Collection<IdeaModule> exposeCompositeBuild(@NotNull DefaultProjectResolverContext resolverContext, @NotNull DataNode<ProjectData> projectDataNode) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(27);
        }
        if (projectDataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(28);
        }
        if (!resolverContext.getSettings().getExecutionWorkspace().getBuildParticipants().isEmpty()) {
            List<IdeaModule> list = Collections.emptyList();
            if (list == null) {
                GradleProjectResolver.$$$reportNull$$$0(29);
            }
            return list;
        }
        SmartList gradleIncludedModules = new SmartList();
        Collection<? extends GradleLightBuild> includedBuilds = resolverContext.getNestedBuilds();
        if (!includedBuilds.isEmpty()) {
            ProjectData projectData = (ProjectData)projectDataNode.getData();
            CompositeBuildData compositeBuildData = new CompositeBuildData(projectData.getLinkedExternalProjectPath());
            for (GradleLightBuild gradleLightBuild : includedBuilds) {
                if (gradleLightBuild.getProjects().isEmpty()) continue;
                IdeaProject ideaProject = resolverContext.getBuildModel((BuildModel)gradleLightBuild, IdeaProject.class);
                if (ideaProject != null) {
                    gradleIncludedModules.addAll(ideaProject.getModules());
                }
                String rootProjectName = gradleLightBuild.getName();
                BuildParticipant buildParticipant = new BuildParticipant();
                String projectPath = ExternalSystemApiUtil.toCanonicalPath((String)gradleLightBuild.getBuildIdentifier().getRootDir().getPath());
                String parentPath = gradleLightBuild.getParentBuildIdentifier() != null ? ExternalSystemApiUtil.toCanonicalPath((String)gradleLightBuild.getParentBuildIdentifier().getRootDir().getPath()) : null;
                buildParticipant.setRootProjectName(rootProjectName);
                buildParticipant.setRootPath(projectPath);
                buildParticipant.setParentRootPath(parentPath);
                if (ideaProject != null) {
                    for (IdeaModule module : ideaProject.getModules()) {
                        String modulePath = ExternalSystemApiUtil.toCanonicalPath((String)module.getGradleProject().getProjectDirectory().getPath());
                        buildParticipant.getProjects().add(modulePath);
                    }
                }
                compositeBuildData.getCompositeParticipants().add(buildParticipant);
            }
            projectDataNode.createChild(CompositeBuildData.KEY, (Object)compositeBuildData);
        }
        SmartList smartList = gradleIncludedModules;
        if (smartList == null) {
            GradleProjectResolver.$$$reportNull$$$0(30);
        }
        return smartList;
    }

    private static void mergeLibraryAndModuleDependencyData(@NotNull ProjectResolverContext context, @NotNull DataNode<ProjectData> projectDataNode, @NotNull File gradleUserHomeDir2, @Nullable File gradleHomeDir) {
        if (context == null) {
            GradleProjectResolver.$$$reportNull$$$0(31);
        }
        if (projectDataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(32);
        }
        if (gradleUserHomeDir2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(33);
        }
        Map sourceSetMap = (Map)projectDataNode.getUserData(RESOLVED_SOURCE_SETS);
        assert (sourceSetMap != null);
        Map moduleOutputsMap = (Map)projectDataNode.getUserData(MODULES_OUTPUTS);
        assert (moduleOutputsMap != null);
        ArtifactMappingService artifactsMap = context.getArtifactsMap();
        assert (artifactsMap != null);
        Collection libraryDependencies = ExternalSystemApiUtil.findAllRecursively(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY_DEPENDENCY);
        LibraryDataNodeSubstitutor librarySubstitutor = new LibraryDataNodeSubstitutor(context, gradleUserHomeDir2, gradleHomeDir, sourceSetMap, moduleOutputsMap, artifactsMap);
        for (DataNode libraryDependencyDataNode : libraryDependencies) {
            librarySubstitutor.run((DataNode<LibraryDependencyData>)libraryDependencyDataNode);
        }
    }

    private static void extractExternalProjectModels(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(34);
        }
        GradleProjectResolver.replicateBuildModelHierarchyInExternalProjectHierarchy(models);
        GradleProjectResolver.replicateProjectModelHierarchyInExternalProjectHierarchy(models);
        GradleProjectResolver.associateSourceSetModelsWithExternalProjects(models);
        GradleProjectResolver.associateSourceSetDependencyModelsWithSourceSetModels(models);
        GradleProjectResolver.registerInheritedTaskModelsInParentTaskModel(models);
        GradleProjectResolver.associateTaskModelsWithExternalProjects(models);
    }

    private static void replicateBuildModelHierarchyInExternalProjectHierarchy(@NotNull GradleIdeaModelHolder models) {
        GradleLightBuild rootBuildModel;
        GradleLightProject rootProjectModel;
        DefaultExternalProject rootExternalProject;
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(35);
        }
        if ((rootExternalProject = (DefaultExternalProject)models.getProjectModel((ProjectModel)(rootProjectModel = (rootBuildModel = models.getRootBuild()).getRootProject()), ExternalProject.class)) == null) {
            return;
        }
        for (GradleLightBuild nestedBuildModel : models.getNestedBuilds()) {
            GradleLightProject projectModel = nestedBuildModel.getRootProject();
            DefaultExternalProject externalProject = (DefaultExternalProject)models.getProjectModel((ProjectModel)projectModel, ExternalProject.class);
            if (externalProject == null) continue;
            rootExternalProject.addChildProject(externalProject);
        }
    }

    private static void replicateProjectModelHierarchyInExternalProjectHierarchy(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(36);
        }
        for (GradleLightBuild buildModel : models.getAllBuilds()) {
            DefaultGradleLightBuild.replicateModelHierarchy((Object)buildModel.getRootProject(), it -> (DefaultExternalProject)models.getProjectModel((ProjectModel)it, ExternalProject.class), GradleLightProject::getChildProjects, DefaultExternalProject::addChildProject);
        }
    }

    private static void associateSourceSetModelsWithExternalProjects(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(37);
        }
        for (GradleLightBuild buildModel : models.getAllBuilds()) {
            for (GradleLightProject projectModel : buildModel.getProjects()) {
                DefaultExternalProject externalProject = (DefaultExternalProject)models.getProjectModel((ProjectModel)projectModel, ExternalProject.class);
                DefaultGradleSourceSetModel sourceSetModel = (DefaultGradleSourceSetModel)models.getProjectModel((ProjectModel)projectModel, GradleSourceSetModel.class);
                if (externalProject == null || sourceSetModel == null) continue;
                externalProject.setSourceSetModel(sourceSetModel);
            }
        }
    }

    private static void associateSourceSetDependencyModelsWithSourceSetModels(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(38);
        }
        for (GradleLightBuild buildModel : models.getAllBuilds()) {
            for (GradleLightProject projectModel : buildModel.getProjects()) {
                DefaultGradleSourceSetModel sourceSetModel = (DefaultGradleSourceSetModel)models.getProjectModel((ProjectModel)projectModel, GradleSourceSetModel.class);
                DefaultGradleSourceSetDependencyModel sourceSetDependencyModel = (DefaultGradleSourceSetDependencyModel)models.getProjectModel((ProjectModel)projectModel, GradleSourceSetDependencyModel.class);
                if (sourceSetModel == null || sourceSetDependencyModel == null) continue;
                Map sourceSets = sourceSetModel.getSourceSets();
                Map dependencies = sourceSetDependencyModel.getDependencies();
                LinkedHashSet sourceSetNames = new LinkedHashSet(sourceSets.keySet());
                sourceSetNames.retainAll(dependencies.keySet());
                for (String sourceSetName : sourceSetNames) {
                    DefaultExternalSourceSet sourceSet = (DefaultExternalSourceSet)sourceSets.get(sourceSetName);
                    Collection sourceSetDependencies = (Collection)dependencies.get(sourceSetName);
                    sourceSet.setDependencies(sourceSetDependencies);
                }
            }
        }
    }

    private static void registerInheritedTaskModelsInParentTaskModel(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(39);
        }
        for (GradleLightBuild buildModel : models.getAllBuilds()) {
            GradleTreeTraverserUtil.backwardTraverseTree((Object)buildModel.getRootProject(), it -> it.getChildProjects(), projectModel -> {
                DefaultGradleTaskModel taskModel = (DefaultGradleTaskModel)models.getProjectModel((ProjectModel)projectModel, GradleTaskModel.class);
                if (taskModel == null) {
                    return;
                }
                HashMap<String, DefaultExternalTask> tasks2 = new HashMap<String, DefaultExternalTask>(taskModel.getTasks());
                for (GradleLightProject childProjectModel : projectModel.getChildProjects()) {
                    DefaultGradleTaskModel childTaskModel = (DefaultGradleTaskModel)models.getProjectModel((ProjectModel)childProjectModel, GradleTaskModel.class);
                    if (childTaskModel == null) continue;
                    for (DefaultExternalTask childTask : childTaskModel.getTasks().values()) {
                        if (tasks2.containsKey(childTask.getName())) continue;
                        DefaultExternalTask inheritedTask = new DefaultExternalTask((ExternalTask)childTask);
                        inheritedTask.setInherited(true);
                        tasks2.put(inheritedTask.getName(), inheritedTask);
                    }
                }
                taskModel.setTasks(tasks2);
            });
        }
    }

    private static void associateTaskModelsWithExternalProjects(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(40);
        }
        for (GradleLightBuild buildModel : models.getAllBuilds()) {
            for (GradleLightProject projectModel : buildModel.getProjects()) {
                DefaultExternalProject externalProject = (DefaultExternalProject)models.getProjectModel((ProjectModel)projectModel, ExternalProject.class);
                DefaultGradleTaskModel taskModel = (DefaultGradleTaskModel)models.getProjectModel((ProjectModel)projectModel, GradleTaskModel.class);
                if (externalProject == null || taskModel == null) continue;
                externalProject.setTaskModel(taskModel);
            }
        }
    }

    private static void mergeSourceSetContentRoots(@NotNull ProjectResolverContext resolverContext, @NotNull Map<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(41);
        }
        if (moduleMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(42);
        }
        Map modules = ContainerUtil.map2Map(moduleMap.values(), it -> new Pair((Object)((IdeaModule)it.getSecond()), (Object)((DataNode)it.getFirst())));
        if (resolverContext.isResolveModulePerSourceSet()) {
            GradleProjectResolver.mergeSourceSetContentRootsInModulePerSourceSetMode(resolverContext, modules);
        } else {
            GradleProjectResolver.mergeSourceSetContentRootsInModulePerProjectMode(resolverContext, modules);
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    static void mergeSourceSetContentRootsInModulePerSourceSetMode(@NotNull ProjectResolverContext resolverContext, @NotNull @Unmodifiable Map<? extends ProjectModel, DataNode<ModuleData>> moduleMap) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(43);
        }
        if (moduleMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(44);
        }
        GradleContentRootIndex contentRootIndex = new GradleContentRootIndex();
        for (Map.Entry<? extends ProjectModel, DataNode<ModuleData>> moduleEntry : moduleMap.entrySet()) {
            DataNode<ModuleData> moduleNode = moduleEntry.getValue();
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll(moduleNode, GradleSourceSetData.KEY)) {
                contentRootIndex.addSourceRoots((DataNode<GradleSourceSetData>)sourceSetNode);
            }
        }
        for (Map.Entry<? extends ProjectModel, DataNode<ModuleData>> moduleEntry : moduleMap.entrySet()) {
            ProjectModel projectModel = moduleEntry.getKey();
            DataNode<ModuleData> moduleNode = moduleEntry.getValue();
            ExternalProject externalProject = resolverContext.getProjectModel(projectModel, ExternalProject.class);
            if (externalProject == null) continue;
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll(moduleNode, GradleSourceSetData.KEY)) {
                Set<String> contentRootPaths = contentRootIndex.resolveContentRoots(externalProject, (DataNode<GradleSourceSetData>)sourceSetNode);
                MutablePrefixTreeMap contentRootNodes = CanonicalPathPrefixTree.INSTANCE.createMap();
                for (String contentRootPath : contentRootPaths) {
                    ContentRootData contentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, contentRootPath);
                    contentRootNodes.put((Object)contentRootPath, (Object)contentRootData);
                }
                for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)sourceSetNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                    for (ExternalSystemSourceType sourceRootType : ExternalSystemSourceType.values()) {
                        for (ContentRootData.SourceRoot sourceRoot : ((ContentRootData)contentRootNode.getData()).getPaths(sourceRootType)) {
                            String sourceRootPath = sourceRoot.getPath();
                            String packagePrefix = sourceRoot.getPackagePrefix();
                            ContentRootData contentRootData = (ContentRootData)ContainerUtil.getLastItem((List)contentRootNodes.getAncestorValues((Object)sourceRootPath));
                            contentRootData.storePath(sourceRootType, sourceRootPath, packagePrefix);
                        }
                    }
                    contentRootNode.clear(true);
                }
                for (ContentRootData contentRootData : contentRootNodes.values()) {
                    sourceSetNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)contentRootData);
                }
            }
        }
    }

    private static void mergeSourceSetContentRootsInModulePerProjectMode(@NotNull ProjectResolverContext resolverContext, @NotNull Map<? extends ProjectModel, DataNode<ModuleData>> moduleMap) {
        if (resolverContext == null) {
            GradleProjectResolver.$$$reportNull$$$0(45);
        }
        if (moduleMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(46);
        }
        for (Map.Entry<? extends ProjectModel, DataNode<ModuleData>> moduleEntry : moduleMap.entrySet()) {
            ProjectModel projectModel = moduleEntry.getKey();
            DataNode<ModuleData> moduleNode = moduleEntry.getValue();
            ExternalProject externalProject = resolverContext.getProjectModel(projectModel, ExternalProject.class);
            if (externalProject == null) continue;
            String projectRootPath = NioPathUtil.toCanonicalPath((Path)externalProject.getProjectDir().toPath());
            ContentRootData projectContentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, projectRootPath);
            ArrayList<ContentRootData> externalContentRootNodes = new ArrayList<ContentRootData>();
            for (DataNode contentRootNode : ExternalSystemApiUtil.findAll(moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                for (ExternalSystemSourceType sourceRootType : ExternalSystemSourceType.values()) {
                    for (ContentRootData.SourceRoot sourceRoot : ((ContentRootData)contentRootNode.getData()).getPaths(sourceRootType)) {
                        String sourceRootPath = sourceRoot.getPath();
                        String packagePrefix = sourceRoot.getPackagePrefix();
                        if (FileUtil.isAncestor((String)projectRootPath, (String)sourceRootPath, (boolean)false)) {
                            projectContentRootData.storePath(sourceRootType, sourceRootPath, packagePrefix);
                            continue;
                        }
                        ContentRootData externalContentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, sourceRootPath);
                        externalContentRootData.storePath(sourceRootType, sourceRootPath, packagePrefix);
                        externalContentRootNodes.add(externalContentRootData);
                    }
                }
                contentRootNode.clear(true);
            }
            moduleNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)projectContentRootData);
            for (ContentRootData externalContentRootData : externalContentRootNodes) {
                moduleNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)externalContentRootData);
            }
        }
    }

    private static Throwable extractCause(Throwable e) {
        if (e instanceof BuildActionFailureException) {
            return GradleProjectResolver.extractCause(e.getCause());
        }
        Class<?> exceptionClass = e.getClass();
        if (exceptionClass.getName().equals(ProjectConfigurationException.class.getName())) {
            try {
                List causes = (List)exceptionClass.getMethod("getCauses", new Class[0]).invoke((Object)e, new Object[0]);
                return (Throwable)causes.get(0);
            }
            catch (Throwable ignore) {
                return e;
            }
        }
        return e;
    }

    @ApiStatus.Experimental
    public static GradleProjectResolverExtension createProjectResolverChain() {
        return GradleProjectResolver.createProjectResolverChain(null);
    }

    @NotNull
    private static GradleProjectResolverExtension createProjectResolverChain(@Nullable DefaultProjectResolverContext resolverContext) {
        GradleProjectResolverExtension firstResolver;
        Predicate<GradleProjectResolverExtension> extensionsFilter = resolverContext == null ? __ -> true : (resolverContext.getPolicy() == null ? __ -> true : resolverContext.getPolicy().getExtensionsFilter());
        Stream<GradleProjectResolverExtension> extensions = GradleProjectResolverUtil.createProjectResolvers(resolverContext).filter(extensionsFilter.or(BaseResolverExtension.class::isInstance));
        ArrayDeque deque = new ArrayDeque();
        extensions.forEachOrdered(extension -> {
            GradleProjectResolverExtension previous = (GradleProjectResolverExtension)deque.peekLast();
            if (previous != null) {
                previous.setNext((GradleProjectResolverExtension)extension);
                if (previous.getNext() != extension) {
                    throw new AssertionError((Object)("Illegal next resolver got, current resolver class is " + previous.getClass().getName()));
                }
            }
            deque.add(extension);
        });
        GradleProjectResolverExtension resolverExtension = firstResolver = (GradleProjectResolverExtension)deque.peekFirst();
        assert (resolverExtension != null);
        while (resolverExtension.getNext() != null) {
            resolverExtension = resolverExtension.getNext();
        }
        if (!(resolverExtension instanceof BaseResolverExtension)) {
            throw new AssertionError((Object)("Illegal last resolver got of class " + resolverExtension.getClass().getName()));
        }
        AbstractProjectResolverExtension chainWrapper = new AbstractProjectResolverExtension(){

            @Override
            @NotNull
            public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
                if (error == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (projectPath == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExternalSystemException friendlyError = super.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
                ExternalSystemException externalSystemException = new BaseProjectImportErrorHandler().checkErrorsWithoutQuickFixes(buildEnvironment, error, projectPath, buildFilePath, friendlyError);
                if (externalSystemException == null) {
                    1.$$$reportNull$$$0(2);
                }
                return externalSystemException;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectPath";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUserFriendlyError";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getUserFriendlyError";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        chainWrapper.setNext(firstResolver);
        AbstractProjectResolverExtension abstractProjectResolverExtension = chainWrapper;
        if (abstractProjectResolverExtension == null) {
            GradleProjectResolver.$$$reportNull$$$0(47);
        }
        return abstractProjectResolverExtension;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 17, 23, 24, 29, 30, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncTaskId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 20: 
            case 26: 
            case 27: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverChain";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 14: 
            case 17: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracedResolverChain";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverChain";
                break;
            }
            case 19: 
            case 21: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionSettings";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleUserHomeDir";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 42: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProjectInfo";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "convertData";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCollectedModules";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "exposeCompositeBuild";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectResolverChain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cancelTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeCancellable";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeProjectResolverTask";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doResolveProjectInfo";
                break;
            }
            case 14: 
            case 17: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 47: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "convertData";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createModuleData";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractCollectedModules";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "configureExecutionArgumentsAndVmOptions";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "exposeCompositeBuild";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "mergeLibraryAndModuleDependencyData";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "extractExternalProjectModels";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "replicateBuildModelHierarchyInExternalProjectHierarchy";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "replicateProjectModelHierarchyInExternalProjectHierarchy";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "associateSourceSetModelsWithExternalProjects";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "associateSourceSetDependencyModelsWithSourceSetModels";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "registerInheritedTaskModelsInParentTaskModel";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "associateTaskModelsWithExternalProjects";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "mergeSourceSetContentRoots";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "mergeSourceSetContentRootsInModulePerSourceSetMode";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "mergeSourceSetContentRootsInModulePerProjectMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 17, 23, 24, 29, 30, 47 -> new IllegalStateException(string);
        };
    }
}

