/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.util.cmd.GradleCommandLineOptionParser;
import org.jetbrains.plugins.gradle.util.cmd.GradleCommandLineTokenizer;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOption;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineParser;", "", "tokenizer", "Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineTokenizer;", "<init>", "(Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineTokenizer;)V", "optionParser", "Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineOptionParser;", "taskOptionParser", "parse", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLine;", "parseTask", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineTask;", "Companion", "intellij.gradle"})
@ApiStatus.Internal
public final class GradleCommandLineParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleCommandLineTokenizer tokenizer;
    @NotNull
    private final GradleCommandLineOptionParser optionParser;
    @NotNull
    private final GradleCommandLineOptionParser taskOptionParser;
    @NotNull
    private static final List<Option> ALL_OPTIONS;
    private static final Collection<Option> ALL_TASK_OPTIONS;

    public GradleCommandLineParser(@NotNull GradleCommandLineTokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.tokenizer = tokenizer;
        this.optionParser = new GradleCommandLineOptionParser((Collection<? extends Option>)ALL_OPTIONS, this.tokenizer);
        Collection<Option> collection = ALL_TASK_OPTIONS;
        Intrinsics.checkNotNullExpressionValue(collection, (String)"ALL_TASK_OPTIONS");
        this.taskOptionParser = new GradleCommandLineOptionParser(collection, this.tokenizer);
    }

    @NotNull
    public final GradleCommandLine parse() {
        ArrayList<GradleCommandLineTask> tasks2 = new ArrayList<GradleCommandLineTask>();
        ArrayList<GradleCommandLineOption> options = new ArrayList<GradleCommandLineOption>();
        while (!this.tokenizer.isEof()) {
            while (!this.tokenizer.isEof() && this.optionParser.tryParseOption() != null) {
                GradleCommandLineOption option;
                options.add(option);
            }
            if (this.tokenizer.isEof()) continue;
            tasks2.add(this.parseTask());
        }
        return new GradleCommandLine((List<GradleCommandLineTask>)tasks2, (List<? extends GradleCommandLineOption>)options);
    }

    private final GradleCommandLineTask parseTask() {
        String name = this.tokenizer.expected();
        ArrayList<GradleCommandLineOption> options = new ArrayList<GradleCommandLineOption>();
        while (!this.tokenizer.isEof() && this.taskOptionParser.tryParseOption() != null) {
            GradleCommandLineOption option;
            options.add(option);
        }
        return new GradleCommandLineTask(name, (List<? extends GradleCommandLineOption>)options);
    }

    static {
        Collection collection = GradleCommandLineOptionsProvider.OPTIONS.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOptions(...)");
        Collection collection2 = GradleCommandLineOptionsProvider.UNSUPPORTED_OPTIONS.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getOptions(...)");
        ALL_OPTIONS = CollectionsKt.plus((Collection)collection, (Iterable)collection2);
        ALL_TASK_OPTIONS = GradleCommandLineOptionsProvider.TASK_OPTIONS.getOptions();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\b\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineParser$Companion;", "", "<init>", "()V", "ALL_OPTIONS", "", "Lorg/apache/commons/cli/Option;", "kotlin.jvm.PlatformType", "ALL_TASK_OPTIONS", "", "", "Ljava/util/Collection;", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

