/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr.thirdparty;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.gdpr.ConfirmedConsent;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentAttributes;
import com.intellij.ide.gdpr.ConsentBase;
import com.intellij.ide.gdpr.DataSharingSettingsChangeListener;
import com.intellij.ide.gdpr.Version;
import com.intellij.ide.gdpr.thirdparty.PathsKt;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
final class ThirdPartyConsentOptions
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(ThirdPartyConsentOptions.class);
    private static final String CONSENTS_CONFIRMATION_PROPERTY = "jb.consents.confirmation.enabled";
    private static final String RECONFIRM_CONSENTS_PROPERTY = "test.force.reconfirm.consents";
    private static final String STATISTICS_OPTION_ID = "rsch.send.usage.stat";
    private static final String EAP_FEEDBACK_OPTION_ID = "eap";
    private static final String AI_DATA_COLLECTION_OPTION_ID = "ai.data.collection.and.use.policy";
    private static final Set<String> PER_PRODUCT_CONSENTS = Set.of("eap");
    private final BooleanSupplier myIsEap;
    private String myProductCode;
    private Set<String> myPluginCodes = Set.of();
    private final AtomicLong myModificationCount = new AtomicLong();
    private final IOBackend myBackend;

    public long getModificationCount() {
        return this.myModificationCount.get();
    }

    @NotNull
    private static Path getDefaultConsentsFile() {
        Path path = PathsKt.getJetBrainsCommonDataPath().resolve(ApplicationNamesInfo.getInstance().getLowercaseProductName()).resolve("consentOptions/cached");
        if (path == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(0);
        }
        return path;
    }

    @NotNull
    private static Path getConfirmedConsentsFile() {
        Path path = PathsKt.getJetBrainsCommonDataPath().resolve("consentOptions/accepted");
        if (path == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(1);
        }
        return path;
    }

    private static Locale getCurrentLocale() {
        return LocalizationUtil.INSTANCE.getLocale();
    }

    private static Locale getDefaultLocale() {
        return LocalizationUtil.INSTANCE.getDefaultLocale();
    }

    ThirdPartyConsentOptions(IOBackend backend, boolean isEap) {
        this.myBackend = backend;
        this.myIsEap = () -> isEap;
    }

    ThirdPartyConsentOptions(IOBackend backend) {
        this.myBackend = backend;
        this.myIsEap = () -> false;
    }

    public static ThirdPartyConsentOptions getInstance() {
        return InstanceHolder.ourInstance;
    }

    public static boolean needToShowUsageStatsConsent() {
        return (Boolean)ThirdPartyConsentOptions.getInstance().getConsents(ThirdPartyConsentOptions.condUsageStatsConsent()).getSecond();
    }

    public boolean isEAP() {
        return this.myIsEap.getAsBoolean();
    }

    public void setProductCode(String platformCode, Iterable<String> pluginCodes) {
        this.myProductCode = platformCode != null ? platformCode.toLowerCase(ThirdPartyConsentOptions.getDefaultLocale()) : null;
        HashSet<String> codes = new HashSet<String>();
        for (String pluginCode : pluginCodes) {
            codes.add(pluginCode.toLowerCase(ThirdPartyConsentOptions.getDefaultLocale()));
        }
        this.myPluginCodes = codes.isEmpty() ? Set.of() : Collections.unmodifiableSet(codes);
    }

    @Nullable
    public Consent getDefaultUsageStatsConsent() {
        return this.getDefaultConsent(STATISTICS_OPTION_ID);
    }

    boolean isUsageStatsConsent(@NotNull Consent consent) {
        if (consent == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(2);
        }
        return STATISTICS_OPTION_ID.equals(consent.getId());
    }

    @NotNull
    public static Predicate<Consent> condUsageStatsConsent() {
        Predicate<Consent> predicate = consent -> STATISTICS_OPTION_ID.equals(consent.getId());
        if (predicate == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(3);
        }
        return predicate;
    }

    @NotNull
    public static Predicate<Consent> condEAPFeedbackConsent() {
        Predicate<Consent> predicate = consent -> ThirdPartyConsentOptions.isProductConsentOfKind(EAP_FEEDBACK_OPTION_ID, consent.getId());
        if (predicate == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(4);
        }
        return predicate;
    }

    @NotNull
    public static Predicate<Consent> condAiDataCollectionConsent() {
        Predicate<Consent> predicate = consent -> AI_DATA_COLLECTION_OPTION_ID.equals(consent.getId());
        if (predicate == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(5);
        }
        return predicate;
    }

    public Permission isSendingUsageStatsAllowed() {
        return this.getPermission(STATISTICS_OPTION_ID);
    }

    public boolean setSendingUsageStatsAllowed(boolean allowed) {
        return this.setPermission(STATISTICS_OPTION_ID, allowed);
    }

    public Permission isEAPFeedbackAllowed() {
        return this.getPermission(EAP_FEEDBACK_OPTION_ID);
    }

    public boolean setEAPFeedbackAllowed(boolean allowed) {
        return this.setPermission(EAP_FEEDBACK_OPTION_ID, allowed);
    }

    @NotNull
    public Permission getAiDataCollectionPermission() {
        return this.getPermission(AI_DATA_COLLECTION_OPTION_ID);
    }

    public void setAiDataCollectionPermission(boolean permitted) {
        this.setPermission(AI_DATA_COLLECTION_OPTION_ID, permitted);
    }

    @NotNull
    private Permission getPermission(String consentId) {
        ConfirmedConsent confirmedConsent = this.getConfirmedConsent(consentId);
        Permission permission = confirmedConsent == null ? Permission.UNDEFINED : (confirmedConsent.isAccepted() ? Permission.YES : Permission.NO);
        if (permission == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(6);
        }
        return permission;
    }

    private boolean setPermission(String consentId, boolean allowed) {
        Consent defConsent = this.getDefaultConsent(consentId);
        if (defConsent != null && !defConsent.isDeleted()) {
            this.setConsents(Collections.singleton(defConsent.derive(allowed)));
            return true;
        }
        return false;
    }

    private String lookupConsentID(String consentId) {
        String productCode = this.myProductCode;
        return productCode != null && PER_PRODUCT_CONSENTS.contains(consentId) ? consentId + "." + productCode : consentId;
    }

    @Nullable
    public String getConfirmedConsentsString() {
        Map<String, Map<Locale, Consent>> defaults = this.loadDefaultConsents();
        if (!defaults.isEmpty()) {
            String str = ThirdPartyConsentOptions.confirmedConsentToExternalString(this.loadConfirmedConsents().values().stream().filter(c -> {
                Consent def;
                Map defaultConsents = (Map)defaults.get(c.getId());
                Consent consent = def = defaultConsents != null ? (Consent)defaultConsents.get(ThirdPartyConsentOptions.getDefaultLocale()) : null;
                if (def != null) {
                    return !def.isDeleted();
                }
                for (String prefix : PER_PRODUCT_CONSENTS) {
                    if (!ThirdPartyConsentOptions.isProductConsentOfKind(prefix, c.getId())) continue;
                    return true;
                }
                return false;
            }));
            return str.isBlank() ? null : str;
        }
        return null;
    }

    public void applyServerUpdates(@Nullable String json) {
        if (json == null || json.isBlank()) {
            return;
        }
        try {
            Map<String, ConfirmedConsent> confirmed;
            Collection<ConsentAttributes> fromServer = this.fromJson(json);
            @NotNull Map<String, Map<Locale, Consent>> defaults = this.loadDefaultConsents();
            if (ThirdPartyConsentOptions.applyServerChangesToDefaults(defaults, fromServer)) {
                this.myBackend.writeDefaultConsents(this.consentsToJson(defaults.values().stream().flatMap(it -> it.values().stream())));
            }
            if (ThirdPartyConsentOptions.applyServerChangesToConfirmedConsents(confirmed = this.loadConfirmedConsents(), fromServer)) {
                this.myBackend.writeConfirmedConsents(ThirdPartyConsentOptions.confirmedConsentToExternalString(confirmed.values().stream()));
            }
            this.notifyConsentsUpdated();
        }
        catch (Exception e) {
            LOG.info("Unable to apply server consents", (Throwable)e);
        }
    }

    @NotNull
    public Pair<List<Consent>, Boolean> getConsents() {
        Pair<List<Consent>, Boolean> pair = this.getConsents(consent -> true);
        if (pair == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @NotNull
    public Pair<List<Consent>, Boolean> getConsents(@NotNull Predicate<? super Consent> filter) {
        if (filter == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(8);
        }
        Map<String, Map<Locale, Consent>> allDefaults = this.loadDefaultConsents();
        if (this.isEAP()) {
            allDefaults.remove(STATISTICS_OPTION_ID);
        } else {
            allDefaults.remove(this.lookupConsentID(EAP_FEEDBACK_OPTION_ID));
        }
        Iterator<Map.Entry<String, Map<Locale, Consent>>> it = allDefaults.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map<Locale, Consent>> entry = it.next();
            Consent consent = entry.getValue().get(ThirdPartyConsentOptions.getDefaultLocale());
            if (consent == null || filter.test((Consent)consent)) continue;
            it.remove();
        }
        if (allDefaults.isEmpty()) {
            return new Pair(Collections.emptyList(), (Object)Boolean.FALSE);
        }
        Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
        ArrayList<Consent> result = new ArrayList<Consent>();
        for (Map.Entry entry : allDefaults.entrySet()) {
            Consent base = (Consent)((Map)entry.getValue()).get(ThirdPartyConsentOptions.getDefaultLocale());
            Consent localized = (Consent)((Map)entry.getValue()).get(ThirdPartyConsentOptions.getCurrentLocale());
            if (base == null || base.isDeleted()) continue;
            ConfirmedConsent confirmed = allConfirmed.get(base.getId());
            Consent consent = localized == null || base.getVersion().isNewer(localized.getVersion()) ? base : localized;
            result.add(confirmed == null ? consent : consent.derive(confirmed.isAccepted()));
        }
        result.sort(Comparator.comparing(ConsentBase::getId));
        boolean confirmationEnabled = Boolean.parseBoolean(System.getProperty(CONSENTS_CONFIRMATION_PROPERTY, "true"));
        return new Pair(result, (Object)(confirmationEnabled && this.needReconfirm(allDefaults, allConfirmed) ? 1 : 0));
    }

    public void setConsents(@NotNull Collection<Consent> confirmedByUser) {
        List<ConfirmedConsent> result;
        if (confirmedByUser == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(9);
        }
        if (confirmedByUser.isEmpty()) {
            result = Collections.emptyList();
        } else {
            ArrayList<ConfirmedConsent> list = new ArrayList<ConfirmedConsent>(confirmedByUser.size());
            for (Consent t : confirmedByUser) {
                String idPrefix;
                list.add(new ConfirmedConsent(t.getId(), t.getVersion(), t.isAccepted(), 0L));
                if (this.myPluginCodes.isEmpty() || (idPrefix = ThirdPartyConsentOptions.getProductConsentKind(this.myProductCode, t.getId())) == null || !PER_PRODUCT_CONSENTS.contains(idPrefix)) continue;
                for (String pluginCode : this.myPluginCodes) {
                    list.add(new ConfirmedConsent(idPrefix + "." + pluginCode, t.getVersion(), t.isAccepted(), 0L));
                }
            }
            result = list;
        }
        this.saveConfirmedConsents(result);
    }

    @Nullable
    private Consent getDefaultConsent(String consentId) {
        Map<String, Map<Locale, Consent>> defaultConsents = this.loadDefaultConsents();
        Map<Locale, Consent> consentMap = defaultConsents.get(consentId);
        Consent defaultConsent = consentMap.get(ThirdPartyConsentOptions.getDefaultLocale());
        if (defaultConsent == null) {
            return null;
        }
        Consent localizedConsent = consentMap.get(ThirdPartyConsentOptions.getCurrentLocale());
        return localizedConsent == null || defaultConsent.getVersion().isNewer(localizedConsent.getVersion()) ? defaultConsent : localizedConsent;
    }

    @Nullable
    private ConfirmedConsent getConfirmedConsent(String consentId) {
        Consent defConsent = this.getDefaultConsent(consentId);
        if (defConsent != null && defConsent.isDeleted()) {
            return null;
        }
        return this.loadConfirmedConsents().get(defConsent != null ? defConsent.getId() : this.lookupConsentID(consentId));
    }

    private void saveConfirmedConsents(@NotNull Collection<ConfirmedConsent> updates) {
        if (updates == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(10);
        }
        if (!updates.isEmpty()) {
            try {
                Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
                long stamp = System.currentTimeMillis();
                for (ConfirmedConsent consent : updates) {
                    consent.setAcceptanceTime(stamp);
                    allConfirmed.put(consent.getId(), consent);
                }
                this.myBackend.writeConfirmedConsents(ThirdPartyConsentOptions.confirmedConsentToExternalString(allConfirmed.values().stream()));
                this.notifyConsentsUpdated();
            }
            catch (IOException e) {
                LOG.info("Unable to save confirmed consents", (Throwable)e);
            }
        }
    }

    public boolean needsReconfirm(Consent consent) {
        Version defaultVersion;
        if (consent == null || consent.isDeleted() || this.isEAP() && STATISTICS_OPTION_ID.equals(consent.getId())) {
            return false;
        }
        ConfirmedConsent confirmedConsent = this.loadConfirmedConsents().get(consent.getId());
        if (confirmedConsent == null) {
            return true;
        }
        Version confirmedVersion = confirmedConsent.getVersion();
        return confirmedVersion.isOlder(defaultVersion = consent.getVersion()) && confirmedVersion.getMajor() != defaultVersion.getMajor();
    }

    private boolean needReconfirm(Map<String, Map<Locale, Consent>> defaults, Map<String, ConfirmedConsent> confirmed) {
        for (Map<Locale, Consent> consents : defaults.values()) {
            Consent defConsent = consents.get(ThirdPartyConsentOptions.getDefaultLocale());
            if (defConsent == null || defConsent.isDeleted()) continue;
            ConfirmedConsent confirmedConsent = confirmed.get(defConsent.getId());
            if (confirmedConsent == null) {
                return true;
            }
            String consentId = ThirdPartyConsentOptions.getProductConsentKind(this.myProductCode, defConsent.getId());
            if (consentId != null && PER_PRODUCT_CONSENTS.contains(consentId)) {
                for (String pluginCode : this.myPluginCodes) {
                    ConfirmedConsent pluginConfirmedConsent = confirmed.get(consentId + "." + pluginCode);
                    if (pluginConfirmedConsent != null) continue;
                    return true;
                }
            }
            Version confirmedVersion = confirmedConsent.getVersion();
            Version defaultVersion = defConsent.getVersion();
            if (Boolean.getBoolean(RECONFIRM_CONSENTS_PROPERTY)) {
                return true;
            }
            if (!confirmedVersion.isOlder(defaultVersion) || confirmedVersion.getMajor() == defaultVersion.getMajor()) continue;
            return true;
        }
        return false;
    }

    private static boolean applyServerChangesToConfirmedConsents(Map<String, ConfirmedConsent> base, Collection<ConsentAttributes> fromServer) {
        boolean changes = false;
        for (ConsentAttributes update : fromServer) {
            ConfirmedConsent change;
            ConfirmedConsent current = base.get(update.consentId);
            if (current == null || (change = new ConfirmedConsent(update)).getVersion().isOlder(current.getVersion()) || current.getAcceptanceTime() >= update.acceptanceTime) continue;
            base.put(change.getId(), change);
            changes = true;
        }
        return changes;
    }

    private static boolean applyServerChangesToDefaults(@NotNull Map<String, Map<Locale, Consent>> base, @NotNull Collection<ConsentAttributes> fromServer) {
        if (base == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(11);
        }
        if (fromServer == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(12);
        }
        boolean changes = false;
        for (ConsentAttributes update : fromServer) {
            Consent newConsent = new Consent(update);
            Map<Locale, Consent> current = base.get(newConsent.getId());
            if (current == null) {
                base.put(newConsent.getId(), Map.of(Locale.forLanguageTag(newConsent.getLocale()), newConsent));
                return true;
            }
            Locale newConsentLocale = newConsent.getLocale() != null && !newConsent.getLocale().isEmpty() ? Locale.forLanguageTag(newConsent.getLocale()) : ThirdPartyConsentOptions.getDefaultLocale();
            Consent consent = current.get(newConsentLocale);
            if (consent == null && newConsentLocale != ThirdPartyConsentOptions.getDefaultLocale()) {
                newConsentLocale = ThirdPartyConsentOptions.getDefaultLocale();
                consent = current.get(newConsentLocale);
            }
            if (consent == null || newConsent.isDeleted() || !newConsent.getVersion().isNewer(consent.getVersion())) continue;
            base.get(newConsent.getId()).put(newConsentLocale, newConsent);
            changes = true;
        }
        return changes;
    }

    @NotNull
    private Collection<ConsentAttributes> fromJson(@Nullable String json) {
        List list;
        if (json == null || json.isEmpty()) {
            List<ConsentAttributes> list2 = Collections.emptyList();
            if (list2 == null) {
                ThirdPartyConsentOptions.$$$reportNull$$$0(13);
            }
            return list2;
        }
        try {
            List data = ConsentAttributes.Companion.readListFromJson(json);
            for (ConsentAttributes attributes : data) {
                attributes.consentId = this.lookupConsentID(attributes.consentId);
            }
            list = data;
        }
        catch (Throwable e) {
            LOG.info(e);
            List<ConsentAttributes> list3 = Collections.emptyList();
            if (list3 == null) {
                ThirdPartyConsentOptions.$$$reportNull$$$0(15);
            }
            return list3;
        }
        if (list == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private String consentsToJson(@NotNull Stream<Consent> consents) {
        if (consents == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(16);
        }
        String string = ConsentAttributes.Companion.writeListToJson(consents.map(consent -> {
            ConsentAttributes attribs = consent.toConsentAttributes();
            String prefix = ThirdPartyConsentOptions.getProductConsentKind(this.myProductCode, attribs.consentId);
            if (prefix != null) {
                attribs.consentId = prefix;
            }
            return attribs;
        }).toList());
        if (string == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String confirmedConsentToExternalString(@NotNull Stream<ConfirmedConsent> consents) {
        if (consents == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(18);
        }
        String string = consents.map(ConfirmedConsent::toExternalString).collect(Collectors.joining(";"));
        if (string == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private Map<String, Map<Locale, Consent>> loadDefaultConsents() {
        HashMap<String, Map<Locale, Consent>> result = new HashMap<String, Map<Locale, Consent>>();
        Collection<ConsentAttributes> localizedConsentAttributes = this.fromJson(this.myBackend.readLocalizedBundledConsents());
        for (ConsentAttributes attributes : this.fromJson(this.myBackend.readBundledConsents())) {
            HashMap<Locale, Consent> map = new HashMap<Locale, Consent>();
            map.put(ThirdPartyConsentOptions.getDefaultLocale(), new Consent(attributes));
            localizedConsentAttributes.stream().filter(it -> Objects.equals(it.consentId, attributes.consentId)).findFirst().ifPresent(localizedAttributes -> map.put(ThirdPartyConsentOptions.getCurrentLocale(), new Consent(localizedAttributes)));
            result.put(attributes.consentId, map);
        }
        try {
            ThirdPartyConsentOptions.applyServerChangesToDefaults(result, this.fromJson(this.myBackend.readDefaultConsents()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, Map<Locale, Consent>> hashMap = result;
        if (hashMap == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    @NotNull
    private Map<String, ConfirmedConsent> loadConfirmedConsents() {
        HashMap<String, ConfirmedConsent> result = new HashMap<String, ConfirmedConsent>();
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.myBackend.readConfirmedConsents(), ";", false);
            while (tokenizer.hasMoreTokens()) {
                ConfirmedConsent consent = ConfirmedConsent.fromString((String)tokenizer.nextToken());
                if (consent == null) continue;
                result.put(consent.getId(), consent);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, ConfirmedConsent> hashMap = result;
        if (hashMap == null) {
            ThirdPartyConsentOptions.$$$reportNull$$$0(21);
        }
        return hashMap;
    }

    private static boolean isProductConsentOfKind(String consentKind, String consentId) {
        return consentKind != null && consentId.startsWith(consentKind) && (consentId.length() == consentKind.length() || consentId.charAt(consentKind.length()) == '.');
    }

    private static String getProductConsentKind(String productCode, String consentId) {
        if (productCode != null && consentId.endsWith(productCode) && (consentId.length() == productCode.length() || consentId.charAt(consentId.length() - productCode.length() - 1) == '.')) {
            return consentId.substring(0, consentId.length() - productCode.length() - 1);
        }
        return null;
    }

    private void notifyConsentsUpdated() {
        this.myModificationCount.incrementAndGet();
        if (LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            ((DataSharingSettingsChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DataSharingSettingsChangeListener.TOPIC)).consentsUpdated();
        }
    }

    @TestOnly
    @NotNull
    public static Path getDefaultConsentsFileForTests() {
        return ThirdPartyConsentOptions.getDefaultConsentsFile();
    }

    @TestOnly
    @NotNull
    public static Path getConfirmedConsentsFileForTests() {
        return ThirdPartyConsentOptions.getConfirmedConsentsFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 8, 9, 10, 11, 12, 16, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/thirdparty/ThirdPartyConsentOptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmedByUser";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromServer";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConsentsFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfirmedConsentsFile";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/thirdparty/ThirdPartyConsentOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "condUsageStatsConsent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "condEAPFeedbackConsent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "condAiDataCollectionConsent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermission";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsents";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "fromJson";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "consentsToJson";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "confirmedConsentToExternalString";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultConsents";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfirmedConsents";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUsageStatsConsent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConsents";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setConsents";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveConfirmedConsents";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyServerChangesToDefaults";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "consentsToJson";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "confirmedConsentToExternalString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 8, 9, 10, 11, 12, 16, 18 -> new IllegalArgumentException(string);
        };
    }

    protected static interface IOBackend {
        public void writeDefaultConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readDefaultConsents() throws IOException;

        @NotNull
        public String readBundledConsents();

        @Nullable
        public String readLocalizedBundledConsents();

        public void writeConfirmedConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readConfirmedConsents() throws IOException;
    }

    private static final class InstanceHolder {
        static final ThirdPartyConsentOptions ourInstance = new ThirdPartyConsentOptions(new IOBackend(){

            @Override
            public void writeDefaultConsents(@NotNull String data) throws IOException {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                Path defaultConsentsFile = ThirdPartyConsentOptions.getDefaultConsentsFile();
                Files.createDirectories(defaultConsentsFile.getParent(), new FileAttribute[0]);
                Files.writeString(defaultConsentsFile, (CharSequence)data, new OpenOption[0]);
            }

            @Override
            @NotNull
            public String readDefaultConsents() throws IOException {
                return 1.loadText(Files.newInputStream(ThirdPartyConsentOptions.getDefaultConsentsFile(), new OpenOption[0]));
            }

            @Override
            @NotNull
            public String readBundledConsents() {
                return 1.loadText(ThirdPartyConsentOptions.class.getClassLoader().getResourceAsStream(InstanceHolder.getBundledResourcePath()));
            }

            @Override
            @Nullable
            public String readLocalizedBundledConsents() {
                if (ThirdPartyConsentOptions.getCurrentLocale() == ThirdPartyConsentOptions.getDefaultLocale()) {
                    return null;
                }
                for (String localizedPath : LocalizationUtil.INSTANCE.getLocalizedPaths(InstanceHolder.getBundledResourcePath(), ThirdPartyConsentOptions.getCurrentLocale())) {
                    String loadedText = 1.loadText(ThirdPartyConsentOptions.class.getClassLoader().getResourceAsStream(localizedPath));
                    if (loadedText.isEmpty()) continue;
                    return loadedText;
                }
                return null;
            }

            @Override
            public void writeConfirmedConsents(@NotNull String data) throws IOException {
                if (data == null) {
                    1.$$$reportNull$$$0(1);
                }
                Path confirmedConsentsFile = ThirdPartyConsentOptions.getConfirmedConsentsFile();
                Files.createDirectories(confirmedConsentsFile.getParent(), new FileAttribute[0]);
                Files.writeString(confirmedConsentsFile, (CharSequence)data, new OpenOption[0]);
                if (LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                    DataSharingSettingsChangeListener syncPublisher = (DataSharingSettingsChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DataSharingSettingsChangeListener.TOPIC);
                    syncPublisher.consentWritten();
                }
            }

            @Override
            @NotNull
            public String readConfirmedConsents() throws IOException {
                return 1.loadText(Files.newInputStream(ThirdPartyConsentOptions.getConfirmedConsentsFile(), new OpenOption[0]));
            }

            /*
             * Loose catch block
             */
            @NotNull
            private static String loadText(InputStream stream) {
                if (stream != null) {
                    String string;
                    InputStream inputStream;
                    block10: {
                        inputStream = CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
                        string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                        if (inputStream == null) break block10;
                        inputStream.close();
                    }
                    String string2 = string;
                    if (string2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string2;
                    {
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                LOG.info((Throwable)e);
                            }
                        }
                    }
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "data";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/gdpr/thirdparty/ThirdPartyConsentOptions$InstanceHolder$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/gdpr/thirdparty/ThirdPartyConsentOptions$InstanceHolder$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "loadText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "writeDefaultConsents";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "writeConfirmedConsents";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });

        private InstanceHolder() {
        }

        @NotNull
        @NonNls
        private static String getBundledResourcePath() {
            return "consents.json";
        }
    }

    public static enum Permission {
        YES,
        NO,
        UNDEFINED;

    }
}

