/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationChecker;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\t*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrFieldVisibilityChecker;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrDeclarationChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrFieldChecker;", "<init>", "()V", "JVM_FIELD_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "isExemptFromValidation", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)Z", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "ir.backend.common"})
public final class IrFieldVisibilityChecker
implements IrDeclarationChecker<IrField> {
    @NotNull
    public static final IrFieldVisibilityChecker INSTANCE = new IrFieldVisibilityChecker();
    @NotNull
    private static final ClassId JVM_FIELD_CLASS_ID = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"kotlin/jvm/JvmField", (boolean)false, (int)2, null);

    private IrFieldVisibilityChecker() {
    }

    private final boolean isExemptFromValidation(IrField $this$isExemptFromValidation) {
        Object object = $this$isExemptFromValidation.getCorrespondingPropertySymbol();
        return (object != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isConst() : false) || IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isExemptFromValidation, JVM_FIELD_CLASS_ID);
    }

    @Override
    public void check(@NotNull IrField declaration, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Intrinsics.areEqual((Object)declaration.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && !this.isExemptFromValidation(declaration)) {
            context.error(declaration, "Kotlin fields are expected to always be private");
        }
    }
}

