/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004QRSTB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ&\u00106\u001a\b\u0018\u000107R\u00020\u00002\u0006\u00108\u001a\u0002002\b\u00109\u001a\u0004\u0018\u00010\b2\u0006\u0010:\u001a\u00020!J\u0014\u0010;\u001a\u00020\b2\n\u0010<\u001a\u000607R\u00020\u0000H\u0002J0\u00106\u001a\b\u0018\u000107R\u00020\u00002\u0006\u00108\u001a\u0002002\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0>2\u0006\u0010:\u001a\u00020!J0\u0010?\u001a\b\u0018\u00010@R\u00020\u00002\u0006\u00108\u001a\u0002002\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0>2\u0006\u0010:\u001a\u00020!J<\u0010?\u001a\b\u0018\u00010@R\u00020\u00002\u0006\u00108\u001a\u0002002\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0>2\b\u0010A\u001a\u0004\u0018\u00010\b2\u0006\u0010:\u001a\u00020!H\u0002J&\u0010B\u001a\b\u0018\u00010CR\u00020\u00002\u0006\u00108\u001a\u0002002\b\u0010A\u001a\u0004\u0018\u00010\b2\u0006\u0010:\u001a\u00020!J\u0016\u0010D\u001a\b\u0018\u00010,R\u00020\u00002\u0006\u00108\u001a\u000200H\u0002J\u001c\u0010E\u001a\u00020F2\u0006\u00109\u001a\u0002002\n\u0010G\u001a\u00060,R\u00020\u0000H\u0002JO\u0010H\u001a\u0004\u0018\u0001HI\"\f\b\u0000\u0010I*\u00060,R\u00020\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HI0K2\"\u0010L\u001a\u001e\u0012\b\u0012\u00060,R\u00020\u0000\u0018\u00010+j\u000e\u0012\b\u0012\u00060,R\u00020\u0000\u0018\u0001`.H\u0002\u00a2\u0006\u0002\u0010MJS\u0010H\u001a\u0004\u0018\u0001HI\"\f\b\u0000\u0010I*\u00060,R\u00020\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HI0K2\u0012\u0010L\u001a\u000e\u0012\b\u0012\u00060,R\u00020\u0000\u0018\u00010\u00122\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u0002HI\u0012\u0004\u0012\u00020!0OH\u0002\u00a2\u0006\u0002\u0010PR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R;\u0010)\u001a/\u0012&\u0012$\u0012\b\u0012\u00060,R\u00020\u00000+j\f\u0012\b\u0012\u00060,R\u00020\u0000`.\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b-0*\u00a2\u0006\u0002\b\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001b\u00104\u001a\f\u0012\b\u0012\u00060,R\u00020\u00000\u00128F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0014\u00a8\u0006U"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext;", "", "runConfiguration", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "myTaskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "targetFileMapper", "Ljava/util/function/Function;", "", "<init>", "(Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Ljava/util/function/Function;)V", "getRunConfiguration", "()Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "getMyTaskId", "()Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "getTargetFileMapper", "()Ljava/util/function/Function;", "projectsInReactor", "", "getProjectsInReactor", "()Ljava/util/List;", "setProjectsInReactor", "(Ljava/util/List;)V", "startedProjects", "Ljava/util/concurrent/CopyOnWriteArrayList;", "getStartedProjects", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "ideaProject", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getIdeaProject", "()Lcom/intellij/openapi/project/Project;", "sessionEnded", "", "getSessionEnded", "()Z", "setSessionEnded", "(Z)V", "projectFailure", "getProjectFailure", "setProjectFailure", "context", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Ljava/util/ArrayList;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$MavenExecutionEntry;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lkotlin/collections/ArrayList;", "lastAddedThreadId", "", "lastId", "getLastId", "()Ljava/lang/Object;", "allEntriesReversed", "getAllEntriesReversed", "getProject", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$ProjectExecutionEntry;", "threadId", "id", "create", "removeVersion", "currentProject", "parameters", "", "getMojo", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$MojoExecutionEntry;", "name", "getNode", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$NodeExecutionEntry;", "getNodeParent", "add", "", "entry", "search", "T", "klass", "Ljava/lang/Class;", "entries", "(Ljava/lang/Class;Ljava/util/ArrayList;)Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$MavenExecutionEntry;", "filter", "Lkotlin/Function1;", "(Ljava/lang/Class;Ljava/util/List;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$MavenExecutionEntry;", "ProjectExecutionEntry", "MojoExecutionEntry", "NodeExecutionEntry", "MavenExecutionEntry", "intellij.maven"})
public final class MavenParsingContext {
    @NotNull
    private final MavenRunConfiguration runConfiguration;
    @NotNull
    private final ExternalSystemTaskId myTaskId;
    @NotNull
    private final Function<String, String> targetFileMapper;
    public List<String> projectsInReactor;
    @NotNull
    private final CopyOnWriteArrayList<String> startedProjects;
    @NotNull
    private final Project ideaProject;
    private volatile boolean sessionEnded;
    private volatile boolean projectFailure;
    @NotNull
    private final ConcurrentIntObjectMap<ArrayList<MavenExecutionEntry>> context;
    private int lastAddedThreadId;

    public MavenParsingContext(@NotNull MavenRunConfiguration runConfiguration, @NotNull ExternalSystemTaskId myTaskId, @NotNull Function<String, String> targetFileMapper) {
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)myTaskId, (String)"myTaskId");
        Intrinsics.checkNotNullParameter(targetFileMapper, (String)"targetFileMapper");
        this.runConfiguration = runConfiguration;
        this.myTaskId = myTaskId;
        this.targetFileMapper = targetFileMapper;
        this.startedProjects = new CopyOnWriteArrayList();
        Project project = this.runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.ideaProject = project;
        ConcurrentIntObjectMap concurrentIntObjectMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentIntObjectMap, (String)"createConcurrentIntObjectMap(...)");
        this.context = concurrentIntObjectMap;
    }

    @NotNull
    public final MavenRunConfiguration getRunConfiguration() {
        return this.runConfiguration;
    }

    @NotNull
    public final ExternalSystemTaskId getMyTaskId() {
        return this.myTaskId;
    }

    @NotNull
    public final Function<String, String> getTargetFileMapper() {
        return this.targetFileMapper;
    }

    @NotNull
    public final List<String> getProjectsInReactor() {
        List<String> list = this.projectsInReactor;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"projectsInReactor");
        return null;
    }

    public final void setProjectsInReactor(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.projectsInReactor = list;
    }

    @NotNull
    public final CopyOnWriteArrayList<String> getStartedProjects() {
        return this.startedProjects;
    }

    @NotNull
    public final Project getIdeaProject() {
        return this.ideaProject;
    }

    public final boolean getSessionEnded() {
        return this.sessionEnded;
    }

    public final void setSessionEnded(boolean bl) {
        this.sessionEnded = bl;
    }

    public final boolean getProjectFailure() {
        return this.projectFailure;
    }

    public final void setProjectFailure(boolean bl) {
        this.projectFailure = bl;
    }

    @NotNull
    public final Object getLastId() {
        ArrayList entries = (ArrayList)this.context.get(this.lastAddedThreadId);
        return entries == null || entries.isEmpty() ? this.myTaskId : ((MavenExecutionEntry)entries.get(entries.size() - 1)).getId();
    }

    @NotNull
    public final List<MavenExecutionEntry> getAllEntriesReversed() {
        ArrayList arrayList = (ArrayList)this.context.get(this.lastAddedThreadId);
        return arrayList != null ? (List)arrayList : CollectionsKt.emptyList();
    }

    @Nullable
    public final ProjectExecutionEntry getProject(int threadId, @Nullable String id, boolean create2) {
        ProjectExecutionEntry currentProject = this.search(ProjectExecutionEntry.class, (List)this.context.get(threadId), arg_0 -> MavenParsingContext.getProject$lambda$0(id, arg_0));
        if (currentProject == null && create2) {
            String string = id;
            if (string == null) {
                string = "";
            }
            currentProject = new ProjectExecutionEntry(string, threadId);
            this.startedProjects.add(this.removeVersion(currentProject));
            this.add(threadId, currentProject);
        }
        return currentProject;
    }

    private final String removeVersion(ProjectExecutionEntry currentProject) {
        String[] stringArray = new String[]{":"};
        List splitted = StringsKt.split$default((CharSequence)currentProject.getName(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (splitted.size() < 3) {
            return currentProject.getName();
        }
        return splitted.get(0) + ":" + splitted.get(1);
    }

    @Nullable
    public final ProjectExecutionEntry getProject(int threadId, @NotNull Map<String, String> parameters, boolean create2) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return this.getProject(threadId, parameters.get("id"), create2);
    }

    @Nullable
    public final MojoExecutionEntry getMojo(int threadId, @NotNull Map<String, String> parameters, boolean create2) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return this.getMojo(threadId, parameters, parameters.get("goal"), create2);
    }

    private final MojoExecutionEntry getMojo(int threadId, Map<String, String> parameters, String name, boolean create2) {
        if (name == null) {
            return null;
        }
        MojoExecutionEntry mojo = this.search(MojoExecutionEntry.class, (List)this.context.get(threadId), arg_0 -> MavenParsingContext.getMojo$lambda$1(name, arg_0));
        if (mojo == null && create2) {
            ProjectExecutionEntry currentProject = this.getProject(threadId, parameters, false);
            mojo = new MojoExecutionEntry(name, threadId, currentProject);
            this.add(threadId, mojo);
        }
        return mojo;
    }

    @Nullable
    public final NodeExecutionEntry getNode(int threadId, @Nullable String name, boolean create2) {
        if (name == null) {
            return null;
        }
        NodeExecutionEntry node = this.search(NodeExecutionEntry.class, (List)this.context.get(threadId), arg_0 -> MavenParsingContext.getNode$lambda$2(name, arg_0));
        if (node == null && create2) {
            MavenExecutionEntry parent = this.getNodeParent(threadId);
            node = new NodeExecutionEntry(name, threadId, parent);
            this.add(threadId, node);
        }
        return node;
    }

    private final MavenExecutionEntry getNodeParent(int threadId) {
        MojoExecutionEntry mojo = this.search(MojoExecutionEntry.class, (ArrayList)this.context.get(threadId));
        if (mojo == null) {
            return this.search(ProjectExecutionEntry.class, (List)this.context.get(threadId), MavenParsingContext::getNodeParent$lambda$3);
        }
        return mojo;
    }

    private final void add(int id, MavenExecutionEntry entry) {
        ArrayList<MavenExecutionEntry> entries = (ArrayList<MavenExecutionEntry>)this.context.get(id);
        if (entries == null) {
            entries = new ArrayList<MavenExecutionEntry>();
            this.context.put(id, entries);
        }
        this.lastAddedThreadId = id;
        entries.add(entry);
    }

    private final <T extends MavenExecutionEntry> T search(Class<T> klass, ArrayList<MavenExecutionEntry> entries) {
        return this.search(klass, (List<? extends MavenExecutionEntry>)entries, MavenParsingContext::search$lambda$4);
    }

    private final <T extends MavenExecutionEntry> T search(Class<T> klass, List<? extends MavenExecutionEntry> entries, Function1<? super T, Boolean> filter) {
        if (entries == null) {
            return null;
        }
        int n = ((Collection)entries).size() + -1;
        if (0 <= n) {
            do {
                int j;
                MavenExecutionEntry entry;
                if (!klass.isAssignableFrom((entry = entries.get(j = n--)).getClass())) continue;
                Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type T of org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext.search");
                if (!((Boolean)filter.invoke((Object)entry)).booleanValue()) continue;
                return (T)entry;
            } while (0 <= n);
        }
        return null;
    }

    private static final boolean getProject$lambda$0(String $id, ProjectExecutionEntry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return $id == null || Intrinsics.areEqual((Object)e.getName(), (Object)$id);
    }

    private static final boolean getMojo$lambda$1(String $name, MojoExecutionEntry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return Intrinsics.areEqual((Object)e.getName(), (Object)$name);
    }

    private static final boolean getNode$lambda$2(String $name, NodeExecutionEntry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return Intrinsics.areEqual((Object)e.getName(), (Object)$name);
    }

    private static final boolean getNodeParent$lambda$3(ProjectExecutionEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean search$lambda$4(MavenExecutionEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010R\u0013\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$MavenExecutionEntry;", "", "name", "", "myThreadId", "", "<init>", "(Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext;Ljava/lang/String;I)V", "getName", "()Ljava/lang/String;", "id", "getId", "()Ljava/lang/Object;", "parentId", "getParentId", "complete", "", "intellij.maven"})
    public abstract class MavenExecutionEntry {
        @NotNull
        private final String name;
        private final int myThreadId;
        @NotNull
        private final Object id;

        public MavenExecutionEntry(String name, int myThreadId) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.myThreadId = myThreadId;
            this.id = new Object();
        }

        @NlsSafe
        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Object getId() {
            return this.id;
        }

        @NotNull
        public abstract Object getParentId();

        public final void complete() {
            block0: {
                ArrayList entries;
                ArrayList arrayList = entries = (ArrayList)MavenParsingContext.this.context.get(this.myThreadId);
                if (arrayList == null) break block0;
                arrayList.remove(this);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B)\b\u0000\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$MojoExecutionEntry;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$MavenExecutionEntry;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext;", "name", "", "threadId", "", "myProject", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$ProjectExecutionEntry;", "<init>", "(Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext;Ljava/lang/String;ILorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$ProjectExecutionEntry;)V", "parentId", "", "getParentId", "()Ljava/lang/Object;", "intellij.maven"})
    public final class MojoExecutionEntry
    extends MavenExecutionEntry {
        @Nullable
        private final ProjectExecutionEntry myProject;

        public MojoExecutionEntry(String name, @Nullable int threadId, ProjectExecutionEntry myProject) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, threadId);
            this.myProject = myProject;
        }

        @Override
        @NotNull
        public Object getParentId() {
            Object object = this.myProject;
            if (object == null || (object = ((MavenExecutionEntry)object).getId()) == null) {
                object = MavenParsingContext.this.getMyTaskId();
            }
            return object;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B)\b\u0000\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0018\u00010\u0001R\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0007\u001a\b\u0018\u00010\u0001R\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$NodeExecutionEntry;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$MavenExecutionEntry;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext;", "name", "", "threadId", "", "parent", "<init>", "(Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext;Ljava/lang/String;ILorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$MavenExecutionEntry;)V", "parentId", "", "getParentId", "()Ljava/lang/Object;", "intellij.maven"})
    public final class NodeExecutionEntry
    extends MavenExecutionEntry {
        @Nullable
        private final MavenExecutionEntry parent;

        public NodeExecutionEntry(String name, @Nullable int threadId, MavenExecutionEntry parent) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, threadId);
            this.parent = parent;
        }

        @Override
        @NotNull
        public Object getParentId() {
            Object object = this.parent;
            if (object == null || (object = ((MavenExecutionEntry)object).getId()) == null) {
                object = MavenParsingContext.this.getMyTaskId();
            }
            return object;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001b\b\u0000\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$ProjectExecutionEntry;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext$MavenExecutionEntry;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext;", "name", "", "threadId", "", "<init>", "(Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext;Ljava/lang/String;I)V", "parentId", "", "getParentId", "()Ljava/lang/Object;", "intellij.maven"})
    public final class ProjectExecutionEntry
    extends MavenExecutionEntry {
        public ProjectExecutionEntry(String name, int threadId) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, threadId);
        }

        @Override
        @NotNull
        public Object getParentId() {
            return MavenParsingContext.this.getMyTaskId();
        }
    }
}

