/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.compilation;

import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.registry.Registry;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.utils.MavenFilteredJarUtils;
import org.jetbrains.jps.maven.model.impl.MavenFilteredJarConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/project/compilation/FilteredJarConfigGenerator;", "", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "mavenProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "transformer", "Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory$Transformer;", "config", "Lorg/jetbrains/jps/maven/model/impl/MavenProjectConfiguration;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "<init>", "(Lcom/intellij/openapi/roots/ProjectFileIndex;Lorg/jetbrains/idea/maven/project/MavenProjectsManager;Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory$Transformer;Lorg/jetbrains/jps/maven/model/impl/MavenProjectConfiguration;Lorg/jetbrains/idea/maven/project/MavenProject;)V", "generateAdditionalJars", "", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nFilteredJarConfigGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilteredJarConfigGenerator.kt\norg/jetbrains/idea/maven/project/compilation/FilteredJarConfigGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,28:1\n1863#2,2:29\n*S KotlinDebug\n*F\n+ 1 FilteredJarConfigGenerator.kt\norg/jetbrains/idea/maven/project/compilation/FilteredJarConfigGenerator\n*L\n24#1:29,2\n*E\n"})
public final class FilteredJarConfigGenerator {
    @NotNull
    private final ProjectFileIndex fileIndex;
    @NotNull
    private final MavenProjectsManager mavenProjectsManager;
    @NotNull
    private final RemotePathTransformerFactory.Transformer transformer;
    @NotNull
    private final MavenProjectConfiguration config;
    @NotNull
    private final MavenProject mavenProject;

    public FilteredJarConfigGenerator(@NotNull ProjectFileIndex fileIndex, @NotNull MavenProjectsManager mavenProjectsManager, @NotNull RemotePathTransformerFactory.Transformer transformer, @NotNull MavenProjectConfiguration config, @NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)fileIndex, (String)"fileIndex");
        Intrinsics.checkNotNullParameter((Object)mavenProjectsManager, (String)"mavenProjectsManager");
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        this.fileIndex = fileIndex;
        this.mavenProjectsManager = mavenProjectsManager;
        this.transformer = transformer;
        this.config = config;
        this.mavenProject = mavenProject;
    }

    public final void generateAdditionalJars() {
        if (!Registry.Companion.is("maven.build.additional.jars")) {
            return;
        }
        if (Intrinsics.areEqual((Object)"pom", (Object)this.mavenProject.getPackaging())) {
            return;
        }
        Iterable $this$forEach$iv = MavenFilteredJarUtils.Companion.getAllFilteredConfigurations(this.mavenProjectsManager, this.mavenProject);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map map;
            MavenFilteredJarConfiguration jarConfig = (MavenFilteredJarConfiguration)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)this.config.jarsConfiguration, (String)"jarsConfiguration");
            map.put(jarConfig.name, jarConfig);
        }
    }
}

