/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.build.issue.BuildIssue;
import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.platform.diagnostic.telemetry.OtlpConfiguration;
import com.intellij.platform.diagnostic.telemetry.impl.agent.AgentConfiguration;
import com.intellij.platform.diagnostic.telemetry.impl.agent.TelemetryAgentProvider;
import com.intellij.platform.diagnostic.telemetry.impl.agent.TelemetryAgentResolver;
import com.intellij.platform.diagnostic.telemetry.rt.context.TelemetryContext;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.net.URI;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.MavenVersionAwareSupportExtension;
import org.jetbrains.idea.maven.MavenVersionSupportUtil;
import org.jetbrains.idea.maven.buildtool.quickfix.InstallMaven2BuildIssue;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.slf4j.Logger;
import org.slf4j.jul.JDK14LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 -2\u00020\u0001:\u0002,-B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0005H\u0014J\u001a\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050!2\b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u0004J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0016J\b\u0010*\u001a\u00020+H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006."}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerCMDState;", "Lcom/intellij/execution/configurations/CommandLineState;", "myJdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "myVmOptions", "", "myDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "myDebugPort", "", "<init>", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Lorg/jetbrains/idea/maven/server/MavenDistribution;Ljava/lang/Integer;)V", "getMyJdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getMyVmOptions", "()Ljava/lang/String;", "getMyDistribution", "()Lorg/jetbrains/idea/maven/server/MavenDistribution;", "getMyDebugPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "createJavaParameters", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "checkExtension", "", "extension", "Lorg/jetbrains/idea/maven/MavenVersionAwareSupportExtension;", "setupMainExt", "params", "getMavenOpts", "", "getWorkingDirectory", "collectRTLibraries", "", "mavenVersion", "setupMainClass", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "startProcess", "Lcom/intellij/execution/process/ProcessHandler;", "MemoryProperty", "Companion", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenServerCMDState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenServerCMDState.kt\norg/jetbrains/idea/maven/server/MavenServerCMDState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,357:1\n1557#2:358\n1628#2,3:359\n*S KotlinDebug\n*F\n+ 1 MavenServerCMDState.kt\norg/jetbrains/idea/maven/server/MavenServerCMDState\n*L\n134#1:358\n134#1:359,3\n*E\n"})
public class MavenServerCMDState
extends CommandLineState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sdk myJdk;
    @Nullable
    private final String myVmOptions;
    @NotNull
    private final MavenDistribution myDistribution;
    @Nullable
    private final Integer myDebugPort;
    @NotNull
    private static final com.intellij.openapi.diagnostic.Logger LOG;
    private static boolean setupThrowMainClass;
    @NotNull
    private static final String MAIN_CLASS_WITH_EXCEPTION_FOR_TESTS = "org.jetbrains.idea.maven.server.RemoteMavenServerThrowsExceptionForTests";

    public MavenServerCMDState(@NotNull Sdk myJdk, @Nullable String myVmOptions, @NotNull MavenDistribution myDistribution, @Nullable Integer myDebugPort) {
        Intrinsics.checkNotNullParameter((Object)myJdk, (String)"myJdk");
        Intrinsics.checkNotNullParameter((Object)myDistribution, (String)"myDistribution");
        super(null);
        this.myJdk = myJdk;
        this.myVmOptions = myVmOptions;
        this.myDistribution = myDistribution;
        this.myDebugPort = myDebugPort;
    }

    @NotNull
    protected final Sdk getMyJdk() {
        return this.myJdk;
    }

    @Nullable
    protected final String getMyVmOptions() {
        return this.myVmOptions;
    }

    @NotNull
    protected final MavenDistribution getMyDistribution() {
        return this.myDistribution;
    }

    @Nullable
    protected final Integer getMyDebugPort() {
        return this.myDebugPort;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected SimpleJavaParameters createJavaParameters() {
        String mavenEmbedderCliOptions;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String profilerOption;
        if (!this.myDistribution.isValid()) {
            MavenLog.LOG.warn("Maven Distribution " + this.myDistribution + " is not valid");
            throw new IllegalArgumentException("Maven distribution at " + this.myDistribution.getMavenHome().toAbsolutePath() + " is not valid");
        }
        SimpleJavaParameters params = new SimpleJavaParameters();
        params.setJdk(this.myJdk);
        params.setWorkingDirectory(this.getWorkingDirectory());
        HashMap<String, String> defs = new HashMap<String, String>(this.getMavenOpts());
        MavenServerCMDState.Companion.configureSslRelatedOptions(defs);
        defs.put("java.awt.headless", "true");
        Iterator<Map.Entry<String, String>> iterator = defs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> each;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            params.getVMParametersList().defineProperty(each.getKey(), each.getValue());
        }
        params.getVMParametersList().addProperty("maven.defaultProjectBuilder.disableGlobalModelCache", "true");
        if (this.myDebugPort != null) {
            params.getVMParametersList().addParametersString("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=*:" + this.myDebugPort);
            params.getProgramParametersList().add("runWithDebugger");
        }
        params.getVMParametersList().addProperty("maven.defaultProjectBuilder.disableGlobalModelCache", "true");
        if (Registry.Companion.is("maven.collect.local.stat")) {
            params.getVMParametersList().addProperty("maven.collect.local.stat", "true");
        }
        if (Registry.Companion.is("maven.delegate.trust.ssl.to.ide")) {
            params.getVMParametersList().addProperty("delegate.ssl.to.ide", "true");
        }
        if ((profilerOption = MavenServerCMDState.Companion.getProfilerVMString()) != null) {
            params.getVMParametersList().addParametersString(profilerOption);
        }
        Object xmxProperty = null;
        String xmsProperty = null;
        if (this.myVmOptions != null) {
            ParametersList mavenOptsList = new ParametersList();
            mavenOptsList.addParametersString(this.myVmOptions);
            for (String param : mavenOptsList.getParameters()) {
                Intrinsics.checkNotNull((Object)param);
                if (StringsKt.startsWith$default((String)param, (String)"-Xmx", (boolean)false, (int)2, null)) {
                    xmxProperty = param;
                    continue;
                }
                if (StringsKt.startsWith$default((String)param, (String)"-Xms", (boolean)false, (int)2, null)) {
                    xmsProperty = param;
                    continue;
                }
                if (Registry.Companion.is("maven.server.vm.remove.javaagent") && StringsKt.startsWith$default((String)param, (String)"-javaagent", (boolean)false, (int)2, null)) continue;
                params.getVMParametersList().add(param);
            }
        }
        params.getVMParametersList().add("-Didea.version=" + MavenUtil.getIdeaVersionToPassToMavenProcess());
        params.getVMParametersList().addProperty("idea.maven.embedder.version", this.myDistribution.getVersion());
        MavenVersionAwareSupportExtension extension = MavenVersionSupportUtil.INSTANCE.getExtensionFor(this.myDistribution);
        this.checkExtension(extension);
        MavenVersionAwareSupportExtension mavenVersionAwareSupportExtension = extension;
        Intrinsics.checkNotNull((Object)mavenVersionAwareSupportExtension);
        this.setupMainClass(params, mavenVersionAwareSupportExtension);
        Iterable iterable = extension.collectClassPathAndLibsFolder(this.myDistribution);
        PathsList pathsList = params.getClassPath();
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNull((Object)v1);
            collection.add(v1.toFile());
        }
        pathsList.addAllFiles((List)destination$iv$iv);
        Collection<String> classPath = this.collectRTLibraries(this.myDistribution.getVersion());
        for (String s : classPath) {
            params.getClassPath().add(s);
        }
        String embedderXmx = System.getProperty("idea.maven.embedder.xmx");
        if (embedderXmx != null) {
            xmxProperty = "-Xmx" + embedderXmx;
        } else if (xmxProperty == null) {
            xmxProperty = Companion.getMaxXmxStringValue("-Xmx768m", xmsProperty);
        }
        params.getVMParametersList().add(xmsProperty);
        params.getVMParametersList().add((String)xmxProperty);
        String mavenEmbedderParameters = System.getProperty("idea.maven.embedder.parameters");
        if (mavenEmbedderParameters != null) {
            params.getProgramParametersList().addParametersString(mavenEmbedderParameters);
        }
        if ((mavenEmbedderCliOptions = System.getProperty("idea.maven.embedder.ext.cli.args")) != null) {
            params.getVMParametersList().addProperty("idea.maven.embedder.ext.cli.args", mavenEmbedderCliOptions);
        }
        params.getVMParametersList().addProperty("sun.rmi.server.exceptionTrace", "true");
        if (Registry.Companion.is("maven.server.opentelemetry.agent.enabled", false)) {
            MavenServerCMDState.Companion.attachTelemetryAgent(params);
        }
        this.setupMainExt(params);
        return params;
    }

    private final void checkExtension(MavenVersionAwareSupportExtension extension) {
        if (extension == null) {
            if (StringUtil.compareVersionNumbers((String)this.myDistribution.getVersion(), (String)"3") < 0) {
                throw new BuildIssueException((BuildIssue)new InstallMaven2BuildIssue());
            }
            throw new IllegalStateException("Maven distribution at" + this.myDistribution.getMavenHome().toAbsolutePath() + " is not supported");
        }
        MavenLog.LOG.info("Using extension " + extension + " to start MavenServer");
    }

    private final void setupMainExt(SimpleJavaParameters params) {
        String string = this.myDistribution.getVersion();
        Intrinsics.checkNotNull((Object)string);
        MavenUtil.addEventListener(string, params);
    }

    @NotNull
    protected Map<String, String> getMavenOpts() {
        return MavenUtil.getPropertiesFromMavenOpts();
    }

    @NotNull
    protected String getWorkingDirectory() {
        String string = PathManager.getBinPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBinPath(...)");
        return string;
    }

    @NotNull
    protected final Collection<String> collectRTLibraries(@Nullable String mavenVersion) {
        Set classPath = new LinkedHashSet();
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
            classPath.add(PathUtil.getJarPathForClass(Logger.class));
            classPath.add(PathUtil.getJarPathForClass(JDK14LoggerFactory.class));
        }
        classPath.add(PathUtil.getJarPathForClass(StringUtilRt.class));
        classPath.add(PathUtil.getJarPathForClass(NotNull.class));
        classPath.add(PathUtil.getJarPathForClass(Element.class));
        return classPath;
    }

    private final void setupMainClass(SimpleJavaParameters params, MavenVersionAwareSupportExtension extension) {
        if (setupThrowMainClass && MavenUtil.isMavenUnitTestModeEnabled()) {
            params.setMainClass(MAIN_CLASS_WITH_EXCEPTION_FOR_TESTS);
        } else {
            params.setMainClass(extension.getMainClass(this.myDistribution));
        }
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        ProcessHandler processHandler = this.startProcess();
        return (ExecutionResult)new DefaultExecutionResult(processHandler);
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        SimpleJavaParameters params = this.createJavaParameters();
        GeneralCommandLine generalCommandLine = params.toCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"toCommandLine(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        OSProcessHandler processHandler = (OSProcessHandler)new OSProcessHandler.Silent(commandLine);
        processHandler.setShouldDestroyProcessRecursively(false);
        return (ProcessHandler)processHandler;
    }

    @JvmStatic
    @Nullable
    public static final String getMaxXmxStringValue(@Nullable String memoryValueA, @Nullable String memoryValueB) {
        return Companion.getMaxXmxStringValue(memoryValueA, memoryValueB);
    }

    static {
        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(MavenServerCMDState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001e\u0010\u0019\u001a\u0004\u0018\u00010\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerCMDState$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "setupThrowMainClass", "", "MAIN_CLASS_WITH_EXCEPTION_FOR_TESTS", "", "Lorg/jetbrains/annotations/NonNls;", "profilerVMString", "getProfilerVMString", "()Ljava/lang/String;", "configureSslRelatedOptions", "", "defs", "", "attachTelemetryAgent", "params", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "withThrowExceptionOnServerStart", "runnable", "Ljava/lang/Runnable;", "getMaxXmxStringValue", "memoryValueA", "memoryValueB", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        private final String getProfilerVMString() {
            boolean isIntegrationTest;
            String profilerOptionPrefix = "-agentpath:";
            String profilerVMOption = VMOptions.readOption((String)profilerOptionPrefix, (boolean)true);
            boolean bl = isIntegrationTest = System.getProperty("test.build_tool.daemon.profiler") != null;
            if (profilerVMOption == null || SystemInfo.isMac || !isIntegrationTest) {
                return null;
            }
            String currentTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("mm:ss"));
            return profilerOptionPrefix + StringsKt.replace$default((String)StringsKt.replace$default((String)profilerVMOption, (String)".jfr", (String)("-" + currentTime + "-maven.jfr"), (boolean)false, (int)4, null), (String)".log", (String)("-" + currentTime + "-maven.log"), (boolean)false, (int)4, null);
        }

        private final void configureSslRelatedOptions(Map<String, String> defs) {
            Iterator<Map.Entry<Object, Object>> iterator = System.getProperties().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> each;
                Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
                Object key = each.getKey();
                Object value = each.getValue();
                if (!(key instanceof String) || !(value instanceof String) || !StringsKt.startsWith$default((String)((String)key), (String)"javax.net.ssl", (boolean)false, (int)2, null)) continue;
                defs.put((String)key, (String)value);
            }
        }

        private final void attachTelemetryAgent(SimpleJavaParameters params) {
            URI traceEndpoint = OtlpConfiguration.getTraceEndpointURI();
            if (traceEndpoint == null) {
                return;
            }
            Path agentLocation = TelemetryAgentResolver.getAgentLocation();
            if (agentLocation == null) {
                return;
            }
            TelemetryContext telemetryContext = TelemetryContext.current();
            Intrinsics.checkNotNullExpressionValue((Object)telemetryContext, (String)"current(...)");
            AgentConfiguration configuration = AgentConfiguration.Companion.forService("MavenServer", telemetryContext, traceEndpoint, agentLocation, AgentConfiguration.Settings.Companion.withoutMetrics());
            List args = TelemetryAgentProvider.getJvmArgs((AgentConfiguration)configuration);
            ParametersList parametersList = params.getVMParametersList();
            parametersList.addAll(args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TestOnly
        public final void withThrowExceptionOnServerStart(@NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            setupThrowMainClass = true;
            try {
                runnable.run();
            }
            finally {
                setupThrowMainClass = false;
            }
        }

        @JvmStatic
        @Nullable
        public final String getMaxXmxStringValue(@Nullable String memoryValueA, @Nullable String memoryValueB) {
            MemoryProperty propertyA = MemoryProperty.Companion.valueOf(memoryValueA);
            MemoryProperty propertyB = MemoryProperty.Companion.valueOf(memoryValueB);
            if (propertyA != null && propertyB != null) {
                MemoryProperty maxMemoryProperty = propertyA.getValueBytes() > propertyB.getValueBytes() ? propertyA : propertyB;
                return MemoryProperty.Companion.of(MemoryProperty.MemoryPropertyType.XMX, maxMemoryProperty.getValueBytes()).toString(maxMemoryProperty.getUnit());
            }
            return Optional.ofNullable(propertyA).or(() -> Companion.getMaxXmxStringValue$lambda$0(propertyB)).map(Companion::getMaxXmxStringValue$lambda$1).orElse(null);
        }

        private static final Optional getMaxXmxStringValue$lambda$0(MemoryProperty $propertyB) {
            return Optional.ofNullable($propertyB);
        }

        private static final String getMaxXmxStringValue$lambda$1(MemoryProperty property) {
            MemoryProperty memoryProperty = property;
            Intrinsics.checkNotNull((Object)memoryProperty);
            return MemoryProperty.Companion.of(MemoryProperty.MemoryPropertyType.XMX, memoryProperty.getValueBytes()).toString(property.getUnit());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0003\u0012\u0013\u0014B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerCMDState$MemoryProperty;", "", "type", "", "value", "", "unit", "<init>", "(Ljava/lang/String;JLjava/lang/String;)V", "getType", "()Ljava/lang/String;", "valueBytes", "getValueBytes", "()J", "Lorg/jetbrains/idea/maven/server/MavenServerCMDState$MemoryProperty$MemoryUnit;", "getUnit", "()Lorg/jetbrains/idea/maven/server/MavenServerCMDState$MemoryProperty$MemoryUnit;", "toString", "MemoryUnit", "MemoryPropertyType", "Companion", "intellij.maven"})
    public static final class MemoryProperty {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String type;
        private final long valueBytes;
        @NotNull
        private final MemoryUnit unit;
        @NotNull
        private static final Pattern MEMORY_PROPERTY_PATTERN;

        public MemoryProperty(@NotNull String type, long value, @Nullable String unit) {
            MemoryUnit memoryUnit;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.type = type;
            String string = unit;
            if (string != null) {
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                memoryUnit = MemoryUnit.valueOf(string3);
            } else {
                memoryUnit = MemoryUnit.B;
            }
            this.unit = memoryUnit;
            this.valueBytes = value * (long)this.unit.getRatio();
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final long getValueBytes() {
            return this.valueBytes;
        }

        @NotNull
        public final MemoryUnit getUnit() {
            return this.unit;
        }

        @NotNull
        public String toString() {
            return this.toString(this.unit);
        }

        @NotNull
        public final String toString(@NotNull MemoryUnit unit) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            long l = this.valueBytes / (long)unit.getRatio();
            String string = unit.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return this.type + l + string2;
        }

        static {
            Pattern pattern = Pattern.compile("^(-Xmx|-Xms)(\\d+)([kK]|[mM]|[gG])?$");
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            MEMORY_PROPERTY_PATTERN = pattern;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerCMDState$MemoryProperty$Companion;", "", "<init>", "()V", "MEMORY_PROPERTY_PATTERN", "Ljava/util/regex/Pattern;", "of", "Lorg/jetbrains/idea/maven/server/MavenServerCMDState$MemoryProperty;", "propertyType", "Lorg/jetbrains/idea/maven/server/MavenServerCMDState$MemoryProperty$MemoryPropertyType;", "bytes", "", "valueOf", "value", "", "intellij.maven"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MemoryProperty of(@NotNull MemoryPropertyType propertyType, long bytes) {
                Intrinsics.checkNotNullParameter((Object)((Object)propertyType), (String)"propertyType");
                return new MemoryProperty(propertyType.getType(), bytes, "B");
            }

            @Nullable
            public final MemoryProperty valueOf(@Nullable String value) {
                if (value == null) {
                    return null;
                }
                Matcher matcher = MEMORY_PROPERTY_PATTERN.matcher(value);
                if (matcher.find()) {
                    String string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    String string2 = matcher.group(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                    return new MemoryProperty(string, Long.parseLong(string2), matcher.group(3));
                }
                LOG.warn(value + " not match " + MEMORY_PROPERTY_PATTERN);
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerCMDState$MemoryProperty$MemoryPropertyType;", "", "type", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getType", "()Ljava/lang/String;", "XMX", "intellij.maven"})
        public static final class MemoryPropertyType
        extends Enum<MemoryPropertyType> {
            @NotNull
            private final String type;
            public static final /* enum */ MemoryPropertyType XMX = new MemoryPropertyType("-Xmx");
            private static final /* synthetic */ MemoryPropertyType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private MemoryPropertyType(String type) {
                this.type = type;
            }

            @NotNull
            public final String getType() {
                return this.type;
            }

            public static MemoryPropertyType[] values() {
                return (MemoryPropertyType[])$VALUES.clone();
            }

            public static MemoryPropertyType valueOf(String value) {
                return Enum.valueOf(MemoryPropertyType.class, value);
            }

            @NotNull
            public static EnumEntries<MemoryPropertyType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = memoryPropertyTypeArray = new MemoryPropertyType[]{MemoryPropertyType.XMX};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerCMDState$MemoryProperty$MemoryUnit;", "", "ratio", "", "<init>", "(Ljava/lang/String;II)V", "getRatio", "()I", "B", "K", "M", "G", "intellij.maven"})
        public static final class MemoryUnit
        extends Enum<MemoryUnit> {
            private final int ratio;
            public static final /* enum */ MemoryUnit B = new MemoryUnit(1);
            public static final /* enum */ MemoryUnit K = new MemoryUnit(MemoryUnit.B.ratio * 1024);
            public static final /* enum */ MemoryUnit M = new MemoryUnit(MemoryUnit.K.ratio * 1024);
            public static final /* enum */ MemoryUnit G = new MemoryUnit(MemoryUnit.M.ratio * 1024);
            private static final /* synthetic */ MemoryUnit[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private MemoryUnit(int ratio) {
                this.ratio = ratio;
            }

            public final int getRatio() {
                return this.ratio;
            }

            public static MemoryUnit[] values() {
                return (MemoryUnit[])$VALUES.clone();
            }

            public static MemoryUnit valueOf(String value) {
                return Enum.valueOf(MemoryUnit.class, value);
            }

            @NotNull
            public static EnumEntries<MemoryUnit> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = memoryUnitArray = new MemoryUnit[]{MemoryUnit.B, MemoryUnit.K, MemoryUnit.M, MemoryUnit.G};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

