/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.debug.actions.evaluate;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.debug.session.KotlinNotebookDebugSession;
import com.intellij.kotlin.jupyter.core.debug.session.KotlinNotebookDebugSessionManager;
import com.intellij.kotlin.jupyter.core.debug.util.DebugSupportUtilsKt;
import com.intellij.kotlin.jupyter.core.util.ActionsKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/actions/evaluate/NotebookSilentEvaluateActionHandler;", "Lcom/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler;", "<init>", "()V", "isEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "perform", "", "intellij.kotlin.jupyter.core"})
public final class NotebookSilentEvaluateActionHandler
extends XDebuggerEvaluateActionHandler {
    public boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = ActionsKt.getKotlinNotebookVirtualFile(dataContext);
        if (backedNotebookVirtualFile == null) {
            return false;
        }
        BackedNotebookVirtualFile notebook = backedNotebookVirtualFile;
        KotlinNotebookDebugSession sessionManager = KotlinNotebookDebugSessionManager.Companion.getForFile(project, notebook);
        XDebugSession xDebugSession = sessionManager.getCurrentXSession();
        if (xDebugSession == null) {
            return false;
        }
        XDebugSession xSession = xDebugSession;
        DataContext dataContext2 = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        return this.isEnabled(xSession, dataContext2);
    }

    protected boolean isEnabled(@NotNull XDebugSession session, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return DebugSupportUtilsKt.isEvaluationPossible(dataContext);
    }

    public void perform(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        XDebugSession xDebugSession = DebugSupportUtilsKt.getNotebookXSessionOrNull(dataContext);
        if (xDebugSession == null) {
            return;
        }
        XDebugSession xSession = xDebugSession;
        DataContext dataContext2 = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext context = dataContext2;
        super.perform(xSession, context);
    }
}

