/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.debug.events;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.debug.events.NotebookDebugEventHandler;
import com.intellij.kotlin.jupyter.core.debug.session.KotlinNotebookDebugSessionManager;
import com.intellij.kotlin.jupyter.core.debug.util.DebugSupportUtilsKt;
import com.intellij.kotlin.jupyter.core.debug.variables.KotlinNotebookSessionVariablesService;
import com.intellij.openapi.project.Project;
import com.sun.jdi.event.LocatableEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/events/NotebookDebugEventsHandler;", "Lcom/intellij/kotlin/jupyter/core/debug/events/NotebookDebugEventHandler;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "handleVMConnectEvent", "", "virtualMachine", "Lcom/intellij/debugger/engine/jdi/VirtualMachineProxy;", "handleVMDisconnectEvent", "handleInternalDebugMethodEntryEvent", "context", "Lcom/intellij/debugger/engine/SuspendContext;", "event", "Lcom/sun/jdi/event/LocatableEvent;", "intellij.kotlin.jupyter.core"})
public final class NotebookDebugEventsHandler
implements NotebookDebugEventHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile virtualFile;

    public NotebookDebugEventsHandler(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.project = project;
        this.virtualFile = virtualFile;
    }

    @Override
    public void handleVMConnectEvent(@NotNull VirtualMachineProxy virtualMachine) {
        Intrinsics.checkNotNullParameter((Object)virtualMachine, (String)"virtualMachine");
        DebugProcess process = virtualMachine.getDebugProcess();
        if (process instanceof DebugProcessImpl) {
            KotlinNotebookDebugSessionManager.Companion.getForFile(this.project, this.virtualFile).prepareInternalRequests((DebugProcessImpl)process);
        }
    }

    @Override
    public void handleVMDisconnectEvent(@NotNull VirtualMachineProxy virtualMachine) {
        Intrinsics.checkNotNullParameter((Object)virtualMachine, (String)"virtualMachine");
    }

    @Override
    public void handleInternalDebugMethodEntryEvent(@Nullable SuspendContext context, @Nullable LocatableEvent event) {
        if (context == null) {
            return;
        }
        if (!DebugSupportUtilsKt.getShouldShowNotebookVariables(this.project)) {
            return;
        }
        KotlinNotebookSessionVariablesService.Companion.getForFile(this.project, this.virtualFile).requestVariablesUpdate();
    }
}

