/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.debug.session;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.debug.session.KotlinNotebookDebugSession;
import com.intellij.kotlin.jupyter.core.debug.util.connection.DebugConnectionUtility;
import com.intellij.kotlin.jupyter.core.settings.KotlinKernelVersionsKt;
import com.intellij.kotlin.jupyter.core.util.FilesKt;
import com.intellij.kotlin.jupyter.core.util.NotebookProjectLevelService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.startup.PortsGenerator;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/session/KotlinNotebookDebugSessionManager;", "Lcom/intellij/kotlin/jupyter/core/util/NotebookProjectLevelService;", "Lcom/intellij/kotlin/jupyter/core/debug/session/KotlinNotebookDebugSession;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "portsGenerator", "Lorg/jetbrains/kotlinx/jupyter/startup/PortsGenerator;", "nextTargetDebugPortOrNull", "", "getNextTargetDebugPortOrNull", "()Ljava/lang/Integer;", "getByDebugProcessOrNull", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "getByPath", "path", "Ljava/nio/file/Path;", "createInstance", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "fileScope", "Companion", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookDebugSessionManager
extends NotebookProjectLevelService<KotlinNotebookDebugSession> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PortsGenerator portsGenerator;

    public KotlinNotebookDebugSessionManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(coroutineScope);
        this.project = project;
        this.portsGenerator = DebugConnectionUtility.INSTANCE.getDebugPortsGenerator();
    }

    private final Integer getNextTargetDebugPortOrNull() {
        boolean isSuitable = KotlinKernelVersionsKt.isKernelVersionEnoughForInstrumentation(this.project);
        return isSuitable && !ApplicationManager.getApplication().isUnitTestMode() ? Integer.valueOf(this.portsGenerator.randomPort()) : null;
    }

    @Nullable
    public final KotlinNotebookDebugSession getByDebugProcessOrNull(@Nullable DebugProcess debugProcess) {
        KotlinNotebookDebugSession kotlinNotebookDebugSession;
        block2: {
            if (debugProcess == null) {
                return null;
            }
            for (Map.Entry it : this.getMapping().entrySet()) {
                boolean bl = false;
                DebuggerSession debuggerSession = ((KotlinNotebookDebugSession)it.getValue()).getDebuggerSession();
                KotlinNotebookDebugSession kotlinNotebookDebugSession2 = Intrinsics.areEqual((Object)(debuggerSession != null ? debuggerSession.getProcess() : null), (Object)debugProcess) ? (KotlinNotebookDebugSession)it.getValue() : null;
                if (kotlinNotebookDebugSession2 == null) continue;
                kotlinNotebookDebugSession = kotlinNotebookDebugSession2;
                break block2;
            }
            kotlinNotebookDebugSession = null;
        }
        return kotlinNotebookDebugSession;
    }

    @Nullable
    public final KotlinNotebookDebugSession getByPath(@NotNull Path path2) {
        KotlinNotebookDebugSession kotlinNotebookDebugSession;
        Object object;
        block3: {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            for (Map.Entry it : this.getMapping().entrySet()) {
                boolean bl = false;
                if ((it = Intrinsics.areEqual((Object)it.getKey().getPath(), (Object)((Object)path2).toString()) ? (KotlinNotebookDebugSession)it.getValue() : null) == null) continue;
                object = it;
                break block3;
            }
            object = kotlinNotebookDebugSession = null;
        }
        if (object == null) {
            KotlinNotebookDebugSessionManager $this$getByPath_u24lambda_u242 = this;
            boolean bl = false;
            BackedNotebookVirtualFile backedNotebookVirtualFile = FilesKt.findNotebookVirtualFileOrNull(path2);
            if (backedNotebookVirtualFile == null) {
                return null;
            }
            BackedNotebookVirtualFile backedNotebookVirtualFile2 = backedNotebookVirtualFile;
            kotlinNotebookDebugSession = (KotlinNotebookDebugSession)$this$getByPath_u24lambda_u242.getOrCreate(backedNotebookVirtualFile2);
        }
        return kotlinNotebookDebugSession;
    }

    @Override
    @NotNull
    protected KotlinNotebookDebugSession createInstance(@NotNull BackedNotebookVirtualFile virtualFile, @NotNull CoroutineScope fileScope) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)fileScope, (String)"fileScope");
        return new KotlinNotebookDebugSession(virtualFile, this.project, this, fileScope, (Function0<Integer>)((Function0)() -> KotlinNotebookDebugSessionManager.createInstance$lambda$3(this)));
    }

    private static final Integer createInstance$lambda$3(KotlinNotebookDebugSessionManager this$0) {
        return this$0.getNextTargetDebugPortOrNull();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/session/KotlinNotebookDebugSessionManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kotlin/jupyter/core/debug/session/KotlinNotebookDebugSessionManager;", "project", "Lcom/intellij/openapi/project/Project;", "getForFile", "Lcom/intellij/kotlin/jupyter/core/debug/session/KotlinNotebookDebugSession;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "intellij.kotlin.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nKotlinNotebookDebugSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookDebugSessionManager.kt\ncom/intellij/kotlin/jupyter/core/debug/session/KotlinNotebookDebugSessionManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,64:1\n31#2,2:65\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookDebugSessionManager.kt\ncom/intellij/kotlin/jupyter/core/debug/session/KotlinNotebookDebugSessionManager$Companion\n*L\n58#1:65,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinNotebookDebugSessionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinNotebookDebugSessionManager> serviceClass$iv = KotlinNotebookDebugSessionManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinNotebookDebugSessionManager)object;
        }

        @NotNull
        public final KotlinNotebookDebugSession getForFile(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            return (KotlinNotebookDebugSession)this.getInstance(project).getOrCreate(virtualFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

