/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.dnd;

import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandlerContext;
import com.intellij.kotlin.jupyter.core.editor.dnd.AbstractKotlinDataframeDropHandler;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u0005H\u0014J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/dnd/KotlinGeoDataDropHandler;", "Lcom/intellij/kotlin/jupyter/core/editor/dnd/AbstractKotlinDataframeDropHandler;", "<init>", "()V", "generateImportExpression", "", "dataFilePath", "context", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext;", "isTargetLibrary", "", "file", "Ljava/io/File;", "getUseStatement", "getCellResultStatement", "variableName", "intellij.kotlin.jupyter.core"})
public final class KotlinGeoDataDropHandler
extends AbstractKotlinDataframeDropHandler {
    public KotlinGeoDataDropHandler() {
        Object[] objectArray = new String[]{"geojson", "shp"};
        super(KotlinNotebookBundle.message("kotlin.jupyter.editor.dnd.geo.dataframe.command", new Object[0]), SetsKt.setOf((Object[])objectArray));
    }

    @Override
    @NotNull
    protected String generateImportExpression(@NotNull String dataFilePath, @NotNull TableDataFileDropHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)dataFilePath, (String)"dataFilePath");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StringsKt.endsWith$default((String)dataFilePath, (String)"geojson", (boolean)false, (int)2, null) ? "GeoDataFrame.readGeoJson(\"" + dataFilePath + "\")" : "GeoDataFrame.readShapefile(\"" + dataFilePath + "\")";
    }

    @Override
    protected boolean isTargetLibrary(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)"dataframe-geo", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    protected String getUseStatement() {
        return "%use dataframe(enableExperimentalGeo=true)\n";
    }

    @Override
    @NotNull
    protected String getCellResultStatement(@NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        return variableName + ".df";
    }
}

