/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.formatting;

import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.AbstractDocumentFormattingService;
import com.intellij.formatting.service.CoreFormattingService;
import com.intellij.formatting.service.FormattingService;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookHighlightingService;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookPerFileHighlightingMetaDataController;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.util.UtilKt;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.util.CollectionsKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J6\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016J0\u0010\u0016\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/formatting/KotlinNotebookFileFormattingService;", "Lcom/intellij/formatting/service/AbstractDocumentFormattingService;", "<init>", "()V", "getFeatures", "", "Lcom/intellij/formatting/service/FormattingService$Feature;", "canFormat", "", "file", "Lcom/intellij/psi/PsiFile;", "formatDocument", "", "document", "Lcom/intellij/openapi/editor/Document;", "formattingRanges", "", "Lcom/intellij/openapi/util/TextRange;", "formattingContext", "Lcom/intellij/formatting/FormattingContext;", "canChangeWhiteSpaceOnly", "quickFormat", "addKotlinFilesWithRanges", "Lcom/intellij/kotlin/jupyter/core/editor/formatting/KotlinNotebookFileFormattingService$FileWithRanges;", "cell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "injectedManager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "FileWithRanges", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookFileFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookFileFormattingService.kt\ncom/intellij/kotlin/jupyter/core/editor/formatting/KotlinNotebookFileFormattingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,137:1\n1#2:138\n1#2:158\n1755#3,3:139\n1863#3,2:142\n774#3:145\n865#3,2:146\n1611#3,9:148\n1863#3:157\n1864#3:159\n1620#3:160\n13#4:144\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookFileFormattingService.kt\ncom/intellij/kotlin/jupyter/core/editor/formatting/KotlinNotebookFileFormattingService\n*L\n124#1:158\n73#1:139,3\n83#1:142,2\n117#1:145\n117#1:146,2\n124#1:148,9\n124#1:157\n124#1:159\n124#1:160\n92#1:144\n*E\n"})
public final class KotlinNotebookFileFormattingService
extends AbstractDocumentFormattingService {
    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        Object[] objectArray = new FormattingService.Feature[]{FormattingService.Feature.AD_HOC_FORMATTING, FormattingService.Feature.FORMAT_FRAGMENTS};
        return SetsKt.setOf((Object[])objectArray);
    }

    public boolean canFormat(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof JupyterFile && IsKotlinNotebookKt.isKotlinNotebook(((JupyterFile)file).getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatDocument(@NotNull Document document, @NotNull List<TextRange> formattingRanges, @NotNull FormattingContext formattingContext, boolean canChangeWhiteSpaceOnly, boolean quickFormat) {
        NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController;
        boolean bl;
        NotebookCellLines.Interval invokedInCell;
        List filesToProcess;
        NotebookPerFileHighlightingMetaDataController highlightingDataProvider;
        PsiFile jupyterPsiFile;
        block21: {
            Collection<TextRange> renamingRanges;
            NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController2;
            Object it;
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter(formattingRanges, (String)"formattingRanges");
            Intrinsics.checkNotNullParameter((Object)formattingContext, (String)"formattingContext");
            PsiFile psiFile = formattingContext.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            jupyterPsiFile = psiFile;
            if (!jupyterPsiFile.isValid()) {
                return;
            }
            Project project = formattingContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            VirtualFile virtualFile = jupyterPsiFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            BackedNotebookVirtualFile backedNotebookVirtualFile = com.intellij.kotlin.jupyter.core.util.UtilKt.toBackedNotebookFile(virtualFile);
            if (backedNotebookVirtualFile != null) {
                it = backedNotebookVirtualFile;
                boolean bl2 = false;
                notebookPerFileHighlightingMetaDataController2 = NotebookHighlightingService.Companion.getForFile(project2, (BackedNotebookVirtualFile)it).getDataController();
            } else {
                notebookPerFileHighlightingMetaDataController2 = null;
            }
            NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController3 = highlightingDataProvider = notebookPerFileHighlightingMetaDataController2;
            Collection<TextRange> collection = renamingRanges = notebookPerFileHighlightingMetaDataController3 != null ? notebookPerFileHighlightingMetaDataController3.getRenamingRanges() : null;
            if (!(collection == null || collection.isEmpty())) {
                return;
            }
            it = com.intellij.kotlin.jupyter.core.util.UtilKt.getNotebookCells(jupyterPsiFile);
            if (it.isEmpty()) {
                boolean bl3 = false;
                return;
            }
            List cellList = (List)it;
            InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)project2);
            Collection collection2 = CollectionsKt.buildFlatMap(cellList, (arg_0, arg_1) -> KotlinNotebookFileFormattingService.formatDocument$lambda$2(this, formattingRanges, injectedManager, arg_0, arg_1));
            if (collection2.isEmpty()) {
                boolean bl4 = false;
                return;
            }
            filesToProcess = (List)collection2;
            VirtualFile virtualFile2 = jupyterPsiFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            invokedInCell = UtilKt.retrieveCellIntervalUnderCaret(document, virtualFile2, project2);
            NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController4 = highlightingDataProvider;
            if (notebookPerFileHighlightingMetaDataController4 != null) {
                notebookPerFileHighlightingMetaDataController4.update((Function1<? super NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator, Unit>)((Function1)KotlinNotebookFileFormattingService::formatDocument$lambda$4));
            }
            Iterable $this$any$iv = filesToProcess;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FileWithRanges it2 = (FileWithRanges)element$iv;
                    boolean bl5 = false;
                    if (!(!it2.getFile().isValid())) continue;
                    bl = true;
                    break block21;
                }
                bl = false;
            }
        }
        if (bl) {
            StorageUtilKt.runAsWriteActionIfNeeded(() -> KotlinNotebookFileFormattingService.formatDocument$lambda$6(jupyterPsiFile));
        }
        try {
            CoreFormattingService formatter = (CoreFormattingService)AbstractDocumentFormattingService.EP_NAME.findExtensionOrFail(CoreFormattingService.class);
            for (Object object : filesToProcess) {
                FormatTextRanges formatTextRanges;
                KtFile file = ((FileWithRanges)object).component1();
                List<TextRange> ranges = ((FileWithRanges)object).component2();
                FormatTextRanges $this$formatDocument_u24lambda_u248 = formatTextRanges = new FormatTextRanges();
                boolean bl6 = false;
                Iterable $this$forEach$iv = ranges;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TextRange it = (TextRange)element$iv;
                    boolean bl7 = false;
                    $this$formatDocument_u24lambda_u248.add(it, false);
                }
                $this$formatDocument_u24lambda_u248.setExtendToContext(true);
                FormatTextRanges rangeInfo = formatTextRanges;
                formatter.formatRanges((PsiFile)file, (FormattingRangesInfo)rangeInfo, canChangeWhiteSpaceOnly, quickFormat);
            }
            notebookPerFileHighlightingMetaDataController = highlightingDataProvider;
        }
        catch (Throwable e) {
            NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController5;
            try {
                if (e instanceof ProcessCanceledException) {
                    throw e;
                }
                KotlinNotebookFileFormattingService $this$notebookLogger$iv = this;
                boolean $i$f$notebookLogger = false;
                KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(KotlinNotebookFileFormattingService.class)).warn("Error occurred during reformatting of Kotlin Notebook", e);
                notebookPerFileHighlightingMetaDataController5 = highlightingDataProvider;
            }
            catch (Throwable throwable) {
                NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController6 = highlightingDataProvider;
                Set<Integer> targets = notebookPerFileHighlightingMetaDataController6 != null ? notebookPerFileHighlightingMetaDataController6.getReformatDocumentTargets() : null;
                NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController7 = highlightingDataProvider;
                if (notebookPerFileHighlightingMetaDataController7 != null) {
                    notebookPerFileHighlightingMetaDataController7.update((Function1<? super NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator, Unit>)((Function1)arg_0 -> KotlinNotebookFileFormattingService.formatDocument$lambda$10(invokedInCell, targets, arg_0)));
                }
                ReadAction.run(() -> KotlinNotebookFileFormattingService.formatDocument$lambda$11(jupyterPsiFile));
                throw throwable;
            }
            Set<Integer> targets = notebookPerFileHighlightingMetaDataController5 != null ? notebookPerFileHighlightingMetaDataController5.getReformatDocumentTargets() : null;
            NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController8 = highlightingDataProvider;
            if (notebookPerFileHighlightingMetaDataController8 != null) {
                notebookPerFileHighlightingMetaDataController8.update((Function1<? super NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator, Unit>)((Function1)arg_0 -> KotlinNotebookFileFormattingService.formatDocument$lambda$10(invokedInCell, targets, arg_0)));
            }
            ReadAction.run(() -> KotlinNotebookFileFormattingService.formatDocument$lambda$11(jupyterPsiFile));
        }
        Set<Integer> targets = notebookPerFileHighlightingMetaDataController != null ? notebookPerFileHighlightingMetaDataController.getReformatDocumentTargets() : null;
        NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController9 = highlightingDataProvider;
        if (notebookPerFileHighlightingMetaDataController9 != null) {
            notebookPerFileHighlightingMetaDataController9.update((Function1<? super NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator, Unit>)((Function1)arg_0 -> KotlinNotebookFileFormattingService.formatDocument$lambda$10(invokedInCell, targets, arg_0)));
        }
        ReadAction.run(() -> KotlinNotebookFileFormattingService.formatDocument$lambda$11(jupyterPsiFile));
    }

    /*
     * WARNING - void declaration
     */
    private final void addKotlinFilesWithRanges(List<FileWithRanges> $this$addKotlinFilesWithRanges, JupyterPsiCell cell, List<TextRange> formattingRanges, InjectedLanguageManager injectedManager) {
        void $this$filterTo$iv$iv;
        Collection $this$filter$iv;
        TextRange cellRange = cell.getTextRange();
        Iterable iterable = formattingRanges;
        boolean $i$f$filter = false;
        void var9_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextRange range = (TextRange)element$iv$iv;
            boolean bl = false;
            if (!range.intersectsStrict(cellRange)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        if ($this$filter$iv.isEmpty()) {
            boolean bl = false;
            return;
        }
        List hostRanges = (List)$this$filter$iv;
        Collection collection = com.intellij.kotlin.jupyter.core.util.UtilKt.getInjectedKtFiles((PsiLanguageInjectionHost)cell, injectedManager);
        if (collection.isEmpty()) {
            boolean bl = false;
            return;
        }
        List ktFiles = (List)collection;
        for (KtFile ktFile : ktFiles) {
            List ranges;
            List list;
            void $this$mapNotNullTo$iv$iv;
            DocumentWindow documentWindow;
            Document document = com.intellij.kotlin.jupyter.core.util.UtilKt.toDocument((PsiFile)ktFile);
            if ((document instanceof DocumentWindow ? (DocumentWindow)document : null) == null) continue;
            documentWindow = documentWindow;
            Iterable $this$mapNotNull$iv = hostRanges;
            boolean $i$f$mapNotNull = false;
            Iterable bl = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ProperTextRange it$iv$iv;
                ProperTextRange properTextRange;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                TextRange range = (TextRange)element$iv$iv;
                boolean bl3 = false;
                ProperTextRange it = properTextRange = new ProperTextRange(documentWindow.hostToInjected(FixersUtilKt.getStart((TextRange)range)), documentWindow.hostToInjected(FixersUtilKt.getEnd((TextRange)range)));
                boolean bl4 = false;
                if ((!it.isEmpty() ? properTextRange : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List it = list = (List)destination$iv$iv2;
            boolean bl6 = false;
            if ((!((Collection)it).isEmpty() ? list : null) == null) continue;
            ranges = ranges;
            $this$addKotlinFilesWithRanges.add(new FileWithRanges(ktFile, ranges));
        }
    }

    private static final Unit formatDocument$lambda$2(KotlinNotebookFileFormattingService this$0, List $formattingRanges, InjectedLanguageManager $injectedManager, List $this$buildFlatMap, JupyterPsiCell it) {
        Intrinsics.checkNotNullParameter((Object)$this$buildFlatMap, (String)"$this$buildFlatMap");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNull((Object)$injectedManager);
        this$0.addKotlinFilesWithRanges($this$buildFlatMap, it, $formattingRanges, $injectedManager);
        return Unit.INSTANCE;
    }

    private static final Unit formatDocument$lambda$4(NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.setReformatDocumentTargets(new LinkedHashSet());
        return Unit.INSTANCE;
    }

    private static final Unit formatDocument$lambda$6(PsiFile $jupyterPsiFile) {
        $jupyterPsiFile.getViewProvider().contentsSynchronized();
        return Unit.INSTANCE;
    }

    private static final Unit formatDocument$lambda$10(NotebookCellLines.Interval $invokedInCell, Set $targets, NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.setReformatDocumentTargets(null);
        NotebookCellLines.Interval interval = $invokedInCell;
        if (interval != null) {
            int it = interval.getOrdinal();
            boolean bl = false;
            $this$update.setNotebookChangedCellIndex(it);
        }
        $this$update.setNotebookDocumentTargetRanges($targets);
        return Unit.INSTANCE;
    }

    private static final void formatDocument$lambda$11(PsiFile $jupyterPsiFile) {
        com.intellij.kotlin.jupyter.core.util.UtilKt.restartAnalyzing($jupyterPsiFile);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/formatting/KotlinNotebookFileFormattingService$FileWithRanges;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "ranges", "", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/util/List;)V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getRanges", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.kotlin.jupyter.core"})
    private static final class FileWithRanges {
        @NotNull
        private final KtFile file;
        @NotNull
        private final List<TextRange> ranges;

        public FileWithRanges(@NotNull KtFile file, @NotNull List<? extends TextRange> ranges) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            this.file = file;
            this.ranges = ranges;
        }

        @NotNull
        public final KtFile getFile() {
            return this.file;
        }

        @NotNull
        public final List<TextRange> getRanges() {
            return this.ranges;
        }

        @NotNull
        public final KtFile component1() {
            return this.file;
        }

        @NotNull
        public final List<TextRange> component2() {
            return this.ranges;
        }

        @NotNull
        public final FileWithRanges copy(@NotNull KtFile file, @NotNull List<? extends TextRange> ranges) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            return new FileWithRanges(file, ranges);
        }

        public static /* synthetic */ FileWithRanges copy$default(FileWithRanges fileWithRanges, KtFile ktFile, List list, int n, Object object) {
            if ((n & 1) != 0) {
                ktFile = fileWithRanges.file;
            }
            if ((n & 2) != 0) {
                list = fileWithRanges.ranges;
            }
            return fileWithRanges.copy(ktFile, list);
        }

        @NotNull
        public String toString() {
            return "FileWithRanges(file=" + this.file + ", ranges=" + this.ranges + ")";
        }

        public int hashCode() {
            int result2 = this.file.hashCode();
            result2 = result2 * 31 + ((Object)this.ranges).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileWithRanges)) {
                return false;
            }
            FileWithRanges fileWithRanges = (FileWithRanges)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)fileWithRanges.file)) {
                return false;
            }
            return Intrinsics.areEqual(this.ranges, fileWithRanges.ranges);
        }
    }
}

