/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.service.util;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/util/DaemonAnalyzerStatusService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "daemonRunning", "getDaemonRunning", "()Z", "dispose", "", "Companion", "intellij.kotlin.jupyter.core"})
@ApiStatus.Internal
public final class DaemonAnalyzerStatusService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private volatile boolean daemonRunning;

    public DaemonAnalyzerStatusService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
        messageBusConnection.subscribe(topic, (Object)new DaemonCodeAnalyzer.DaemonListener(){

            public void daemonStarting(Collection<? extends FileEditor> fileEditors) {
                Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                daemonRunning = true;
            }

            public void daemonFinished(Collection<? extends FileEditor> fileEditors) {
                Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                daemonRunning = false;
            }

            public void daemonCancelEventOccurred(String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                daemonRunning = false;
            }
        });
    }

    public final boolean getDaemonRunning() {
        return this.daemonRunning;
    }

    public void dispose() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/util/DaemonAnalyzerStatusService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/util/DaemonAnalyzerStatusService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nDaemonAnalyzerStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DaemonAnalyzerStatusService.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/util/DaemonAnalyzerStatusService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,50:1\n31#2,2:51\n*S KotlinDebug\n*F\n+ 1 DaemonAnalyzerStatusService.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/util/DaemonAnalyzerStatusService$Companion\n*L\n47#1:51,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DaemonAnalyzerStatusService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DaemonAnalyzerStatusService> serviceClass$iv = DaemonAnalyzerStatusService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DaemonAnalyzerStatusService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

