/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server.process;

import com.intellij.jupyter.core.jupyter.connections.execution.JupyterKernelCommunicationClient;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSessionId;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.KotlinKernelSession;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.MessageBridgeKt;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.RawMessageWithSocket;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.messages.JupyterMessageFilter;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.process.IdeaJupyterSocketManager;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.process.KernelZMQClientSessionKt;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.process.UtilKt;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.nio.channels.ClosedSelectorException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.ConnectionKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.protocol.AbstractJupyterConnection;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocket;
import org.jetbrains.kotlinx.jupyter.startup.KernelConfig;
import org.zeromq.ZMQException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001&B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0002J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u000bH\u0016J\b\u0010%\u001a\u00020\u000bH\u0016R\u0016\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelZMQClientSession;", "Lorg/jetbrains/kotlinx/jupyter/protocol/AbstractJupyterConnection;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterKernelCommunicationClient;", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/KotlinKernelSession;", "sessionId", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSessionId;", "kernelConfig", "Lorg/jetbrains/kotlinx/jupyter/startup/KernelConfig;", "onMessageCallback", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "", "outgoingMessagesFilter", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/messages/JupyterMessageFilter;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlinx/jupyter/startup/KernelConfig;Lkotlin/jvm/functions/Function1;Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/messages/JupyterMessageFilter;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getSessionId-PaPw8_s", "()Ljava/lang/String;", "Ljava/lang/String;", "receiveMessageLock", "Ljava/util/concurrent/locks/ReentrantLock;", "clientThreads", "", "Ljava/lang/Thread;", "socketManager", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/IdeaJupyterSocketManager;", "getSocketManager", "()Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/IdeaJupyterSocketManager;", "send", "content", "initSockets", "processMessage", "socketType", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/JupyterSocketType;", "rawMessage", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;", "close", "dispose", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKernelZMQClientSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelZMQClientSession.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelZMQClientSession\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n62#2,5:148\n1863#3,2:153\n1863#3,2:155\n*S KotlinDebug\n*F\n+ 1 KernelZMQClientSession.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelZMQClientSession\n*L\n48#1:148,5\n72#1:153,2\n102#1:155,2\n*E\n"})
public final class KernelZMQClientSession
extends AbstractJupyterConnection
implements JupyterKernelCommunicationClient,
KotlinKernelSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sessionId;
    @NotNull
    private final Function1<JupyterMessage, Unit> onMessageCallback;
    @NotNull
    private final JupyterMessageFilter outgoingMessagesFilter;
    @NotNull
    private final ReentrantLock receiveMessageLock;
    @NotNull
    private final List<Thread> clientThreads;
    @NotNull
    private final IdeaJupyterSocketManager socketManager;
    @NotNull
    private static final Logger LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(KernelZMQClientSession.class));

    private KernelZMQClientSession(String sessionId, KernelConfig kernelConfig, Function1<? super JupyterMessage, Unit> onMessageCallback, JupyterMessageFilter outgoingMessagesFilter) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)kernelConfig, (String)"kernelConfig");
        Intrinsics.checkNotNullParameter(onMessageCallback, (String)"onMessageCallback");
        Intrinsics.checkNotNullParameter((Object)outgoingMessagesFilter, (String)"outgoingMessagesFilter");
        this.sessionId = sessionId;
        this.onMessageCallback = onMessageCallback;
        this.outgoingMessagesFilter = outgoingMessagesFilter;
        this.receiveMessageLock = new ReentrantLock(true);
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.clientThreads = (List)concurrentList;
        this.socketManager = new IdeaJupyterSocketManager(kernelConfig);
        this.initSockets();
    }

    @Override
    @NotNull
    public String getSessionId-PaPw8_s() {
        return this.sessionId;
    }

    @Override
    @NotNull
    public IdeaJupyterSocketManager getSocketManager() {
        return this.socketManager;
    }

    public void send(@NotNull JupyterMessage content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (!this.outgoingMessagesFilter.accepts(content)) {
            return;
        }
        RawMessageWithSocket rawMessageWithSocket = MessageBridgeKt.toRawMessageWithSocket(content);
        if (rawMessageWithSocket == null) {
            return;
        }
        RawMessageWithSocket rawMessageWithSocket2 = rawMessageWithSocket;
        RawMessage rawMessage = rawMessageWithSocket2.component1();
        JupyterSocketType socketType = rawMessageWithSocket2.component2();
        try {
            JupyterSocket socket = this.getSocketManager().fromSocketType(socketType);
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Sending message to " + socketType + " in " + JupyterNotebookSessionId.toString-impl((String)this.getSessionId-PaPw8_s()) + ":\n" + rawMessage, e$iv);
            }
            socket.sendRawMessage(rawMessage);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    private final void initSockets() {
        Thread mainClientThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"Main Kernel ZMQ client thread", (int)0, () -> KernelZMQClientSession.initSockets$lambda$8(this), (int)23, null);
        this.clientThreads.add(mainClientThread);
    }

    private final void processMessage(JupyterSocketType socketType, RawMessage rawMessage) {
        JupyterMessage message = MessageBridgeKt.toJupyterMessage(rawMessage, KernelZMQClientSessionKt.getChannel(socketType));
        this.onMessageCallback.invoke((Object)message);
    }

    public void close() {
        this.clientThreads.clear();
        UtilKt.closeSafely(this.getSocketManager());
    }

    public void dispose() {
        this.close();
    }

    private static final void initSockets$socketLoop(String interruptedMessage, Function0<Unit> loopBody) {
        while (true) {
            try {
                loopBody.invoke();
            }
            catch (InterruptedException interruptedException) {
                LOG.debug(interruptedMessage);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit initSockets$lambda$8$lambda$6$lambda$5$lambda$2(KernelZMQClientSession this$0, JupyterSocketType $socketType, RawMessage rawMessage) {
        Intrinsics.checkNotNullParameter((Object)rawMessage, (String)"rawMessage");
        Lock lock = this$0.receiveMessageLock;
        lock.lock();
        try {
            boolean bl = false;
            this$0.processMessage($socketType, rawMessage);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return Unit.INSTANCE;
    }

    private static final Unit initSockets$lambda$8$lambda$6$lambda$5$lambda$4$lambda$3(JupyterSocket $socket) {
        try {
            $socket.runCallbacksOnMessage();
        }
        catch (ClosedSelectorException e) {
            UtilKt.rethrowAsInterrupted(e);
        }
        catch (ZMQException e) {
            UtilKt.rethrowAsInterrupted(e);
        }
        catch (AssertionError e) {
            UtilKt.rethrowAsInterrupted((Throwable)((Object)e));
        }
        return Unit.INSTANCE;
    }

    private static final Unit initSockets$lambda$8$lambda$6$lambda$5$lambda$4(JupyterSocketType $socketType, JupyterSocket $socket) {
        KernelZMQClientSession.initSockets$socketLoop("Socket " + $socketType + ": Interrupted", (Function0<Unit>)((Function0)() -> KernelZMQClientSession.initSockets$lambda$8$lambda$6$lambda$5$lambda$4$lambda$3($socket)));
        return Unit.INSTANCE;
    }

    private static final Unit initSockets$lambda$8(KernelZMQClientSession this$0) {
        List list;
        List $this$initSockets_u24lambda_u248_u24lambda_u246 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterSocketType socketType = (JupyterSocketType)((Object)element$iv);
            boolean bl2 = false;
            JupyterSocket socket = this$0.getSocketManager().fromSocketType(socketType);
            this$0.addMessageCallback(ConnectionKt.rawMessageCallback(socketType, null, (Function1<? super RawMessage, Unit>)((Function1)arg_0 -> KernelZMQClientSession.initSockets$lambda$8$lambda$6$lambda$5$lambda$2(this$0, socketType, arg_0))));
            $this$initSockets_u24lambda_u248_u24lambda_u246.add(ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)(socketType + "'s socket thread"), (int)0, () -> KernelZMQClientSession.initSockets$lambda$8$lambda$6$lambda$5$lambda$4(socketType, socket), (int)23, null));
        }
        List childThreads = CollectionsKt.build((List)list);
        this$0.clientThreads.addAll(childThreads);
        Iterable $this$forEach$iv2 = childThreads;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Thread it = (Thread)element$iv;
            boolean bl3 = false;
            it.join();
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ KernelZMQClientSession(String sessionId, KernelConfig kernelConfig, Function1 onMessageCallback, JupyterMessageFilter outgoingMessagesFilter, DefaultConstructorMarker $constructor_marker) {
        this(sessionId, kernelConfig, (Function1<? super JupyterMessage, Unit>)onMessageCallback, outgoingMessagesFilter);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/process/KernelZMQClientSession$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<JupyterSocketType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])JupyterSocketType.values());
        }
    }
}

