/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.variables;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsToolWindowPanel;
import com.intellij.jupyter.core.jupyter.variables.common.NotebookVarsToolWindowPanelProvider;
import com.intellij.kotlin.jupyter.core.debug.variables.KotlinNotebookSessionVariablesService;
import com.intellij.kotlin.jupyter.core.debug.variables.NotebookVariablesPerFileStateService;
import com.intellij.kotlin.jupyter.core.util.FilesKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/core/variables/NotebookVarsToolWindowProvider;", "Lcom/intellij/jupyter/core/jupyter/variables/common/NotebookVarsToolWindowPanelProvider;", "<init>", "()V", "isSupported", "", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getToolWindowPanel", "Lcom/intellij/jupyter/core/jupyter/variables/common/JupyterVarsToolWindowPanel;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.jupyter.core"})
public final class NotebookVarsToolWindowProvider
implements NotebookVarsToolWindowPanelProvider {
    public boolean isSupported(@NotNull BackedNotebookVirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return IsKotlinNotebookKt.isKotlinNotebook(virtualFile.getFile());
    }

    @NotNull
    public JupyterVarsToolWindowPanel getToolWindowPanel(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        NotebookVariablesPerFileStateService variableService = KotlinNotebookSessionVariablesService.Companion.getForFile(project, virtualFile);
        if (!variableService.isToolWindowReady()) {
            throw new IllegalStateException(("Variable window was not created for: " + FilesKt.toAbsolutePath(virtualFile.getFile())).toString());
        }
        return NotebookVariablesPerFileStateService.getToolWindow$default(variableService, null, 1, null);
    }
}

