/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class FontFamilyManager
extends AbstractValueManager {
    protected static final ListValue DEFAULT_VALUE = new ListValue();
    protected static final Object2ObjectOpenHashMap<String, Value> values;

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 26;
    }

    @Override
    public String getPropertyName() {
        return "font-family";
    }

    @Override
    public Value getDefaultValue() {
        return DEFAULT_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine2) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            default: {
                throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
            }
            case 35: 
            case 36: 
        }
        ListValue result2 = new ListValue();
        do {
            switch (lu.getLexicalUnitType()) {
                case 36: {
                    result2.append(new StringValue(19, lu.getStringValue()));
                    lu = lu.getNextLexicalUnit();
                    break;
                }
                case 35: {
                    StringBuilder sb = new StringBuilder(lu.getStringValue());
                    lu = lu.getNextLexicalUnit();
                    if (lu != null && FontFamilyManager.isIdentOrNumber(lu)) {
                        do {
                            sb.append(' ');
                            switch (lu.getLexicalUnitType()) {
                                case 35: {
                                    sb.append(lu.getStringValue());
                                    break;
                                }
                                case 13: {
                                    sb.append(Integer.toString(lu.getIntegerValue()));
                                }
                            }
                        } while ((lu = lu.getNextLexicalUnit()) != null && FontFamilyManager.isIdentOrNumber(lu));
                        result2.append(new StringValue(19, sb.toString()));
                        break;
                    }
                    String id = sb.toString();
                    String s = id.toLowerCase();
                    Value v = (Value)values.get((Object)s);
                    result2.append(v != null ? v : new StringValue(19, id));
                }
            }
            if (lu == null) {
                return result2;
            }
            if (lu.getLexicalUnitType() == 0) continue;
            throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        } while ((lu = lu.getNextLexicalUnit()) != null);
        throw this.createMalformedLexicalUnitDOMException();
    }

    private static boolean isIdentOrNumber(LexicalUnit lu) {
        short type2 = lu.getLexicalUnitType();
        switch (type2) {
            case 13: 
            case 35: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine2, int idx, StyleMap sm, Value value) {
        if (value == DEFAULT_VALUE) {
            CSSContext ctx = engine2.getCSSContext();
            value = ctx.getDefaultFontFamily();
        }
        return value;
    }

    static {
        DEFAULT_VALUE.append(new StringValue(19, "Arial"));
        DEFAULT_VALUE.append(new StringValue(19, "Helvetica"));
        DEFAULT_VALUE.append(new StringValue(21, "sans-serif"));
        values = new Object2ObjectOpenHashMap();
        values.put((Object)"cursive", (Object)ValueConstants.CURSIVE_VALUE);
        values.put((Object)"fantasy", (Object)ValueConstants.FANTASY_VALUE);
        values.put((Object)"monospace", (Object)ValueConstants.MONOSPACE_VALUE);
        values.put((Object)"serif", (Object)ValueConstants.SERIF_VALUE);
        values.put((Object)"sans-serif", (Object)ValueConstants.SANS_SERIF_VALUE);
    }
}

