/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SubInputStream
extends FilterInputStream {
    private long bytesToRead;
    private boolean closeUnderlying;

    public SubInputStream(InputStream in, long maxLen, boolean closeUnderlying) {
        super(in);
        this.bytesToRead = maxLen;
        this.closeUnderlying = closeUnderlying;
    }

    public SubInputStream(InputStream in, long maxLen) {
        this(in, maxLen, false);
    }

    @Override
    public int read() throws IOException {
        if (this.bytesToRead > 0L) {
            int result2 = super.read();
            if (result2 >= 0) {
                --this.bytesToRead;
                return result2;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesToRead == 0L) {
            return -1;
        }
        int effRead = (int)Math.min(this.bytesToRead, (long)len);
        int result2 = super.read(b, off, effRead);
        if (result2 >= 0) {
            this.bytesToRead -= (long)result2;
        }
        return result2;
    }

    @Override
    public long skip(long n) throws IOException {
        long effRead = Math.min(this.bytesToRead, n);
        long result2 = super.skip(effRead);
        this.bytesToRead -= result2;
        return result2;
    }

    @Override
    public void close() throws IOException {
        this.bytesToRead = 0L;
        if (this.closeUnderlying) {
            super.close();
        }
    }
}

