/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageData;
import org.jetbrains.kotlinx.jupyter.messaging.MessageHeader;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImpl;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImplKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0001\u001aV\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00022\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a*\u0010\u0011\u001a\u00020\u000b2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u001a\"\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\t\"\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"toMessage", "Lorg/jetbrains/kotlinx/jupyter/messaging/Message;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;", "toRawMessage", "makeReplyMessage", "msg", "msgType", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageType;", "sessionId", "", "header", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageHeader;", "parentHeader", "metadata", "Lkotlinx/serialization/json/JsonElement;", "content", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageContent;", "makeHeader", "incomingMsg", "ISO8601DateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "ISO8601DateNow", "getISO8601DateNow", "()Ljava/lang/String;", "type", "username", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Message.kt\norg/jetbrains/kotlinx/jupyter/messaging/MessageKt\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n309#2:97\n298#2:98\n309#2:99\n309#2:101\n1#3:100\n*S KotlinDebug\n*F\n+ 1 Message.kt\norg/jetbrains/kotlinx/jupyter/messaging/MessageKt\n*L\n34#1:97\n38#1:98\n60#1:99\n71#1:101\n*E\n"})
public final class MessageKt {
    private static final DateTimeFormatter ISO8601DateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSxxx'['VV']'");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Message toMessage(@NotNull RawMessage $this$toMessage) {
        void $this$decodeFromJsonElement$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toMessage, (String)"<this>");
        List<byte[]> list = $this$toMessage.getId();
        Json json = RawMessageImplKt.getMessageFormat();
        JsonElement json$iv = (JsonElement)RawMessageImplKt.getData($this$toMessage);
        boolean $i$f$decodeFromJsonElement = false;
        $this$decodeFromJsonElement$iv.getSerializersModule();
        return new Message(list, (MessageData)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)MessageData.Companion.serializer(), json$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RawMessage toRawMessage(@NotNull Message $this$toRawMessage) {
        void $this$encodeToJsonElement$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toRawMessage, (String)"<this>");
        Object object = RawMessageImplKt.getMessageFormat();
        MessageData value$iv = $this$toRawMessage.getData();
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        JsonObject dataJson = JsonElementKt.getJsonObject((JsonElement)$this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)MessageData.Companion.serializer(), (Object)value$iv));
        List<byte[]> list = $this$toRawMessage.getId();
        Object object2 = dataJson.get((Object)"header");
        Intrinsics.checkNotNull((Object)object2);
        JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)((JsonElement)object2));
        object = dataJson.get((Object)"parent_header");
        JsonObject jsonObject2 = object instanceof JsonObject ? (JsonObject)object : null;
        object = dataJson.get((Object)"metadata");
        JsonObject jsonObject3 = object instanceof JsonObject ? (JsonObject)object : null;
        Object object3 = dataJson.get((Object)"content");
        Intrinsics.checkNotNull((Object)object3);
        return new RawMessageImpl(list, jsonObject, jsonObject2, jsonObject3, (JsonElement)object3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Message makeReplyMessage(@NotNull RawMessage msg, @Nullable MessageType msgType, @Nullable String sessionId, @Nullable MessageHeader header, @Nullable MessageHeader parentHeader, @Nullable JsonElement metadata2, @Nullable MessageContent content) {
        MessageHeader messageHeader;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        List<byte[]> list = msg.getId();
        MessageHeader messageHeader2 = header;
        if (messageHeader2 == null) {
            messageHeader2 = MessageKt.makeHeader(msgType, msg, sessionId);
        }
        if ((messageHeader = parentHeader) == null) {
            void $this$decodeFromJsonElement$iv;
            Json json = RawMessageImplKt.getMessageFormat();
            JsonElement json$iv = (JsonElement)msg.getHeader();
            boolean $i$f$decodeFromJsonElement = false;
            $this$decodeFromJsonElement$iv.getSerializersModule();
            messageHeader = (MessageHeader)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)MessageHeader.Companion.serializer(), json$iv);
        }
        return new Message(list, new MessageData(messageHeader2, messageHeader, metadata2, content));
    }

    public static /* synthetic */ Message makeReplyMessage$default(RawMessage rawMessage, MessageType messageType, String string, MessageHeader messageHeader, MessageHeader messageHeader2, JsonElement jsonElement, MessageContent messageContent, int n, Object object) {
        if ((n & 2) != 0) {
            messageType = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            messageHeader = null;
        }
        if ((n & 0x10) != 0) {
            messageHeader2 = null;
        }
        if ((n & 0x20) != 0) {
            jsonElement = null;
        }
        if ((n & 0x40) != 0) {
            messageContent = null;
        }
        return MessageKt.makeReplyMessage(rawMessage, messageType, string, messageHeader, messageHeader2, jsonElement, messageContent);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MessageHeader makeHeader(@Nullable MessageType msgType, @Nullable RawMessage incomingMsg, @Nullable String sessionId) {
        Object object;
        Object object2;
        MessageType messageType;
        MessageHeader parentHeader;
        MessageHeader messageHeader;
        RawMessage rawMessage = incomingMsg;
        if (rawMessage != null && (rawMessage = rawMessage.getHeader()) != null) {
            void $this$decodeFromJsonElement$iv;
            RawMessage it = rawMessage;
            boolean bl = false;
            Json json = RawMessageImplKt.getMessageFormat();
            JsonElement json$iv = (JsonElement)it;
            boolean $i$f$decodeFromJsonElement = false;
            $this$decodeFromJsonElement$iv.getSerializersModule();
            messageHeader = (MessageHeader)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)MessageHeader.Companion.serializer(), json$iv);
        } else {
            messageHeader = parentHeader = null;
        }
        if ((messageType = msgType) == null) {
            messageType = MessageType.NONE;
        }
        if ((object2 = parentHeader) == null || (object2 = ((MessageHeader)object2).getSession()) == null) {
            object2 = sessionId;
        }
        if ((object = parentHeader) == null || (object = ((MessageHeader)object).getUsername()) == null) {
            object = "kernel";
        }
        return MessageKt.makeHeader(messageType, (String)object2, (String)object);
    }

    public static /* synthetic */ MessageHeader makeHeader$default(MessageType messageType, RawMessage rawMessage, String string, int n, Object object) {
        if ((n & 1) != 0) {
            messageType = null;
        }
        if ((n & 2) != 0) {
            rawMessage = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return MessageKt.makeHeader(messageType, rawMessage, string);
    }

    @NotNull
    public static final String getISO8601DateNow() {
        String string = ZonedDateTime.now().format(ISO8601DateFormatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final MessageHeader makeHeader(@NotNull MessageType type2, @Nullable String sessionId, @Nullable String username) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new MessageHeader(string, type2, sessionId, username, "5.3", MessageKt.getISO8601DateNow());
    }
}

