/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import zmq.Command;
import zmq.Config;
import zmq.Ctx;
import zmq.IMailbox;
import zmq.Mailbox;
import zmq.Msg;
import zmq.Own;
import zmq.ZMQ;
import zmq.ZObject;
import zmq.io.IOThread;
import zmq.io.SessionBase;
import zmq.io.net.Address;
import zmq.io.net.Listener;
import zmq.io.net.NetProtocol;
import zmq.pipe.Pipe;
import zmq.poll.IPollEvents;
import zmq.poll.Poller;
import zmq.socket.Sockets;
import zmq.util.Blob;
import zmq.util.Clock;
import zmq.util.MultiMap;

public abstract class SocketBase
extends Own
implements IPollEvents,
Pipe.IPipeEvents {
    private final MultiMap<String, EndpointPipe> endpoints;
    private final MultiMap<String, Pipe> inprocs;
    private boolean active = true;
    private final AtomicBoolean ctxTerminated = new AtomicBoolean();
    private final ThreadLocal<Boolean> isInEventThreadLocal = new ThreadLocal();
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private final IMailbox mailbox;
    private final Set<Pipe> pipes;
    private Poller poller;
    private Poller.Handle handle;
    private long lastTsc = 0L;
    private int ticks = 0;
    private boolean rcvmore = false;
    private SocketChannel fileDesc;
    private int monitorEvents = 0;
    protected String connectRid;
    private final AtomicReference<ZMQ.EventConsummer> monitor = new AtomicReference<Object>(null);
    private final boolean threadSafe;
    private final ReentrantLock threadSafeSync;

    protected SocketBase(Ctx parent, int tid, int sid) {
        this(parent, tid, sid, false);
    }

    protected SocketBase(Ctx parent, int tid, int sid, boolean threadSafe) {
        super(parent, tid);
        this.options.socketId = sid;
        this.options.ipv6 = parent.get(42) != 0;
        this.options.linger = parent.get(70) != 0 ? -1 : 0;
        this.endpoints = new MultiMap();
        this.inprocs = new MultiMap();
        this.pipes = new HashSet<Pipe>();
        this.threadSafe = threadSafe;
        this.threadSafeSync = new ReentrantLock();
        this.mailbox = new Mailbox(parent, "socket-" + sid, tid);
    }

    protected abstract void xattachPipe(Pipe var1, boolean var2, boolean var3);

    protected abstract void xpipeTerminated(Pipe var1);

    boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroy() {
        AtomicReference<ZMQ.EventConsummer> atomicReference = this.monitor;
        synchronized (atomicReference) {
            try {
                this.mailbox.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stopMonitor();
            assert (this.destroyed.get());
        }
    }

    final IMailbox getMailbox() {
        return this.mailbox;
    }

    final void stop() {
        this.sendStop();
    }

    private NetProtocol checkProtocol(String protocol) {
        try {
            NetProtocol proto = NetProtocol.getProtocol(protocol);
            if (!proto.valid) {
                this.errno.set(43);
                return proto;
            }
            if (!proto.compatible(this.options.type)) {
                this.errno.set(156384764);
                return null;
            }
            return proto;
        }
        catch (IllegalArgumentException e) {
            this.errno.set(43);
            return null;
        }
    }

    private void attachPipe(Pipe pipe, boolean isLocallyInitiated) {
        this.attachPipe(pipe, false, isLocallyInitiated);
    }

    private void attachPipe(Pipe pipe, boolean subscribe2all, boolean isLocallyInitiated) {
        assert (pipe != null);
        pipe.setEventSink(this);
        this.pipes.add(pipe);
        this.xattachPipe(pipe, subscribe2all, isLocallyInitiated);
        if (this.isTerminating()) {
            this.registerTermAcks(1);
            pipe.terminate(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setSocketOpt(int option2, Object optval) {
        this.lock();
        try {
            if (this.ctxTerminated.get()) {
                this.errno.set(156384765);
                boolean bl = false;
                return bl;
            }
            boolean rc = this.xsetsockopt(option2, optval);
            if (rc || this.errno.get() != 22) {
                boolean bl = rc;
                return bl;
            }
            rc = this.options.setSocketOpt(option2, optval);
            if (rc) {
                this.errno.set(0);
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public final int getSocketOpt(int option2) {
        this.lock();
        try {
            if (this.ctxTerminated.get()) {
                this.errno.set(156384765);
                int n = -1;
                return n;
            }
            if (option2 == 13) {
                int n = this.rcvmore ? 1 : 0;
                return n;
            }
            if (option2 == 15) {
                boolean rc = this.processCommands(0, false, null);
                if (!(rc || this.errno.get() != 156384765 && this.errno.get() != 4)) {
                    int n = -1;
                    return n;
                }
                assert (rc);
                int val = 0;
                if (this.hasOut()) {
                    val |= 2;
                }
                if (this.hasIn()) {
                    val |= 1;
                }
                int n = val;
                return n;
            }
            Object val = this.options.getSocketOpt(option2);
            if (val instanceof Integer) {
                int n = (Integer)val;
                return n;
            }
            if (val instanceof Boolean) {
                int n = (Boolean)val != false ? 1 : 0;
                return n;
            }
            throw new IllegalArgumentException(val + " is neither an integer or a boolean for option " + option2);
        }
        finally {
            this.unlock();
        }
    }

    public final Object getSocketOptx(int option2) {
        if (this.ctxTerminated.get()) {
            this.errno.set(156384765);
            return null;
        }
        if (option2 == 13) {
            return this.rcvmore ? 1 : 0;
        }
        if (option2 == 14) {
            if (this.threadSafe) {
                this.errno.set(22);
                return null;
            }
            return ((Mailbox)this.mailbox).getFd();
        }
        if (option2 == 15) {
            boolean rc = this.processCommands(0, false, null);
            if (!(rc || this.errno.get() != 156384765 && this.errno.get() != 4)) {
                return -1;
            }
            assert (rc);
            int val = 0;
            if (this.hasOut()) {
                val |= 2;
            }
            if (this.hasIn()) {
                val |= 1;
            }
            return val;
        }
        return this.options.getSocketOpt(option2);
    }

    public final boolean bind(String addr) {
        this.lock();
        try {
            if (this.ctxTerminated.get()) {
                this.errno.set(156384765);
                boolean bl = false;
                return bl;
            }
            this.options.mechanism.check(this.options);
            boolean brc = this.processCommands(0, false, null);
            if (!brc) {
                boolean bl = false;
                return bl;
            }
            SimpleURI uri = SimpleURI.create(addr);
            String address = uri.getAddress();
            NetProtocol protocol = this.checkProtocol(uri.getProtocol());
            if (protocol == null) {
                boolean bl = false;
                return bl;
            }
            switch (protocol) {
                case inproc: {
                    Ctx.Endpoint endpoint = new Ctx.Endpoint(this, this.options);
                    boolean rc = this.registerEndpoint(addr, endpoint);
                    if (rc) {
                        this.connectPending(addr, this);
                        this.options.lastEndpoint = addr;
                    } else {
                        this.errno.set(48);
                    }
                    boolean bl = rc;
                    return bl;
                }
                case pgm: 
                case epgm: 
                case norm: {
                    boolean endpoint = this.connect(addr);
                    return endpoint;
                }
                case tcp: 
                case ipc: 
                case tipc: {
                    IOThread ioThread = this.chooseIoThread(this.options.affinity);
                    if (ioThread == null) {
                        this.errno.set(156384766);
                        boolean rc = false;
                        return rc;
                    }
                    Listener listener2 = protocol.getListener(ioThread, this, this.options);
                    boolean rc = listener2.setAddress(address);
                    if (!rc) {
                        listener2.destroy();
                        this.eventBindFailed(address, this.errno.get());
                        boolean bl = false;
                        return bl;
                    }
                    this.options.lastEndpoint = listener2.getAddress();
                    this.addEndpoint(this.options.lastEndpoint, listener2, null);
                    boolean bl = true;
                    return bl;
                }
            }
            throw new IllegalArgumentException(addr);
        }
        finally {
            this.unlock();
        }
    }

    public final boolean connect(String addr) {
        this.lock();
        try {
            boolean bl = this.connectInternal(addr);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int connectPeer(String addr) {
        this.lock();
        try {
            if (this.options.type != 17 && this.options.type != 18) {
                this.errno.set(45);
                int n = 0;
                return n;
            }
            boolean rc = this.connectInternal(addr);
            if (!rc) {
                int n = 0;
                return n;
            }
            int n = this.options.peerLastRoutingId;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    private boolean connectInternal(String addr) {
        boolean isSingleConnect;
        if (this.ctxTerminated.get()) {
            this.errno.set(156384765);
            return false;
        }
        this.options.mechanism.check(this.options);
        boolean brc = this.processCommands(0, false, null);
        if (!brc) {
            return false;
        }
        SimpleURI uri = SimpleURI.create(addr);
        String address = uri.getAddress();
        NetProtocol protocol = this.checkProtocol(uri.getProtocol());
        if (protocol == null || !protocol.valid) {
            return false;
        }
        if (protocol == NetProtocol.inproc) {
            Ctx.Endpoint peer = this.findEndpoint(addr);
            int sndhwm = 0;
            if (peer.socket == null) {
                sndhwm = this.options.sendHwm;
            } else if (this.options.sendHwm != 0 && peer.options.recvHwm != 0) {
                sndhwm = this.options.sendHwm + peer.options.recvHwm;
            }
            int rcvhwm = 0;
            if (peer.socket == null) {
                rcvhwm = this.options.recvHwm;
            } else if (this.options.recvHwm != 0 && peer.options.sendHwm != 0) {
                rcvhwm = this.options.recvHwm + peer.options.sendHwm;
            }
            ZObject[] parents = new ZObject[]{this, peer.socket == null ? this : peer.socket};
            boolean conflate = this.options.conflate && (this.options.type == 5 || this.options.type == 7 || this.options.type == 8 || this.options.type == 1 || this.options.type == 2);
            int[] hwms = new int[]{conflate ? -1 : sndhwm, conflate ? -1 : rcvhwm};
            boolean[] conflates = new boolean[]{conflate, conflate};
            Pipe[] pipes = Pipe.pair(parents, hwms, conflates);
            this.attachPipe(pipes[0], true);
            if (peer.socket == null) {
                Msg id = new Msg(this.options.identitySize);
                id.put(this.options.identity, 0, (int)this.options.identitySize);
                id.setFlags(64);
                boolean written = pipes[0].write(id);
                assert (written);
                pipes[0].flush();
                if (this.options.canSendHelloMsg && this.options.helloMsg != null) {
                    written = pipes[0].write(this.options.helloMsg);
                    assert (written);
                    pipes[0].flush();
                }
                this.pendConnection(addr, new Ctx.Endpoint(this, this.options), pipes);
            } else {
                boolean written;
                Msg id;
                if (peer.options.recvIdentity) {
                    id = new Msg(this.options.identitySize);
                    id.put(this.options.identity, 0, (int)this.options.identitySize);
                    id.setFlags(64);
                    written = pipes[0].write(id);
                    assert (written);
                    pipes[0].flush();
                }
                if (this.options.recvIdentity) {
                    id = new Msg(peer.options.identitySize);
                    id.put(peer.options.identity, 0, (int)peer.options.identitySize);
                    id.setFlags(64);
                    written = pipes[1].write(id);
                    assert (written);
                    pipes[1].flush();
                }
                if (this.options.canSendHelloMsg && this.options.helloMsg != null) {
                    boolean written2 = pipes[0].write(this.options.helloMsg);
                    assert (written2);
                    pipes[0].flush();
                }
                if (peer.options.canSendHelloMsg && peer.options.helloMsg != null) {
                    boolean written3 = pipes[1].write(peer.options.helloMsg);
                    assert (written3);
                    pipes[1].flush();
                }
                if (peer.options.canReceiveDisconnectMsg && peer.options.disconnectMsg != null) {
                    pipes[0].setDisconnectMsg(peer.options.disconnectMsg);
                }
                this.sendBind(peer.socket, pipes[1], false);
            }
            this.options.lastEndpoint = addr;
            this.inprocs.insert(addr, pipes[0]);
            return true;
        }
        boolean bl = isSingleConnect = this.options.type == 5 || this.options.type == 2 || this.options.type == 3;
        if (isSingleConnect && this.endpoints.hasValues(addr)) {
            return true;
        }
        IOThread ioThread = this.chooseIoThread(this.options.affinity);
        if (ioThread == null) {
            this.errno.set(156384766);
            return false;
        }
        Address paddr = new Address(protocol, address);
        protocol.resolve(paddr, this.options.ipv6);
        SessionBase session = Sockets.createSession(ioThread, true, this, this.options, paddr);
        assert (session != null);
        boolean subscribe2all = protocol.subscribe2all;
        Pipe newpipe = null;
        if (this.options.immediate || subscribe2all) {
            ZObject[] parents = new ZObject[]{this, session};
            boolean conflate = this.options.conflate && (this.options.type == 5 || this.options.type == 7 || this.options.type == 8 || this.options.type == 1 || this.options.type == 2);
            int[] hwms = new int[]{conflate ? -1 : this.options.sendHwm, conflate ? -1 : this.options.recvHwm};
            boolean[] conflates = new boolean[]{conflate, conflate};
            Pipe[] pipes = Pipe.pair(parents, hwms, conflates);
            this.attachPipe(pipes[0], subscribe2all, true);
            newpipe = pipes[0];
            session.attachPipe(pipes[1]);
        }
        this.options.lastEndpoint = paddr.toString();
        this.addEndpoint(addr, session, newpipe);
        return true;
    }

    public boolean disconnectPeer(int routingId) {
        return this.xdisconnectPeer(routingId);
    }

    private void addEndpoint(String addr, Own endpoint, Pipe pipe) {
        this.launchChild(endpoint);
        this.endpoints.insert(addr, new EndpointPipe(endpoint, pipe));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean termEndpoint(String addr) {
        this.lock();
        try {
            Collection<EndpointPipe> eps;
            Address.IZAddress address;
            boolean endpoint;
            if (this.ctxTerminated.get()) {
                this.errno.set(156384765);
                boolean bl = false;
                return bl;
            }
            if (addr == null) {
                this.errno.set(22);
                boolean bl = false;
                return bl;
            }
            boolean rc = this.processCommands(0, false, null);
            if (!rc) {
                boolean bl = false;
                return bl;
            }
            SimpleURI uri = SimpleURI.create(addr);
            NetProtocol protocol = this.checkProtocol(uri.getProtocol());
            if (protocol == null) {
                boolean bl = false;
                return bl;
            }
            if (protocol == NetProtocol.inproc) {
                if (this.unregisterEndpoint(addr, this)) {
                    boolean bl = true;
                    return bl;
                }
                Collection<Pipe> olds = this.inprocs.remove(addr);
                if (olds == null || olds.isEmpty()) {
                    this.errno.set(2);
                    boolean bl = false;
                    return bl;
                }
                for (Pipe old : olds) {
                    old.sendDisconnectMsg();
                    old.terminate(true);
                }
                boolean bl = true;
                return bl;
            }
            String resolvedAddress = addr;
            if (protocol == NetProtocol.tcp && !(endpoint = this.endpoints.hasValues(resolvedAddress)) && !(endpoint = this.endpoints.hasValues(resolvedAddress = (address = protocol.zresolve(uri.getAddress(), this.options.ipv6)).address().toString()))) {
                InetSocketAddress socketAddress = address.resolve(uri.getAddress(), this.options.ipv6, true);
                resolvedAddress = socketAddress.toString();
            }
            if ((eps = this.endpoints.remove(resolvedAddress)) == null || eps.isEmpty()) {
                this.errno.set(2);
                boolean bl = false;
                return bl;
            }
            for (EndpointPipe ep : eps) {
                if (ep.pipe != null) {
                    ep.pipe.terminate(false);
                }
                this.termChild(ep.endpoint);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public final boolean send(Msg msg, int flags) {
        return this.send(msg, flags, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean send(Msg msg, int flags, AtomicBoolean canceled) {
        this.lock();
        try {
            block21: {
                long end;
                if (this.ctxTerminated.get()) {
                    this.errno.set(156384765);
                    boolean bl = false;
                    return bl;
                }
                if (msg == null || !msg.check()) {
                    this.errno.set(14);
                    boolean bl = false;
                    return bl;
                }
                boolean brc = this.processCommands(0, true, canceled);
                if (!brc) {
                    boolean bl = false;
                    return bl;
                }
                msg.resetFlags(1);
                if ((flags & 2) > 0) {
                    msg.setFlags(1);
                }
                msg.resetMetadata();
                boolean rc = this.xsend(msg);
                if (rc) {
                    boolean bl = true;
                    return bl;
                }
                if (this.errno.get() != 35) {
                    boolean bl = false;
                    return bl;
                }
                if ((flags & 1) > 0 || this.options.sendTimeout == 0) {
                    boolean bl = false;
                    return bl;
                }
                int timeout = this.options.sendTimeout;
                long l = end = timeout < 0 ? 0L : Clock.nowMS() + (long)timeout;
                do {
                    if (!this.processCommands(timeout, false, canceled)) {
                        boolean bl = false;
                        return bl;
                    }
                    rc = this.xsend(msg);
                    if (rc) break block21;
                    if (this.errno.get() == 35) continue;
                    boolean bl = false;
                    return bl;
                } while (timeout <= 0 || (timeout = (int)(end - Clock.nowMS())) > 0);
                this.errno.set(35);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public final Msg recv(int flags) {
        return this.recv(flags, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Msg recv(int flags, AtomicBoolean canceled) {
        this.lock();
        try {
            Msg msg;
            block25: {
                if (this.ctxTerminated.get()) {
                    this.errno.set(156384765);
                    Msg msg2 = null;
                    return msg2;
                }
                if (++this.ticks == Config.INBOUND_POLL_RATE.getValue()) {
                    if (!this.processCommands(0, false, canceled)) {
                        Msg msg3 = null;
                        return msg3;
                    }
                    this.ticks = 0;
                }
                if ((msg = this.xrecv()) == null && this.errno.get() != 35) {
                    Msg msg4 = null;
                    return msg4;
                }
                if (msg != null) {
                    if (this.fileDesc != null) {
                        msg.setFd(this.fileDesc);
                    }
                    this.extractFlags(msg);
                    Msg msg5 = msg;
                    return msg5;
                }
                if ((flags & 1) > 0 || this.options.recvTimeout == 0) {
                    if (!this.processCommands(0, false, canceled)) {
                        Msg msg6 = null;
                        return msg6;
                    }
                    this.ticks = 0;
                    msg = this.xrecv();
                    if (msg == null) {
                        Msg msg7 = null;
                        return msg7;
                    }
                    this.extractFlags(msg);
                    Msg msg8 = msg;
                    return msg8;
                }
                int timeout = this.options.recvTimeout;
                long end = timeout < 0 ? 0L : Clock.nowMS() + (long)timeout;
                boolean block = this.ticks != 0;
                do {
                    if (!this.processCommands(block ? timeout : 0, false, canceled)) {
                        Msg msg9 = null;
                        return msg9;
                    }
                    msg = this.xrecv();
                    if (msg != null) break block25;
                    if (this.errno.get() != 35) {
                        Msg msg10 = null;
                        return msg10;
                    }
                    block = true;
                } while (timeout <= 0 || (timeout = (int)(end - Clock.nowMS())) > 0);
                this.errno.set(35);
                Msg msg11 = null;
                return msg11;
            }
            this.ticks = 0;
            this.extractFlags(msg);
            Msg msg12 = msg;
            return msg12;
        }
        finally {
            this.unlock();
        }
    }

    public final boolean join(String group) {
        this.lock();
        try {
            boolean bl = this.xjoin(group);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public final boolean leave(String group) {
        this.lock();
        try {
            boolean bl = this.xleave(group);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public final void cancel(AtomicBoolean canceled) {
        canceled.set(true);
        this.sendCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int poll(int interest, int timeout, AtomicBoolean canceled) {
        this.lock();
        try {
            long end;
            if (this.ctxTerminated.get()) {
                this.errno.set(156384765);
                int n = -1;
                return n;
            }
            int ready = 0;
            if (this.hasOut() && (interest & 2) > 0) {
                ready |= 2;
            }
            if (this.hasIn() && (interest & 1) > 0) {
                ready |= 1;
            }
            if (ready != 0) {
                int n = ready;
                return n;
            }
            long l = end = timeout < 0 ? 0L : Clock.nowMS() + (long)timeout;
            do {
                if (!this.processCommands(timeout, false, canceled)) {
                    int n = -1;
                    return n;
                }
                ready = 0;
                if (this.hasOut() && (interest & 2) > 0) {
                    ready |= 2;
                }
                if (this.hasIn() && (interest & 1) > 0) {
                    ready |= 1;
                }
                if (ready != 0) {
                    int n = ready;
                    return n;
                }
                if (timeout != 0) continue;
                this.errno.set(35);
                int n = -1;
                return n;
            } while (timeout <= 0 || (timeout = (int)(end - Clock.nowMS())) > 0);
            this.errno.set(35);
            int n = -1;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public final void close() {
        this.lock();
        try {
            this.active = false;
            this.sendReap(this);
        }
        finally {
            this.unlock();
        }
    }

    final boolean hasIn() {
        return this.xhasIn();
    }

    final boolean hasOut() {
        return this.xhasOut();
    }

    final void startReaping(Poller poller) {
        this.poller = poller;
        SelectableChannel fd = ((Mailbox)this.mailbox).getFd();
        this.handle = this.poller.addHandle(fd, this);
        this.poller.setPollIn(this.handle);
        this.ctxTerminated.set(true);
        this.terminate();
        this.checkDestroy();
    }

    private boolean isInEvent() {
        Boolean bRes = this.isInEventThreadLocal.get();
        return null != bRes && bRes != false;
    }

    private boolean processCommands(int timeout, boolean throttle, AtomicBoolean canceled) {
        Command cmd;
        if (timeout != 0) {
            cmd = this.mailbox.recv(timeout);
        } else {
            long tsc = 0L;
            if (tsc != 0L && throttle) {
                if (tsc >= this.lastTsc && tsc - this.lastTsc <= (long)Config.MAX_COMMAND_DELAY.getValue()) {
                    return true;
                }
                this.lastTsc = tsc;
            }
            cmd = this.mailbox.recv(0L);
        }
        while (cmd != null) {
            cmd.process();
            cmd = this.mailbox.recv(0L);
        }
        if (!this.isInEvent() && this.destroyed.get()) {
            this.sendReapAck();
        }
        if (this.errno.get() == 4) {
            return false;
        }
        if (canceled != null && canceled.get()) {
            this.errno.set(125);
            return false;
        }
        assert (this.errno.get() == 35) : this.errno;
        if (this.ctxTerminated.get()) {
            this.errno.set(156384765);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void processStop() {
        AtomicReference<ZMQ.EventConsummer> atomicReference = this.monitor;
        synchronized (atomicReference) {
            this.stopMonitor();
            this.ctxTerminated.set(true);
        }
    }

    @Override
    protected final void processBind(Pipe pipe) {
        this.attachPipe(pipe, false);
    }

    @Override
    protected final void processTerm(int linger) {
        this.unregisterEndpoints(this);
        for (Pipe pipe : this.pipes) {
            pipe.sendDisconnectMsg();
            pipe.terminate(false);
        }
        this.registerTermAcks(this.pipes.size());
        super.processTerm(linger);
    }

    @Override
    protected final void processDestroy() {
        this.destroyed.set(true);
    }

    protected boolean xsetsockopt(int option2, Object optval) {
        this.errno.set(22);
        return false;
    }

    protected boolean xhasOut() {
        return false;
    }

    protected boolean xsend(Msg msg) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected boolean xhasIn() {
        return false;
    }

    protected Msg xrecv() {
        throw new UnsupportedOperationException("Must Override");
    }

    protected Blob getCredential() {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xreadActivated(Pipe pipe) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xwriteActivated(Pipe pipe) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xhiccuped(Pipe pipe) {
        throw new UnsupportedOperationException("Must override");
    }

    protected boolean xjoin(String group) {
        throw new UnsupportedOperationException("Must override");
    }

    protected boolean xleave(String group) {
        throw new UnsupportedOperationException("Must override");
    }

    protected boolean xdisconnectPeer(int routingId) {
        throw new UnsupportedOperationException("Must override");
    }

    private void enterInEvent() {
        this.isInEventThreadLocal.set(true);
    }

    private void leaveInEvent() {
        this.isInEventThreadLocal.remove();
    }

    @Override
    public final void inEvent() {
        this.lock();
        try {
            this.enterInEvent();
            this.processCommands(0, false, null);
        }
        finally {
            this.leaveInEvent();
            this.unlock();
        }
        this.checkDestroy();
    }

    private void checkDestroy() {
        if (this.destroyed.get()) {
            this.poller.removeHandle(this.handle);
            this.destroySocket(this);
            this.sendReaped();
            super.processDestroy();
        }
    }

    @Override
    public final void readActivated(Pipe pipe) {
        this.xreadActivated(pipe);
    }

    @Override
    public final void writeActivated(Pipe pipe) {
        this.xwriteActivated(pipe);
    }

    @Override
    public final void hiccuped(Pipe pipe) {
        if (!this.options.immediate) {
            pipe.terminate(false);
        } else {
            this.xhiccuped(pipe);
        }
    }

    @Override
    public final void pipeTerminated(Pipe pipe) {
        this.xpipeTerminated(pipe);
        this.inprocs.remove(pipe);
        this.pipes.remove(pipe);
        if (this.isTerminating()) {
            this.unregisterTermAck();
        }
    }

    private void extractFlags(Msg msg) {
        assert (!msg.isIdentity() || this.options.recvIdentity);
        this.rcvmore = msg.hasMore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean monitor(String addr, int events) {
        AtomicReference<ZMQ.EventConsummer> atomicReference = this.monitor;
        synchronized (atomicReference) {
            if (this.ctxTerminated.get()) {
                this.errno.set(156384765);
                return false;
            }
            if (addr == null) {
                this.stopMonitor();
                return true;
            }
            SimpleURI uri = SimpleURI.create(addr);
            NetProtocol protocol = this.checkProtocol(uri.getProtocol());
            if (protocol == null) {
                return false;
            }
            if (protocol != NetProtocol.inproc) {
                this.errno.set(43);
                return false;
            }
            SocketBase monitorSocket = this.getCtx().createSocket(0);
            if (monitorSocket == null) {
                return false;
            }
            monitorSocket.setSocketOpt(17, 0);
            boolean rc = monitorSocket.bind(addr);
            if (rc) {
                return this.setEventHook(new SocketEventHandler(monitorSocket), events);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setEventHook(ZMQ.EventConsummer consumer, int events) {
        AtomicReference<ZMQ.EventConsummer> atomicReference = this.monitor;
        synchronized (atomicReference) {
            if (this.ctxTerminated.get()) {
                this.errno.set(156384765);
                return false;
            }
            if (consumer == null) {
                this.stopMonitor();
            } else {
                if (this.monitor.get() != null) {
                    throw new IllegalStateException("Monitor registered twice");
                }
                this.monitor.set(consumer);
                this.monitorEvents = events;
            }
            return true;
        }
    }

    public final void eventHandshaken(String addr, int zmtpVersion) {
        this.event(addr, zmtpVersion, 32768);
    }

    public final void eventConnected(String addr, SelectableChannel ch) {
        this.event(addr, ch, 1);
    }

    public final void eventConnectDelayed(String addr, int errno) {
        this.event(addr, errno, 2);
    }

    public final void eventConnectRetried(String addr, int interval) {
        this.event(addr, interval, 4);
    }

    public final void eventListening(String addr, SelectableChannel ch) {
        this.event(addr, ch, 8);
    }

    public final void eventBindFailed(String addr, int errno) {
        this.event(addr, errno, 16);
    }

    public final void eventAccepted(String addr, SelectableChannel ch) {
        this.event(addr, ch, 32);
    }

    public final void eventAcceptFailed(String addr, int errno) {
        this.event(addr, errno, 64);
    }

    public final void eventClosed(String addr, SelectableChannel ch) {
        this.event(addr, ch, 128);
    }

    public final void eventCloseFailed(String addr, int errno) {
        this.event(addr, errno, 256);
    }

    public final void eventDisconnected(String addr, SelectableChannel ch) {
        this.event(addr, ch, 512);
    }

    public final void eventHandshakeFailedNoDetail(String addr, int errno) {
        this.event(addr, errno, 2048);
    }

    public final void eventHandshakeFailedProtocol(String addr, int errno) {
        this.event(addr, errno, 8192);
    }

    public final void eventHandshakeFailedAuth(String addr, int errno) {
        this.event(addr, errno, 16384);
    }

    public final void eventHandshakeSucceeded(String addr, int errno) {
        this.event(addr, errno, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void event(String addr, Object arg, int event) {
        AtomicReference<ZMQ.EventConsummer> atomicReference = this.monitor;
        synchronized (atomicReference) {
            if ((this.monitorEvents & event) == 0 || this.monitor.get() == null) {
                return;
            }
            this.monitorEvent(new ZMQ.Event(event, addr, arg));
        }
    }

    protected final void monitorEvent(ZMQ.Event event) {
        if (this.monitor.get() == null) {
            return;
        }
        this.monitor.get().consume(event);
    }

    private void stopMonitor() {
        if (this.monitor.get() != null) {
            if ((this.monitorEvents & 0x400) != 0) {
                this.monitorEvent(new ZMQ.Event(1024, "", 0));
            }
            this.monitor.get().close();
            this.monitor.set(null);
            this.monitorEvents = 0;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.options.socketId + "]";
    }

    public final SelectableChannel getFD() {
        if (this.threadSafe) {
            this.errno.set(22);
            return null;
        }
        return ((Mailbox)this.mailbox).getFd();
    }

    public String typeString() {
        return Sockets.name(this.options.type);
    }

    public final int errno() {
        return this.errno.get();
    }

    private void lock() {
        if (this.threadSafe) {
            this.threadSafeSync.lock();
        }
    }

    private void unlock() {
        if (this.threadSafe) {
            this.threadSafeSync.unlock();
        }
    }

    private static class SimpleURI {
        private final String protocol;
        private final String address;

        private SimpleURI(String protocol, String address) {
            this.protocol = protocol;
            this.address = address;
        }

        public static SimpleURI create(String value) {
            int pos = value.indexOf("://");
            if (pos < 0) {
                throw new IllegalArgumentException("Invalid URI: " + value);
            }
            String protocol = value.substring(0, pos);
            String address = value.substring(pos + 3);
            if (protocol.isEmpty() || address.isEmpty()) {
                throw new IllegalArgumentException("Invalid URI: " + value);
            }
            return new SimpleURI(protocol, address);
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getAddress() {
            return this.address;
        }
    }

    private static class EndpointPipe {
        private final Own endpoint;
        private final Pipe pipe;

        public EndpointPipe(Own endpoint, Pipe pipe) {
            this.endpoint = endpoint;
            this.pipe = pipe;
        }

        public String toString() {
            return "EndpointPipe [endpoint=" + this.endpoint + ", pipe=" + this.pipe + "]";
        }
    }

    private static class SocketEventHandler
    implements ZMQ.EventConsummer {
        private final SocketBase monitorSocket;

        public SocketEventHandler(SocketBase monitorSocket) {
            this.monitorSocket = monitorSocket;
        }

        @Override
        public void consume(ZMQ.Event ev) {
            ev.write(this.monitorSocket);
        }

        @Override
        public void close() {
            this.monitorSocket.close();
        }
    }
}

