/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.mechanism;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import zmq.Options;
import zmq.ZMQ;
import zmq.io.SessionBase;
import zmq.io.mechanism.Mechanism;
import zmq.io.mechanism.NullMechanism;
import zmq.io.mechanism.curve.CurveClientMechanism;
import zmq.io.mechanism.curve.CurveServerMechanism;
import zmq.io.mechanism.gssapi.GssapiClientMechanism;
import zmq.io.mechanism.gssapi.GssapiServerMechanism;
import zmq.io.mechanism.plain.PlainClientMechanism;
import zmq.io.mechanism.plain.PlainServerMechanism;
import zmq.io.net.Address;

public enum Mechanisms {
    NULL{

        @Override
        public void check(Options options2) {
        }

        @Override
        public Mechanism create(SessionBase session, Address peerAddress, Options options2) {
            return new NullMechanism(session, peerAddress, options2);
        }
    }
    ,
    PLAIN{

        @Override
        public void check(Options options2) {
            if (!options2.asServer) {
                HashSet<String> errors = new HashSet<String>(2);
                if (options2.plainUsername == null || options2.plainUsername.length() >= 256) {
                    errors.add("user name invalid");
                }
                if (options2.plainPassword == null || options2.plainPassword.length() >= 256) {
                    errors.add("password is invalid");
                }
                if (!errors.isEmpty()) {
                    throw new IllegalStateException("Plain mechanism definition incomplete: " + errors);
                }
            }
        }

        @Override
        public Mechanism create(SessionBase session, Address peerAddress, Options options2) {
            if (options2.asServer) {
                return new PlainServerMechanism(session, peerAddress, options2);
            }
            return new PlainClientMechanism(session, options2);
        }
    }
    ,
    CURVE{

        @Override
        public void check(Options options2) {
            HashSet<String> errors = new HashSet<String>(3);
            if (options2.curvePublicKey == null || options2.curvePublicKey.length != 32) {
                errors.add("public key is invalid");
            }
            if (options2.curveSecretKey == null || options2.curveSecretKey.length != 32) {
                errors.add("secret key is invalid");
            }
            if (!(options2.asServer || options2.curveServerKey != null && options2.curveServerKey.length == 32)) {
                errors.add("not a server and no server public key given");
            }
            if (!errors.isEmpty()) {
                throw new IllegalStateException("Curve mechanism definition incomplete: " + errors);
            }
        }

        @Override
        public Mechanism create(SessionBase session, Address peerAddress, Options options2) {
            if (options2.asServer) {
                return new CurveServerMechanism(session, peerAddress, options2);
            }
            return new CurveClientMechanism(session, options2);
        }
    }
    ,
    GSSAPI{

        @Override
        public void check(Options options2) {
            throw new UnsupportedOperationException("GSSAPI mechanism is not yet implemented");
        }

        @Override
        public Mechanism create(SessionBase session, Address peerAddress, Options options2) {
            if (options2.asServer) {
                return new GssapiServerMechanism(session, peerAddress, options2);
            }
            return new GssapiClientMechanism(session, options2);
        }
    };


    public abstract Mechanism create(SessionBase var1, Address var2, Options var3);

    public abstract void check(Options var1);

    public boolean isMechanism(ByteBuffer greetingRecv) {
        byte[] dst = new byte[20];
        greetingRecv.get(dst, 0, dst.length);
        byte[] name = this.name().getBytes(ZMQ.CHARSET);
        byte[] comp = Arrays.copyOf(name, 20);
        return Arrays.equals(dst, comp);
    }
}

