/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.debugger.impl.frontend.actions;

import com.intellij.java.debugger.impl.shared.actions.ViewTextActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.FrontendXValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueDescriptor;
import com.intellij.xdebugger.frame.XValueType;
import com.intellij.xdebugger.impl.actions.FrontendDebuggerActionsKt;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/java/debugger/impl/frontend/actions/FrontendViewTextAction;", "Lcom/intellij/java/debugger/impl/shared/actions/ViewTextActionBase;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getStringNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "intellij.java.debugger.impl.frontend"})
final class FrontendViewTextAction
extends ViewTextActionBase
implements ActionRemoteBehaviorSpecification.Frontend {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!FrontendDebuggerActionsKt.areFrontendDebuggerActionsEnabled()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        super.update(e);
    }

    @Nullable
    protected XValueNodeImpl getStringNode(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List list = XDebuggerTreeActionBase.getSelectedNodes((DataContext)e.getDataContext());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedNodes(...)");
        XValueNodeImpl xValueNodeImpl = (XValueNodeImpl)CollectionsKt.singleOrNull((List)list);
        if (xValueNodeImpl == null) {
            return null;
        }
        XValueNodeImpl node = xValueNodeImpl;
        XValueContainer xValueContainer = node.getValueContainer();
        FrontendXValue frontendXValue = xValueContainer instanceof FrontendXValue ? (FrontendXValue)xValueContainer : null;
        if (frontendXValue == null) {
            return null;
        }
        FrontendXValue xValue = frontendXValue;
        XValueDescriptor xValueDescriptor = xValue.getDescriptor();
        if (xValueDescriptor == null) {
            return null;
        }
        XValueDescriptor descriptor = xValueDescriptor;
        if (xValue.getModifier() != null && Intrinsics.areEqual((Object)descriptor.getKind(), (Object)"JavaValue") && descriptor.getType() instanceof XValueType.StringType) {
            return node;
        }
        return null;
    }
}

