/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.util.ReflectionUtilRt;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.ActivationOS;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryPolicy;
import org.apache.maven.api.model.Resource;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenBuild;
import org.jetbrains.idea.maven.model.MavenBuildBase;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenParent;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProfile;
import org.jetbrains.idea.maven.model.MavenProfileActivation;
import org.jetbrains.idea.maven.model.MavenProfileActivationFile;
import org.jetbrains.idea.maven.model.MavenProfileActivationOS;
import org.jetbrains.idea.maven.model.MavenProfileActivationProperty;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.server.MavenServerGlobals;

public final class Maven40ApiModelConverter {
    @NotNull
    public static MavenModel convertModel(Model model) {
        Build build = model.getBuild();
        return Maven40ApiModelConverter.convertModel(model, Maven40ApiModelConverter.asSourcesList(build.getSourceDirectory()), Maven40ApiModelConverter.asSourcesList(build.getTestSourceDirectory()));
    }

    @NotNull
    private static MavenModel convertModel(Model model, List<String> sources, List<String> testSources) {
        MavenModel result = new MavenModel();
        result.setMavenId(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()));
        Parent parent = model.getParent();
        if (parent != null) {
            result.setParent(new MavenParent(new MavenId(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()), parent.getRelativePath()));
        }
        result.setPackaging(model.getPackaging());
        result.setName(model.getName());
        result.setProperties(model.getProperties());
        result.setPlugins(Maven40ApiModelConverter.convertPlugins(model));
        result.setRemoteRepositories(Maven40ApiModelConverter.convertRepositories(model.getRepositories()));
        result.setRemotePluginRepositories(Maven40ApiModelConverter.convertRepositories(model.getPluginRepositories()));
        result.setProfiles(Maven40ApiModelConverter.convertProfiles(model.getProfiles()));
        result.setModules(model.getModules());
        Maven40ApiModelConverter.convertBuild(result.getBuild(), model.getBuild(), sources, testSources);
        MavenModel mavenModel = result;
        if (mavenModel == null) {
            Maven40ApiModelConverter.$$$reportNull$$$0(0);
        }
        return mavenModel;
    }

    private static List<MavenPlugin> convertPlugins(Model mavenModel) {
        List plugins;
        ArrayList<MavenPlugin> result = new ArrayList<MavenPlugin>();
        Build build = mavenModel.getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            for (Plugin each : plugins) {
                result.add(Maven40ApiModelConverter.convertPlugin(false, each));
            }
        }
        return result;
    }

    private static MavenPlugin convertPlugin(boolean isDefault, Plugin plugin) {
        ArrayList<MavenPlugin.Execution> executions = new ArrayList<MavenPlugin.Execution>(plugin.getExecutions().size());
        for (PluginExecution each : plugin.getExecutions()) {
            executions.add(Maven40ApiModelConverter.convertExecution(each));
        }
        ArrayList<MavenId> deps = new ArrayList<MavenId>(plugin.getDependencies().size());
        for (Dependency each : plugin.getDependencies()) {
            deps.add(new MavenId(each.getGroupId(), each.getArtifactId(), each.getVersion()));
        }
        return new MavenPlugin(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), isDefault, "true".equals(plugin.getExtensions()), Maven40ApiModelConverter.convertConfiguration(plugin.getConfiguration()), executions, deps);
    }

    private static MavenPlugin.Execution convertExecution(PluginExecution execution) {
        return new MavenPlugin.Execution(execution.getId(), execution.getPhase(), execution.getGoals(), Maven40ApiModelConverter.convertConfiguration(execution.getConfiguration()));
    }

    private static Element convertConfiguration(Object config) {
        return config == null ? null : Maven40ApiModelConverter.xppToElement((Xpp3Dom)config);
    }

    private static Element xppToElement(Xpp3Dom xpp) {
        Element result;
        try {
            result = new Element(xpp.getName());
        }
        catch (IllegalNameException e) {
            MavenServerGlobals.getLogger().info((Throwable)e);
            return null;
        }
        Xpp3Dom[] children = xpp.getChildren();
        if (children == null || children.length == 0) {
            result.setText(xpp.getValue());
        } else {
            for (Xpp3Dom each : children) {
                Element child = Maven40ApiModelConverter.xppToElement(each);
                if (child == null) continue;
                result.addContent(child);
            }
        }
        return result;
    }

    private static List<String> asSourcesList(String directory) {
        return directory == null ? Collections.emptyList() : Collections.singletonList(directory);
    }

    private static void convertBuild(MavenBuild result, Build build, List<String> sources, List<String> testSources) {
        Maven40ApiModelConverter.convertBuildBase((MavenBuildBase)result, (BuildBase)build);
        result.setOutputDirectory(build.getOutputDirectory());
        result.setTestOutputDirectory(build.getTestOutputDirectory());
        result.setSources(sources);
        result.setTestSources(testSources);
    }

    private static void convertBuildBase(MavenBuildBase result, BuildBase build) {
        result.setFinalName(build.getFinalName());
        result.setDefaultGoal(build.getDefaultGoal());
        result.setDirectory(build.getDirectory());
        result.setResources(Maven40ApiModelConverter.convertResources(build.getResources()));
        result.setTestResources(Maven40ApiModelConverter.convertResources(build.getTestResources()));
        result.setFilters(build.getFilters() == null ? Collections.emptyList() : build.getFilters());
    }

    private static List<MavenResource> convertResources(List<Resource> resources) {
        if (resources == null) {
            return new ArrayList<MavenResource>();
        }
        ArrayList<MavenResource> result = new ArrayList<MavenResource>(resources.size());
        for (Resource each : resources) {
            String directory = each.getDirectory();
            if (null == directory) continue;
            result.add(new MavenResource(directory, each.isFiltering(), each.getTargetPath(), Maven40ApiModelConverter.ensurePatterns(each.getIncludes()), Maven40ApiModelConverter.ensurePatterns(each.getExcludes())));
        }
        return result;
    }

    private static List<String> ensurePatterns(List<String> patterns) {
        return patterns == null ? Collections.emptyList() : patterns;
    }

    private static List<MavenRemoteRepository> convertRepositories(List<? extends Repository> repositories) {
        if (repositories == null) {
            return new ArrayList<MavenRemoteRepository>();
        }
        ArrayList<MavenRemoteRepository> result = new ArrayList<MavenRemoteRepository>(repositories.size());
        for (Repository repository : repositories) {
            result.add(new MavenRemoteRepository(repository.getId(), repository.getName(), repository.getUrl(), repository.getLayout(), Maven40ApiModelConverter.convertPolicy(repository.getReleases()), Maven40ApiModelConverter.convertPolicy(repository.getSnapshots())));
        }
        return result;
    }

    private static MavenRemoteRepository.Policy convertPolicy(RepositoryPolicy policy) {
        return policy != null ? new MavenRemoteRepository.Policy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy()) : null;
    }

    private static MavenRemoteRepository.Policy convertPolicy(ArtifactRepositoryPolicy policy) {
        return policy != null ? new MavenRemoteRepository.Policy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy()) : null;
    }

    private static String convertExtension(Artifact artifact) {
        return artifact.getExtension();
    }

    private static List<MavenProfile> convertProfiles(Collection<? extends Profile> profiles) {
        if (profiles == null) {
            return Collections.emptyList();
        }
        ArrayList<MavenProfile> result = new ArrayList<MavenProfile>();
        for (Profile profile : profiles) {
            String id = profile.getId();
            if (id == null) continue;
            MavenProfile profile2 = new MavenProfile(id, profile.getSource());
            List modules = profile.getModules();
            profile2.setModules(modules == null ? Collections.emptyList() : modules);
            profile2.setActivation(Maven40ApiModelConverter.convertActivation(profile.getActivation()));
            if (profile.getBuild() != null) {
                Maven40ApiModelConverter.convertBuildBase(profile2.getBuild(), profile.getBuild());
            }
            result.add(profile2);
        }
        return result;
    }

    private static MavenProfileActivation convertActivation(Activation activation) {
        if (activation == null) {
            return null;
        }
        MavenProfileActivation result = new MavenProfileActivation();
        result.setActiveByDefault(activation.isActiveByDefault());
        result.setOs(Maven40ApiModelConverter.convertOsActivation(activation.getOs()));
        result.setJdk(activation.getJdk());
        result.setFile(Maven40ApiModelConverter.convertFileActivation(activation.getFile()));
        result.setProperty(Maven40ApiModelConverter.convertPropertyActivation(activation.getProperty()));
        return result;
    }

    private static MavenProfileActivationOS convertOsActivation(ActivationOS os) {
        return os == null ? null : new MavenProfileActivationOS(os.getName(), os.getFamily(), os.getArch(), os.getVersion());
    }

    private static MavenProfileActivationFile convertFileActivation(ActivationFile file) {
        return file == null ? null : new MavenProfileActivationFile(file.getExists(), file.getMissing());
    }

    private static MavenProfileActivationProperty convertPropertyActivation(ActivationProperty property) {
        return property == null ? null : new MavenProfileActivationProperty(property.getName(), property.getValue());
    }

    private static boolean isNativeToString(String toStringResult, Object o) {
        String className = o.getClass().getName();
        return toStringResult.startsWith(className) && toStringResult.startsWith("@", className.length());
    }

    private static void doConvert(Object object, String prefix, Map<String, String> result) throws IllegalAccessException, InvocationTargetException {
        for (Method each : ReflectionUtilRt.collectGetters(object.getClass())) {
            Class<?> type = each.getReturnType();
            if (Maven40ApiModelConverter.shouldSkip(type)) continue;
            each.setAccessible(true);
            Object value = each.invoke(object, new Object[0]);
            if (value == null) continue;
            String key = each.getName().substring(3);
            String name = prefix + key.substring(0, 1).toLowerCase() + key.substring(1);
            if (value instanceof String || value.getClass().isPrimitive()) {
                String sValue = String.valueOf(value);
                if (Maven40ApiModelConverter.isNativeToString(sValue, value)) continue;
                result.put(name, sValue);
                continue;
            }
            Package pack = type.getPackage();
            if (pack == null || !pack.getName().startsWith("org.apache.maven")) continue;
            Maven40ApiModelConverter.doConvert(value, name + ".", result);
        }
    }

    private static boolean shouldSkip(Class clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Xpp3Dom.class.isAssignableFrom(clazz);
    }

    public static MavenArtifact convertArtifactAndPath(Artifact artifact, Path artifactPath, File localRepository) {
        return new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion().asString(), artifact.getVersion().asString(), "", artifact.getClassifier(), "", false, Maven40ApiModelConverter.convertExtension(artifact), null == artifactPath ? null : artifactPath.toFile(), localRepository, null != artifactPath, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/maven/server/m40/utils/Maven40ApiModelConverter", "convertModel"));
    }
}

