/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.plots;

import com.intellij.kotlin.jupyter.plots.FlavorsKt;
import com.intellij.kotlin.jupyter.plots.LetsPlotFlavor;
import com.intellij.kotlin.jupyter.plots.LetsPlotOutputDataKey;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.kotlinx.ggdsl.util.serialization.SpecSerializationKt;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.spec.FigKind;
import org.jetbrains.letsPlot.core.spec.config.PlotConfig;
import org.jetbrains.letsPlot.core.util.MonolithicCommon;
import org.jetbrains.letsPlot.core.util.PlotSizeHelper;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a(\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a<\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u001a,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u001a<\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"getSpec", "", "", "", "Lcom/intellij/kotlin/jupyter/plots/MutableLetsPlotSpec;", "dataKey", "Lcom/intellij/kotlin/jupyter/plots/LetsPlotOutputDataKey;", "flavor", "Lcom/intellij/kotlin/jupyter/plots/LetsPlotFlavor;", "plotSize", "Lkotlin/Pair;", "", "spec", "", "Lcom/intellij/kotlin/jupyter/plots/LetsPlotSpec;", "containerWidth", "containerHeight", "scaledFigureSize", "aspectRatio", "", "figureSpec", "intellij.kotlin.jupyter.plots"})
public final class LetsPlotComponentKt {
    private static final Map<String, Object> getSpec(LetsPlotOutputDataKey dataKey) {
        return LetsPlotComponentKt.getSpec(dataKey, FlavorsKt.getCurrentLetsPlotFlavor());
    }

    private static final Map<String, Object> getSpec(LetsPlotOutputDataKey dataKey, LetsPlotFlavor flavor) {
        Map map2;
        Map it = map2 = MapsKt.toMutableMap(SpecSerializationKt.deserializeSpec((JsonElement)dataKey.getSpec()));
        boolean bl = false;
        if (dataKey.getApplyColorScheme()) {
            FlavorsKt.updateFlavor(it, flavor);
        }
        Map rawSpec = map2;
        Map<String, Object> processedSpec = MonolithicCommon.INSTANCE.processRawSpecs(rawSpec, false);
        return MapsKt.toMutableMap(processedSpec);
    }

    private static final Pair<Integer, Integer> plotSize(Map<String, ? extends Object> spec, int containerWidth, int containerHeight) {
        return LetsPlotComponentKt.scaledFigureSize(spec, containerWidth, containerHeight);
    }

    private static final Pair<Integer, Integer> scaledFigureSize(double aspectRatio, int containerWidth, int containerHeight) {
        Pair pair2;
        if (aspectRatio >= 1.0) {
            double plotHeight = (double)containerWidth / aspectRatio;
            double scaling = plotHeight > (double)containerHeight ? (double)containerHeight / plotHeight : 1.0;
            pair2 = new Pair((Object)((int)Math.floor((double)containerWidth * scaling)), (Object)((int)Math.floor(plotHeight * scaling)));
        } else {
            double plotWidth = (double)containerHeight * aspectRatio;
            double scaling = plotWidth > (double)containerWidth ? (double)containerWidth / plotWidth : 1.0;
            pair2 = new Pair((Object)((int)Math.floor(plotWidth * scaling)), (Object)((int)Math.floor((double)containerHeight * scaling)));
        }
        return pair2;
    }

    private static final Pair<Integer, Integer> scaledFigureSize(Map<String, ? extends Object> figureSpec, int containerWidth, int containerHeight) {
        if (PlotConfig.Companion.isFailure(figureSpec)) {
            return new Pair((Object)containerWidth, (Object)containerHeight);
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(figureSpec).ordinal()]) {
            case 1 -> {
                DoubleVector bunchSize = PlotSizeHelper.INSTANCE.plotBunchSize(figureSpec);
                yield new Pair<Integer, Integer>((Object)((int)Math.ceil(bunchSize.getX())), (Object)((int)Math.ceil(bunchSize.getY())));
            }
            case 2 -> {
                double aspectRatio = PlotSizeHelper.INSTANCE.figureAspectRatio(figureSpec);
                yield LetsPlotComponentKt.scaledFigureSize(aspectRatio, containerWidth, containerHeight);
            }
            case 3 -> {
                Object v1 = figureSpec.get("layout");
                Intrinsics.checkNotNull((Object)v1);
                Map it = (Map)v1;
                boolean $i$a$-let-LetsPlotComponentKt$scaledFigureSize$1 = false;
                Object v2 = it.get("ncol");
                Intrinsics.checkNotNull(v2);
                Double v3 = (Double)v2;
                Object v4 = it.get("nrow");
                Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type kotlin.Double");
                Pair var3_5 = TuplesKt.to((Object)v3, (Object)((Double)v4));
                double nCol = ((Number)var3_5.component1()).doubleValue();
                double nRow = ((Number)var3_5.component2()).doubleValue();
                double aspectRatio = nCol * 600.0 / (nRow * 400.0);
                yield LetsPlotComponentKt.scaledFigureSize(aspectRatio, containerWidth, containerHeight);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ Map access$getSpec(LetsPlotOutputDataKey dataKey) {
        return LetsPlotComponentKt.getSpec(dataKey);
    }

    public static final /* synthetic */ Map access$getSpec(LetsPlotOutputDataKey dataKey, LetsPlotFlavor flavor) {
        return LetsPlotComponentKt.getSpec(dataKey, flavor);
    }

    public static final /* synthetic */ Pair access$plotSize(Map spec, int containerWidth, int containerHeight) {
        return LetsPlotComponentKt.plotSize(spec, containerWidth, containerHeight);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FigKind.values().length];
            try {
                nArray[FigKind.GG_BUNCH_SPEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.PLOT_SPEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.SUBPLOTS_SPEC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

