/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.values;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0003J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/commons/values/Color;", "", "red", "", "green", "blue", "alpha", "(IIII)V", "getAlpha", "()I", "getBlue", "getGreen", "getRed", "changeAlpha", "newAlpha", "equals", "", "other", "hashCode", "toCssColor", "", "toHexColor", "toString", "Companion", "commons"})
public final class Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;
    @NotNull
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    @NotNull
    private static final Color WHITE = new Color(255, 255, 255, 0, 8, null);
    @NotNull
    private static final Color CONSOLE_WHITE = new Color(204, 204, 204, 0, 8, null);
    @NotNull
    private static final Color BLACK = new Color(0, 0, 0, 0, 8, null);
    @NotNull
    private static final Color LIGHT_GRAY = new Color(192, 192, 192, 0, 8, null);
    @NotNull
    private static final Color VERY_LIGHT_GRAY = new Color(210, 210, 210, 0, 8, null);
    @NotNull
    private static final Color GRAY = new Color(128, 128, 128, 0, 8, null);
    @NotNull
    private static final Color RED = new Color(255, 0, 0, 0, 8, null);
    @NotNull
    private static final Color LIGHT_GREEN = new Color(210, 255, 210, 0, 8, null);
    @NotNull
    private static final Color GREEN = new Color(0, 255, 0, 0, 8, null);
    @NotNull
    private static final Color DARK_GREEN = new Color(0, 128, 0, 0, 8, null);
    @NotNull
    private static final Color BLUE = new Color(0, 0, 255, 0, 8, null);
    @NotNull
    private static final Color DARK_BLUE = new Color(0, 0, 128, 0, 8, null);
    @NotNull
    private static final Color LIGHT_BLUE = new Color(210, 210, 255, 0, 8, null);
    @NotNull
    private static final Color YELLOW = new Color(255, 255, 0, 0, 8, null);
    @NotNull
    private static final Color CONSOLE_YELLOW = new Color(174, 174, 36, 0, 8, null);
    @NotNull
    private static final Color LIGHT_YELLOW = new Color(255, 255, 128, 0, 8, null);
    @NotNull
    private static final Color VERY_LIGHT_YELLOW = new Color(255, 255, 210, 0, 8, null);
    @NotNull
    private static final Color MAGENTA = new Color(255, 0, 255, 0, 8, null);
    @NotNull
    private static final Color LIGHT_MAGENTA = new Color(255, 210, 255, 0, 8, null);
    @NotNull
    private static final Color DARK_MAGENTA = new Color(128, 0, 128, 0, 8, null);
    @NotNull
    private static final Color CYAN = new Color(0, 255, 255, 0, 8, null);
    @NotNull
    private static final Color LIGHT_CYAN = new Color(210, 255, 255, 0, 8, null);
    @NotNull
    private static final Color ORANGE = new Color(255, 192, 0, 0, 8, null);
    @NotNull
    private static final Color PINK = new Color(255, 175, 175, 0, 8, null);
    @NotNull
    private static final Color LIGHT_PINK = new Color(255, 210, 210, 0, 8, null);
    @NotNull
    private static final Color PACIFIC_BLUE = Companion.parseHex("#118ED8");
    @NotNull
    private static final String RGB = "rgb";
    @NotNull
    private static final String COLOR = "color";
    @NotNull
    private static final String RGBA = "rgba";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmOverloads
    public Color(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        int n = this.red;
        boolean bl = 0 <= n ? n < 256 : false;
        if (bl) {
            n = this.green;
            boolean bl2 = 0 <= n ? n < 256 : false;
            if (bl2) {
                n = this.blue;
                boolean bl3 = 0 <= n ? n < 256 : false;
                if (bl3) {
                    boolean bl4;
                    n = this.alpha;
                    if (0 <= n) {
                        if (n < 256) {
                            return;
                        }
                        bl4 = false;
                    } else {
                        bl4 = false;
                    }
                    if (bl4) {
                        return;
                    }
                }
            }
        }
        boolean bl5 = false;
        if (bl5) return;
        boolean bl6 = false;
        String string = "Color components out of range: " + this;
        throw new IllegalArgumentException(string.toString());
    }

    public /* synthetic */ Color(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = 255;
        }
        this(n, n2, n3, n4);
    }

    public final int getRed() {
        return this.red;
    }

    public final int getGreen() {
        return this.green;
    }

    public final int getBlue() {
        return this.blue;
    }

    public final int getAlpha() {
        return this.alpha;
    }

    @NotNull
    public final Color changeAlpha(int newAlpha) {
        return new Color(this.red, this.green, this.blue, newAlpha);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Color && this.red == ((Color)other).red && this.green == ((Color)other).green && this.blue == ((Color)other).blue && this.alpha == ((Color)other).alpha;
    }

    @NotNull
    public final String toCssColor() {
        return this.alpha == 255 ? "rgb(" + this.red + ',' + this.green + ',' + this.blue + ')' : "rgba(" + this.red + ',' + this.green + ',' + this.blue + ',' + (double)this.alpha / 255.0 + ')';
    }

    @NotNull
    public final String toHexColor() {
        return '#' + Color.Companion.toColorPart(this.red) + Color.Companion.toColorPart(this.green) + Color.Companion.toColorPart(this.blue);
    }

    public int hashCode() {
        int result2 = 0;
        result2 = 31 * result2 + this.red;
        result2 = 31 * result2 + this.green;
        result2 = 31 * result2 + this.blue;
        result2 = 31 * result2 + this.alpha;
        return result2;
    }

    @NotNull
    public String toString() {
        return "color(" + this.red + ',' + this.green + ',' + this.blue + ',' + this.alpha + ')';
    }

    @JvmOverloads
    public Color(int red, int green, int blue) {
        this(red, green, blue, 0, 8, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b5\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\n2\u0006\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020@H\u0002J\u000e\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\nJ\u0010\u0010F\u001a\u0004\u0018\u00010\u00042\u0006\u0010G\u001a\u00020\nJ\u000e\u0010H\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\nJ\u0010\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020@H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0011\u0010+\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0011\u0010/\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0011\u00101\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006R\u000e\u00103\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0006R\u0011\u00107\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0006R\u0011\u00109\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0006R\u0011\u0010;\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0006R\u0011\u0010=\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0006\u00a8\u0006L"}, d2={"Lorg/jetbrains/letsPlot/commons/values/Color$Companion;", "", "()V", "BLACK", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getBLACK", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "BLUE", "getBLUE", "COLOR", "", "CONSOLE_WHITE", "getCONSOLE_WHITE", "CONSOLE_YELLOW", "getCONSOLE_YELLOW", "CYAN", "getCYAN", "DARK_BLUE", "getDARK_BLUE", "DARK_GREEN", "getDARK_GREEN", "DARK_MAGENTA", "getDARK_MAGENTA", "GRAY", "getGRAY", "GREEN", "getGREEN", "LIGHT_BLUE", "getLIGHT_BLUE", "LIGHT_CYAN", "getLIGHT_CYAN", "LIGHT_GRAY", "getLIGHT_GRAY", "LIGHT_GREEN", "getLIGHT_GREEN", "LIGHT_MAGENTA", "getLIGHT_MAGENTA", "LIGHT_PINK", "getLIGHT_PINK", "LIGHT_YELLOW", "getLIGHT_YELLOW", "MAGENTA", "getMAGENTA", "ORANGE", "getORANGE", "PACIFIC_BLUE", "getPACIFIC_BLUE", "PINK", "getPINK", "RED", "getRED", "RGB", "RGBA", "TRANSPARENT", "getTRANSPARENT", "VERY_LIGHT_GRAY", "getVERY_LIGHT_GRAY", "VERY_LIGHT_YELLOW", "getVERY_LIGHT_YELLOW", "WHITE", "getWHITE", "YELLOW", "getYELLOW", "findNext", "", "s", "what", "from", "parseHex", "hexColor", "parseOrNull", "string", "parseRGB", "text", "toColorPart", "value", "commons"})
    @SourceDebugExtension(value={"SMAP\nColor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Color.kt\norg/jetbrains/letsPlot/commons/values/Color$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,177:1\n1#2:178\n107#3:179\n79#3,22:180\n107#3:202\n79#3,22:203\n107#3:225\n79#3,22:226\n107#3:248\n79#3,22:249\n107#3:271\n79#3,22:272\n970#4:294\n1041#4,3:295\n*S KotlinDebug\n*F\n+ 1 Color.kt\norg/jetbrains/letsPlot/commons/values/Color$Companion\n*L\n121#1:179\n121#1:180,22\n122#1:202\n122#1:203,22\n127#1:225\n127#1:226,22\n130#1:248\n130#1:249,22\n131#1:271\n131#1:272,22\n155#1:294\n155#1:295,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getTRANSPARENT() {
            return TRANSPARENT;
        }

        @NotNull
        public final Color getWHITE() {
            return WHITE;
        }

        @NotNull
        public final Color getCONSOLE_WHITE() {
            return CONSOLE_WHITE;
        }

        @NotNull
        public final Color getBLACK() {
            return BLACK;
        }

        @NotNull
        public final Color getLIGHT_GRAY() {
            return LIGHT_GRAY;
        }

        @NotNull
        public final Color getVERY_LIGHT_GRAY() {
            return VERY_LIGHT_GRAY;
        }

        @NotNull
        public final Color getGRAY() {
            return GRAY;
        }

        @NotNull
        public final Color getRED() {
            return RED;
        }

        @NotNull
        public final Color getLIGHT_GREEN() {
            return LIGHT_GREEN;
        }

        @NotNull
        public final Color getGREEN() {
            return GREEN;
        }

        @NotNull
        public final Color getDARK_GREEN() {
            return DARK_GREEN;
        }

        @NotNull
        public final Color getBLUE() {
            return BLUE;
        }

        @NotNull
        public final Color getDARK_BLUE() {
            return DARK_BLUE;
        }

        @NotNull
        public final Color getLIGHT_BLUE() {
            return LIGHT_BLUE;
        }

        @NotNull
        public final Color getYELLOW() {
            return YELLOW;
        }

        @NotNull
        public final Color getCONSOLE_YELLOW() {
            return CONSOLE_YELLOW;
        }

        @NotNull
        public final Color getLIGHT_YELLOW() {
            return LIGHT_YELLOW;
        }

        @NotNull
        public final Color getVERY_LIGHT_YELLOW() {
            return VERY_LIGHT_YELLOW;
        }

        @NotNull
        public final Color getMAGENTA() {
            return MAGENTA;
        }

        @NotNull
        public final Color getLIGHT_MAGENTA() {
            return LIGHT_MAGENTA;
        }

        @NotNull
        public final Color getDARK_MAGENTA() {
            return DARK_MAGENTA;
        }

        @NotNull
        public final Color getCYAN() {
            return CYAN;
        }

        @NotNull
        public final Color getLIGHT_CYAN() {
            return LIGHT_CYAN;
        }

        @NotNull
        public final Color getORANGE() {
            return ORANGE;
        }

        @NotNull
        public final Color getPINK() {
            return PINK;
        }

        @NotNull
        public final Color getLIGHT_PINK() {
            return LIGHT_PINK;
        }

        @NotNull
        public final Color getPACIFIC_BLUE() {
            return PACIFIC_BLUE;
        }

        @Nullable
        public final Color parseOrNull(@NotNull String string) {
            Object $this$parseOrNull_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Object object = this;
            try {
                $this$parseOrNull_u24lambda_u240 = object;
                boolean bl = false;
                $this$parseOrNull_u24lambda_u240 = Result.constructor-impl((Object)((Companion)$this$parseOrNull_u24lambda_u240).parseHex(string));
            }
            catch (Throwable bl) {
                $this$parseOrNull_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$parseOrNull_u24lambda_u240;
            Color color = (Color)(Result.isFailure-impl((Object)object) ? null : object);
            if (color == null) {
                Object object2;
                object = this;
                try {
                    Companion $this$parseOrNull_u24lambda_u241 = (Companion)object;
                    boolean bl = false;
                    object2 = Result.constructor-impl((Object)$this$parseOrNull_u24lambda_u241.parseRGB(string));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object = object2;
                color = (Color)(Result.isFailure-impl((Object)object) ? null : object);
            }
            return color;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Color parseRGB(@NotNull String text) {
            int index$iv$iv;
            boolean startFound$iv$iv;
            int endIndex$iv$iv;
            int startIndex$iv$iv;
            boolean $i$f$trim;
            String $this$trim$iv;
            void $this$trim$iv2;
            void $this$trim$iv3;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int firstParen = this.findNext(text, "(", 0);
            String string = text.substring(0, firstParen);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String prefix = string;
            int firstComma = this.findNext(text, ",", firstParen + 1);
            int secondComma = this.findNext(text, ",", firstComma + 1);
            int thirdComma = -1;
            if (Intrinsics.areEqual((Object)prefix, (Object)Color.RGBA)) {
                thirdComma = this.findNext(text, ",", secondComma + 1);
            } else if (Intrinsics.areEqual((Object)prefix, (Object)Color.COLOR)) {
                thirdComma = StringsKt.indexOf$default((CharSequence)text, (String)",", (int)(secondComma + 1), (boolean)false, (int)4, null);
            } else if (!Intrinsics.areEqual((Object)prefix, (Object)Color.RGB)) {
                throw new IllegalArgumentException(text);
            }
            int lastParen = this.findNext(text, ")", thirdComma + 1);
            String string2 = text.substring(firstParen + 1, firstComma);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = string2;
            boolean $i$f$trim22 = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv3;
            boolean $i$f$trim3 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                int index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $this$trim$iv$iv.charAt(index$iv$iv2);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            int red = Integer.parseInt(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString());
            String string4 = text.substring(firstComma + 1, secondComma);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String $i$f$trim22 = string4;
            boolean $i$f$trim4 = false;
            CharSequence $this$trim$iv$iv2 = (CharSequence)$this$trim$iv2;
            boolean $i$f$trim5 = false;
            int startIndex$iv$iv3 = 0;
            int endIndex$iv$iv3 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv3 = false;
            while (startIndex$iv$iv3 <= endIndex$iv$iv3) {
                boolean match$iv$iv;
                int index$iv$iv3 = !startFound$iv$iv3 ? startIndex$iv$iv3 : endIndex$iv$iv3;
                char it = $this$trim$iv$iv2.charAt(index$iv$iv3);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv3) {
                    if (!match$iv$iv) {
                        startFound$iv$iv3 = true;
                        continue;
                    }
                    ++startIndex$iv$iv3;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv3;
            }
            int green = Integer.parseInt(((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv3, endIndex$iv$iv3 + 1)).toString());
            int blue = 0;
            int alpha = 0;
            if (thirdComma == -1) {
                String string5 = text.substring(secondComma + 1, lastParen);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                $this$trim$iv$iv2 = string5;
                $i$f$trim5 = false;
                CharSequence $this$trim$iv$iv3 = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv3.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv3.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                blue = Integer.parseInt(((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                alpha = 255;
            } else {
                boolean match$iv$iv;
                char it;
                String string6 = text.substring(secondComma + 1, thirdComma);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                $this$trim$iv = string6;
                $i$f$trim5 = false;
                CharSequence $this$trim$iv$iv4 = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv4.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv4.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                blue = Integer.parseInt(((Object)$this$trim$iv$iv4.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                String string7 = text.substring(thirdComma + 1, lastParen);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                $this$trim$iv = string7;
                $i$f$trim5 = false;
                $this$trim$iv$iv4 = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv4.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv4.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl6 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                alpha = MathKt.roundToInt((float)(Float.parseFloat(((Object)$this$trim$iv$iv4.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()) * (float)255));
            }
            return new Color(red, green, blue, alpha);
        }

        private final int findNext(String s, String what, int from2) {
            int result2 = StringsKt.indexOf$default((CharSequence)s, (String)what, (int)from2, (boolean)false, (int)4, null);
            if (result2 == -1) {
                throw new IllegalArgumentException("text=" + s + " what=" + what + " from=" + from2);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Color parseHex(@NotNull String hexColor) {
            Intrinsics.checkNotNullParameter((Object)hexColor, (String)"hexColor");
            String hexColor2 = null;
            hexColor2 = hexColor;
            if (!(StringsKt.startsWith$default((String)hexColor2, (String)"#", (boolean)false, (int)2, null) && (hexColor2.length() == 4 || hexColor2.length() == 7))) {
                boolean $i$a$-require-Color$Companion$parseHex$22 = false;
                String $i$a$-require-Color$Companion$parseHex$22 = "Not a valid HEX value: " + hexColor2;
                throw new IllegalArgumentException($i$a$-require-Color$Companion$parseHex$22.toString());
            }
            String string = hexColor2.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            hexColor2 = string;
            if (hexColor2.length() == 3) {
                void $this$mapTo$iv$iv;
                CharSequence $this$map$iv = hexColor2;
                boolean $i$f$map = false;
                CharSequence charSequence = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length());
                boolean $i$f$mapTo = false;
                for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                    void it;
                    char item$iv$iv;
                    char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add("" + (char)it + (char)it);
                }
                hexColor2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            }
            String string2 = hexColor2.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            int r = Integer.parseInt(string2, CharsKt.checkRadix((int)16));
            String string3 = hexColor2.substring(2, 4);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            int g = Integer.parseInt(string3, CharsKt.checkRadix((int)16));
            String string4 = hexColor2.substring(4, 6);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            int b2 = Integer.parseInt(string4, CharsKt.checkRadix((int)16));
            return new Color(r, g, b2, 0, 8, null);
        }

        private final String toColorPart(int value) {
            if (value < 0 || value > 255) {
                throw new IllegalArgumentException("RGB color part must be in range [0..255] but was " + value);
            }
            String string = Integer.toString(value, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String result2 = string;
            return result2.length() == 1 ? '0' + result2 : result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

